/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.impala.authorization.User;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TPoolConfig;
import org.apache.impala.thrift.TResolveRequestPoolParams;
import org.apache.impala.thrift.TResolveRequestPoolResult;
import org.apache.impala.util.RequestPoolService;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestRequestPoolService {
    private static final String ALLOCATION_FILE = "fair-scheduler-test.xml";
    private static final String ALLOCATION_FILE_MODIFIED = "fair-scheduler-test2.xml";
    private static final String ALLOCATION_FILE_EMPTY = "fair-scheduler-empty.xml";
    private static final String ALLOCATION_FILE_GROUP_RULE = "fair-scheduler-group-rule.xml";
    private static final String LLAMA_CONFIG_FILE = "llama-site-test.xml";
    private static final String LLAMA_CONFIG_FILE_MODIFIED = "llama-site-test2.xml";
    private static final String LLAMA_CONFIG_FILE_EMPTY = "llama-site-empty.xml";
    private static final long CHECK_INTERVAL_MS = 100L;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private RequestPoolService poolService_;
    private File allocationConfFile_;
    private File llamaConfFile_;

    private void createPoolService(String allocationFile, String llamaConfFile) throws Exception {
        this.allocationConfFile_ = this.tempFolder.newFile("fair-scheduler-temp-file.xml");
        Files.copy((File)this.getClasspathFile(allocationFile), (File)this.allocationConfFile_);
        String llamaConfPath = null;
        if (llamaConfFile != null) {
            this.llamaConfFile_ = this.tempFolder.newFile("llama-conf-temp-file.xml");
            Files.copy((File)this.getClasspathFile(llamaConfFile), (File)this.llamaConfFile_);
            llamaConfPath = this.llamaConfFile_.getAbsolutePath();
        }
        this.poolService_ = RequestPoolService.getInstance((String)this.allocationConfFile_.getAbsolutePath(), llamaConfPath, (boolean)true);
        Field f = AllocationFileLoaderService.class.getDeclaredField("reloadIntervalMs");
        f.setAccessible(true);
        f.set(this.poolService_.allocLoader_, 100L);
        if (llamaConfFile != null) {
            this.poolService_.confWatcher_.setCheckIntervalMs(100L);
        }
        this.poolService_.start();
        QueuePlacementPolicy policy = this.poolService_.getAllocationConfig().getPlacementPolicy();
        Configuration conf = policy.getConf();
        Assert.assertTrue((boolean)conf.getBoolean("impala.core-site.overridden", false));
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        RuntimeEnv.INSTANCE.setTestEnv(true);
        User.setRulesForTesting((String)new Configuration().get("hadoop.security.auth_to_local", "DEFAULT"));
    }

    @AfterClass
    public static void cleanUpClass() {
        RuntimeEnv.INSTANCE.reset();
    }

    @After
    public void cleanUp() throws Exception {
        if (this.poolService_ != null) {
            this.poolService_.stop();
        }
    }

    private File getClasspathFile(String filename) throws URISyntaxException {
        return new File(this.getClass().getClassLoader().getResource(filename).toURI());
    }

    @Test
    public void testPoolResolution() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        Assert.assertEquals((Object)"root.queueA", (Object)this.poolService_.assignToPool("root.queueA", "userA"));
        Assert.assertNull((Object)this.poolService_.assignToPool("nonexistentQueue", "userA"));
    }

    @Test
    public void testResolvePrincipalName() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        TResolveRequestPoolResult result = this.poolService_.resolveRequestPool(new TResolveRequestPoolParams("userA@abc.com", "root.queueA"));
        Assert.assertEquals((Object)TErrorCode.OK, (Object)result.getStatus().getStatus_code());
        Assert.assertEquals((Object)"root.queueA", (Object)result.getResolved_pool());
        result = this.poolService_.resolveRequestPool(new TResolveRequestPoolParams("userA/a.qualified.domain@abc.com", "root.queueA"));
        Assert.assertEquals((Object)TErrorCode.OK, (Object)result.getStatus().getStatus_code());
        Assert.assertEquals((Object)"root.queueA", (Object)result.getResolved_pool());
    }

    @Test
    public void testUserNoGroupsError() throws Exception {
        this.createPoolService(ALLOCATION_FILE_GROUP_RULE, LLAMA_CONFIG_FILE);
        TResolveRequestPoolResult result = this.poolService_.resolveRequestPool(new TResolveRequestPoolParams("userA", "root.NOT_A_POOL"));
        Assert.assertEquals((Object)false, (Object)result.isSetResolved_pool());
        Assert.assertEquals((Object)false, (Object)result.isSetHas_access());
        Assert.assertEquals((Object)TErrorCode.INTERNAL_ERROR, (Object)result.getStatus().getStatus_code());
        String expectedMessage = "Failed to resolve user 'userA' to a pool while evaluating the 'primaryGroup' or 'secondaryGroup' queue placement rules because no groups were found for the user. This is likely because the user does not exist on the local operating system.";
        Assert.assertEquals((Object)expectedMessage, (Object)Iterables.getOnlyElement((Iterable)result.getStatus().getError_msgs()));
    }

    @Test
    public void testPoolAcls() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueA", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueB", "userB"));
        Assert.assertFalse((boolean)this.poolService_.hasAccess("root.queueB", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueB", "root"));
    }

    @Test
    public void testPoolLimitConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        this.checkPoolConfigResult("root", 15L, 50L, -1L, 30000L, "mem_limit=1024m");
        this.checkPoolConfigResult("root.queueA", 10L, 30L, 0x40000000L, 10000L, "mem_limit=1024m,query_timeout_s=10");
        this.checkPoolConfigResult("root.queueB", 5L, 10L, -1L, 30000L, "mem_limit=1024m");
        this.checkPoolConfigResult("root.queueC", 5L, 10L, 0x40000000L, 30000L, "mem_limit=1024m", 1000L, 10L, false, 8L, 8L);
    }

    @Test
    public void testDefaultConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE_EMPTY, LLAMA_CONFIG_FILE_EMPTY);
        Assert.assertEquals((Object)"root.userA", (Object)this.poolService_.assignToPool("", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.userA", "userA"));
        this.checkPoolConfigResult("root", -1L, 200L, -1L, null, "", 0L, 0L, true, 0L, 0L);
    }

    @Ignore(value="IMPALA-4868")
    @Test
    public void testUpdatingConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        Thread.sleep(1000L);
        Files.copy((File)this.getClasspathFile(ALLOCATION_FILE_MODIFIED), (File)this.allocationConfFile_);
        Files.copy((File)this.getClasspathFile(LLAMA_CONFIG_FILE_MODIFIED), (File)this.llamaConfFile_);
        Thread.sleep(5100L);
        int numAttempts = 20;
        while (true) {
            try {
                this.checkModifiedConfigResults();
            }
            catch (AssertionError e) {
                if (numAttempts == 0) {
                    throw e;
                }
                --numAttempts;
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testModifiedConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE_MODIFIED, LLAMA_CONFIG_FILE_MODIFIED);
        this.checkModifiedConfigResults();
    }

    @Test
    public void testNullLlamaSite() throws Exception {
        this.createPoolService(ALLOCATION_FILE_MODIFIED, null);
        Assert.assertEquals((Object)"root.queueA", (Object)this.poolService_.assignToPool("queueA", "userA"));
        Assert.assertNull((Object)this.poolService_.assignToPool("queueX", "userA"));
        Assert.assertEquals((Object)"root.queueC", (Object)this.poolService_.assignToPool("queueC", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueA", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueB", "userB"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueB", "userA"));
        Assert.assertFalse((boolean)this.poolService_.hasAccess("root.queueC", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueC", "root"));
        this.checkPoolConfigResult("root", -1L, 200L, -1L);
        this.checkPoolConfigResult("root.queueA", -1L, 200L, 104857600000L);
        this.checkPoolConfigResult("root.queueB", -1L, 200L, -1L);
        this.checkPoolConfigResult("root.queueC", -1L, 200L, 0x8000000L);
    }

    private void checkModifiedConfigResults() throws InternalException, IOException {
        Assert.assertEquals((Object)"root.queueA", (Object)this.poolService_.assignToPool("queueA", "userA"));
        Assert.assertNull((Object)this.poolService_.assignToPool("queueX", "userA"));
        Assert.assertEquals((Object)"root.queueC", (Object)this.poolService_.assignToPool("queueC", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueA", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueB", "userB"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueB", "userA"));
        Assert.assertFalse((boolean)this.poolService_.hasAccess("root.queueC", "userA"));
        Assert.assertTrue((boolean)this.poolService_.hasAccess("root.queueC", "root"));
        this.checkPoolConfigResult("root", 15L, 100L, -1L, 30000L, "");
        this.checkPoolConfigResult("root.queueA", 1L, 30L, 104857600000L, 50L, "mem_limit=128m,query_timeout_s=5,not_a_valid_option=foo.bar");
        this.checkPoolConfigResult("root.queueB", 5L, 10L, -1L, 600000L, "");
        this.checkPoolConfigResult("root.queueC", 10L, 30L, 0x8000000L, 30000L, "mem_limit=2048m,query_timeout_s=60");
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMem, Long expectedQueueTimeoutMs, String expectedQueryOptions, long max_query_mem_limit, long min_query_mem_limit, boolean clamp_mem_limit_query_option, long max_query_cpu_core_per_node_limit, long max_query_cpu_core_coordinator_limit) {
        TPoolConfig expectedResult = new TPoolConfig();
        expectedResult.setMax_requests(expectedMaxRequests);
        expectedResult.setMax_queued(expectedMaxQueued);
        expectedResult.setMax_mem_resources(expectedMaxMem);
        expectedResult.setMax_query_mem_limit(max_query_mem_limit);
        expectedResult.setMin_query_mem_limit(min_query_mem_limit);
        expectedResult.setClamp_mem_limit_query_option(clamp_mem_limit_query_option);
        expectedResult.setMax_query_cpu_core_per_node_limit(max_query_cpu_core_per_node_limit);
        expectedResult.setMax_query_cpu_core_coordinator_limit(max_query_cpu_core_coordinator_limit);
        if (expectedQueueTimeoutMs != null) {
            expectedResult.setQueue_timeout_ms(expectedQueueTimeoutMs.longValue());
        }
        if (expectedQueryOptions != null) {
            expectedResult.setDefault_query_options(expectedQueryOptions);
        }
        Assert.assertEquals((String)("Unexpected config values for pool " + pool), (Object)expectedResult, (Object)this.poolService_.getPoolConfig(pool));
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMem, Long expectedQueueTimeoutMs, String expectedQueryOptions) {
        this.checkPoolConfigResult(pool, expectedMaxRequests, expectedMaxQueued, expectedMaxMem, expectedQueueTimeoutMs, expectedQueryOptions, 0L, 0L, true, 0L, 0L);
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMemUsage) {
        this.checkPoolConfigResult(pool, expectedMaxRequests, expectedMaxQueued, expectedMaxMemUsage, null, "");
    }
}

