/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.ImmutableList;
import org.apache.impala.common.PrintUtils;
import org.junit.Assert;
import org.junit.Test;

public class PrintUtilsTest {
    private static final int WRAP_LENGTH = 60;

    @Test
    public void testPrintBytes() {
        Assert.assertEquals((Object)"0B", (Object)PrintUtils.printBytes((long)0L));
        Assert.assertEquals((Object)"55B", (Object)PrintUtils.printBytes((long)55L));
        Assert.assertEquals((Object)"1023B", (Object)PrintUtils.printBytes((long)1023L));
        Assert.assertEquals((Object)"1.00KB", (Object)PrintUtils.printBytes((long)1024L));
        Assert.assertEquals((Object)"54.16KB", (Object)PrintUtils.printBytes((long)55463L));
        Assert.assertEquals((Object)"54.16KB", (Object)PrintUtils.printBytes((long)55463L));
        Assert.assertEquals((Object)"1024.00KB", (Object)PrintUtils.printBytes((long)1048575L));
        Assert.assertEquals((Object)"1.00MB", (Object)PrintUtils.printBytes((long)0x100000L));
        Assert.assertEquals((Object)"1.00MB", (Object)PrintUtils.printBytes((long)0x10000AL));
        Assert.assertEquals((Object)"1.00GB", (Object)PrintUtils.printBytes((long)0x40000000L));
        Assert.assertEquals((Object)"1.50GB", (Object)PrintUtils.printBytes((long)0x60000000L));
        Assert.assertEquals((Object)"4.00TB", (Object)PrintUtils.printBytes((long)0x40000000000L));
        Assert.assertEquals((Object)"8.42PB", (Object)PrintUtils.printBytes((long)9480077215614894L));
        Assert.assertEquals((Object)"-10B", (Object)PrintUtils.printBytes((long)-10L));
        Assert.assertEquals((Object)"-123456789B", (Object)PrintUtils.printBytes((long)-123456789L));
    }

    @Test
    public void testPrintBytesRoundedToMb() {
        Assert.assertEquals((Object)"0B", (Object)PrintUtils.printBytesRoundedToMb((long)0L));
        Assert.assertEquals((Object)"55B", (Object)PrintUtils.printBytesRoundedToMb((long)55L));
        Assert.assertEquals((Object)"1023B", (Object)PrintUtils.printBytesRoundedToMb((long)1023L));
        Assert.assertEquals((Object)"1KB", (Object)PrintUtils.printBytesRoundedToMb((long)1024L));
        Assert.assertEquals((Object)"54KB", (Object)PrintUtils.printBytesRoundedToMb((long)55463L));
        Assert.assertEquals((Object)"54KB", (Object)PrintUtils.printBytesRoundedToMb((long)55463L));
        Assert.assertEquals((Object)"1024KB", (Object)PrintUtils.printBytesRoundedToMb((long)1048575L));
        Assert.assertEquals((Object)"1MB", (Object)PrintUtils.printBytesRoundedToMb((long)0x100000L));
        Assert.assertEquals((Object)"1MB", (Object)PrintUtils.printBytesRoundedToMb((long)0x10000AL));
        Assert.assertEquals((Object)"1.00GB", (Object)PrintUtils.printBytesRoundedToMb((long)0x40000000L));
        Assert.assertEquals((Object)"1.50GB", (Object)PrintUtils.printBytesRoundedToMb((long)0x60000000L));
        Assert.assertEquals((Object)"4.00TB", (Object)PrintUtils.printBytesRoundedToMb((long)0x40000000000L));
        Assert.assertEquals((Object)"8.42PB", (Object)PrintUtils.printBytesRoundedToMb((long)9480077215614894L));
        Assert.assertEquals((Object)"-10B", (Object)PrintUtils.printBytesRoundedToMb((long)-10L));
        Assert.assertEquals((Object)"-123456789B", (Object)PrintUtils.printBytesRoundedToMb((long)-123456789L));
    }

    @Test
    public void testWrapText() {
        this.assertWrap("Analyzed query: SELECT * FROM functional_kudu.alltypestiny WHERE CAST(bigint_col AS DOUBLE) < CAST(10 AS DOUBLE)", "Analyzed query: SELECT * FROM functional_kudu.alltypestiny\nWHERE CAST(bigint_col AS DOUBLE) < CAST(10 AS DOUBLE)");
        this.assertWrap("insert into foo values ('                                                                                                                                                ')", "insert into foo values ('                                   \n')");
        this.assertWrap("select xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "select\nxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\nxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\nxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\nxxxxxxxxxxxxxxxxxxxxxxxxx");
    }

    private void assertWrap(String input, String expected) {
        String actual = PrintUtils.wrapString((String)input, (int)60);
        Assert.assertEquals((Object)expected, (Object)actual);
        this.assertNoBlankLines(actual);
        this.assertNoTerminatingNewline(actual);
        this.assertNoLongLines(actual);
    }

    private void assertNoLongLines(String s) {
        for (String line : s.split("\n")) {
            Assert.assertTrue((String)("line too long: " + line), (line.length() <= 60 ? 1 : 0) != 0);
        }
    }

    private void assertNoTerminatingNewline(String s) {
        Assert.assertFalse((String)("wrapped string ends in newline: " + s), (boolean)s.endsWith("\n"));
    }

    private void assertNoBlankLines(String s) {
        Assert.assertFalse((String)("output contains blank line " + s), (boolean)s.contains("\n\n"));
    }

    @Test
    public void testJoinQuoted() {
        Assert.assertEquals((Object)"", (Object)PrintUtils.joinQuoted((Iterable)ImmutableList.of()));
        Assert.assertEquals((Object)"'a'", (Object)PrintUtils.joinQuoted((Iterable)ImmutableList.of((Object)"a")));
        Assert.assertEquals((Object)"'a', 'b'", (Object)PrintUtils.joinQuoted((Iterable)ImmutableList.of((Object)"a", (Object)"b")));
    }

    @Test
    public void testPrintTime() {
        Assert.assertEquals((Object)"", (Object)PrintUtils.printTimeNs((long)-1L));
        Assert.assertEquals((Object)"0ns", (Object)PrintUtils.printTimeNs((long)0L));
        Assert.assertEquals((Object)"1ns", (Object)PrintUtils.printTimeNs((long)1L));
        Assert.assertEquals((Object)"10ns", (Object)PrintUtils.printTimeNs((long)10L));
        Assert.assertEquals((Object)"100ns", (Object)PrintUtils.printTimeNs((long)100L));
        Assert.assertEquals((Object)"1.000us", (Object)PrintUtils.printTimeNs((long)1000L));
        Assert.assertEquals((Object)"10.000us", (Object)PrintUtils.printTimeNs((long)10000L));
        Assert.assertEquals((Object)"100.000us", (Object)PrintUtils.printTimeNs((long)100000L));
        Assert.assertEquals((Object)"1.000ms", (Object)PrintUtils.printTimeNs((long)1000000L));
        Assert.assertEquals((Object)"10.000ms", (Object)PrintUtils.printTimeNs((long)10000000L));
        Assert.assertEquals((Object)"100.000ms", (Object)PrintUtils.printTimeNs((long)100000000L));
        Assert.assertEquals((Object)"1s", (Object)PrintUtils.printTimeNs((long)1000000000L));
        Assert.assertEquals((Object)"10s", (Object)PrintUtils.printTimeNs((long)10000000000L));
        Assert.assertEquals((Object)"1m40s", (Object)PrintUtils.printTimeNs((long)100000000000L));
        Assert.assertEquals((Object)"16m40s", (Object)PrintUtils.printTimeNs((long)1000000000000L));
        Assert.assertEquals((Object)"2h46m", (Object)PrintUtils.printTimeNs((long)10000000000000L));
        Assert.assertEquals((Object)"27h46m", (Object)PrintUtils.printTimeNs((long)100000000000000L));
    }
}

