/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.util.MathUtil;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilTest {
    @Test
    public void testSaturatingMultiply() {
        Assert.assertEquals((long)10L, (long)MathUtil.saturatingMultiply((long)2L, (long)5L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)2L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)3L, (long)0x3FFFFFFFFFFFFFFFL));
        Assert.assertEquals((long)-10L, (long)MathUtil.saturatingMultiply((long)2L, (long)-5L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingMultiply((long)2L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingMultiply((long)-3L, (long)0x3FFFFFFFFFFFFFFFL));
        Assert.assertEquals((long)10L, (long)MathUtil.saturatingMultiply((long)-2L, (long)-5L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)-1L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)-922337203685477580L, (long)-100L));
    }

    @Test
    public void testSaturatingAdd() {
        Assert.assertEquals((long)1234L, (long)MathUtil.saturatingAdd((long)1200L, (long)34L));
        Assert.assertEquals((long)-1L, (long)MathUtil.saturatingAdd((long)Long.MAX_VALUE, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingAdd((long)Long.MIN_VALUE, (long)-1L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingAdd((long)Long.MIN_VALUE, (long)-4611686018427387904L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingAdd((long)0x7FFFFFFFFFFFFFF5L, (long)11L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingAdd((long)Long.MAX_VALUE, (long)0x3FFFFFFFFFFFFFFFL));
    }
}

