/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.util.IntArrayList;
import org.apache.impala.util.IntIterator;
import org.junit.Assert;
import org.junit.Test;

public class IntArrayListTest {
    private void assertNaturalNumberSequence(IntArrayList arr, int size) {
        assert (arr.data().length >= size);
        Assert.assertEquals((long)arr.size(), (long)size);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)arr.get(i), (long)i);
        }
        try {
            arr.get(-1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException i) {
            // empty catch block
        }
        try {
            arr.get(arr.size());
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException i) {
            // empty catch block
        }
        IntIterator it = arr.iterator();
        for (int i = 0; i < size; ++i) {
            assert (it.hasNext());
            assert (it.peek() == i);
            assert (it.next() == i);
        }
        assert (!it.hasNext());
        try {
            it.peek();
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            it.next();
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void fillNaturalNumberSequence(IntArrayList arr, int end) {
        for (int i = arr.size(); i < end; ++i) {
            arr.add(i);
        }
    }

    @Test
    public void testIntArrayList() {
        IntArrayList arr = new IntArrayList();
        this.fillNaturalNumberSequence(arr, 10);
        this.assertNaturalNumberSequence(arr, 10);
        arr.removeLast(5);
        this.assertNaturalNumberSequence(arr, 5);
        this.fillNaturalNumberSequence(arr, 32);
        this.assertNaturalNumberSequence(arr, 32);
        try {
            arr.removeLast(33);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            arr.removeLast(Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            arr.removeLast(-1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        arr.removeLast(0);
        this.assertNaturalNumberSequence(arr, 32);
        arr.set(0, -1);
        assert (arr.get(0) == -1);
        arr.set(31, -1);
        assert (arr.get(31) == -1);
        try {
            arr.set(-1, -1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            arr.set(32, -1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        arr.clear();
        this.assertNaturalNumberSequence(arr, 0);
    }
}

