/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.util.DebugUtils;
import org.junit.Assert;
import org.junit.Test;

public class DebugUtilsTest {
    @Test
    public void testSleepDebugAction() {
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION:SLEEP@1", (String)"test_sleep_action");
        long startTime = System.currentTimeMillis();
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION:SLEEP@100|SOME_OTHER_ACTION:SLEEP@10", (String)"SOME_OTHER_ACTION");
        long endTime = System.currentTimeMillis();
        Assert.assertTrue((endTime - startTime < 100L && endTime - startTime >= 10L ? 1 : 0) != 0);
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION:SLEEP@1", (String)"INVALID_LABEL");
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION:NOT_FOUND@1", (String)"TEST_SLEEP_ACTION");
    }

    @Test(expected=Exception.class)
    public void testSleepDebugActionNegative() throws Exception {
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION:SLEEP10", (String)"TEST_SLEEP_ACTION");
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION|SLEEP10", (String)"TEST_SLEEP_ACTION");
        DebugUtils.executeDebugAction((String)"TEST_SLEEP_ACTION@SLEEP:10", (String)"TEST_SLEEP_ACTION");
    }

    @Test
    public void testJitter() {
        DebugUtils.executeDebugAction((String)"TEST_JITTER_ACTION:JITTER@1", (String)"test_jitter_action");
        long startTime = System.currentTimeMillis();
        DebugUtils.executeDebugAction((String)"SOME_OTHER_ACTION:SLEEP@100|TEST_JITTER_ACTION:JITTER@10@0.2", (String)"test_jitter_action");
        long endTime = System.currentTimeMillis();
        Assert.assertTrue((endTime - startTime < 100L ? 1 : 0) != 0);
    }

    @Test(expected=Exception.class)
    public void testJitterNegative() throws Exception {
        DebugUtils.executeDebugAction((String)"TEST_JITTER_ACTION@JITTER:1", (String)"test_jitter_action");
        DebugUtils.executeDebugAction((String)"TEST_JITTER_ACTION:JITTER", (String)"test_jitter_action");
    }

    @Test
    public void testException() {
        try {
            DebugUtils.executeDebugAction((String)"TEST_FAIL_ACTION:EXCEPTION@CommitFailedException@some text", (String)"test_fail_action");
            Assert.fail((String)"should have got exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getClass().getName().contains("CommitFailedException"));
            Assert.assertTrue((boolean)e.getMessage().contains("some text"));
        }
    }

    @Test
    public void testExceptionNegative() {
        DebugUtils.executeDebugAction((String)"TEST_FAIL_ACTION:EXCEPTION@LocalCatalogException@some text", (String)"test_fail_action");
        try {
            DebugUtils.executeDebugAction((String)"TEST_FAIL_ACTION:EXCEPTION@CommitFailedException", (String)"test_fail_action");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("EXCEPTION debug action needs 3 action params"));
        }
    }
}

