/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.authorization.ranger.RangerAuthorizationFactory;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.util.AuthorizationUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AuthorizationUtilTest {
    private static TBackendGflags origFlags;

    @BeforeClass
    public static void setup() {
        if (BackendConfig.INSTANCE == null) {
            BackendConfig.create((TBackendGflags)new TBackendGflags());
        }
        origFlags = BackendConfig.INSTANCE.getBackendCfg();
    }

    @AfterClass
    public static void teardown() {
        BackendConfig.create((TBackendGflags)origFlags);
    }

    private static BackendConfig authCfg(String authorization_factory_class, String authorization_provider) {
        TBackendGflags stubCfg = new TBackendGflags();
        stubCfg.setAuthorization_factory_class(authorization_factory_class);
        stubCfg.setAuthorization_provider(authorization_provider);
        BackendConfig.create((TBackendGflags)stubCfg);
        return BackendConfig.INSTANCE;
    }

    private static BackendConfig authCfg(Class<? extends AuthorizationFactory> authorization_factory_class, String authorization_provider) {
        return AuthorizationUtilTest.authCfg(authorization_factory_class.getCanonicalName(), authorization_provider);
    }

    @Test
    public void testAuthorizationProviderFlag() throws Exception {
        Assert.assertEquals((Object)RangerAuthorizationFactory.class.getCanonicalName(), (Object)AuthorizationUtil.authzFactoryClassNameFrom((BackendConfig)AuthorizationUtilTest.authCfg("", "ranger")));
        Assert.assertEquals((Object)NoopAuthorizationFactory.class.getCanonicalName(), (Object)AuthorizationUtil.authzFactoryClassNameFrom((BackendConfig)AuthorizationUtilTest.authCfg("", "")));
        Assert.assertEquals((Object)RangerAuthorizationFactory.class.getCanonicalName(), (Object)AuthorizationUtil.authzFactoryClassNameFrom((BackendConfig)AuthorizationUtilTest.authCfg(RangerAuthorizationFactory.class, "")));
    }
}

