/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WebClient {
    private static final String WEBSERVER_HOST = "localhost";
    private static final int DEFAULT_WEBSERVER_PORT = 25000;
    private static final String JSON_METRICS = "/jsonmetrics?json";
    private CloseableHttpClient httpClient_;
    private BasicCookieStore cookieStore_;
    private int port_;
    private String username_;
    private String password_;

    public WebClient() {
        this("", "", 25000);
    }

    public WebClient(int port) {
        this("", "", port);
    }

    public WebClient(String username, String password) {
        this(username, password, 25000);
    }

    public WebClient(String username, String password, int port) {
        this.username_ = username;
        this.password_ = password;
        this.port_ = port;
        this.httpClient_ = HttpClients.createDefault();
        this.cookieStore_ = new BasicCookieStore();
    }

    public void Close() throws IOException {
        this.httpClient_.close();
    }

    public List<Cookie> getCookies() {
        return this.cookieStore_.getCookies();
    }

    public Object getMetric(String metricId) throws Exception {
        JSONObject json = this.jsonGet(JSON_METRICS);
        if (json == null) {
            return null;
        }
        return json.get((Object)metricId);
    }

    public JSONObject jsonGet(String path) throws Exception {
        return WebClient.toJson(this.readContent(path));
    }

    public JSONObject jsonPost(String path, Header[] headers, List<NameValuePair> params) throws Exception {
        return WebClient.toJson(this.post(path, headers, params, 200));
    }

    public String readContent(String path) throws IOException {
        HttpHost target = new HttpHost(WEBSERVER_HOST, this.port_, "http");
        HttpClientContext context = this.getContext(target);
        HttpGet get = new HttpGet(path);
        try (CloseableHttpResponse response = this.httpClient_.execute(target, (HttpRequest)get, (HttpContext)context);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    public String post(String path, Header[] headers, List<NameValuePair> params, int code) throws IOException {
        HttpHost target = new HttpHost(WEBSERVER_HOST, this.port_, "http");
        HttpClientContext context = this.getContext(target);
        HttpPost post = new HttpPost(path);
        if (headers != null) {
            post.setHeaders(headers);
        }
        if (params != null) {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        }
        try (CloseableHttpResponse response = this.httpClient_.execute(target, (HttpRequest)post, (HttpContext)context);){
            if (response.getStatusLine().getStatusCode() != code) {
                String string = null;
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    private HttpClientContext getContext(HttpHost targetHost) {
        HttpClientContext context = HttpClientContext.create();
        if (!this.username_.equals("")) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(WEBSERVER_HOST, this.port_), (Credentials)new UsernamePasswordCredentials(this.username_, this.password_));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            context.setAuthCache((AuthCache)authCache);
        }
        context.setCookieStore((CookieStore)this.cookieStore_);
        return context;
    }

    private static JSONObject toJson(String text) throws ParseException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(text);
        if (!(obj instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)obj;
    }
}

