/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.impala.thrift.TClientRequest;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSessionState;
import org.apache.impala.thrift.TSessionType;
import org.apache.impala.thrift.TUniqueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    private static final String[] ignoreContentAfter_ = new String[]{"HOST:", "LOCATIONS:"};
    private static final String REGEX_AGAINST_ACTUAL = "regex:";
    private static final String NUMBER_REGEX = "\\d+(\\.\\d+)?";
    private static final String BYTE_SUFFIX_REGEX = "[KMGT]?B";
    private static final String BYTE_VALUE_REGEX = "\\d+(\\.\\d+)?[KMGT]?B";
    static final String HIVE_SERVER2_DRIVER_NAME = "org.apache.hive.jdbc.HiveDriver";
    static final String HS2_CONNECTION_TEMPLATE = "jdbc:hive2://localhost:%d/default";
    public static final ResultFilter SCAN_NODE_SCHEME_FILTER = new ResultFilter(){
        private final String fsSchemes = "(HDFS|S3|LOCAL|ADLS|OSS)";
        private final Pattern scanNodeFsScheme = Pattern.compile("SCAN (HDFS|S3|LOCAL|ADLS|OSS)");
        private final Pattern scanNodeInputMetadata = Pattern.compile("(HDFS|S3|LOCAL|ADLS|OSS) partitions=\\d+/\\d+ files=\\d+ size=");

        @Override
        public boolean matches(String input) {
            return this.scanNodeInputMetadata.matcher(input).find() || this.scanNodeFsScheme.matcher(input).find();
        }

        @Override
        public String transform(String input) {
            return input.replaceAll("(HDFS|S3|LOCAL|ADLS|OSS)", "");
        }
    };
    public static final IgnoreValueFilter FILE_SIZE_FILTER = new IgnoreValueFilter("size", "\\d+(\\.\\d+)?[KMGT]?B");
    public static final IgnoreValueFilter ROW_SIZE_FILTER = new IgnoreValueFilter("row-size", "\\S+");
    public static final IgnoreValueFilter CARDINALITY_FILTER = new IgnoreValueFilter("cardinality", "(unavailable|[0-9\\.KMGT]+(\\(filtered from [0-9\\.KMGT]+\\))?)");
    public static final IgnoreValueFilter ICEBERG_SNAPSHOT_ID_FILTER = new IgnoreValueFilter("Iceberg snapshot id", " \\d+", ':');
    public static final ReplaceValueFilter PARTITIONS_FILTER = new ReplaceValueFilter("partitions", "( \\d+/\\d+ rows=)\\S+", "$1", ':');
    static IgnoreValueFilter SCAN_RANGE_ROW_COUNT_FILTER = new IgnoreValueFilter("max-scan-range-rows", "(\\d+(?:.\\d+)?)([TGMK]?)");
    private static final List<ResultFilter> DEFAULT_FILTERS = Arrays.asList(SCAN_RANGE_ROW_COUNT_FILTER, new PathFilter("hdfs:"), new PathFilter("file: "));
    public static final List<ResultFilter> RESOURCE_FILTERS = Arrays.asList(new IgnoreValueFilter("mem-estimate", "\\d+(\\.\\d+)?[KMGT]?B"), new IgnoreValueFilter("mem-reservation", "\\d+(\\.\\d+)?[KMGT]?B"), new IgnoreValueFilter("thread-reservation", "\\d+(\\.\\d+)?"), new IgnoreValueFilter("Memory", "\\d+(\\.\\d+)?[KMGT]?B"), new IgnoreValueFilter("Threads", "\\d+(\\.\\d+)?"));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String compareOutput(ArrayList<String> actual, ArrayList<String> expected, boolean orderMatters, List<ResultFilter> lineFilters) {
        String str2;
        if (!orderMatters) {
            Collections.sort(actual);
            Collections.sort(expected);
        }
        int mismatch = -1;
        int maxLen = Math.min(actual.size(), expected.size());
        block41: for (int i = 0; i < maxLen; ++i) {
            String expectedStr = expected.get(i);
            String actualStr = actual.get(i);
            boolean containsPrefix = false;
            for (List filters : Arrays.asList(DEFAULT_FILTERS, lineFilters)) {
                for (ResultFilter filter : filters) {
                    if (!filter.matches(expectedStr) && !filter.matches(actualStr)) continue;
                    containsPrefix = true;
                    expectedStr = filter.transform(expectedStr);
                    actualStr = filter.transform(actualStr);
                }
            }
            boolean ignoreAfter = false;
            for (int j = 0; j < ignoreContentAfter_.length; ignoreAfter |= expectedStr.startsWith(ignoreContentAfter_[j]), ++j) {
            }
            if (expectedStr.startsWith(REGEX_AGAINST_ACTUAL)) {
                String regex = expectedStr.replace(REGEX_AGAINST_ACTUAL, "").trim();
                if (actualStr.matches(regex)) continue;
                mismatch = i;
                break;
            }
            Scanner e = new Scanner(expectedStr);
            Object object = null;
            try (Scanner a = new Scanner(actualStr);){
                while (a.hasNext() && e.hasNext()) {
                    String aToken = a.next();
                    String eToken = e.next();
                    if (containsPrefix) {
                        if (aToken.contains(eToken)) continue;
                        mismatch = i;
                        break block41;
                    }
                    if (aToken.equals(eToken)) continue;
                    mismatch = i;
                    break block41;
                }
                if (ignoreAfter) {
                    if (!e.hasNext() || a.hasNext()) continue;
                    mismatch = i;
                    break;
                }
                if (a.hasNext() == e.hasNext()) continue;
                mismatch = i;
                break;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (e != null) {
                    if (object != null) {
                        try {
                            e.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        e.close();
                    }
                }
            }
        }
        if (mismatch == -1 && actual.size() < expected.size()) {
            int i;
            StringBuilder output = new StringBuilder("Actual result is missing lines:\n");
            for (i = 0; i < actual.size(); ++i) {
                output.append(actual.get(i)).append("\n");
            }
            output.append("Missing:\n");
            i = actual.size();
            while (true) {
                if (i >= expected.size()) {
                    return output.toString();
                }
                output.append(expected.get(i)).append("\n");
                ++i;
            }
        }
        if (mismatch != -1) {
            int i;
            StringBuilder output = new StringBuilder("Actual does not match expected result:\n");
            for (i = 0; i <= mismatch; ++i) {
                output.append(actual.get(i)).append("\n");
            }
            for (i = 0; i < actual.get(mismatch).length(); ++i) {
                output.append('^');
            }
            output.append("\n");
            for (i = mismatch + 1; i < actual.size(); ++i) {
                output.append(actual.get(i)).append("\n");
            }
            output.append("\nExpected:\n");
            Iterator<String> iterator = expected.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return output.toString();
                }
                str2 = iterator.next();
                output.append(str2).append("\n");
            }
        }
        if (actual.size() <= expected.size()) {
            return "";
        }
        StringBuilder output = new StringBuilder("Actual result contains extra output:\n");
        for (String str2 : actual) {
            output.append(str2).append("\n");
        }
        output.append("\nExpected:\n");
        Iterator<String> iterator = expected.iterator();
        while (iterator.hasNext()) {
            str2 = iterator.next();
            output.append(str2).append("\n");
        }
        return output.toString();
    }

    public static TQueryCtx createQueryContext() {
        return TestUtils.createQueryContext("default", System.getProperty("user.name"));
    }

    public static TQueryCtx createQueryContext(String defaultDb, String user) {
        TQueryCtx queryCtx = TestUtils.createQueryContext(defaultDb, user, new TQueryOptions());
        queryCtx.client_request.query_options.setEnable_expr_rewrites(false);
        return queryCtx;
    }

    public static TQueryCtx createQueryContext(TQueryOptions options) {
        return TestUtils.createQueryContext("default", System.getProperty("user.name"), options);
    }

    public static TQueryCtx createQueryContext(String defaultDb, String user, TQueryOptions options) {
        TQueryCtx queryCtx = new TQueryCtx();
        queryCtx.setClient_request(new TClientRequest("FeTests", options));
        queryCtx.setQuery_id(new TUniqueId());
        queryCtx.setSession(new TSessionState(new TUniqueId(), TSessionType.BEESWAX, defaultDb, user, new TNetworkAddress("localhost", 0)));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
        Date now = Calendar.getInstance().getTime();
        queryCtx.setNow_string(formatter.format(now));
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        queryCtx.setUtc_timestamp_string(formatter.format(now));
        queryCtx.setLocal_time_zone("UTC");
        queryCtx.setStart_unix_millis(System.currentTimeMillis());
        queryCtx.setPid(1000);
        return queryCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrintJson(String json) {
        StringWriter sw = new StringWriter();
        try (JsonWriter jsonWriter = null;){
            JsonReader jr = Json.createReader((Reader)new StringReader(json));
            JsonObject jobj = jr.readObject();
            HashMap properties = Maps.newHashMap();
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory((Map)properties);
            jsonWriter = writerFactory.createWriter((Writer)sw);
            jsonWriter.writeObject(jobj);
        }
        return sw.toString();
    }

    public static int getHiveMajorVersion() {
        String hiveMajorVersion = (String)Preconditions.checkNotNull((Object)System.getenv("IMPALA_HIVE_MAJOR_VERSION"));
        return Integer.parseInt(hiveMajorVersion);
    }

    public static boolean isCatalogV2Enabled(String host, int port) throws IOException {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkState((port >= 0 ? 1 : 0) != 0);
        String topicMode = TestUtils.getConfigValue(new URL(String.format("http://%s:%s/varz?json", host, port)), "catalog_topic_mode");
        Preconditions.checkNotNull((Object)topicMode);
        return topicMode.equals("minimal");
    }

    private static String getConfigValue(URL url, String key) throws IOException {
        Map map = (Map)new ObjectMapper().readValue(url, Map.class);
        if (map.containsKey("flags")) {
            Preconditions.checkState((boolean)map.containsKey("flags"));
            ArrayList flags = (ArrayList)map.get("flags");
            for (LinkedHashMap flag : flags) {
                if (!flag.getOrDefault("name", "").equals(key)) continue;
                return (String)flag.get("current");
            }
        }
        return null;
    }

    public static String getRandomString(int size) {
        return RandomStringUtils.randomAlphanumeric((int)size);
    }

    public static class ReplaceValueFilter
    extends IgnoreValueFilter {
        private final String replaceRegex;

        public ReplaceValueFilter(String key, String valueRegex, String replaceRegex, char separator) {
            super(key, valueRegex, separator);
            this.replaceRegex = replaceRegex;
        }

        @Override
        public String transform(String input) {
            return input.replaceAll(this.keyPrefix + this.valueRegex, this.keyPrefix + this.replaceRegex);
        }
    }

    public static class IgnoreValueFilter
    implements ResultFilter {
        protected final String keyPrefix;
        protected final String valueRegex;

        public IgnoreValueFilter(String key, String valueRegex, char separator) {
            this.keyPrefix = " " + key + Character.toString(separator);
            this.valueRegex = valueRegex;
        }

        public IgnoreValueFilter(String key, String valueRegex) {
            this(key, valueRegex, '=');
        }

        @Override
        public boolean matches(String input) {
            return input.contains(this.keyPrefix);
        }

        @Override
        public String transform(String input) {
            return input.replaceAll(this.keyPrefix + this.valueRegex, this.keyPrefix);
        }
    }

    static class PathFilter
    implements ResultFilter {
        private static final String PATH_FILTER = "-*\\d+--\\d+_\\d+.*$";
        private static final String PORT_FILTER = "//\\w+(\\.\\w+)?(\\.\\w+)?:\\d+";
        private final String filterKey_;

        public PathFilter(String prefix) {
            this.filterKey_ = prefix;
        }

        @Override
        public boolean matches(String input) {
            return input.contains(this.filterKey_);
        }

        @Override
        public String transform(String input) {
            String result = input.replaceFirst(this.filterKey_, "");
            result = result.replaceAll(PATH_FILTER, " ");
            return result.replaceAll(PORT_FILTER, "");
        }
    }

    public static interface ResultFilter {
        public boolean matches(String var1);

        public String transform(String var1);
    }
}

