/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Scanner;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class TestFileParser {
    private static final Logger LOG = Logger.getLogger(TestCase.class);
    private final List<TestCase> testCases = Lists.newArrayList();
    private int lineNum = 0;
    private final String fileName;
    private BufferedReader reader;
    private Scanner scanner;
    private boolean hasSetupSection = false;
    private TQueryOptions options;
    private static final ArrayList<Section> defaultSectionOrder = Lists.newArrayList((Object[])new Section[]{Section.QUERY, Section.TYPES, Section.RESULTS});

    public TestFileParser(String fileName, TQueryOptions options) {
        this.fileName = fileName;
        this.options = options;
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public String getTestFileName() {
        return this.fileName;
    }

    public boolean hasSetupSection() {
        return this.hasSetupSection;
    }

    private void open(String table) {
        try {
            String testFileBaseDir = new File(System.getenv("IMPALA_HOME"), "testdata/workloads").getPath();
            String fullPath = new File(testFileBaseDir, this.fileName).getPath();
            this.reader = new BufferedReader(new FileReader(fullPath));
            this.scanner = new Scanner(this.reader);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private TestCase parseOneTestCase() {
        Section currentSection = Section.QUERY;
        ArrayList sectionContents = Lists.newArrayList();
        TestCase currentTestCase = new TestCase(this.lineNum, this.options.deepCopy());
        int sectionCount = 0;
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            ++this.lineNum;
            if (line.startsWith("====") && sectionCount > 0) {
                currentTestCase.addSection(currentSection, sectionContents);
                this.parseQueryOptions(currentTestCase);
                if (!currentTestCase.isValid()) {
                    throw new IllegalStateException("Invalid test case at line " + currentTestCase.startLineNum + " detected.");
                }
                return currentTestCase;
            }
            if (line.startsWith("----")) {
                ++sectionCount;
                currentTestCase.addSection(currentSection, sectionContents);
                boolean found = false;
                line = line.trim().toLowerCase();
                if (!line.endsWith("----")) {
                    for (Section s : Section.values()) {
                        if (!line.matches("----\\s+" + s.toString().toLowerCase() + "\\b.*")) continue;
                        currentSection = s;
                        if (s == Section.SETUP) {
                            this.hasSetupSection = true;
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IllegalStateException("Unknown section name: " + line);
                    }
                } else {
                    if (sectionCount >= defaultSectionOrder.size()) {
                        throw new IllegalStateException("Unexpected number of untitled sections: " + sectionCount);
                    }
                    currentSection = defaultSectionOrder.get(sectionCount);
                    LOG.warn((Object)("No section header found. Guessing: " + (Object)((Object)currentSection)));
                }
                if (!currentTestCase.getSectionContents(currentSection).isEmpty()) {
                    throw new IllegalStateException("Duplicate sections are not allowed: " + (Object)((Object)currentSection));
                }
                sectionContents = Lists.newArrayList();
                continue;
            }
            sectionContents.add(line);
        }
        if (!currentTestCase.isEmpty() && !currentTestCase.isValid()) {
            throw new IllegalStateException("Invalid test case at line " + currentTestCase.startLineNum + " detected.");
        }
        return currentTestCase;
    }

    private void parseQueryOptions(TestCase testCase) {
        String optionsStr = testCase.getSectionAsString(Section.QUERYOPTIONS, false, ",");
        if (optionsStr == null || optionsStr.isEmpty()) {
            return;
        }
        TQueryOptions result = null;
        try {
            result = FeSupport.ParseQueryOptions((String)optionsStr, (TQueryOptions)testCase.getOptions());
        }
        catch (InternalException e) {
            throw new IllegalStateException("Failed to parse query options: " + optionsStr + " - " + e.getMessage(), e);
        }
        Preconditions.checkNotNull((Object)result);
        testCase.setOptions(result);
    }

    public void parseFile() {
        this.parseFile(null);
    }

    public void parseFile(String table) {
        try {
            this.open(table);
            this.testCases.clear();
            while (this.scanner.hasNextLine()) {
                TestCase testCase = this.parseOneTestCase();
                if (testCase.isEmpty()) continue;
                this.testCases.add(testCase);
            }
        }
        finally {
            this.close();
        }
    }

    private void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        if (this.scanner != null) {
            this.scanner.close();
        }
    }

    public static class TestCase {
        private final EnumMap<Section, ArrayList<String>> expectedResultSections = Maps.newEnumMap(Section.class);
        private final int startLineNum;
        private TQueryOptions options;

        public TestCase(int lineNum, TQueryOptions options) {
            this.startLineNum = lineNum;
            this.options = options;
        }

        public int getStartingLineNum() {
            return this.startLineNum;
        }

        public TQueryOptions getOptions() {
            return this.options;
        }

        public void setOptions(TQueryOptions options) {
            this.options = options;
        }

        protected void addSection(Section section, ArrayList<String> contents) {
            this.expectedResultSections.put(section, contents);
        }

        public ArrayList<String> getSectionContents(Section section) {
            return this.getSectionContents(section, false);
        }

        public ArrayList<String> getSectionContents(Section section, boolean withComments) {
            return this.getSectionContents(section, withComments, null);
        }

        public ArrayList<String> getSectionContents(Section section, boolean withComments, String dbSuffix) {
            ArrayList<String> ret = this.expectedResultSections.get((Object)section);
            if (ret == null) {
                return Lists.newArrayList();
            }
            if (withComments && dbSuffix == null) {
                return ret;
            }
            ArrayList retList = Lists.newArrayList();
            for (String s : ret) {
                if (!s.startsWith("#") && !s.startsWith("//")) {
                    if (dbSuffix != null) {
                        retList.add(s.replaceAll("\\$DATABASE", dbSuffix));
                        continue;
                    }
                    retList.add(s);
                    continue;
                }
                if (!withComments) continue;
                retList.add(s);
            }
            return retList;
        }

        public String getSectionAsString(Section section, boolean withComments, String delimiter) {
            return this.getSectionAsString(section, withComments, delimiter, null);
        }

        public String getSectionAsString(Section section, boolean withComments, String delimiter, String dbSuffix) {
            ArrayList<String> sectionList = this.getSectionContents(section, withComments, dbSuffix);
            if (sectionList == null) {
                return null;
            }
            return Joiner.on((String)delimiter).join(sectionList);
        }

        public String getQuery() {
            return this.getSectionAsString(Section.QUERY, false, "\n");
        }

        public boolean isValid() {
            return !this.getQuery().isEmpty() && (!this.getSectionContents(Section.PLAN).isEmpty() || !this.getSectionContents(Section.DISTRIBUTEDPLAN).isEmpty() || !this.getSectionContents(Section.PARALLELPLANS).isEmpty() || !this.getSectionContents(Section.LINEAGE).isEmpty());
        }

        public boolean isEmpty() {
            return this.expectedResultSections.isEmpty();
        }
    }

    public static enum Section {
        QUERY,
        TYPES,
        COLLABELS,
        RESULTS,
        PLAN,
        DISTRIBUTEDPLAN,
        PARALLELPLANS,
        FILEERRORS,
        PARTITIONS,
        SETUP,
        ERRORS,
        SCANRANGELOCATIONS,
        LINEAGE,
        QUERYOPTIONS,
        HIVE_MAJOR_VERSION;


        public String getHeader() {
            return "---- " + this.toString();
        }
    }
}

