/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.NoOpEventProcessor;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.catalog.metastore.NoOpCatalogMetastoreServer;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hive.executor.HiveJavaFunctionFactory;
import org.apache.impala.hive.executor.TestHiveJavaFunctionFactory;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.FeSupport;
import org.apache.impala.testutil.EmbeddedMetastoreClientPool;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.NoOpEventSequence;

public class CatalogServiceTestCatalog
extends CatalogServiceCatalog {
    private CatalogOpExecutor opExecutor_;

    protected CatalogServiceTestCatalog(boolean loadInBackground, int numLoadingThreads, MetaStoreClientPool metaStoreClientPool) throws ImpalaException {
        super(loadInBackground, numLoadingThreads, System.getProperty("java.io.tmpdir"), metaStoreClientPool);
        CatalogServiceCatalog.CachePoolReader rd = new CatalogServiceCatalog.CachePoolReader((CatalogServiceCatalog)this, false);
        rd.run();
    }

    public static CatalogServiceTestCatalog create() {
        return CatalogServiceTestCatalog.createWithAuth((AuthorizationFactory)new NoopAuthorizationFactory());
    }

    public static CatalogServiceTestCatalog createWithAuth(AuthorizationFactory factory) {
        return CatalogServiceTestCatalog.createWithAuth(factory, () -> new CatalogServiceTestCatalog(false, 16, new MetaStoreClientPool(0, 0)));
    }

    public static CatalogServiceTestCatalog createWithAuth(AuthorizationFactory factory, BaseTestCatalogSupplier catalogSupplier) {
        CatalogServiceTestCatalog cs;
        FeSupport.loadLibrary();
        try {
            if (MetastoreShim.getMajorVersion() > 2L) {
                MetastoreShim.setHiveClientCapabilities();
            }
            cs = catalogSupplier.get();
            cs.setAuthzManager(factory.newAuthorizationManager((CatalogServiceCatalog)cs));
            cs.setMetastoreEventProcessor(NoOpEventProcessor.getInstance());
            cs.setCatalogMetastoreServer((ICatalogMetastoreServer)NoOpCatalogMetastoreServer.INSTANCE);
            cs.setCatalogOpExecutor(new CatalogOpExecutor((CatalogServiceCatalog)cs, new NoopAuthorizationFactory().getAuthorizationConfig(), (AuthorizationManager)new NoopAuthorizationFactory.NoopAuthorizationManager(), (HiveJavaFunctionFactory)new TestHiveJavaFunctionFactory()));
            cs.setEventFactoryForSyncToLatestEvent((MetastoreEvents.MetastoreEventFactory)new MetastoreEvents.EventFactoryForSyncToLatestEvent(cs.getCatalogOpExecutor()));
            cs.reset((EventSequence)NoOpEventSequence.INSTANCE);
        }
        catch (ImpalaException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return cs;
    }

    public static CatalogServiceCatalog createTransientTestCatalog() throws ImpalaException {
        FeSupport.loadLibrary();
        Path derbyPath = Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        if (MetastoreShim.getMajorVersion() > 2L) {
            MetastoreShim.setHiveClientCapabilities();
        }
        CatalogServiceTestCatalog cs = new CatalogServiceTestCatalog(false, 16, new EmbeddedMetastoreClientPool(0, derbyPath));
        cs.setAuthzManager((AuthorizationManager)new NoopAuthorizationFactory.NoopAuthorizationManager());
        cs.setMetastoreEventProcessor(NoOpEventProcessor.getInstance());
        cs.setCatalogOpExecutor(new CatalogOpExecutor((CatalogServiceCatalog)cs, new NoopAuthorizationFactory().getAuthorizationConfig(), (AuthorizationManager)new NoopAuthorizationFactory.NoopAuthorizationManager(), (HiveJavaFunctionFactory)new TestHiveJavaFunctionFactory()));
        cs.setEventFactoryForSyncToLatestEvent((MetastoreEvents.MetastoreEventFactory)new MetastoreEvents.EventFactoryForSyncToLatestEvent(cs.getCatalogOpExecutor()));
        cs.reset((EventSequence)NoOpEventSequence.INSTANCE);
        return cs;
    }

    public AuthorizationPolicy getAuthPolicy() {
        return this.authPolicy_;
    }

    protected void setCatalogOpExecutor(CatalogOpExecutor opExecutor) {
        this.opExecutor_ = opExecutor;
    }

    public CatalogOpExecutor getCatalogOpExecutor() {
        Preconditions.checkNotNull((Object)this.opExecutor_, (Object)"returning null opExecutor_");
        return this.opExecutor_;
    }

    public static interface BaseTestCatalogSupplier {
        public CatalogServiceTestCatalog get() throws ImpalaException;
    }
}

