/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.util.PatternMatcher;

public class BlockIdGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Exception("Invalid args: BlockIdGenerator <output_file>");
        }
        HdfsConfiguration hdfsConfig = new HdfsConfiguration();
        File output = new File(args[0]);
        try (FileWriter writer = null;){
            writer = new FileWriter(output);
            try (CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();){
                for (FeDb database : catalog.getDbs(PatternMatcher.MATCHER_MATCH_ALL)) {
                    for (String tableName : database.getAllTableNames()) {
                        FeTable table = database.getTable(tableName);
                        if (table == null || !(table instanceof HdfsTable)) continue;
                        HdfsTable hdfsTable = (HdfsTable)table;
                        writer.write(tableName + ":");
                        Collection parts = FeCatalogUtils.loadAllPartitions((FeFsTable)hdfsTable);
                        for (FeFsPartition partition : parts) {
                            List fileDescriptors = partition.getFileDescriptors();
                            for (HdfsPartition.FileDescriptor fd : fileDescriptors) {
                                Path p = new Path(fd.getAbsolutePath(partition.getLocation()));
                                DistributedFileSystem dfs = (DistributedFileSystem)p.getFileSystem((Configuration)hdfsConfig);
                                LocatedBlocks locations = dfs.getClient().getNamenode().getBlockLocations(p.toUri().getPath(), 0L, fd.getFileLength());
                                for (LocatedBlock lb : locations.getLocatedBlocks()) {
                                    long id = lb.getBlock().getBlockId();
                                    writer.write(" " + id);
                                }
                            }
                        }
                        writer.write("\n");
                    }
                }
            }
        }
    }
}

