/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.testutil.ImpalaJdbcClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class JdbcTestBase {
    protected String connectionType_;
    protected Connection con_;
    protected final List<String> testTableNames_ = Lists.newArrayList();

    public JdbcTestBase(String connectionType) {
        this.connectionType_ = connectionType;
    }

    @Parameterized.Parameters
    public static String[] createConnections() {
        return new String[]{"binary", "http"};
    }

    @After
    public void cleanUp() throws Exception {
        for (String tableName : this.testTableNames_) {
            this.dropTestTable(tableName);
        }
        if (this.con_ != null) {
            this.con_.close();
            Assert.assertTrue((String)"Connection should be closed", (boolean)this.con_.isClosed());
            Exception expectedException = null;
            try {
                this.con_.createStatement();
            }
            catch (Exception e) {
                expectedException = e;
            }
            Assert.assertNotNull((String)"createStatement() on closed connection should throw exception", (Object)expectedException);
        }
    }

    protected static Connection createConnection(String connStr) throws Exception {
        ImpalaJdbcClient client = ImpalaJdbcClient.createClientUsingHiveJdbcDriver(connStr);
        client.connect();
        Connection connection = client.getConnection();
        Assert.assertNotNull((String)"Connection is null", (Object)connection);
        Assert.assertFalse((String)"Connection should not be closed", (boolean)connection.isClosed());
        Statement stmt = connection.createStatement();
        Assert.assertNotNull((String)"Statement is null", (Object)stmt);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTestTable(String createTableSql) throws Exception {
        StatementBase result = Parser.parse((String)createTableSql);
        if (!(result instanceof CreateTableStmt)) {
            throw new Exception("Given stmt is not a CREATE TABLE stmt: " + createTableSql);
        }
        try (Statement stmt = this.con_.createStatement();){
            stmt.execute(createTableSql);
        }
        CreateTableStmt parsedStmt = (CreateTableStmt)result;
        this.testTableNames_.add(parsedStmt.getTblName().toString());
    }

    protected void dropTestTable(String tableName) throws SQLException {
        try (Statement stmt = this.con_.createStatement();){
            stmt.execute("DROP TABLE " + tableName);
        }
    }
}

