/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.impala.service.JdbcTestBase;
import org.apache.impala.testutil.ImpalaJdbcClient;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.testutil.WebClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcTest
extends JdbcTestBase {
    public JdbcTest(String connectionType) {
        super(connectionType);
    }

    @Before
    public void setUp() throws Exception {
        this.con_ = JdbcTest.createConnection(ImpalaJdbcClient.getNoAuthConnectionStr(this.connectionType_));
    }

    @Test
    public void testMetaDataGetTables() throws SQLException {
        HashMap<String, String> tests = new HashMap<String, String>();
        tests.put("alltypes", "alltypes");
        tests.put("%all_ypes", "alltypes");
        String[][] tblTypes = new String[][]{null, {"TABLE"}};
        for (String tblNamePattern : tests.keySet()) {
            for (String[] tblType : tblTypes) {
                ResultSet rs = this.con_.getMetaData().getTables("", "functional", tblNamePattern, tblType);
                Assert.assertTrue((boolean)rs.next());
                String resultTableName = rs.getString("TABLE_NAME");
                Assert.assertEquals((Object)rs.getString(3), (Object)resultTableName);
                Assert.assertEquals((String)"Table mismatch", tests.get(tblNamePattern), (Object)resultTableName);
                String tableType = rs.getString("TABLE_TYPE");
                Assert.assertEquals((Object)"table", (Object)tableType.toLowerCase());
                Assert.assertFalse((boolean)rs.next());
                rs.close();
            }
        }
        for (String[] tblType : tblTypes) {
            ResultSet rs = this.con_.getMetaData().getTables(null, null, null, tblType);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
            rs = this.con_.getMetaData().getTables(null, null, null, tblType);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
        }
    }

    @Test
    public void testMetaDataGetCatalogs() throws SQLException {
        ResultSet rs = this.con_.getMetaData().getCatalogs();
        ResultSetMetaData resMeta = rs.getMetaData();
        Assert.assertEquals((long)1L, (long)resMeta.getColumnCount());
        Assert.assertEquals((Object)"TABLE_CAT", (Object)resMeta.getColumnName(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMetaDataGetSchemas() throws SQLException {
        ResultSet rs = this.con_.getMetaData().getSchemas("", "d_f%");
        ResultSetMetaData resMeta = rs.getMetaData();
        Assert.assertEquals((long)2L, (long)resMeta.getColumnCount());
        Assert.assertEquals((Object)"TABLE_SCHEM", (Object)resMeta.getColumnName(1));
        Assert.assertEquals((Object)"TABLE_CATALOG", (Object)resMeta.getColumnName(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1).toLowerCase(), (Object)"default");
        Assert.assertFalse((boolean)rs.next());
        rs.close();
    }

    @Test
    public void testMetaDataGetTableTypes() throws SQLException {
        ResultSet rs = this.con_.getMetaData().getTableTypes();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1).toLowerCase(), (Object)"table");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1).toLowerCase(), (Object)"view");
        Assert.assertFalse((boolean)rs.next());
        rs.close();
    }

    @Test
    public void testMetaDataGetColumns() throws Exception {
        ResultSet rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "s%rin%");
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((Object)"TABLE_CAT", (Object)rsmd.getColumnName(1));
        Assert.assertTrue((boolean)rs.next());
        String columnname = rs.getString("COLUMN_NAME");
        int ordinalPos = rs.getInt("ORDINAL_POSITION");
        Assert.assertEquals((String)"Incorrect column name", (Object)"string_col", (Object)columnname);
        Assert.assertEquals((String)"Incorrect ordinal position", (long)12L, (long)ordinalPos);
        Assert.assertEquals((String)"Incorrect type", (long)12L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "bool_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)16L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "tinyint_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)-6L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)3L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "smallint_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)5L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)5L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "int_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)4L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)10L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "bigint_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)-5L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)19L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "float_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)6L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)7L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)7L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "double_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)8L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)15L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)15L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", "timestamp_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)93L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)29L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)9L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals(null, (Object)rs.getString("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "alltypessmall", null);
        int numCols = 0;
        while (rs.next()) {
            ++numCols;
        }
        Assert.assertEquals((long)13L, (long)numCols);
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "date_tbl", "date_col");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)91L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)10L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals(null, (Object)rs.getString("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "decimal_tbl", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)3L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)9L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)3L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)10L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)3L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)20L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)10L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)3L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)38L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)38L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)3L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)10L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)5L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)3L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)9L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)10L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "chars_tiny", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)1L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)5L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)1L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)140L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)12L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)32L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = this.con_.getMetaData().getColumns(null, "functional", "binary_tbl", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)4L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)10L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)12L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)-2L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        this.addTestTable("create table default.jdbc_complex_type_test (s struct<f1:int,f2:char(4),f3:varchar(5),f4:decimal(10,10)>,a1 array<int>,a2 array<char(4)>,a3 array<varchar(5)>,a4 array<decimal(10,10)>,m1 map<int,string>,m2 map<string,char(4)>,m3 map<bigint,varchar(5)>,m4 map<boolean,decimal(10,10)>)");
        rs = this.con_.getMetaData().getColumns(null, "default", "jdbc_complex_type_test", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2002L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"STRUCT<f1:INT,f2:CHAR(4),f3:VARCHAR(5),f4:DECIMAL(10,10)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"ARRAY<INT>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"ARRAY<CHAR(4)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"ARRAY<VARCHAR(5)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"ARRAY<DECIMAL(10,10)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"MAP<INT,STRING>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"MAP<STRING,CHAR(4)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"MAP<BIGINT,VARCHAR(5)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect type", (long)2003L, (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((String)"Incorrect type name", (Object)"MAP<BOOLEAN,DECIMAL(10,10)>", (Object)rs.getString("TYPE_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertEquals((long)0L, (long)rs.getInt("NUM_PREC_RADIX"));
        rs.close();
    }

    @Test
    public void testMetaDataGetColumnComments() throws Exception {
        this.addTestTable("create table default.jdbc_column_comments_test (a int comment 'column comment') comment 'table comment'");
        ResultSet rs = this.con_.getMetaData().getTables(null, "default", "jdbc_column_comments_test", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect table name", (Object)"jdbc_column_comments_test", (Object)rs.getString("TABLE_NAME"));
        String remarks = rs.getString("REMARKS");
        Assert.assertTrue((String)("Incorrect table comment: " + remarks), (remarks.equals("") || remarks.equals("table comment") ? 1 : 0) != 0);
        rs = this.con_.getMetaData().getColumns(null, "default", "jdbc_column_comments_test", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect column comment", (Object)"column comment", (Object)rs.getString("REMARKS"));
        rs = this.con_.getMetaData().getTables(null, "default", "jdbc_column_comments_test", null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Incorrect table name", (Object)"jdbc_column_comments_test", (Object)rs.getString("TABLE_NAME"));
        if (!TestUtils.isCatalogV2Enabled("localhost", 25020)) {
            Assert.assertEquals((String)"Incorrect table comment", (Object)"table comment", (Object)rs.getString("REMARKS"));
        }
    }

    @Test
    public void testMetadataGetPrimaryKeys() throws Exception {
        ArrayList<String> pkList = new ArrayList<String>(Arrays.asList("id", "year"));
        ResultSet rs = this.con_.getMetaData().getPrimaryKeys(null, "functional", "parent_table");
        ResultSetMetaData md = rs.getMetaData();
        Assert.assertEquals((String)"Incorrect number of columns seen", (long)6L, (long)md.getColumnCount());
        int pkCount = 0;
        while (rs.next()) {
            Assert.assertEquals((Object)"", (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)"functional", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"parent_table", (Object)rs.getString("TABLE_NAME"));
            Assert.assertTrue((++pkCount <= 2 ? 1 : 0) != 0);
            Assert.assertEquals(pkList.get(pkCount - 1), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((rs.getString("PK_NAME").length() > 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)pkCount);
    }

    @Test
    public void testMetadataGetCrossReference() throws Exception {
        ResultSet rs = this.con_.getMetaData().getCrossReference(null, "functional", "parent_table", null, "functional", "child_table");
        ResultSetMetaData md = rs.getMetaData();
        Assert.assertEquals((String)"Incorrect number of columns seen for primary key.", (long)14L, (long)md.getColumnCount());
        ArrayList<String> colList = new ArrayList<String>(Arrays.asList("id", "year"));
        int fkCount = 0;
        while (rs.next()) {
            Assert.assertEquals((Object)"", (Object)rs.getString("PKTABLE_CAT"));
            Assert.assertEquals((Object)"functional", (Object)rs.getString("PKTABLE_SCHEM"));
            Assert.assertEquals((Object)"parent_table", (Object)rs.getString("PKTABLE_NAME"));
            Assert.assertTrue((++fkCount <= 2 ? 1 : 0) != 0);
            Assert.assertEquals(colList.get(fkCount - 1), (Object)rs.getString("PKCOLUMN_NAME"));
            Assert.assertTrue((rs.getString("FK_NAME").length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"", (Object)rs.getString("FKTABLE_CAT"));
            Assert.assertEquals((Object)"functional", (Object)rs.getString("FKTABLE_SCHEM"));
            Assert.assertEquals((Object)"child_table", (Object)rs.getString("FKTABLE_NAME"));
            Assert.assertTrue((boolean)colList.contains(rs.getString("FKCOLUMN_NAME")));
        }
        Assert.assertEquals((long)2L, (long)fkCount);
    }

    @Test
    public void testDecimalGetColumnTypes() throws SQLException {
        ResultSet rs = this.con_.createStatement().executeQuery("select * from functional.decimal_tbl");
        Assert.assertEquals((long)rs.getMetaData().getColumnType(1), (long)3L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(1), (long)9L);
        Assert.assertEquals((long)rs.getMetaData().getScale(1), (long)0L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(2), (long)3L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(2), (long)10L);
        Assert.assertEquals((long)rs.getMetaData().getScale(2), (long)0L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(3), (long)3L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(3), (long)20L);
        Assert.assertEquals((long)rs.getMetaData().getScale(3), (long)10L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(4), (long)3L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(4), (long)38L);
        Assert.assertEquals((long)rs.getMetaData().getScale(4), (long)38L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(5), (long)3L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(5), (long)10L);
        Assert.assertEquals((long)rs.getMetaData().getScale(5), (long)5L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(6), (long)3L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(6), (long)9L);
        Assert.assertEquals((long)rs.getMetaData().getScale(6), (long)0L);
        rs.close();
    }

    @Test
    public void testDateGetColumnTypes() throws SQLException {
        ResultSet rs = this.con_.createStatement().executeQuery("select * from functional.date_tbl");
        Assert.assertEquals((long)rs.getMetaData().getColumnType(1), (long)4L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(1), (long)10L);
        Assert.assertEquals((long)rs.getMetaData().getScale(1), (long)0L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(2), (long)91L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(2), (long)10L);
        Assert.assertEquals((long)rs.getMetaData().getScale(2), (long)0L);
        Assert.assertEquals((long)rs.getMetaData().getColumnType(3), (long)91L);
        Assert.assertEquals((long)rs.getMetaData().getPrecision(3), (long)10L);
        Assert.assertEquals((long)rs.getMetaData().getScale(3), (long)0L);
        rs.close();
    }

    @Test
    public void testMetaDataGetColumnsMetaData() throws SQLException {
        ResultSet rs = this.con_.getMetaData().getColumns(null, "functional", "alltypes", null);
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((Object)"TABLE_CAT", (Object)rsmd.getColumnName(1));
        Assert.assertEquals((long)12L, (long)rsmd.getColumnType(1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)rsmd.getColumnDisplaySize(1));
        Assert.assertEquals((Object)"ORDINAL_POSITION", (Object)rsmd.getColumnName(17));
        Assert.assertEquals((long)4L, (long)rsmd.getColumnType(17));
        Assert.assertEquals((long)11L, (long)rsmd.getColumnDisplaySize(17));
    }

    @Test
    public void testMetaDataGetFunctions() throws SQLException {
        ResultSet rs = this.con_.getMetaData().getFunctions(null, null, "substring");
        int numFound = 0;
        while (rs.next()) {
            String funcName = rs.getString("FUNCTION_NAME");
            Assert.assertEquals((String)"Incorrect function name", (Object)"substring", (Object)funcName.toLowerCase());
            String dbName = rs.getString("FUNCTION_SCHEM");
            Assert.assertEquals((String)"Incorrect function name", (Object)"_impala_builtins", (Object)dbName.toLowerCase());
            String fnSignature = rs.getString("SPECIFIC_NAME");
            Assert.assertTrue((boolean)fnSignature.startsWith("substring("));
            ++numFound;
        }
        Assert.assertEquals((long)numFound, (long)2L);
        rs.close();
        rs = this.con_.getMetaData().getFunctions(null, "default", "substring");
        Assert.assertFalse((boolean)rs.next());
        rs.close();
    }

    @Test
    public void testUtilityFunctions() throws SQLException {
        try (ResultSet rs = this.con_.createStatement().executeQuery("select user()");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"anonymous", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectNull() throws SQLException {
        Assert.assertEquals((long)rs.getMetaData().getColumnType(1), (long)16L);
        try (ResultSet rs = this.con_.createStatement().executeQuery("select NULL");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testConcurrentSessionMixedIdleTimeout() throws Exception {
        WebClient client = new WebClient();
        List<Integer> timeoutPeriods = Arrays.asList(0, 3, 15);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ArrayList<Long> lastTimeSessionActive = new ArrayList<Long>();
        for (int timeout : timeoutPeriods) {
            connections.add(JdbcTest.createConnection(ImpalaJdbcClient.getNoAuthConnectionStr(this.connectionType_)));
        }
        Long numOpenSessions = (Long)client.getMetric("impala-server.num-open-hiveserver2-sessions");
        Long numExpiredSessions = (Long)client.getMetric("impala-server.num-sessions-expired");
        for (int i = 0; i < connections.size(); ++i) {
            Connection connection = (Connection)connections.get(i);
            Integer timeout = timeoutPeriods.get(i);
            connection.createStatement().executeQuery("SELECT 1+2");
            connection.createStatement().executeQuery("SET IDLE_SESSION_TIMEOUT=" + Integer.toString(timeout));
            lastTimeSessionActive.add(System.currentTimeMillis() / 1000L);
        }
        Assert.assertEquals((Object)numOpenSessions, (Object)((Long)client.getMetric("impala-server.num-open-hiveserver2-sessions")));
        Assert.assertEquals((Object)numExpiredSessions, (Object)((Long)client.getMetric("impala-server.num-sessions-expired")));
        for (int timeout : timeoutPeriods) {
            int timeoutToleranceMs = 1500;
            int sleepPeriodMs = timeout * 1000 + timeoutToleranceMs;
            Thread.sleep(sleepPeriodMs);
            for (int i = 0; i < connections.size(); ++i) {
                Connection connection = (Connection)connections.get(i);
                if (connection == null) continue;
                Integer timeoutPeriod = timeoutPeriods.get(i);
                long now = System.currentTimeMillis() / 1000L;
                boolean sessionIsValid = timeoutPeriod == 0 || (long)timeoutPeriod.intValue() > now - (Long)lastTimeSessionActive.get(i);
                try (ResultSet rs = connection.createStatement().executeQuery("SELECT 1+2");){
                    Assert.assertTrue((boolean)sessionIsValid);
                    lastTimeSessionActive.set(i, now);
                    continue;
                }
                catch (SQLException exception) {
                    Assert.assertFalse((boolean)sessionIsValid);
                    connection.close();
                    connections.set(i, null);
                    numOpenSessions = numOpenSessions - 1L;
                    numExpiredSessions = numExpiredSessions + 1L;
                }
            }
            Assert.assertEquals((Object)numOpenSessions, (Object)((Long)client.getMetric("impala-server.num-open-hiveserver2-sessions")));
            Assert.assertEquals((Object)numExpiredSessions, (Object)((Long)client.getMetric("impala-server.num-sessions-expired")));
        }
        Assert.assertNotNull((String)"Connection with 0 timeout should not be null", connections.get(0));
        ((Connection)connections.get(0)).close();
        connections.set(0, null);
        for (Connection connection : connections) {
            Assert.assertNull((String)"Connection is not null", (Object)connection);
        }
    }

    @Test
    public void testSetQueryOptionsInConnectionURL() throws Exception {
        String divideZeroSQL = "SELECT CAST(1 AS DECIMAL)/0";
        String connStr = ImpalaJdbcClient.getNoAuthConnectionStr(this.connectionType_);
        connStr = connStr + "?DECIMAL_V2=false";
        try (Connection connection = JdbcTest.createConnection(connStr);){
            Statement stmt = connection.createStatement();
            try (ResultSet rs = stmt.executeQuery(divideZeroSQL);){
                rs.next();
            }
            stmt.execute("SET DECIMAL_V2=true");
            try {
                rs = stmt.executeQuery(divideZeroSQL);
                var7_10 = null;
                try {
                    rs.next();
                }
                catch (Throwable throwable) {
                    var7_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var7_10 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var7_10.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("UDF ERROR: Cannot divide decimal by zero"));
            }
        }
    }
}

