/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerTestBase;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.planner.TupleCacheNode;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.junit.Assert;
import org.junit.Test;

public class TupleCacheTest
extends PlannerTestBase {
    @Test
    public void testBasicCacheKeys() {
        this.verifyIdenticalCacheKeys("select id from functional.alltypes", "select id from functional.alltypes");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select id from functional.alltypestiny");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select id from functional_parquet.alltypes");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select int_col from functional.alltypes");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select id from functional.alltypes where id = 1");
        this.verifyDifferentCacheKeys("select id from functional.alltypes where id = 1", "select id from functional.alltypes where id = 2");
    }

    @Test
    public void testCacheKeyMasking() {
        this.verifyIdenticalCacheKeys("select id from functional.alltypes", "select id from functional.alltypes a");
        this.verifyIdenticalCacheKeys("select id from functional.alltypes", "select id as a from functional.alltypes");
    }

    @Test
    public void testIneligibility() {
        this.verifyCacheIneligible("select id from functional_kudu.alltypes");
        this.verifyCacheIneligible("select id from functional_hbase.alltypes");
    }

    @Test
    public void testCacheKeyGenerality() {
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id", "select straight_join probe.id from functional.alltypestiny probe, functional.alltypes build where probe.id = build.id");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id", "select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col=100");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and build.int_col = 100", "select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col = 100 and build.int_col = 100");
        this.verifyOverlappingCacheKeys("select straight_join probe1.id from functional.alltypes probe1, functional.alltypes probe2, functional.alltypes build where probe1.id = probe2.id and probe2.id = build.id", "select straight_join probe1.id from functional.alltypes probe1, functional.alltypes build where probe1.id = build.id");
    }

    protected List<PlanNode> getCacheEligibleNodes(String query) {
        List<PlanFragment> plan = this.getPlan(query);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        List preOrderPlanNodes = planRoot.getNodesPreOrder();
        ArrayList<PlanNode> cacheEligibleNodes = new ArrayList<PlanNode>();
        for (PlanNode node : preOrderPlanNodes) {
            TupleCacheInfo info;
            if (node instanceof TupleCacheNode || !(info = node.getTupleCacheInfo()).isEligible()) continue;
            cacheEligibleNodes.add(node);
        }
        return cacheEligibleNodes;
    }

    private List<String> getCacheKeys(List<PlanNode> cacheEligibleNodes) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        for (PlanNode node : cacheEligibleNodes) {
            cacheKeys.add(node.getTupleCacheInfo().getHashString());
        }
        return cacheKeys;
    }

    private List<String> getCacheHashTraces(List<PlanNode> cacheEligibleNodes) {
        ArrayList<String> cacheHashTraces = new ArrayList<String>();
        for (PlanNode node : cacheEligibleNodes) {
            cacheHashTraces.add(node.getTupleCacheInfo().getHashTrace());
        }
        return cacheHashTraces;
    }

    private void printCacheEligibleNode(PlanNode node, StringBuilder log) {
        log.append(node.getDisplayLabel());
        log.append("\n");
        log.append("cache key: ");
        log.append(node.getTupleCacheInfo().getHashString());
        log.append("\n");
        log.append("cache key hash trace: ");
        log.append(node.getTupleCacheInfo().getHashTrace());
        log.append("\n");
    }

    private void printQueryCacheEligibleNodes(String query, List<PlanNode> cacheEligibleNodes, StringBuilder log) {
        log.append("Query: ");
        log.append(query);
        log.append("\n");
        for (PlanNode node : cacheEligibleNodes) {
            this.printCacheEligibleNode(node, log);
        }
    }

    protected void verifyCacheIneligible(String query) {
        List<PlanNode> cacheEligibleNodes = this.getCacheEligibleNodes(query);
        if (cacheEligibleNodes.size() != 0) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected no cache eligible nodes. Instead found:\n");
            this.printQueryCacheEligibleNodes(query, cacheEligibleNodes, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyIdenticalCacheKeys(String query1, String query2) {
        List<PlanNode> cacheEligibleNodes1 = this.getCacheEligibleNodes(query1);
        List<PlanNode> cacheEligibleNodes2 = this.getCacheEligibleNodes(query2);
        Assert.assertTrue((cacheEligibleNodes1.size() > 0 ? 1 : 0) != 0);
        List<String> cacheKeys1 = this.getCacheKeys(cacheEligibleNodes1);
        List<String> cacheKeys2 = this.getCacheKeys(cacheEligibleNodes2);
        List<String> cacheHashTraces1 = this.getCacheHashTraces(cacheEligibleNodes1);
        List<String> cacheHashTraces2 = this.getCacheHashTraces(cacheEligibleNodes2);
        if (!cacheKeys1.equals(cacheKeys2) || !cacheHashTraces1.equals(cacheHashTraces2)) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected identical cache keys. Instead found:\n");
            this.printQueryCacheEligibleNodes(query1, cacheEligibleNodes1, errorLog);
            this.printQueryCacheEligibleNodes(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyOverlappingCacheKeys(String query1, String query2) {
        List<PlanNode> cacheEligibleNodes1 = this.getCacheEligibleNodes(query1);
        List<PlanNode> cacheEligibleNodes2 = this.getCacheEligibleNodes(query2);
        Assert.assertTrue((cacheEligibleNodes1.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cacheEligibleNodes2.size() > 0 ? 1 : 0) != 0);
        HashSet<String> cacheKeys1 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes1));
        HashSet<String> cacheKeys2 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes2));
        HashSet<String> keyIntersection = new HashSet<String>(cacheKeys1);
        keyIntersection.retainAll(cacheKeys2);
        HashSet<String> cacheHashTraces1 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes1));
        HashSet<String> cacheHashTraces2 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes2));
        HashSet<String> hashTraceIntersection = new HashSet<String>(cacheHashTraces1);
        hashTraceIntersection.retainAll(cacheHashTraces2);
        Assert.assertEquals((long)keyIntersection.size(), (long)hashTraceIntersection.size());
        if (keyIntersection.size() == 0 || hashTraceIntersection.size() == 0) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected overlapping cache keys. Instead found:\n");
            this.printQueryCacheEligibleNodes(query1, cacheEligibleNodes1, errorLog);
            this.printQueryCacheEligibleNodes(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyDifferentCacheKeys(String query1, String query2) {
        List<PlanNode> cacheEligibleNodes1 = this.getCacheEligibleNodes(query1);
        List<PlanNode> cacheEligibleNodes2 = this.getCacheEligibleNodes(query2);
        Assert.assertTrue((cacheEligibleNodes1.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cacheEligibleNodes2.size() > 0 ? 1 : 0) != 0);
        HashSet<String> cacheKeys1 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes1));
        HashSet<String> cacheKeys2 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes2));
        HashSet<String> keyIntersection = new HashSet<String>(cacheKeys1);
        keyIntersection.retainAll(cacheKeys2);
        HashSet<String> cacheHashTraces1 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes1));
        HashSet<String> cacheHashTraces2 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes2));
        HashSet<String> hashTraceIntersection = new HashSet<String>(cacheHashTraces1);
        hashTraceIntersection.retainAll(cacheHashTraces2);
        Assert.assertEquals((long)keyIntersection.size(), (long)hashTraceIntersection.size());
        if (keyIntersection.size() != 0 || hashTraceIntersection.size() != 0) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected different cache keys. Instead found:\n");
            this.printQueryCacheEligibleNodes(query1, cacheEligibleNodes1, errorLog);
            this.printQueryCacheEligibleNodes(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    private List<PlanFragment> getPlan(String query) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
        queryOptions.setNum_nodes(1);
        queryOptions.setEnable_tuple_cache(true);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        planCtx.requestPlanCapture();
        try {
            frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)e.getMessage());
        }
        return planCtx.getPlan();
    }
}

