/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.thrift.TUniqueId;
import org.apache.thrift.TBase;
import org.junit.Assert;
import org.junit.Test;

public class TupleCacheInfoTest {
    @Test
    public void testHashThrift() {
        TupleCacheInfo info1 = new TupleCacheInfo(null);
        info1.hashThrift((TBase)new TUniqueId(1L, 2L));
        info1.finalizeHash();
        TupleCacheInfo info2 = new TupleCacheInfo(null);
        info2.hashThrift((TBase)new TUniqueId(1L, 2L));
        info2.finalizeHash();
        Assert.assertEquals((Object)info1.getHashTrace(), (Object)"TUniqueId(hi:1, lo:2)");
        Assert.assertEquals((Object)info1.getHashTrace(), (Object)info2.getHashTrace());
        Assert.assertEquals((Object)info1.getHashString(), (Object)"b3f5384f81770c6adb83209b2a171dfa");
        Assert.assertEquals((Object)info1.getHashString(), (Object)info2.getHashString());
    }

    @Test
    public void testMergeHash() {
        TupleCacheInfo child1 = new TupleCacheInfo(null);
        child1.hashThrift((TBase)new TUniqueId(1L, 2L));
        child1.finalizeHash();
        TupleCacheInfo child2 = new TupleCacheInfo(null);
        child2.hashThrift((TBase)new TUniqueId(3L, 4L));
        child2.finalizeHash();
        TupleCacheInfo parent = new TupleCacheInfo(null);
        parent.mergeChild(child1);
        parent.mergeChild(child2);
        parent.hashThrift((TBase)new TUniqueId(5L, 6L));
        parent.finalizeHash();
        Assert.assertEquals((Object)parent.getHashTrace(), (Object)"TUniqueId(hi:1, lo:2)TUniqueId(hi:3, lo:4)TUniqueId(hi:5, lo:6)");
        Assert.assertEquals((Object)parent.getHashString(), (Object)"edf5633bed2280c3c3edb703182f3122");
    }

    @Test
    public void testMergeEligibility() {
        TupleCacheInfo child1 = new TupleCacheInfo(null);
        child1.hashThrift((TBase)new TUniqueId(1L, 2L));
        child1.finalizeHash();
        Assert.assertTrue((boolean)child1.isEligible());
        TupleCacheInfo child2 = new TupleCacheInfo(null);
        child2.setIneligible(TupleCacheInfo.IneligibilityReason.NOT_IMPLEMENTED);
        child2.finalizeHash();
        Assert.assertTrue((!child2.isEligible() ? 1 : 0) != 0);
        TupleCacheInfo parent = new TupleCacheInfo(null);
        parent.mergeChild(child1);
        Assert.assertTrue((boolean)parent.isEligible());
        parent.mergeChild(child2);
        Assert.assertTrue((!parent.isEligible() ? 1 : 0) != 0);
        parent.finalizeHash();
        Assert.assertTrue((!parent.isEligible() ? 1 : 0) != 0);
    }

    @Test
    public void testIdTranslation() {
        DescriptorTable descTbl = new DescriptorTable();
        TupleDescriptor tuple1 = descTbl.createTupleDescriptor("tuple1");
        Assert.assertEquals((long)tuple1.getId().asInt(), (long)0L);
        SlotDescriptor t1slot = descTbl.addSlotDescriptor(tuple1);
        t1slot.setType((Type)ScalarType.createType((PrimitiveType)PrimitiveType.INT));
        t1slot.setLabel("t1slot");
        Assert.assertEquals((long)t1slot.getId().asInt(), (long)0L);
        TupleDescriptor tuple2 = descTbl.createTupleDescriptor("tuple2");
        Assert.assertEquals((long)tuple2.getId().asInt(), (long)1L);
        SlotDescriptor t2slot = descTbl.addSlotDescriptor(tuple2);
        t2slot.setType((Type)ScalarType.createType((PrimitiveType)PrimitiveType.INT));
        t2slot.setLabel("t2slot");
        Assert.assertEquals((long)t2slot.getId().asInt(), (long)1L);
        tuple1.materializeSlots();
        tuple2.materializeSlots();
        descTbl.computeMemLayout();
        TupleCacheInfo child1 = new TupleCacheInfo(descTbl);
        child1.hashThrift((TBase)new TUniqueId(1L, 2L));
        child1.registerTuple(tuple1.getId());
        child1.finalizeHash();
        Assert.assertEquals((long)child1.getLocalTupleId(tuple1.getId()).asInt(), (long)0L);
        Assert.assertEquals((long)child1.getLocalSlotId(t1slot.getId()).asInt(), (long)0L);
        String child1ExpectedHashTrace = "TUniqueId(hi:1, lo:2)TTupleDescriptor(id:0, byteSize:5, numNullBytes:1)TSlotDescriptor(id:0, parent:0, slotType:TColumnType(types:[TTypeNode(type:SCALAR, scalar_type:TScalarType(type:INT))]), materializedPath:[], byteOffset:0, nullIndicatorByte:4, nullIndicatorBit:0, slotIdx:0, virtual_col_type:NONE)";
        Assert.assertEquals((Object)child1.getHashTrace(), (Object)child1ExpectedHashTrace);
        TupleCacheInfo child2 = new TupleCacheInfo(descTbl);
        child2.hashThrift((TBase)new TUniqueId(1L, 2L));
        child2.registerTuple(tuple2.getId());
        child2.finalizeHash();
        Assert.assertEquals((long)child2.getLocalTupleId(tuple2.getId()).asInt(), (long)0L);
        Assert.assertEquals((long)child2.getLocalSlotId(t2slot.getId()).asInt(), (long)0L);
        Assert.assertEquals((Object)child2.getHashTrace(), (Object)child1ExpectedHashTrace);
        Assert.assertEquals((Object)child2.getHashString(), (Object)child1.getHashString());
        TupleCacheInfo parent = new TupleCacheInfo(descTbl);
        parent.mergeChild(child2);
        parent.mergeChild(child1);
        parent.finalizeHash();
        Assert.assertEquals((long)parent.getLocalTupleId(tuple1.getId()).asInt(), (long)1L);
        Assert.assertEquals((long)parent.getLocalTupleId(tuple2.getId()).asInt(), (long)0L);
        Assert.assertEquals((long)parent.getLocalSlotId(t1slot.getId()).asInt(), (long)1L);
        Assert.assertEquals((long)parent.getLocalSlotId(t2slot.getId()).asInt(), (long)0L);
        Assert.assertEquals((Object)parent.getHashTrace(), (Object)(child1ExpectedHashTrace + child1ExpectedHashTrace));
    }
}

