/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.Db;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.testutil.PlannerTestCaseLoader;
import org.apache.impala.util.PatternMatcher;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestCaseLoaderTest {
    private static final Logger LOG = Logger.getLogger(TestCaseLoaderTest.class);
    private static final Path TESTCASE_DATA_DIR = new Path("/test-warehouse/tpcds-testcase-data");
    private static final String TESTCASE_FILE_PREFIX = "impala-testcase-data";

    @Test
    public void testTestCaseImport() throws Exception {
        FileStatus[] testCaseFiles = FileSystemUtil.getFileSystemForPath((Path)TESTCASE_DATA_DIR).listStatus(TESTCASE_DATA_DIR);
        Random rand = new Random();
        int maxIterations = 10;
        Preconditions.checkState((testCaseFiles.length > maxIterations ? 1 : 0) != 0);
        for (int i = 0; i < maxIterations; ++i) {
            FileStatus fs = testCaseFiles[rand.nextInt(testCaseFiles.length)];
            if (!fs.getPath().getName().contains(TESTCASE_FILE_PREFIX)) continue;
            try (PlannerTestCaseLoader testCaseLoader = new PlannerTestCaseLoader();){
                Catalog srcCatalog = testCaseLoader.getSrcCatalog();
                List dbs = srcCatalog.getDbs(PatternMatcher.MATCHER_MATCH_ALL);
                assert (dbs.size() == 1 && ((Db)dbs.get(0)).getName().equals("default"));
                LOG.info((Object)testCaseLoader.loadTestCase(fs.getPath().toString()));
                dbs = srcCatalog.getDbs(PatternMatcher.MATCHER_MATCH_ALL);
                if ($assertionsDisabled || dbs.size() > 1) continue;
                throw new AssertionError();
            }
        }
    }
}

