/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.Table;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBackendGflags;
import org.junit.Assert;
import org.junit.Test;

public class StatsExtrapolationTest
extends FrontendTestBase {
    private void setStats(Table tbl, Long rowCount, Long totalSize) {
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable();
        if (msTbl == null) {
            msTbl = new org.apache.hadoop.hive.metastore.api.Table();
            msTbl.setParameters(new HashMap());
        }
        if (msTbl.getParameters() == null) {
            msTbl.setParameters(new HashMap());
        }
        Map params = msTbl.getParameters();
        if (rowCount != null) {
            params.put("numRows", String.valueOf(rowCount));
        } else {
            params.remove("numRows");
        }
        if (totalSize != null) {
            params.put("totalSize", String.valueOf(totalSize));
        } else {
            params.remove("totalSize");
        }
        tbl.setTableStats(msTbl);
    }

    private void runTest(Table tbl, Long rowCount, Long totalSize, long fileBytes, long expectedExtrapNumRows) {
        Preconditions.checkState((boolean)(tbl instanceof HdfsTable));
        this.setStats(tbl, rowCount, totalSize);
        long actualExtrapNumRows = FeFsTable.Utils.getExtrapolatedNumRows((FeFsTable)((HdfsTable)tbl), (long)fileBytes);
        Assert.assertEquals((long)expectedExtrapNumRows, (long)actualExtrapNumRows);
    }

    private void testInvalidStats(Table tbl, Long rowCount, Long totalSize) {
        this.runTest(tbl, rowCount, totalSize, 0L, 0L);
        this.runTest(tbl, rowCount, totalSize, 1L, -1L);
        this.runTest(tbl, rowCount, totalSize, 100L, -1L);
        this.runTest(tbl, rowCount, totalSize, 1000000000L, -1L);
        this.runTest(tbl, rowCount, totalSize, Long.MAX_VALUE, -1L);
        this.runTest(tbl, rowCount, totalSize, Long.MIN_VALUE, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestStatsExtrapolation() {
        this.addTestDb("extrap_stats", null);
        Table tbl = this.addTestTable("create table extrap_stats.t (i int)");
        TBackendGflags gflags = BackendConfig.INSTANCE.getBackendCfg();
        boolean origEnableStatsExtrapolation = gflags.isEnable_stats_extrapolation();
        try {
            gflags.setEnable_stats_extrapolation(true);
            this.runTest(tbl, 100L, 1000L, 0L, 0L);
            this.runTest(tbl, 100L, 1000L, 100L, 10L);
            this.runTest(tbl, 100L, 1000L, 1000000000L, 100000000L);
            this.runTest(tbl, 100L, 1000L, Long.MAX_VALUE, 0xCCCCCCCCCCCCD00L);
            this.runTest(tbl, 100L, 1000L, -100L, -1L);
            this.runTest(tbl, 1000000000L, 123456789L, 246913578L, 2000000000L);
            this.runTest(tbl, 1000000000L, 123456789L, 370370367L, 3000000000L);
            this.runTest(tbl, 7777777777L, 33333333L, 66666666L, 15555555554L);
            this.runTest(tbl, 7777777777L, 33333333L, 99999999L, 23333333331L);
            this.runTest(tbl, 1L, Long.MAX_VALUE, 1L, 1L);
            this.runTest(tbl, 1L, Long.MAX_VALUE, 100L, 1L);
            this.runTest(tbl, 1L, Long.MAX_VALUE, 1000000000L, 1L);
            this.runTest(tbl, 1L, Long.MAX_VALUE, Long.MAX_VALUE, 1L);
            this.runTest(tbl, 1L, Long.MAX_VALUE, -100L, -1L);
            this.runTest(tbl, Long.MAX_VALUE, 1L, 1L, Long.MAX_VALUE);
            this.runTest(tbl, Long.MAX_VALUE, 1L, 100L, Long.MAX_VALUE);
            this.runTest(tbl, Long.MAX_VALUE, 1L, 1000000000L, Long.MAX_VALUE);
            this.runTest(tbl, Long.MAX_VALUE, 1L, Long.MAX_VALUE, Long.MAX_VALUE);
            this.runTest(tbl, Long.MAX_VALUE, 1L, -100L, -1L);
            this.testInvalidStats(tbl, null, null);
            this.testInvalidStats(tbl, 100L, null);
            this.testInvalidStats(tbl, null, 1000L);
            this.testInvalidStats(tbl, -100L, -1000L);
            this.testInvalidStats(tbl, -100L, 1000L);
            this.testInvalidStats(tbl, 100L, -1000L);
            this.runTest(tbl, 0L, 0L, 0L, 0L);
            this.testInvalidStats(tbl, 0L, 0L);
            this.testInvalidStats(tbl, 100L, 0L);
            this.testInvalidStats(tbl, 0L, 1000L);
            this.runTest(tbl, 100L, 1000L, -1L, -1L);
            this.runTest(tbl, 100L, 1000L, Long.MIN_VALUE, -1L);
        }
        finally {
            gflags.setEnable_stats_extrapolation(origEnableStatsExtrapolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestStatsExtrapolationConfig() {
        this.addTestDb("extrap_config", null);
        Table propUnsetTbl = this.addTestTable("create table extrap_config.tbl_prop_unset (i int)");
        Table propFalseTbl = this.addTestTable("create table extrap_config.tbl_prop_false (i int) tblproperties('impala.enable.stats.extrapolation'='false')");
        Table propTrueTbl = this.addTestTable("create table extrap_config.tbl_prop_true (i int) tblproperties('impala.enable.stats.extrapolation'='true')");
        TBackendGflags gflags = BackendConfig.INSTANCE.getBackendCfg();
        boolean origEnableStatsExtrapolation = gflags.isEnable_stats_extrapolation();
        try {
            gflags.setEnable_stats_extrapolation(false);
            this.configTestExtrapolationDisabled(propUnsetTbl);
            this.configTestExtrapolationDisabled(propFalseTbl);
            this.configTestExtrapolationEnabled(propTrueTbl);
            gflags.setEnable_stats_extrapolation(true);
            this.configTestExtrapolationEnabled(propUnsetTbl);
            this.configTestExtrapolationDisabled(propFalseTbl);
            this.configTestExtrapolationEnabled(propTrueTbl);
        }
        finally {
            gflags.setEnable_stats_extrapolation(origEnableStatsExtrapolation);
        }
    }

    private void configTestExtrapolationDisabled(Table tbl) {
        this.runTest(tbl, 100L, 1000L, 0L, -1L);
        this.runTest(tbl, 100L, 1000L, 100L, -1L);
        this.runTest(tbl, 100L, 1000L, 1000000000L, -1L);
        this.runTest(tbl, 100L, 1000L, Long.MAX_VALUE, -1L);
        this.runTest(tbl, 100L, 1000L, -100L, -1L);
    }

    private void configTestExtrapolationEnabled(Table tbl) {
        this.runTest(tbl, 100L, 1000L, 0L, 0L);
        this.runTest(tbl, 100L, 1000L, 100L, 10L);
        this.runTest(tbl, 100L, 1000L, 1000000000L, 100000000L);
        this.runTest(tbl, 100L, 1000L, Long.MAX_VALUE, 0xCCCCCCCCCCCCD00L);
        this.runTest(tbl, 100L, 1000L, -100L, -1L);
    }
}

