/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.impala.planner.PlannerTestBase;
import org.apache.impala.planner.S3Tests;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={S3Tests.class})
public class S3PlannerTest
extends PlannerTestBase {
    private static final Path S3A_CANONICAL_BUCKET = new Path("s3a://bucket");
    private Path fsName;

    @Override
    @Before
    public void setUpTest() throws Exception {
        super.setUpTest();
        String targetFs = System.getenv("TARGET_FILESYSTEM");
        Assume.assumeTrue((targetFs != null && targetFs.equals("s3") ? 1 : 0) != 0);
        String fsNameStr = System.getenv("DEFAULT_FS");
        this.fsName = new Path(fsNameStr);
    }

    @Override
    protected Path cleanseFilePath(Path path) {
        path = super.cleanseFilePath(path);
        URI fsURI = this.fsName.toUri();
        URI pathURI = path.toUri();
        Assert.assertTrue((String)("error: " + path + " is not on filesystem " + this.fsName), (fsURI.getScheme().equals(pathURI.getScheme()) && fsURI.getAuthority().equals(pathURI.getAuthority()) ? 1 : 0) != 0);
        return Path.mergePaths((Path)S3A_CANONICAL_BUCKET, (Path)path);
    }

    @Ignore(value="IMPALA-8944, IMPALA-5931")
    @Test
    public void testS3ScanRanges() {
        this.runPlannerTestFile("s3");
    }

    @Test
    public void testPredicatePropagation() {
        this.runPlannerTestFile("predicate-propagation");
    }

    @Test
    public void testConstant() {
        this.runPlannerTestFile("constant");
    }

    @Test
    public void testDistinct() {
        this.runPlannerTestFile("distinct");
    }

    @Test
    public void testAggregation() {
        this.runPlannerTestFile("aggregation");
    }

    @Test
    public void testAnalyticFns() {
        this.runPlannerTestFile("analytic-fns");
    }

    @Test
    public void testNestedCollections() {
        this.runPlannerTestFile("nested-collections");
    }

    @Ignore(value="IMPALA-8949")
    @Test
    public void testJoinOrder() {
        this.runPlannerTestFile("join-order");
    }

    @Test
    public void testOuterJoins() {
        this.runPlannerTestFile("outer-joins");
    }

    @Test
    public void testImplicitJoins() {
        this.runPlannerTestFile("implicit-joins");
    }

    @Test
    public void testInlineViewLimit() {
        this.runPlannerTestFile("inline-view-limit");
    }

    @Ignore(value="IMPALA-8949")
    @Test
    public void testSubqueryRewrite() {
        this.runPlannerTestFile("subquery-rewrite");
    }

    @Test
    public void testUnion() {
        this.runPlannerTestFile("union");
    }

    @Test
    public void testValues() {
        this.runPlannerTestFile("values");
    }

    @Test
    public void testViews() {
        this.runPlannerTestFile("views");
    }

    @Test
    public void testDistinctEstimate() {
        this.runPlannerTestFile("distinct-estimate");
    }

    @Test
    public void testDataSourceTables() {
        this.runPlannerTestFile("data-source-tables");
    }

    @Ignore(value="IMPALA-8949")
    @Test
    public void testTpch() {
        this.runPlannerTestFile("tpch-all", "tpch", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Ignore(value="IMPALA-8949")
    @Test
    public void testTpcds() {
        this.runPlannerTestFile("tpcds-all", "tpcds", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Override
    public boolean scanRangeLocationsCheckEnabled() {
        return false;
    }
}

