/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.impala.planner.HdfsTableSink;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class ParquetBloomFilterTblPropParserTest {
    private static final Logger LOG = Logger.getLogger(ParquetBloomFilterTblPropParserTest.class);

    @Test
    public void testParsingOnlyColNames() throws Exception {
        String props = "col1,col2,col3";
        ImmutableMap exp = ImmutableMap.of((Object)"col1", (Object)0x8000000L, (Object)"col2", (Object)0x8000000L, (Object)"col3", (Object)0x8000000L);
        this.parseAndCheck("col1,col2,col3", (Map<String, Long>)exp);
    }

    @Test
    public void testParsingAllSizesGiven() {
        String props = "col1:128,col2:256,col3:64";
        ImmutableMap exp = ImmutableMap.of((Object)"col1", (Object)128L, (Object)"col2", (Object)256L, (Object)"col3", (Object)64L);
        this.parseAndCheck("col1:128,col2:256,col3:64", (Map<String, Long>)exp);
    }

    @Test
    public void testParsingSomeSizesGiven() {
        String props = "col1:128,col2,col3:64";
        ImmutableMap exp = ImmutableMap.of((Object)"col1", (Object)128L, (Object)"col2", (Object)0x8000000L, (Object)"col3", (Object)64L);
        this.parseAndCheck("col1:128,col2,col3:64", (Map<String, Long>)exp);
    }

    @Test
    public void testParsingContainsWhitespace() {
        String props = "col1 : 128, col2, \ncol3: 64 \t";
        ImmutableMap exp = ImmutableMap.of((Object)"col1", (Object)128L, (Object)"col2", (Object)0x8000000L, (Object)"col3", (Object)64L);
        this.parseAndCheck("col1 : 128, col2, \ncol3: 64 \t", (Map<String, Long>)exp);
    }

    private void parseAndCheck(String tbl_props, Map<String, Long> exp_res) {
        Map res = HdfsTableSink.parseParquetBloomFilterWritingTblProp((String)tbl_props);
        Assert.assertEquals(exp_res, (Object)res);
    }
}

