/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TExecutorGroupSet;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TUpdateExecutorMembershipRequest;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.junit.Assert;
import org.junit.Test;

public class ClusterSizeTest
extends FrontendTestBase {
    private String getExplainString(String stmt) {
        String ret = "";
        try {
            TQueryCtx queryCtx = TestUtils.createQueryContext("functional", System.getProperty("user.name"));
            queryCtx.client_request.setStmt(stmt);
            TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
            queryOptions.setTest_replan(false);
            ret = frontend_.getExplainString(queryCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)e.getMessage());
        }
        return ret;
    }

    private void setNumExecutors(int numExecutor, int numExpectedExecutors) {
        TUpdateExecutorMembershipRequest updateReq = new TUpdateExecutorMembershipRequest();
        updateReq.setIp_addresses((Set)Sets.newHashSet((Object[])new String[]{"127.0.0.1"}));
        updateReq.setHostnames((Set)Sets.newHashSet((Object[])new String[]{"localhost"}));
        TExecutorGroupSet group_set = new TExecutorGroupSet();
        group_set.curr_num_executors = numExecutor;
        group_set.expected_num_executors = numExpectedExecutors;
        updateReq.setExec_group_sets(new ArrayList());
        updateReq.getExec_group_sets().add(group_set);
        ExecutorMembershipSnapshot.update((TUpdateExecutorMembershipRequest)updateReq);
    }

    @Test
    public void testChangeClusterSize() {
        String query = "select * from alltypes a inner join alltypes b on a.id = b.id";
        String broadcast_exchange = ":EXCHANGE [BROADCAST]";
        String hash_exchange = ":EXCHANGE [HASH(b.id)]";
        int default_num_expected_executors = 20;
        this.setNumExecutors(0, 20);
        Assert.assertTrue((boolean)this.getExplainString("select * from alltypes a inner join alltypes b on a.id = b.id").contains(":EXCHANGE [HASH(b.id)]"));
        this.setNumExecutors(1, 20);
        Assert.assertTrue((boolean)this.getExplainString("select * from alltypes a inner join alltypes b on a.id = b.id").contains(":EXCHANGE [BROADCAST]"));
        for (int n = 2; n < 5; ++n) {
            this.setNumExecutors(n, 20);
            Assert.assertTrue((boolean)this.getExplainString("select * from alltypes a inner join alltypes b on a.id = b.id").contains(":EXCHANGE [HASH(b.id)]"));
        }
        this.setNumExecutors(1, 20);
        Assert.assertTrue((boolean)this.getExplainString("select * from alltypes a inner join alltypes b on a.id = b.id").contains(":EXCHANGE [BROADCAST]"));
    }
}

