/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class TestGenericUdf
extends GenericUDF {
    private List<PrimitiveObjectInspector.PrimitiveCategory> inputTypes_;
    private PrimitiveObjectInspector retTypeOI_;
    private PrimitiveObjectInspector.PrimitiveCategory argAndRetType_;
    private static final Set SUPPORTED_ARG_TYPES = new ImmutableSet.Builder().add((Object)PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN).add((Object)PrimitiveObjectInspector.PrimitiveCategory.BYTE).add((Object)PrimitiveObjectInspector.PrimitiveCategory.SHORT).add((Object)PrimitiveObjectInspector.PrimitiveCategory.INT).add((Object)PrimitiveObjectInspector.PrimitiveCategory.LONG).add((Object)PrimitiveObjectInspector.PrimitiveCategory.FLOAT).add((Object)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE).add((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING).add((Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY).build();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length == 0) {
            throw new UDFArgumentException("No arguments provided.");
        }
        this.inputTypes_ = new ArrayList<PrimitiveObjectInspector.PrimitiveCategory>();
        for (ObjectInspector oi : arguments) {
            if (!(oi instanceof PrimitiveObjectInspector)) {
                throw new UDFArgumentException("Found an input that is not a primitive.");
            }
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
            this.inputTypes_.add(poi.getPrimitiveCategory());
        }
        this.retTypeOI_ = this.getReturnObjectInspector((PrimitiveObjectInspector)arguments[0]);
        this.argAndRetType_ = this.retTypeOI_.getPrimitiveCategory();
        this.verifyArgs(this.argAndRetType_, this.inputTypes_);
        return this.retTypeOI_;
    }

    protected PrimitiveObjectInspector getReturnObjectInspector(PrimitiveObjectInspector oi) {
        return oi;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments.length != this.inputTypes_.size()) {
            throw new HiveException("Number of arguments passed in did not match number of arguments expected. Expected: " + this.inputTypes_.size() + " actual: " + arguments.length);
        }
        for (GenericUDF.DeferredObject arg : arguments) {
            if (arg.get() != null) continue;
            return null;
        }
        switch (this.argAndRetType_) {
            case BOOLEAN: {
                return this.evaluateBooleanWrapped(arguments);
            }
            case BYTE: {
                return this.evaluateByteWrapped(arguments);
            }
            case SHORT: {
                return this.evaluateShortWrapped(arguments);
            }
            case INT: {
                return this.evaluateIntWrapped(arguments);
            }
            case LONG: {
                return this.evaluateLongWrapped(arguments);
            }
            case FLOAT: {
                return this.evaluateFloatWrapped(arguments);
            }
            case DOUBLE: {
                return this.evaluateDoubleWrapped(arguments);
            }
            case STRING: {
                return this.evaluateStringWrapped(arguments);
            }
            case BINARY: {
                return this.evaluateBinaryWrapped(arguments);
            }
        }
        throw new HiveException("Unsupported argument type " + this.argAndRetType_);
    }

    public String getDisplayString(String[] children) {
        return "TestGenericUdf";
    }

    private void verifyArgs(PrimitiveObjectInspector.PrimitiveCategory argAndRetType, List<PrimitiveObjectInspector.PrimitiveCategory> inputTypes) throws UDFArgumentException {
        if (!SUPPORTED_ARG_TYPES.contains(argAndRetType)) {
            throw new UDFArgumentException("Unsupported argument type " + this.argAndRetType_);
        }
        for (PrimitiveObjectInspector.PrimitiveCategory inputType : inputTypes) {
            if (inputType == argAndRetType) continue;
            throw new UDFArgumentException("Invalid function for " + this.getSignatureString(argAndRetType, inputTypes));
        }
    }

    protected Boolean evaluateBoolean(GenericUDF.DeferredObject[] inputs) throws HiveException {
        boolean finalBoolean = false;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof BooleanWritable)) {
                throw new HiveException("Expected BooleanWritable but got " + input.get().getClass());
            }
            boolean currentBool = ((BooleanWritable)input.get()).get();
            finalBoolean |= currentBool;
        }
        return finalBoolean;
    }

    protected Byte evaluateByte(GenericUDF.DeferredObject[] inputs) throws HiveException {
        byte finalByte = 0;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof ByteWritable)) {
                throw new HiveException("Expected ByteWritable but got " + input.get().getClass());
            }
            byte currentByte = ((ByteWritable)input.get()).get();
            finalByte = (byte)(finalByte + currentByte);
        }
        return finalByte;
    }

    protected Short evaluateShort(GenericUDF.DeferredObject[] inputs) throws HiveException {
        short finalShort = 0;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof ShortWritable)) {
                throw new HiveException("Expected ShortWritable but got " + input.get().getClass());
            }
            short currentShort = ((ShortWritable)input.get()).get();
            finalShort = (short)(finalShort + currentShort);
        }
        return finalShort;
    }

    protected Integer evaluateInt(GenericUDF.DeferredObject[] inputs) throws HiveException {
        int finalInt = 0;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof IntWritable)) {
                throw new HiveException("Expected IntWritable but got " + input.get().getClass());
            }
            int currentInt = ((IntWritable)input.get()).get();
            finalInt += currentInt;
        }
        return finalInt;
    }

    protected Long evaluateLong(GenericUDF.DeferredObject[] inputs) throws HiveException {
        long finalLong = 0L;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof LongWritable)) {
                throw new HiveException("Expected LongWritable but got " + input.get().getClass());
            }
            long currentLong = ((LongWritable)input.get()).get();
            finalLong += currentLong;
        }
        return finalLong;
    }

    protected Float evaluateFloat(GenericUDF.DeferredObject[] inputs) throws HiveException {
        float finalFloat = 0.0f;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof FloatWritable)) {
                throw new HiveException("Expected FloatWritable but got " + input.get().getClass());
            }
            float currentFloat = ((FloatWritable)input.get()).get();
            finalFloat += currentFloat;
        }
        return Float.valueOf(finalFloat);
    }

    protected Double evaluateDouble(GenericUDF.DeferredObject[] inputs) throws HiveException {
        double finalDouble = 0.0;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof DoubleWritable)) {
                throw new HiveException("Expected DoubleWritable but got " + input.get().getClass());
            }
            double currentDouble = ((DoubleWritable)input.get()).get();
            finalDouble += currentDouble;
        }
        return finalDouble;
    }

    protected String evaluateString(GenericUDF.DeferredObject[] inputs) throws HiveException {
        String finalString = "";
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof Text)) {
                throw new HiveException("Expected Text but got " + input.get().getClass());
            }
            String currentString = ((Text)input.get()).toString();
            finalString = finalString + currentString;
        }
        return finalString;
    }

    protected byte[] evaluateBinary(GenericUDF.DeferredObject[] inputs) throws HiveException {
        int resultLength = 0;
        for (GenericUDF.DeferredObject input : inputs) {
            if (!(input.get() instanceof BytesWritable)) {
                throw new HiveException("Expected BytesWritable but got " + input.get().getClass());
            }
            byte[] currentArray = ((BytesWritable)input.get()).getBytes();
            resultLength += currentArray.length;
        }
        int pos = 0;
        byte[] result = new byte[resultLength];
        for (GenericUDF.DeferredObject input : inputs) {
            byte[] currentArray = ((BytesWritable)input.get()).getBytes();
            System.arraycopy(currentArray, 0, result, pos, currentArray.length);
            pos += currentArray.length;
        }
        return result;
    }

    protected Object evaluateBooleanWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new BooleanWritable(this.evaluateBoolean(inputs).booleanValue());
    }

    protected Object evaluateByteWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new ByteWritable(this.evaluateByte(inputs).byteValue());
    }

    protected Object evaluateShortWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new ShortWritable(this.evaluateShort(inputs).shortValue());
    }

    protected Object evaluateIntWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new IntWritable(this.evaluateInt(inputs).intValue());
    }

    protected Object evaluateLongWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new LongWritable(this.evaluateLong(inputs).longValue());
    }

    protected Object evaluateFloatWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new FloatWritable(this.evaluateFloat(inputs).floatValue());
    }

    protected Object evaluateDoubleWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new DoubleWritable(this.evaluateDouble(inputs).doubleValue());
    }

    protected Object evaluateStringWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new Text(this.evaluateString(inputs));
    }

    protected Object evaluateBinaryWrapped(GenericUDF.DeferredObject[] inputs) throws HiveException {
        return new BytesWritable(this.evaluateBinary(inputs));
    }

    protected String getSignatureString(PrimitiveObjectInspector.PrimitiveCategory argAndRetType_, List<PrimitiveObjectInspector.PrimitiveCategory> inputTypes_) {
        return argAndRetType_ + "TestGenericUdf(" + Joiner.on((String)",").join(inputTypes_) + ")";
    }
}

