/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.datagenerator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.impala.planner.HBaseScanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTestDataRegionAssignment {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTestDataRegionAssignment.class);
    private final Configuration conf;
    private Connection connection = null;
    private final Admin admin;
    private final List<ServerName> sortedRS;
    private final String[] splitPoints = new String[]{"1", "3", "5", "7", "9"};
    private static final int REGION_MOVE_TIMEOUT_MILLIS = 120000;

    public HBaseTestDataRegionAssignment() throws IOException {
        this.conf = new Configuration();
        this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
        this.admin = this.connection.getAdmin();
        ClusterStatus clusterStatus = this.admin.getClusterStatus();
        ArrayList regionServerNames = new ArrayList(clusterStatus.getServers());
        ServerName master = clusterStatus.getMaster();
        regionServerNames.remove(master);
        this.sortedRS = new ArrayList<ServerName>(regionServerNames);
        Collections.sort(this.sortedRS);
    }

    public void close() throws IOException {
        this.admin.close();
    }

    public void performAssignment(String tableName) throws IOException, InterruptedException, TableNotFoundException {
        long start;
        TableName table;
        block4: {
            table = TableName.valueOf((String)tableName);
            if (!this.admin.tableExists(table)) {
                throw new TableNotFoundException("Table " + tableName + " not found.");
            }
            List regions = this.admin.getRegions(table);
            Preconditions.checkArgument((regions.size() == this.splitPoints.length + 1 ? 1 : 0) != 0);
            Collections.sort(regions, RegionInfo.COMPARATOR);
            HashMap expectedLocs = Maps.newHashMap();
            for (int i = 0; i < regions.size(); ++i) {
                RegionInfo regionInfo = (RegionInfo)regions.get(i);
                int rsIdx = i / 2 % this.sortedRS.size();
                ServerName regionServerName = this.sortedRS.get(rsIdx);
                LOG.info("Moving " + regionInfo.getRegionNameAsString() + " to " + regionServerName.getAddress());
                this.admin.move(regionInfo.getEncodedNameAsBytes(), regionServerName.getServerName().getBytes());
                expectedLocs.put(regionInfo.getRegionNameAsString(), regionServerName);
            }
            start = System.currentTimeMillis();
            long timeout = System.currentTimeMillis() + 120000L;
            while (true) {
                int matched = 0;
                List pairs = MetaTableAccessor.getTableRegionsAndLocations((Connection)this.connection, (TableName)table);
                Preconditions.checkState((pairs.size() == regions.size() ? 1 : 0) != 0);
                for (Pair pair : pairs) {
                    RegionInfo regionInfo = (RegionInfo)pair.getFirst();
                    String regionName = regionInfo.getRegionNameAsString();
                    ServerName serverName = (ServerName)pair.getSecond();
                    Preconditions.checkNotNull(expectedLocs.get(regionName));
                    LOG.info(regionName + " " + HBaseScanNode.printKey((byte[])regionInfo.getStartKey()) + " -> " + serverName.getAddress().toString() + ", expecting " + expectedLocs.get(regionName));
                    if (!((ServerName)expectedLocs.get(regionName)).equals((Object)serverName)) continue;
                    ++matched;
                }
                if (matched == regions.size()) break block4;
                if (System.currentTimeMillis() >= timeout) break;
                Thread.sleep(100L);
            }
            throw new IllegalStateException(String.format("Failed to assign regions to servers after 120000 millis.", new Object[0]));
        }
        long elapsed = System.currentTimeMillis() - start;
        LOG.info("Regions moved after " + elapsed + " millis.");
        LOG.info("Major compacting HBase table: " + tableName);
        this.admin.majorCompact(table);
    }

    public class TableNotFoundException
    extends Exception {
        public TableNotFoundException(String s) {
            super(s);
        }
    }
}

