/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.impala.analysis.AnalyzeKuduDDLTest;
import org.apache.impala.analysis.AuditingKuduTest;
import org.apache.impala.analysis.ParserTest;
import org.apache.impala.analysis.ToSqlTest;
import org.apache.impala.customservice.CustomServiceRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={AnalyzeKuduDDLTest.class, AuditingKuduTest.class, ParserTest.class, ToSqlTest.class})
public class KuduHMSIntegrationTest {
    private static void restartKudu(boolean enableHMSIntegration) throws Exception {
        List<String> envp = KuduHMSIntegrationTest.getSystemEnv(enableHMSIntegration);
        String altJavaHome = System.getenv("MINICLUSTER_JAVA_HOME");
        if (!StringUtils.isEmpty((String)altJavaHome)) {
            envp.removeIf(s -> s.startsWith("LD_PRELOAD="));
            envp.removeIf(s -> s.startsWith("JAVA="));
            envp.removeIf(s -> s.startsWith("JAVA_HOME="));
            envp.add("JAVA=" + altJavaHome + "/bin/java");
            envp.add("JAVA_HOME=" + altJavaHome);
        }
        int exitVal = CustomServiceRunner.RestartMiniclusterComponent("kudu", envp.toArray(new String[envp.size()]));
        Assert.assertEquals((long)0L, (long)exitVal);
    }

    private static List<String> getSystemEnv(boolean enableHMSIntegration) {
        ArrayList<String> envp = new ArrayList<String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            envp.add(entry.getKey() + "=" + entry.getValue());
        }
        if (enableHMSIntegration) {
            String hmsIntegrationEnv = String.format("IMPALA_KUDU_STARTUP_FLAGS=-hive_metastore_uris=thrift://%s:9083", System.getenv("INTERNAL_LISTEN_HOST"));
            envp.add(hmsIntegrationEnv);
        }
        return envp;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        KuduHMSIntegrationTest.restartKudu(true);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        KuduHMSIntegrationTest.restartKudu(false);
    }
}

