/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.junit.Assert;

class RunShellCommand {
    RunShellCommand() {
    }

    public static Output Run(String[] cmd, boolean shouldSucceed, String expectedOut, String expectedErr) throws Exception {
        return RunShellCommand.Run(cmd, null, shouldSucceed, expectedOut, expectedErr);
    }

    public static Output Run(String[] cmd, String[] env, boolean shouldSucceed, String expectedOut, String expectedErr) throws Exception {
        String line;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec(cmd, env);
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuffer stderrBuf = new StringBuffer();
        while ((line = input.readLine()) != null) {
            stderrBuf.append(line);
            stderrBuf.append('\n');
        }
        String stderr = stderrBuf.toString();
        Assert.assertTrue((String)stderr, (boolean)stderr.contains(expectedErr));
        input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer stdoutBuf = new StringBuffer();
        while ((line = input.readLine()) != null) {
            stdoutBuf.append(line);
            stdoutBuf.append('\n');
        }
        int expectedReturn = shouldSucceed ? 0 : 1;
        Assert.assertEquals((String)stderr.toString(), (long)expectedReturn, (long)process.waitFor());
        String stdout = stdoutBuf.toString();
        if (shouldSucceed) {
            Assert.assertTrue((String)stdout, (boolean)stdout.contains(expectedOut));
        }
        return new Output(stdout, stderr);
    }

    public static class Output {
        public String stdout;
        public String stderr;

        public Output(String out, String err) {
            this.stdout = out;
            this.stderr = err;
        }
    }
}

