/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.THandleIdentifier;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.cookie.Cookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.customcluster.LdapHS2Test;
import org.apache.impala.testutil.WebClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.json.simple.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@ApplyLdifFiles(value={"users.ldif"})
public class LdapWebserverTest {
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    private static final Range<Long> zero = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L));
    WebClient client_ = new WebClient("Test1Ldap", "12345");

    public void setUp(String extraArgs, String startArgs, String catalogdArgs, String stateStoredArgs, String admissiondArgs) throws Exception {
        String uri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String dn = "cn=#UID,ou=Users,dc=myorg,dc=com";
        String impalaArgs = String.format("--enable_ldap_auth --ldap_uri='%s' --ldap_bind_pattern='%s' --ldap_passwords_in_clear_ok --webserver_require_ldap=true --webserver_ldap_passwords_in_clear_ok --cookie_require_secure=false %s", uri, dn, extraArgs);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("IMPALA_WEBSERVER_USERNAME", "Test1Ldap");
        env.put("IMPALA_WEBSERVER_PASSWORD", "12345");
        catalogdArgs = catalogdArgs + " " + impalaArgs;
        stateStoredArgs = stateStoredArgs + " " + impalaArgs;
        int ret = CustomClusterRunner.StartImpalaCluster(impalaArgs, catalogdArgs, stateStoredArgs, admissiondArgs, env, startArgs);
        Assert.assertEquals((long)0L, (long)ret);
    }

    @After
    public void cleanUp() throws IOException {
        this.client_.Close();
    }

    private void verifyMetrics(Range<Long> expectedBasicSuccess, Range<Long> expectedBasicFailure, Range<Long> expectedCookieSuccess, Range<Long> expectedCookieFailure) throws Exception {
        long actualBasicSuccess = (Long)this.client_.getMetric("impala.webserver.total-basic-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedBasicSuccess + ", Actual: " + actualBasicSuccess), (boolean)expectedBasicSuccess.contains((Comparable)Long.valueOf(actualBasicSuccess)));
        long actualBasicFailure = (Long)this.client_.getMetric("impala.webserver.total-basic-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedBasicFailure + ", Actual: " + actualBasicFailure), (boolean)expectedBasicFailure.contains((Comparable)Long.valueOf(actualBasicFailure)));
        long actualCookieSuccess = (Long)this.client_.getMetric("impala.webserver.total-cookie-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedCookieSuccess + ", Actual: " + actualCookieSuccess), (boolean)expectedCookieSuccess.contains((Comparable)Long.valueOf(actualCookieSuccess)));
        long actualCookieFailure = (Long)this.client_.getMetric("impala.webserver.total-cookie-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedCookieFailure + ", Actual: " + actualCookieFailure), (boolean)expectedCookieFailure.contains((Comparable)Long.valueOf(actualCookieFailure)));
    }

    private void verifyTrustedDomainMetrics(Range<Long> expectedSuccess) throws Exception {
        long actualSuccess = (Long)this.client_.getMetric("impala.webserver.total-trusted-domain-check-success");
        Assert.assertTrue((String)("Expected: " + expectedSuccess + ", Actual: " + actualSuccess), (boolean)expectedSuccess.contains((Comparable)Long.valueOf(actualSuccess)));
    }

    private void verifyTrustedAuthHeaderMetrics(Range<Long> expectedSuccess) throws Exception {
        long actualSuccess = (Long)this.client_.getMetric("impala.webserver.total-trusted-auth-header-check-success");
        Assert.assertTrue((String)("Expected: " + expectedSuccess + ", Actual: " + actualSuccess), (boolean)expectedSuccess.contains((Comparable)Long.valueOf(actualSuccess)));
    }

    private void verifyJwtAuthMetrics(Range<Long> expectedAuthSuccess, Range<Long> expectedAuthFailure) throws Exception {
        long actualAuthSuccess = (Long)this.client_.getMetric("impala.webserver.total-jwt-token-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedAuthSuccess + ", Actual: " + actualAuthSuccess), (boolean)expectedAuthSuccess.contains((Comparable)Long.valueOf(actualAuthSuccess)));
        long actualAuthFailure = (Long)this.client_.getMetric("impala.webserver.total-jwt-token-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedAuthFailure + ", Actual: " + actualAuthFailure), (boolean)expectedAuthFailure.contains((Comparable)Long.valueOf(actualAuthFailure)));
    }

    @Test
    public void testWebserver() throws Exception {
        this.setUp("", "", "", "", "");
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
        WebClient noUsername = new WebClient();
        String result = noUsername.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
        WebClient invalidUserPass = new WebClient("invalid", "invalid");
        result = invalidUserPass.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
    }

    @Test
    public void testWebserverFilters() throws Exception {
        this.setUp(String.format("--webserver_ldap_group_filter=%s --webserver_ldap_user_filter=%s,%s --ldap_group_dn_pattern=ou=Groups,dc=myorg,dc=com --ldap_group_membership_key=uniqueMember --ldap_group_class_key=groupOfUniqueNames --ldap_bind_dn=%s --ldap_bind_password_cmd='echo -n %s' ", "group1", "Test1Ldap", "Test3Ldap", "cn=Test1Ldap,ou=Users,dc=myorg,dc=com", "12345"), "", "", "", "");
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
        WebClient user2 = new WebClient("Test2Ldap", "abcde");
        String result = user2.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
        WebClient user3 = new WebClient("Test3Ldap", "67890");
        result = user3.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
        WebClient user4 = new WebClient("Test4Ldap", "fghij");
        result = user4.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(3L), (Comparable)Long.valueOf(3L)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
    }

    @Test
    public void testMetricsWebserver() throws Exception {
        this.setUp("", "--per_impalad_args=--metrics_webserver_port=25040 ", "--metrics_webserver_port=25021 ", "--metrics_webserver_port=25011 ", "--metrics_webserver_port=25031 ");
        WebClient noUsername = new WebClient();
        String result = noUsername.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        WebClient invalidUserPass = new WebClient("invalid", "invalid");
        result = invalidUserPass.readContent("/");
        Assert.assertTrue((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        WebClient noUsernameMetrics = new WebClient(25040);
        WebClient catalogdMetrics = new WebClient(25021);
        WebClient statestoredMetrics = new WebClient(25011);
        WebClient admissiondMetrics = new WebClient(25031);
        for (String endpoint : new String[]{"/metrics", "/jsonmetrics", "/metrics_prometheus", "/healthz"}) {
            result = noUsernameMetrics.readContent(endpoint);
            Assert.assertFalse((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
            result = catalogdMetrics.readContent(endpoint);
            Assert.assertFalse((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
            result = statestoredMetrics.readContent(endpoint);
            Assert.assertFalse((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
            result = admissiondMetrics.readContent(endpoint);
            Assert.assertFalse((String)result, (boolean)result.contains("Must authenticate with Basic authentication."));
        }
        for (String endpoint : new String[]{"/varz", "/backends"}) {
            result = noUsernameMetrics.readContent(endpoint);
            Assert.assertTrue((String)result, (boolean)result.contains("No URI handler for"));
        }
    }

    private void webserverTrustedDomainTestBody(boolean strictLocalhost) throws Exception {
        String strictLocalhostArgs = "--trusted_domain_strict_localhost=" + String.valueOf(strictLocalhost);
        this.setUp("--trusted_domain=localhost --trusted_domain_use_xff_header=true " + strictLocalhostArgs, "", "", "", "");
        this.attemptConnection("Basic VGVzdDFMZGFwOjEyMzQ1", "127.0.0.1", false);
        this.verifyTrustedDomainMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)));
        this.attemptConnection("Basic VGVzdDFMZGFwOg==", "127.0.0.1", false);
        this.verifyTrustedDomainMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)));
        String nontrustedIp = strictLocalhost ? "127.0.23.1" : "126.0.23.1";
        this.attemptConnection("Basic VGVzdDFMZGFwOjEyMzQ1", nontrustedIp, false);
        this.verifyTrustedDomainMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)));
        try {
            this.attemptConnection(null, "127.0.0.1", false);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyTrustedDomainMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)));
        try {
            this.attemptConnection("Basic VGVzdDFMZGFwOg==", nontrustedIp, false);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyTrustedDomainMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)));
        long successMetricBefore = (Long)this.client_.getMetric("impala.webserver.total-trusted-domain-check-success");
        this.attemptConnection("Basic VGVzdDFMZGFwOjEyMzQ1", null, false);
        this.verifyTrustedDomainMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(successMetricBefore), (Comparable)Long.valueOf(successMetricBefore)));
    }

    @Test
    public void testWebserverTrustedDomainStrict() throws Exception {
        this.webserverTrustedDomainTestBody(true);
    }

    @Test
    public void testWebserverTrustedDomainNonstrict() throws Exception {
        this.webserverTrustedDomainTestBody(false);
    }

    @Test
    public void testWebserverTrustedDomainEmptyXffHeaderUseOrigin() throws Exception {
        this.setUp("--trusted_domain=localhost --trusted_domain_use_xff_header=true --trusted_domain_empty_xff_header_use_origin=true", "", "", "", "");
        this.attemptConnection("Basic VGVzdDFMZGFwOg==", "127.0.0.1", false);
        this.attemptConnection("Basic VGVzdDFMZGFwOg==", null, false);
        try {
            this.attemptConnection("Basic VGVzdDFMZGFwOg==", "126.0.23.1", false);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.setUp("--trusted_domain=any.domain --trusted_domain_use_xff_header=true --trusted_domain_empty_xff_header_use_origin=true", "", "", "", "");
        try {
            this.attemptConnection("Basic VGVzdDFMZGFwOg==", null, false);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
    }

    @Test
    public void testWebserverTrustedAuthHeader() throws Exception {
        this.setUp("--trusted_auth_header=X-Trusted-Proxy-Auth-Header", "", "", "", "");
        this.attemptConnection("Basic VGVzdDFMZGFwOjEyMzQ1", null, true);
        this.verifyTrustedAuthHeaderMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)));
        this.attemptConnection("Basic VGVzdDFMZGFwOg==", null, true);
        this.verifyTrustedAuthHeaderMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)));
        try {
            this.attemptConnection(null, null, true);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyTrustedAuthHeaderMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(2L)));
        long successMetricBefore = (Long)this.client_.getMetric("impala.webserver.total-trusted-auth-header-check-success");
        this.attemptConnection("Basic VGVzdDFMZGFwOjEyMzQ1", null, false);
        this.verifyTrustedAuthHeaderMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(successMetricBefore), (Comparable)Long.valueOf(successMetricBefore)));
    }

    @Test
    public void testWebserverJwtAuth() throws Exception {
        String jwksFilename = new File(System.getenv("IMPALA_HOME"), "testdata/jwt/jwks_rs256.json").getPath();
        this.setUp(String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_file_path=%s --jwt_allow_without_tls=true", jwksFilename), "", "", "", "");
        String jwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.OW5H2SClLlsotsCarTHYEbqlbRh43LFwOyo9WubpNTwE7hTuJDsnFoVrvHiWI02W69TZNat7DYcC86A_ogLMfNXagHjlMFJaRnvG5Ekag8NRuZNJmHVqfX-qr6x7_8mpOdU554kc200pqbpYLhhuK4Qf7oT7y9mOrtNrUKGDCZ0Q2y_mizlbY6SMg4RWqSz0RQwJbRgXIWSgcbZd0GbD_MQQ8x7WRE4nluU-5Fl4N2Wo8T9fNTuxALPiuVeIczO25b5n4fryfKasSgaZfmk0CoOJzqbtmQxqiK9QNSJAiH2kaqMwLNgAdgn8fbd-lB1RAEGeyPH8Px8ipqcKsPk0bg";
        this.attemptConnection("Bearer " + jwtToken, "127.0.0.1", false);
        this.verifyJwtAuthMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), zero);
        String invalidJwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.";
        try {
            this.attemptConnection("Bearer " + invalidJwtToken, "127.0.0.1", false);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyJwtAuthMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)));
    }

    @Test
    public void testDisplaySrcUsernameInQueryCause() throws Exception {
        this.setUp("", "", "", "", "");
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        TOperationHandle operationHandle = LdapHS2Test.execQueryAsync((TCLIService.Iface)client, openResp.getSessionHandle(), "select sleep(10000)");
        String queryId = LdapWebserverTest.PrintId(operationHandle.getOperationId());
        String cancelQueryUrl = String.format("/cancel_query?query_id=%s", queryId);
        String textProfileUrl = String.format("/query_profile_plain_text?query_id=%s", queryId);
        this.client_.readContent(cancelQueryUrl);
        String response = this.client_.readContent(textProfileUrl);
        String cancelStatus = String.format("Cancelled from Impala&apos;s debug web interface by user: &apos;%s&apos; at", "Test1Ldap");
        Assert.assertTrue((boolean)response.contains(cancelStatus));
        TimeUnit.SECONDS.sleep(6L);
        response = this.client_.readContent("/logs");
        Assert.assertTrue((boolean)response.contains(cancelStatus));
        String sessionId = LdapWebserverTest.PrintId(openResp.getSessionHandle().getSessionId());
        String closeSessionUrl = String.format("/close_session?session_id=%s", sessionId);
        this.client_.readContent(closeSessionUrl);
        TimeUnit.SECONDS.sleep(6L);
        String closeStatus = String.format("Session closed from Impala&apos;s debug web interface by user: &apos;%s&apos; at", "Test1Ldap");
        response = this.client_.readContent("/logs");
        Assert.assertTrue((boolean)response.contains(closeStatus));
    }

    @Test
    public void testSetGLogLevel() throws Exception {
        this.setUp("", "", "", "", "");
        JSONObject json = this.client_.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        json = this.client_.jsonGet("/set_glog_level?glog=0&json");
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        Assert.assertEquals((Object)"Use form input to update glog level", (Object)json.get((Object)"error"));
        json = this.client_.jsonGet("/reset_glog_level?json");
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        Assert.assertEquals((Object)"Use form input to reset glog level", (Object)json.get((Object)"error"));
        BasicHeader[] headers = new BasicHeader[]{new BasicHeader("X-Requested-By", "anything")};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("glog", "0"));
        WebClient client = new WebClient("Test1Ldap", "12345");
        String body = client.post("/set_glog_level?json", null, params, 403);
        Assert.assertEquals((Object)"rejected POST missing X-Requested-By header", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        body = client.post("/reset_glog_level?json", null, null, 403);
        Assert.assertEquals((Object)"rejected POST missing X-Requested-By header", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonPost("/set_glog_level?json", (Header[])headers, params);
        Assert.assertEquals((Object)"0", (Object)json.get((Object)"glog_level"));
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonPost("/reset_glog_level?json", (Header[])headers, null);
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        body = client.post("/set_glog_level?json", null, params, 403);
        Assert.assertEquals((Object)"", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        body = client.post("/reset_glog_level?json", null, null, 403);
        Assert.assertEquals((Object)"", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
        String rand = this.getRandToken(client.getCookies());
        params.add((NameValuePair)new BasicNameValuePair("csrf_token", rand));
        json = client.jsonPost("/set_glog_level?json", null, params);
        Assert.assertEquals((Object)"0", (Object)json.get((Object)"glog_level"));
        json = client.jsonPost("/reset_glog_level?json", null, params);
        Assert.assertEquals((Object)"1", (Object)json.get((Object)"glog_level"));
    }

    @Test
    public void testSetJavaLogLevel() throws Exception {
        this.setUp("", "", "", "", "");
        JSONObject json = this.client_.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        json = this.client_.jsonGet("/set_java_loglevel?class=org.apache&level=WARN&json");
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        Assert.assertEquals((Object)"Use form input to update java log levels", (Object)json.get((Object)"error"));
        json = this.client_.jsonGet("/reset_java_loglevel?json");
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        Assert.assertEquals((Object)"Use form input to reset java log levels", (Object)json.get((Object)"error"));
        BasicHeader[] headers = new BasicHeader[]{new BasicHeader("X-Requested-By", "anything")};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("class", "org.apache"));
        params.add((NameValuePair)new BasicNameValuePair("level", "WARN"));
        WebClient client = new WebClient("Test1Ldap", "12345");
        String body = client.post("/set_java_loglevel?json", null, params, 403);
        Assert.assertEquals((Object)"rejected POST missing X-Requested-By header", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        body = client.post("/reset_java_loglevel?json", null, null, 403);
        Assert.assertEquals((Object)"rejected POST missing X-Requested-By header", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonPost("/set_java_loglevel?json", (Header[])headers, params);
        Assert.assertEquals((Object)"org.apache : WARN\norg.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonPost("/reset_java_loglevel?json", (Header[])headers, null);
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        body = client.post("/set_java_loglevel?json", null, params, 403);
        Assert.assertEquals((Object)"", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        body = client.post("/reset_java_loglevel?json", null, null, 403);
        Assert.assertEquals((Object)"", (Object)body);
        client = new WebClient("Test1Ldap", "12345");
        json = client.jsonGet("/log_level?json");
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        String rand = this.getRandToken(client.getCookies());
        params.add((NameValuePair)new BasicNameValuePair("csrf_token", rand));
        json = client.jsonPost("/set_java_loglevel?json", null, params);
        Assert.assertEquals((Object)"org.apache : WARN\norg.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
        json = client.jsonPost("/reset_java_loglevel?json", null, params);
        Assert.assertEquals((Object)"org.apache.impala : DEBUG\n", (Object)json.get((Object)"get_java_loglevel_result"));
    }

    private String getRandToken(List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            String[] tokens;
            for (String token : tokens = cookie.getValue().split("&")) {
                if (token.charAt(0) != 'r' || token.charAt(1) != '=') continue;
                String rand = token.substring(2);
                Assert.assertTrue((String)("Expected number: " + rand), (boolean)rand.matches("^[1-9][0-9]*$"));
                return rand;
            }
        }
        Assert.fail((String)"Expected cookie to contain random number");
        return "";
    }

    private void attemptConnection(String basic_auth_token, String xff_address, boolean add_trusted_auth_header) throws Exception {
        String url = "http://localhost:25000/?json";
        URLConnection connection = new URL(url).openConnection();
        if (basic_auth_token != null) {
            connection.setRequestProperty("Authorization", basic_auth_token);
        }
        if (xff_address != null) {
            connection.setRequestProperty("X-Forwarded-For", xff_address);
        }
        if (add_trusted_auth_header) {
            connection.setRequestProperty("X-Trusted-Proxy-Auth-Header", "");
        }
        connection.getInputStream();
    }

    private static String PrintId(THandleIdentifier handle) {
        byte[] guid_bytes = handle.getGuid();
        Assert.assertEquals((long)guid_bytes.length, (long)16L);
        byte[] low_bytes = ArrayUtils.subarray((byte[])guid_bytes, (int)0, (int)8);
        byte[] high_bytes = ArrayUtils.subarray((byte[])guid_bytes, (int)8, (int)16);
        ArrayUtils.reverse((byte[])low_bytes);
        ArrayUtils.reverse((byte[])high_bytes);
        return Hex.encodeHexString((byte[])low_bytes) + ":" + Hex.encodeHexString((byte[])high_bytes);
    }
}

