/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.impala.customcluster.KerberosKdcEnvironment;
import org.apache.impala.customcluster.LdapImpalaShellTest;
import org.apache.impala.customcluster.LdapKerberosImpalaShellTestBase;
import org.apache.impala.customcluster.RunShellCommand;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@RunWith(value=Parameterized.class)
public class LdapSearchBindImpalaShellTest
extends LdapImpalaShellTest {
    @ClassRule
    public static KerberosKdcEnvironment kerberosKdcEnvironment = new KerberosKdcEnvironment(new TemporaryFolder());
    private final boolean kerberosAuthenticationEnabled;

    @Parameterized.Parameters(name="kerberosAuthenticationEnabled={0}")
    public static Boolean[] kerberosAuthenticationEnabled() {
        return new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    }

    public LdapSearchBindImpalaShellTest(boolean isKerberosAuthenticationEnabled) {
        this.kerberosAuthenticationEnabled = isKerberosAuthenticationEnabled;
    }

    @Override
    protected int startImpalaCluster(String args) throws IOException, InterruptedException {
        if (this.kerberosAuthenticationEnabled) {
            return kerberosKdcEnvironment.startImpalaClusterWithArgs(args);
        }
        return super.startImpalaCluster(args);
    }

    @Override
    public void setUp(String extraArgs) throws Exception {
        String searchBindArgs = String.format("--ldap_search_bind_authentication=true --ldap_bind_dn=%s --ldap_bind_password_cmd='echo -n %s' %s %s", "cn=Test1Ldap,ou=Users,dc=myorg,dc=com", "12345", this.getKerberosArgs(), extraArgs);
        super.setUp(searchBindArgs);
    }

    private String getKerberosArgs() throws IOException {
        return this.kerberosAuthenticationEnabled ? LdapKerberosImpalaShellTestBase.flagsToArgs(LdapKerberosImpalaShellTestBase.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true")})) : "";
    }

    @Test
    public void testShellLdapAuth() throws Exception {
        this.setUp("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_user_filter=(&(objectClass=person)(cn={0}))");
        this.testShellLdapAuthImpl(null);
    }

    @Test
    public void testHttpImpersonation() throws Exception {
        this.setUp(String.format("--authorized_proxy_user_config=%s=%s --ldap_user_search_basedn=dc=myorg,dc=com --ldap_user_filter=(cn={0})", "Test1Ldap", "proxyUser$"));
        this.testHttpImpersonationImpl();
    }

    @Test
    public void testLdapFilters() throws Exception {
        this.setUp(String.format("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_group_search_basedn=ou=Groups,dc=myorg,dc=com --ldap_user_filter=(&(objectClass=person)(cn={0})(!(cn=%s))) --ldap_group_filter=(uniqueMember={0})", "Test2Ldap"));
        this.testLdapFiltersImpl();
    }

    @Test
    public void testLdapFiltersWithNarrowGroupSearch() throws Exception {
        this.setUp(String.format("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_group_search_basedn=ou=Groups,dc=myorg,dc=com --ldap_user_filter=(&(objectClass=person)(cn={0})(!(cn=%s))) --ldap_group_filter=(&(cn=%s)(uniqueMember={0}))", "Test2Ldap", "group1"));
        this.testLdapFiltersImpl();
    }

    @Test
    public void testLdapFiltersWithProxy() throws Exception {
        this.setUp(String.format("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_group_search_basedn=ou=Groups,dc=myorg,dc=com --ldap_user_filter=(&(objectClass=person)(cn={0})(!(cn=Test2Ldap))) --ldap_group_filter=(&(cn=group1)(uniqueMember={0})) --authorized_proxy_user_config=%s=* ", "Test4Ldap"));
        this.testLdapFiltersWithProxyImpl();
    }

    @Test
    public void testLdapFiltersWithProxyWithoutDoAsUser() throws Exception {
        this.setUp(String.format("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_group_search_basedn=ou=Groups,dc=myorg,dc=com --ldap_user_filter=(&(objectClass=person)(cn={0})(!(cn=Test2Ldap))) --ldap_group_filter=(&(cn=group1)(uniqueMember={0})) --authorized_proxy_user_config=%s=* ", "Test1Ldap"));
        String query = "select logged_in_user()";
        for (String protocol : this.getProtocolsToTest()) {
            String[] command = this.buildCommand(query, protocol, "Test1Ldap", "12345", "/cliservice");
            RunShellCommand.Run(command, true, "Test1Ldap", "");
        }
    }

    @Test
    public void testAuthenticationOverMultipleOUs() throws Exception {
        this.setUp("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_user_filter=(cn={0})");
        String query = "select logged_in_user()";
        String[] command = this.buildCommand(query, "hs2-http", "Test2Ldap", "abcde", "/cliservice");
        RunShellCommand.Run(command, true, "", "");
        command = this.buildCommand(query, "hs2-http", "Test5Ldap", "klmnop", "/cliservice");
        RunShellCommand.Run(command, true, "", "");
        command = this.buildCommand(query, "hs2-http", "invalid", "123", "/cliservice");
        RunShellCommand.Run(command, false, "", "");
    }

    @Test
    public void testEscapedCharactersInDN() throws Exception {
        this.setUp("--ldap_user_search_basedn=dc=myorg,dc=com --ldap_group_search_basedn=ou=Groups,dc=myorg,dc=com --ldap_user_filter=(cn={0}) --ldap_group_filter=(uniqueMember={0}) ");
        String query = "select logged_in_user()";
        String[] command = this.buildCommand(query, "hs2-http", "Ldap\\, (Test6*)", "qrstu", "/cliservice");
        RunShellCommand.Run(command, true, "Ldap\\, (Test6*)", "");
    }
}

