/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.impala.customcluster.LdapKerberosImpalaShellTestBase;
import org.junit.Assert;
import org.junit.Test;

@CreateDS(name="myAD", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@ApplyLdifFiles(value={"adschema.ldif", "adusers.ldif"})
public class LdapSearchBindDefaultFiltersKerberosImpalaShellTest
extends LdapKerberosImpalaShellTestBase {
    @Test
    public void testCustomLdapFiltersNotAllowedWithKerberos() throws Exception {
        Map<String, String> flags = LdapSearchBindDefaultFiltersKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(), this.getCustomLdapFilterFlags(), ImmutableMap.of((Object)"enable_minidumps", (Object)"false")});
        int ret = this.startImpalaCluster(LdapSearchBindDefaultFiltersKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)1L);
    }

    @Test
    public void testDefaultLdapFiltersAreAllowedWithSearchBindAndKerberos() throws Exception {
        String userSearchBaseDn = "ou=Users,dc=myorg,dc=com";
        Map<String, String> flags = LdapSearchBindDefaultFiltersKerberosImpalaShellTest.mergeFlags(kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(userSearchBaseDn, "ou=Groups,dc=myorg,dc=com"));
        int ret = this.startImpalaCluster(LdapSearchBindDefaultFiltersKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testLdapFiltersImpl();
    }

    @Test
    public void testDefaultLdapFiltersAreAppliedToDelegateUserWithKerberosAuth() throws Exception {
        String userSearchBaseDn = "ou=Users,dc=myorg,dc=com";
        Map<String, String> flags = LdapSearchBindDefaultFiltersKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(userSearchBaseDn, "ou=Groups,dc=myorg,dc=com"), ImmutableMap.of((Object)"authorized_proxy_user_config", (Object)String.format("%s=*", "Test1Ldap"))});
        int ret = this.startImpalaCluster(LdapSearchBindDefaultFiltersKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=proxyUser$", false, "", "User is not authorized.");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=Test2Ldap", false, "", "User is not authorized.");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=Test3Ldap", false, "", "User is not authorized.");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=Test1Ldap", true, "Test1Ldap", "");
    }
}

