/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.Range;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.service.JdbcTestBase;
import org.apache.impala.testutil.ImpalaJdbcClient;
import org.apache.impala.testutil.WebClient;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@ApplyLdifFiles(value={"users.ldif"})
public class LdapJdbcTest
extends JdbcTestBase {
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    private static final String testUser_ = "Test1Ldap";
    private static final String testPassword_ = "12345";
    private static final Range<Long> zero = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L));
    private static final Range<Long> one = Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L));
    WebClient client_ = new WebClient();

    public LdapJdbcTest(String connectionType) {
        super(connectionType);
    }

    public void setUp(String extraArgs) throws Exception {
        String uri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String dn = "cn=#UID,ou=Users,dc=myorg,dc=com";
        String impalaArgs = String.format("--enable_ldap_auth --ldap_uri='%s' --ldap_bind_pattern='%s' --ldap_passwords_in_clear_ok --cookie_require_secure=false %s", uri, dn, extraArgs);
        int ret = CustomClusterRunner.StartImpalaCluster(impalaArgs);
        Assert.assertEquals((long)ret, (long)0L);
        this.con_ = LdapJdbcTest.createConnection(ImpalaJdbcClient.getLdapConnectionStr(this.connectionType_, testUser_, testPassword_));
        if (this.connectionType_.equals("http")) {
            this.verifyMetrics(one, zero, zero, zero);
        }
    }

    private void verifyMetrics(Range<Long> expectedBasicSuccess, Range<Long> expectedBasicFailure, Range<Long> expectedCookieSuccess, Range<Long> expectedCookieFailure) throws Exception {
        long actualBasicSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedBasicSuccess + ", Actual: " + actualBasicSuccess), (boolean)expectedBasicSuccess.contains((Comparable)Long.valueOf(actualBasicSuccess)));
        long actualBasicFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedBasicFailure + ", Actual: " + actualBasicFailure), (boolean)expectedBasicFailure.contains((Comparable)Long.valueOf(actualBasicFailure)));
        long actualCookieSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedCookieSuccess + ", Actual: " + actualCookieSuccess), (boolean)expectedCookieSuccess.contains((Comparable)Long.valueOf(actualCookieSuccess)));
        long actualCookieFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedCookieFailure + ", Actual: " + actualCookieFailure), (boolean)expectedCookieFailure.contains((Comparable)Long.valueOf(actualCookieFailure)));
    }

    @Test
    public void testLoggedInUser() throws Exception {
        this.setUp("");
        ResultSet rs = this.con_.createStatement().executeQuery("select logged_in_user() user");
        if (this.connectionType_.equals("http")) {
            this.verifyMetrics(one, zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("user"), (Object)testUser_);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testFailedConnection() throws Exception {
        Connection con;
        this.setUp("");
        try {
            con = LdapJdbcTest.createConnection(ImpalaJdbcClient.getLdapConnectionStr(this.connectionType_, testUser_, "invalid-password"));
            Assert.fail((String)"Connecting with an invalid password should throw an error.");
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not open client transport"));
        }
        try {
            con = LdapJdbcTest.createConnection(ImpalaJdbcClient.getLdapConnectionStr(this.connectionType_, "invalid-user", testPassword_));
            Assert.fail((String)"Connecting with an invalid user name should throw an error.");
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not open client transport"));
        }
    }

    @Test
    public void testExpireCookies() throws Exception {
        if (this.connectionType_.equals("http")) {
            this.setUp("--max_cookie_lifetime_s=1");
            Thread.sleep(2000L);
            ResultSet rs = this.con_.createStatement().executeQuery("select logged_in_user() user");
            this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(0L)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("user"), (Object)testUser_);
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

