/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.log4j.Logger;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

class KerberosKdcEnvironment
extends ExternalResource {
    private final Logger LOG = Logger.getLogger(KerberosKdcEnvironment.class);
    private static final String realm = "myorg.com";
    private static final String servicePrincipal = String.format("impala/localhost@%s", "myorg.com");
    private final TemporaryFolder testFolder;
    private SimpleKdcServer kerbyServer;

    public KerberosKdcEnvironment(TemporaryFolder testFolder) {
        this.testFolder = testFolder;
    }

    protected void before() throws Throwable {
        this.testFolder.create();
        this.kerbyServer = new SimpleKdcServer();
        this.kerbyServer.setKdcRealm(realm);
        this.kerbyServer.setAllowUdp(false);
        this.kerbyServer.setWorkDir(this.testFolder.getRoot());
        this.kerbyServer.init();
        this.kerbyServer.createPrincipal(servicePrincipal, "password");
        File keytabFile = new File(this.getServiceKeytabFilePath());
        this.kerbyServer.exportPrincipal(servicePrincipal, keytabFile);
        this.kerbyServer.start();
    }

    protected void after() {
        try {
            this.kerbyServer.stop();
        }
        catch (KrbException e) {
            this.LOG.error((Object)"An exception received while stopping KDC server", (Throwable)e);
        }
    }

    public String getServicePrincipal() {
        return servicePrincipal;
    }

    public String getServicePrincipal(String service, String hostname) {
        return String.format("%s/%s@%s", service, hostname, realm);
    }

    public String getServiceKeytabFilePath() throws IOException {
        return new File(this.kerbyServer.getWorkDir().getCanonicalPath() + "/impala.keytab").getCanonicalPath();
    }

    public String getKeytabFilePathWithServicePrincipal(String service, String hostname) throws IOException, KrbException {
        String servicePrincipal = this.getServicePrincipal(service, hostname);
        String keytabFileName = String.format("%s.%s.keytab", service, hostname);
        File keytabFile = new File(this.kerbyServer.getWorkDir().getCanonicalPath() + "/" + keytabFileName);
        this.kerbyServer.createPrincipal(servicePrincipal, "password");
        this.kerbyServer.exportPrincipal(servicePrincipal, keytabFile);
        return keytabFile.getCanonicalPath();
    }

    public String getKrb5ConfigPath() throws IOException {
        return this.kerbyServer.getWorkDir().getCanonicalPath() + "/krb5.conf";
    }

    public String getUserPrincipal(String user) {
        return String.format("%s@%s", user, realm);
    }

    public String createUserPrincipalAndCredentialsCache(String username) throws KrbException, IOException {
        String userPrincipal = this.getUserPrincipal(username);
        this.deleteUserPrincipalIfExists(userPrincipal);
        this.kerbyServer.createPrincipal(userPrincipal, "password");
        File credentialsCache = this.testFolder.newFile();
        KrbClient krbClient = new KrbClient(this.kerbyServer.getWorkDir());
        krbClient.init();
        TgtTicket tgt = krbClient.requestTgt(username, "password");
        krbClient.storeTicket(tgt, credentialsCache);
        return credentialsCache.getCanonicalPath();
    }

    private void deleteUserPrincipalIfExists(String userPrincipal) throws KrbException {
        if (this.kerbyServer.getIdentityService().getIdentity(userPrincipal) != null) {
            this.kerbyServer.deletePrincipal(userPrincipal);
        }
    }

    public Map<String, String> getKerberosAuthFlags() throws IOException {
        return ImmutableMap.of((Object)"principal", (Object)this.getServicePrincipal(), (Object)"keytab_file", (Object)this.getServiceKeytabFilePath());
    }

    public Map<String, String> getKerberosAuthFlagsWithCustomServicePrincipal(String service, String hostname) throws IOException, KrbException {
        return ImmutableMap.of((Object)"principal", (Object)this.getServicePrincipal(service, hostname), (Object)"keytab_file", (Object)this.getKeytabFilePathWithServicePrincipal(service, hostname), (Object)"skip_internal_kerberos_auth", (Object)"true");
    }

    private Map<String, String> getClusterEnv() throws IOException {
        String krb5Config = this.getKrb5ConfigPath();
        return ImmutableMap.of((Object)"KRB5_CONFIG", (Object)krb5Config, (Object)"KRB5_KDC_PROFILE", (Object)krb5Config);
    }

    private String overrideKrbCcNameFlag(String args) throws IOException {
        return String.format("%s --krb5_ccname=%s", args, this.testFolder.newFile().getCanonicalPath());
    }

    public int startImpalaClusterWithArgs(String args) throws IOException, InterruptedException {
        return CustomClusterRunner.StartImpalaCluster(this.overrideKrbCcNameFlag(args), this.overrideKrbCcNameFlag(args), this.overrideKrbCcNameFlag(args), this.getClusterEnv(), "--cluster_size=1");
    }

    public String[] getImpalaShellEnv(String credentialsCacheFilePath) throws IOException {
        List<String> envList = System.getenv().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList());
        String krb5ConfigPath = this.getKrb5ConfigPath();
        envList.addAll((Collection<String>)ImmutableList.of((Object)String.format("KRB5_CONFIG=%s", krb5ConfigPath), (Object)String.format("KRB5_KDC_PROFILE=%s", krb5ConfigPath), (Object)String.format("KRB5CCNAME=FILE:%s", credentialsCacheFilePath)));
        return envList.toArray(new String[0]);
    }
}

