/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.testutil.WebClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JwtWebserverTest {
    private static final Range<Long> zero = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L));
    WebClient client_ = new WebClient("Test1Ldap", "12345");

    public void setUp(String extraArgs, String startArgs) throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("IMPALA_WEBSERVER_USERNAME", "Test1Ldap");
        env.put("IMPALA_WEBSERVER_PASSWORD", "12345");
        int ret = CustomClusterRunner.StartImpalaCluster(extraArgs, env, startArgs);
        Assert.assertEquals((long)ret, (long)0L);
    }

    @After
    public void cleanUp() throws Exception {
        CustomClusterRunner.StartImpalaCluster();
        this.client_.Close();
    }

    private void verifyJwtAuthMetrics(Range<Long> expectedAuthSuccess, Range<Long> expectedAuthFailure) throws Exception {
        long actualAuthSuccess = (Long)this.client_.getMetric("impala.webserver.total-jwt-token-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedAuthSuccess + ", Actual: " + actualAuthSuccess), (boolean)expectedAuthSuccess.contains((Comparable)Long.valueOf(actualAuthSuccess)));
        long actualAuthFailure = (Long)this.client_.getMetric("impala.webserver.total-jwt-token-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedAuthFailure + ", Actual: " + actualAuthFailure), (boolean)expectedAuthFailure.contains((Comparable)Long.valueOf(actualAuthFailure)));
    }

    @Test
    public void testWebserverJwtAuth() throws Exception {
        String jwksFilename = new File(System.getenv("IMPALA_HOME"), "testdata/jwt/jwks_rs256.json").getPath();
        this.setUp(String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_file_path=%s --jwt_allow_without_tls=true", jwksFilename), "");
        String jwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.OW5H2SClLlsotsCarTHYEbqlbRh43LFwOyo9WubpNTwE7hTuJDsnFoVrvHiWI02W69TZNat7DYcC86A_ogLMfNXagHjlMFJaRnvG5Ekag8NRuZNJmHVqfX-qr6x7_8mpOdU554kc200pqbpYLhhuK4Qf7oT7y9mOrtNrUKGDCZ0Q2y_mizlbY6SMg4RWqSz0RQwJbRgXIWSgcbZd0GbD_MQQ8x7WRE4nluU-5Fl4N2Wo8T9fNTuxALPiuVeIczO25b5n4fryfKasSgaZfmk0CoOJzqbtmQxqiK9QNSJAiH2kaqMwLNgAdgn8fbd-lB1RAEGeyPH8Px8ipqcKsPk0bg";
        this.attemptConnection("Bearer " + jwtToken, "127.0.0.1");
        this.verifyJwtAuthMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), zero);
        String invalidJwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.";
        try {
            this.attemptConnection("Bearer " + invalidJwtToken, "127.0.0.1");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyJwtAuthMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)));
        try {
            this.attemptConnection("Basic VGVzdDFMZGFwOjEyMzQ1", "127.0.0.1");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyJwtAuthMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)));
        try {
            this.attemptConnection(null, "127.0.0.1");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Server returned HTTP response code: 401"));
        }
        this.verifyJwtAuthMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L)));
    }

    private void attemptConnection(String auth_token, String xff_address) throws Exception {
        String url = "http://localhost:25000/?json";
        URLConnection connection = new URL(url).openConnection();
        if (auth_token != null) {
            connection.setRequestProperty("Authorization", auth_token);
        }
        if (xff_address != null) {
            connection.setRequestProperty("X-Forwarded-For", xff_address);
        }
        connection.getInputStream();
    }
}

