/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import java.util.List;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TCloseSessionResp;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.impala.common.FrontendFixture;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.ImpalaHiveServer2Service;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TExecutePlannedStatementReq;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExternalFrontendTest {
    private final FrontendFixture feFixture_ = FrontendFixture.instance();
    private final Frontend frontend_ = this.feFixture_.frontend();
    private final int externalFePort = 21159;
    private final int hs2BinaryPort = 21050;
    private final int hs2HttpPort = 28000;

    void setup(int port, boolean isHttp) throws Exception {
        String impaladFlags = "--external_fe_port=" + port;
        if (isHttp) {
            impaladFlags = impaladFlags + " --enable_external_fe_http";
        }
        int ret = CustomClusterRunner.StartImpalaCluster("", "", "", "--per_impalad_args=" + impaladFlags);
        Assert.assertEquals((String)("custom cluster failed to start with args: " + impaladFlags), (long)ret, (long)0L);
    }

    void setupExternalFe() throws Exception {
        this.setup(21159, false);
    }

    void setupExternalFeHttp() throws Exception {
        this.setup(21159, true);
    }

    ImpalaHiveServer2Service.Client createBinaryClient(int port) throws Exception {
        TSocket sock = new TSocket("localhost", port);
        sock.open();
        return new ImpalaHiveServer2Service.Client((TProtocol)new TBinaryProtocol((TTransport)sock));
    }

    ImpalaHiveServer2Service.Client createHttpClient(int port) throws Exception {
        String host_url = "http://localhost:" + port + "/cliservice";
        THttpClient client = new THttpClient(host_url);
        return new ImpalaHiveServer2Service.Client((TProtocol)new TBinaryProtocol((TTransport)client));
    }

    static TStatus verifySuccess(TStatus status) throws Exception {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return status;
        }
        throw new Exception(status.toString());
    }

    void executeTestQuery(ImpalaHiveServer2Service.Client client) throws Exception {
        this.executeTestQuery(client, false);
    }

    TStatus executeTestQueryExpectFailure(ImpalaHiveServer2Service.Client client) throws Exception {
        return this.executeTestQuery(client, true);
    }

    TStatus executeTestQuery(ImpalaHiveServer2Service.Client client, boolean shouldFailExecute) throws Exception {
        String testStmt = "SELECT 'this is a test, this is only a test'";
        String expectedValue = "this is a test, this is only a test";
        TQueryOptions options = new TQueryOptions();
        options.setExec_single_node_rows_threshold(0);
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(testStmt);
        queryCtx.client_request.query_options = options;
        TExecRequest request = null;
        try {
            request = this.frontend_.createExecRequest(new Frontend.PlanCtx(queryCtx));
        }
        catch (ImpalaException e) {
            Assert.fail((String)("Failed to create exec request for '" + testStmt + "': " + e.getMessage()));
        }
        TOpenSessionResp openResp = client.OpenSession(new TOpenSessionReq());
        ExternalFrontendTest.verifySuccess(openResp.getStatus());
        TExecuteStatementReq executeReq = new TExecuteStatementReq();
        executeReq.setSessionHandle(openResp.getSessionHandle());
        executeReq.setStatement(testStmt);
        TExecutePlannedStatementReq executePlannedReq = new TExecutePlannedStatementReq();
        executePlannedReq.setStatementReq(executeReq);
        executePlannedReq.setPlan(request);
        TExecuteStatementResp execResp = client.ExecutePlannedStatement(executePlannedReq);
        if (shouldFailExecute) {
            return execResp.getStatus();
        }
        ExternalFrontendTest.verifySuccess(execResp.getStatus());
        TFetchResultsReq fetchReq = new TFetchResultsReq(execResp.getOperationHandle(), TFetchOrientation.FETCH_NEXT, 1000L);
        TFetchResultsResp fetchResp = client.FetchResults(fetchReq);
        ExternalFrontendTest.verifySuccess(fetchResp.getStatus());
        List columns = fetchResp.getResults().getColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        Assert.assertEquals((Object)expectedValue, ((TColumn)columns.get(0)).getStringVal().getValues().get(0));
        TCloseSessionResp closeResp = client.CloseSession(new TCloseSessionReq(openResp.getSessionHandle()));
        return ExternalFrontendTest.verifySuccess(closeResp.getStatus());
    }

    @Test
    public void testExternalFrontendBinary() throws Exception {
        this.setupExternalFe();
        this.executeTestQuery(this.createBinaryClient(21159));
    }

    @Test
    public void testExternalFrontendHttp() throws Exception {
        this.setupExternalFeHttp();
        this.executeTestQuery(this.createHttpClient(21159));
    }

    @Test
    public void testExecutePlannedStatementDisallowedNonExternalFe() throws Exception {
        this.setupExternalFe();
        TStatus status = this.executeTestQueryExpectFailure(this.createBinaryClient(21050));
        Assert.assertEquals((Object)status.getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
        Assert.assertTrue((boolean)status.toString().contains("Unsupported operation"));
        status = this.executeTestQueryExpectFailure(this.createHttpClient(28000));
        Assert.assertEquals((Object)status.getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
        Assert.assertTrue((boolean)status.toString().contains("Unsupported operation"));
    }

    @After
    public void cleanUp() throws Exception {
        CustomClusterRunner.StartImpalaCluster();
    }
}

