/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java_cup.runtime.Scanner;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SqlParser;
import org.apache.impala.analysis.SqlScanner;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.AnalysisSessionFixture;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.EventSequence;
import org.junit.Assert;

public class QueryFixture {
    protected final AnalysisSessionFixture session_;
    protected final TQueryCtx queryCtx_;
    protected final TQueryOptions queryOptions_;
    protected String stmtSql_;
    protected String db_;
    protected String user_;

    public QueryFixture(AnalysisSessionFixture session, String stmtSql) {
        this.session_ = session;
        this.stmtSql_ = stmtSql;
        this.queryCtx_ = this.session_.queryContext();
        this.queryOptions_ = this.session_.cloneOptions();
        this.db_ = this.session_.db();
        this.user_ = this.session_.user();
    }

    public void setDb(String db) {
        this.db_ = db;
    }

    public void setUser(String user) {
        this.user_ = user;
    }

    public TQueryCtx context() {
        return this.queryCtx_;
    }

    public String stmtSql() {
        return this.stmtSql_;
    }

    public TQueryOptions options() {
        return this.queryOptions_;
    }

    protected TQueryCtx queryContext() {
        return TestUtils.createQueryContext(this.db_, this.user_, this.queryOptions_);
    }

    public StatementBase parse() {
        SqlScanner input = new SqlScanner((Reader)new StringReader(this.stmtSql_));
        SqlParser parser = new SqlParser((Scanner)input);
        parser.setQueryOptions(this.queryOptions_);
        try {
            return (StatementBase)parser.parse().value;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static class SelectFixture
    extends AnalysisFixture {
        public String table_ = "functional.alltypes";
        public String exprSql_;

        public SelectFixture(AnalysisSessionFixture analysisFixture) {
            super(analysisFixture, null);
        }

        public SelectFixture table(String table) {
            this.table_ = table;
            return this;
        }

        public SelectFixture exprSql(String exprSql) {
            this.exprSql_ = exprSql;
            this.stmtSql_ = "select " + exprSql + " from " + this.table_;
            return this;
        }

        public SelectFixture whereSql(String exprSql) {
            this.exprSql_ = exprSql;
            this.stmtSql_ = "select count(1)  from " + this.table_ + " where " + this.exprSql_;
            return this;
        }

        public SelectStmt analyzeSelect() throws AnalysisException {
            this.analyze();
            return this.selectStmt();
        }

        public Expr analyzeExpr() throws AnalysisException {
            this.analyze();
            return this.selectExpr();
        }

        public SelectStmt selectStmt() {
            Preconditions.checkState((this.stmt_ != null ? 1 : 0) != 0, (Object)"Not yet analyzed");
            return (SelectStmt)this.stmt_;
        }

        public Expr selectExpr() {
            return ((SelectListItem)this.selectStmt().getSelectList().getItems().get(0)).getExpr();
        }

        public Expr whereExpr() {
            return this.selectStmt().getWhereClause();
        }

        public Expr verifySelect(String expectedExprStr) {
            Expr rewrittenExpr = this.selectExpr();
            String rewrittenSql = rewrittenExpr.toSql();
            Assert.assertEquals((Object)(expectedExprStr == null ? this.exprSql_ : expectedExprStr), (Object)rewrittenSql);
            return rewrittenExpr;
        }
    }

    public static class AnalysisFixture
    extends QueryFixture {
        protected AnalysisContext analysisCtx_;
        protected StatementBase stmt_;
        private AnalysisContext.AnalysisResult analysisResult_;

        public AnalysisFixture(AnalysisSessionFixture analysisFixture, String stmtSql) {
            super(analysisFixture, stmtSql);
        }

        public StatementBase analyze() throws AnalysisException {
            Preconditions.checkState((this.analysisCtx_ == null ? 1 : 0) != 0, (Object)"Already analyzed");
            try {
                this.stmt_ = this.parse();
                this.analysisCtx_ = this.makeAnalysisContext();
                this.analysisResult_ = this.analysisCtx_.analyzeAndAuthorize(this.stmt_, this.makeTableCache(this.stmt_), this.session_.frontend().getAuthzChecker());
                Preconditions.checkNotNull((Object)this.analysisResult_.getStmt());
                return this.stmt_;
            }
            catch (AnalysisException e) {
                throw e;
            }
            catch (ImpalaException e) {
                throw new IllegalStateException(e);
            }
        }

        protected AnalysisContext makeAnalysisContext() {
            EventSequence timeline = new EventSequence("Frontend Test Timeline");
            return new AnalysisContext(this.queryCtx_, (AuthorizationFactory)new NoopAuthorizationFactory(), timeline);
        }

        protected StmtMetadataLoader.StmtTableCache makeTableCache(StatementBase stmt) {
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(this.session_.frontend(), this.db_, null);
            try {
                return mdLoader.loadTables(stmt);
            }
            catch (InternalException e) {
                Assert.fail((String)e.getMessage());
                throw new IllegalStateException(e);
            }
        }

        public StatementBase statement() {
            return this.stmt_;
        }

        public Analyzer analyzer() {
            Preconditions.checkState((this.analysisResult_ != null ? 1 : 0) != 0, (Object)"Not yet analyzed");
            return this.analysisResult_.getAnalyzer();
        }

        public void expectWarning(String expectedWarning) {
            List actualWarnings = this.analyzer().getWarnings();
            boolean matchedWarning = false;
            for (String actualWarning : actualWarnings) {
                if (!actualWarning.startsWith(expectedWarning)) continue;
                matchedWarning = true;
                break;
            }
            if (!matchedWarning) {
                Assert.fail((String)String.format("Did not produce expected warning.\nExpected warning:\n%s.\nActual warnings:\n%s", expectedWarning, Joiner.on((String)"\n").join((Iterable)actualWarnings)));
            }
        }
    }
}

