/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FileSystemUtilTest {
    private static final Path TEST_TABLE_PATH = new Path("/test-warehouse/foo.db/filesystem-util-test");

    @Test
    public void testIsInIgnoredDirectory() {
        Assert.assertTrue((String)"Files in hive staging directory should be ignored", (boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, "/part=1/.hive-staging/tempfile")));
        Assert.assertTrue((String)"Files in hidden directory ignored", (boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, ".hidden/000000_0")));
        Assert.assertTrue((String)"Files in the hive temporary directories should be ignored", (boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, "_tmp.base_0000000_1/000000_1.manifest")));
        Assert.assertTrue((String)"Files in hive temporary directories should be ignored", (boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, "_tmp.delta_000000_2/test.manifest")));
        Assert.assertTrue((String)"Files in spark temporary directories should be ignored", (boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, "_spark_metadata/0")));
        Assert.assertTrue((boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, ".hive-staging/nested-1/nested-2/nested-3/tempfile")));
        Assert.assertFalse((boolean)this.testIsInIgnoredDirectory(TEST_TABLE_PATH));
        Assert.assertFalse((boolean)this.testIsInIgnoredDirectory(new Path("hdfs://localhost:20500" + TEST_TABLE_PATH)));
        Assert.assertFalse((boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH + "/part=1/000000")));
        Assert.assertFalse((boolean)this.testIsInIgnoredDirectory(new Path("hdfs://localhost:20500" + TEST_TABLE_PATH + "/part=1/00000")));
        Assert.assertFalse((boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, "/part=100/base_0000005/datafile")));
        Assert.assertFalse((boolean)this.testIsInIgnoredDirectory(new Path(TEST_TABLE_PATH, "/delta_0000001_0000002/deltafile")));
    }

    @Test
    public void testIsIgnoredDir() {
        Assert.assertTrue((String)"Directory should be ignored if it starts with _tmp.", (boolean)FileSystemUtil.isIgnoredDir((Path)new Path(TEST_TABLE_PATH, "_tmp.dummy")));
        Assert.assertTrue((String)"Directory should be ignored if its hidden", (boolean)FileSystemUtil.isIgnoredDir((Path)new Path(TEST_TABLE_PATH, ".hidden-dir")));
        Assert.assertFalse((boolean)FileSystemUtil.isIgnoredDir((Path)TEST_TABLE_PATH));
        Assert.assertFalse((boolean)FileSystemUtil.isIgnoredDir((Path)new Path(TEST_TABLE_PATH + "/part=100/datafile")));
    }

    @Test
    public void testFsType() throws IOException {
        this.testFsType(this.mockLocation("abfs"), FileSystemUtil.FsType.ADLS);
        this.testFsType(this.mockLocation("abfss"), FileSystemUtil.FsType.ADLS);
        this.testFsType(this.mockLocation("adl"), FileSystemUtil.FsType.ADLS);
        this.testFsType(this.mockLocation("file"), FileSystemUtil.FsType.LOCAL);
        this.testFsType(this.mockLocation("hdfs"), FileSystemUtil.FsType.HDFS);
        this.testFsType(this.mockLocation("s3a"), FileSystemUtil.FsType.S3);
        this.testFsType(this.mockLocation("o3fs"), FileSystemUtil.FsType.OZONE);
        this.testFsType(this.mockLocation("ofs"), FileSystemUtil.FsType.OZONE);
        this.testFsType(this.mockLocation("alluxio"), FileSystemUtil.FsType.ALLUXIO);
    }

    @Test
    public void testSupportStorageIds() throws IOException {
        this.testIsSupportStorageIds(this.mockLocation("abfs"), false);
        this.testIsSupportStorageIds(this.mockLocation("abfss"), false);
        this.testIsSupportStorageIds(this.mockLocation("adl"), false);
        this.testIsSupportStorageIds(this.mockLocation("file"), false);
        this.testIsSupportStorageIds(this.mockLocation("s3a"), false);
        this.testIsSupportStorageIds(this.mockLocation("hdfs"), true);
    }

    @Test
    public void testWriteableByImpala() throws IOException {
        this.testIsWritableByImpala(this.mockLocation("alluxio"), false);
        this.testIsWritableByImpala(this.mockLocation("abfs"), true);
        this.testIsWritableByImpala(this.mockLocation("abfss"), true);
        this.testIsWritableByImpala(this.mockLocation("adl"), true);
        this.testIsWritableByImpala(this.mockLocation("file"), true);
        this.testIsWritableByImpala(this.mockLocation("hdfs"), true);
        this.testIsWritableByImpala(this.mockLocation("s3a"), true);
        this.testIsWritableByImpala(this.mockLocation("o3fs"), true);
        this.testIsWritableByImpala(this.mockLocation("ofs"), true);
    }

    @Test
    public void testSupportedDefaultFs() throws IOException {
        this.testIsSupportedDefaultFs(this.mockLocation("abfs"), true);
        this.testIsSupportedDefaultFs(this.mockLocation("abfss"), true);
        this.testIsSupportedDefaultFs(this.mockLocation("adl"), true);
        this.testIsSupportedDefaultFs(this.mockLocation("hdfs"), true);
        this.testIsSupportedDefaultFs(this.mockLocation("s3a"), true);
        this.testIsSupportedDefaultFs(this.mockLocation("file"), false);
    }

    @Test
    public void testValidLoadDataInpath() throws IOException {
        this.testValidLoadDataInpath(this.mockLocation("abfs"), true);
        this.testValidLoadDataInpath(this.mockLocation("abfss"), true);
        this.testValidLoadDataInpath(this.mockLocation("adl"), true);
        this.testValidLoadDataInpath(this.mockLocation("hdfs"), true);
        this.testValidLoadDataInpath(this.mockLocation("s3a"), true);
        this.testValidLoadDataInpath(this.mockLocation("file"), false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsPathOnFileSystem() throws IOException {
        void var4_7;
        List<String> schemes = Arrays.asList("abfs", "abfss", "adl", "hdfs", "s3a", "file");
        ArrayList<Path> mockFiles = new ArrayList<Path>();
        for (String string : schemes) {
            mockFiles.add(new Path(this.mockLocation(string)));
        }
        ArrayList<FileSystem> fileSystems = new ArrayList<FileSystem>();
        for (Path mockFile : mockFiles) {
            fileSystems.add(FileSystemUtil.getFileSystemForPath((Path)mockFile));
        }
        boolean bl = false;
        while (var4_7 < fileSystems.size()) {
            FileSystem fs = (FileSystem)fileSystems.get((int)var4_7);
            for (int j = 0; j < mockFiles.size(); ++j) {
                Path mockFile = (Path)mockFiles.get(j);
                if (var4_7 == j) {
                    Assert.assertTrue((String)String.format("Path '%s' should be on file system '%s'", mockFile, fs), (boolean)FileSystemUtil.isPathOnFileSystem((Path)mockFile, (FileSystem)fs));
                    continue;
                }
                Assert.assertFalse((String)String.format("Path '%s' should not be on file system '%s'", mockFile, fs), (boolean)FileSystemUtil.isPathOnFileSystem((Path)mockFile, (FileSystem)fs));
            }
            ++var4_7;
        }
    }

    @Test
    public void testVolumeBucketPair() throws IOException {
        List<Pair> cases = Arrays.asList(Pair.create((Object)this.mockLocation("ofs"), (Object)Pair.create((Object)"volume1", (Object)"bucket2")), Pair.create((Object)"ofs://svc1:9876/volume/bucket/file", (Object)Pair.create((Object)"volume", (Object)"bucket")), Pair.create((Object)"ofs://svc1:9876/volume/bucket/", (Object)Pair.create((Object)"volume", (Object)"bucket")), Pair.create((Object)"ofs://svc1:9876/volume/bucket", (Object)Pair.create((Object)"volume", (Object)"bucket")), Pair.create((Object)"ofs://svc1:9876/volume/", (Object)Pair.create((Object)"volume", (Object)"")), Pair.create((Object)"ofs://svc1:9876/volume", (Object)Pair.create((Object)"volume", (Object)"")), Pair.create((Object)"ofs://svc1:9876/", (Object)Pair.create((Object)"", (Object)"")));
        for (Pair c : cases) {
            Path p = new Path((String)c.first);
            Assert.assertEquals((Object)c.second, (Object)FileSystemUtil.volumeBucketPair((Path)p));
        }
    }

    private boolean testIsInIgnoredDirectory(Path input) {
        return this.testIsInIgnoredDirectory(input, true);
    }

    private boolean testIsInIgnoredDirectory(Path input, boolean isDir) {
        FileStatus mockFileStatus = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)mockFileStatus.getPath()).thenReturn((Object)input);
        Mockito.when((Object)mockFileStatus.isDirectory()).thenReturn((Object)isDir);
        return FileSystemUtil.isInIgnoredDirectory((Path)TEST_TABLE_PATH, (FileStatus)mockFileStatus);
    }

    private String mockLocation(String scheme) throws IOException {
        switch (scheme) {
            case "abfs": {
                return "abfs://dummy-fs@dummy-account.dfs.core.windows.net/dummy-part-1";
            }
            case "abfss": {
                return "abfss://dummy-fs@dummy-account.dfs.core.windows.net/dummy-part-2";
            }
            case "adl": {
                return "adl://dummy-account.azuredatalakestore.net/dummy-part-3";
            }
            case "file": {
                return "file:///tmp/dummy-part-4";
            }
            case "hdfs": {
                return "hdfs://localhost:20500/dummy-part-5";
            }
            case "s3a": {
                return "s3a://dummy-bucket/dummy-part-6";
            }
            case "o3fs": {
                return "o3fs://bucket.volume/key";
            }
            case "ofs": {
                return "ofs://svc1:9876/volume1/bucket2/dir3/";
            }
            case "alluxio": {
                return "alluxio://zk@zk-1:2181,zk-2:2181,zk-3:2181/path/";
            }
        }
        throw new IOException("FileSystem scheme is not supported!");
    }

    private void testFsType(String location, FileSystemUtil.FsType expected) {
        Path path = new Path(location);
        FileSystemUtil.FsType type = FileSystemUtil.FsType.getFsType((String)path.toUri().getScheme());
        Assert.assertEquals((Object)type, (Object)expected);
    }

    private void testIsSupportStorageIds(String location, boolean expected) throws IOException {
        Path path = new Path(location);
        FileSystem fs = FileSystemUtil.getFileSystemForPath((Path)path);
        Assert.assertEquals((Object)FileSystemUtil.supportsStorageIds((FileSystem)fs), (Object)expected);
    }

    private void testIsWritableByImpala(String location, boolean expected) throws IOException {
        Assert.assertEquals((Object)FileSystemUtil.isImpalaWritableFilesystem((String)location), (Object)expected);
    }

    private void testIsSupportedDefaultFs(String location, boolean expected) throws IOException {
        Path path = new Path(location);
        FileSystem fs = FileSystemUtil.getFileSystemForPath((Path)path);
        Assert.assertEquals((Object)FileSystemUtil.isValidDefaultFileSystem((FileSystem)fs), (Object)expected);
    }

    private void testValidLoadDataInpath(String location, boolean expected) throws IOException {
        Path path = new Path(location);
        FileSystem fs = FileSystemUtil.getFileSystemForPath((Path)path);
        Assert.assertEquals((Object)FileSystemUtil.isValidLoadDataInpath((FileSystem)fs), (Object)expected);
    }
}

