/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import org.apache.impala.common.FrontendFixture;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;

public class AnalysisSessionFixture {
    private final FrontendFixture feFixture_ = FrontendFixture.instance();
    private final TQueryOptions queryOptions_;
    private String db_ = "default";
    private String user_ = System.getProperty("user.name");

    public AnalysisSessionFixture() {
        this.queryOptions_ = new TQueryOptions();
    }

    public AnalysisSessionFixture setDB(String db) {
        this.db_ = db;
        return this;
    }

    public AnalysisSessionFixture setUser(String user) {
        this.user_ = user;
        return this;
    }

    public TQueryOptions options() {
        return this.queryOptions_;
    }

    public String db() {
        return this.db_;
    }

    public String user() {
        return this.user_;
    }

    public Frontend frontend() {
        return this.feFixture_.frontend();
    }

    public ImpaladTestCatalog catalog() {
        return this.feFixture_.catalog();
    }

    public AnalysisSessionFixture disableExprRewrite() {
        this.queryOptions_.setEnable_expr_rewrites(false);
        return this;
    }

    public TQueryOptions cloneOptions() {
        return new TQueryOptions(this.queryOptions_);
    }

    public TQueryCtx queryContext() {
        return TestUtils.createQueryContext(this.db_, this.user_, this.cloneOptions());
    }
}

