/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.monitor.CatalogTableMetrics;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.junit.Assert;
import org.junit.Test;

public class CatalogTableMetricsTest {
    private final CatalogServiceTestCatalog catalog_ = CatalogServiceTestCatalog.create();

    @Test
    public void testAddRemoveInverse() throws DatabaseNotFoundException {
        CatalogTableMetrics.INSTANCE.removeAllTables();
        Table table = this.catalog_.getTable("functional", "alltypes");
        this.assertAddRemoveInverse(table, arg_0 -> ((CatalogTableMetrics)CatalogTableMetrics.INSTANCE).updateFrequentlyAccessedTables(arg_0), () -> CatalogTableMetrics.INSTANCE.getFrequentlyAccessedTables().size());
        this.assertAddRemoveInverse(table, arg_0 -> ((CatalogTableMetrics)CatalogTableMetrics.INSTANCE).updateLargestTables(arg_0), () -> CatalogTableMetrics.INSTANCE.getLargestTables().size());
        this.assertAddRemoveInverse(table, arg_0 -> ((CatalogTableMetrics)CatalogTableMetrics.INSTANCE).updateHighFileCountTables(arg_0), () -> CatalogTableMetrics.INSTANCE.getHighFileCountTables().size());
        this.assertAddRemoveInverse(table, arg_0 -> ((CatalogTableMetrics)CatalogTableMetrics.INSTANCE).updateLongMetadataLoadingTables(arg_0), () -> CatalogTableMetrics.INSTANCE.getLongMetadataLoadingTables().size());
    }

    private void assertAddRemoveInverse(Table table, Consumer<Table> metricUpdater, Supplier<Integer> tableCounter) {
        Assert.assertEquals((long)0L, (long)tableCounter.get().intValue());
        metricUpdater.accept(table);
        Assert.assertEquals((long)1L, (long)tableCounter.get().intValue());
        CatalogTableMetrics.INSTANCE.removeTable(table);
        Assert.assertEquals((long)0L, (long)tableCounter.get().intValue());
    }
}

