/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.List;
import org.apache.impala.catalog.monitor.CatalogResetMetadataCounter;
import org.apache.impala.thrift.TOperationUsageCounter;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TTableName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatalogResetMetadataCounterTest {
    private CatalogResetMetadataCounter catalogResetMetadataCounter;
    private final String TEST_DB_NAME = "TEST";
    private final String TEST_TABLE_NAME = "TABLE";

    @Before
    public void setUp() {
        this.catalogResetMetadataCounter = new CatalogResetMetadataCounter();
    }

    @Test
    public void testIncrementOperationIncrementsRefreshCounter() {
        TResetMetadataRequest testTResetMetadataRequest = this.createTestTResetMetadataRequest("TEST", "TABLE", true);
        this.catalogResetMetadataCounter.incrementOperation(testTResetMetadataRequest);
        List operationUsage = this.catalogResetMetadataCounter.getOperationUsage();
        Assert.assertEquals((Object)CatalogResetMetadataCounter.ResetMetadataType.REFRESH.name(), (Object)((TOperationUsageCounter)operationUsage.get((int)0)).catalog_op_name);
        Assert.assertEquals((long)1L, (long)((TOperationUsageCounter)operationUsage.get((int)0)).op_counter);
        Assert.assertEquals((Object)"TEST.TABLE", (Object)((TOperationUsageCounter)operationUsage.get((int)0)).table_name);
    }

    @Test
    public void testIncrementOperationIncrementsInvalidateCounter() {
        TResetMetadataRequest testTResetMetadataRequest = this.createTestTResetMetadataRequest("TEST", "TABLE", false);
        this.catalogResetMetadataCounter.incrementOperation(testTResetMetadataRequest);
        List operationUsage = this.catalogResetMetadataCounter.getOperationUsage();
        Assert.assertEquals((Object)CatalogResetMetadataCounter.ResetMetadataType.INVALIDATE_METADATA.name(), (Object)((TOperationUsageCounter)operationUsage.get((int)0)).catalog_op_name);
        Assert.assertEquals((long)1L, (long)((TOperationUsageCounter)operationUsage.get((int)0)).op_counter);
        Assert.assertEquals((Object)"TEST.TABLE", (Object)((TOperationUsageCounter)operationUsage.get((int)0)).table_name);
    }

    @Test
    public void testIncrementOperationIncrementsGlobalInvalidateCounter() {
        TResetMetadataRequest testTResetMetadataRequest = this.createTestTResetMetadataRequest(null, null, false);
        this.catalogResetMetadataCounter.incrementOperation(testTResetMetadataRequest);
        List operationUsage = this.catalogResetMetadataCounter.getOperationUsage();
        Assert.assertEquals((Object)CatalogResetMetadataCounter.ResetMetadataType.INVALIDATE_METADATA_GLOBAL.name(), (Object)((TOperationUsageCounter)operationUsage.get((int)0)).catalog_op_name);
        Assert.assertEquals((long)1L, (long)((TOperationUsageCounter)operationUsage.get((int)0)).op_counter);
        Assert.assertEquals((Object)"Not available", (Object)((TOperationUsageCounter)operationUsage.get((int)0)).table_name);
    }

    @Test
    public void testDecrementOperationDecrementsCounter() {
        TResetMetadataRequest testTResetMetadataRequest = this.createTestTResetMetadataRequest("TEST", "TABLE", true);
        this.catalogResetMetadataCounter.incrementOperation(testTResetMetadataRequest);
        this.catalogResetMetadataCounter.decrementOperation(testTResetMetadataRequest);
        List operationUsage = this.catalogResetMetadataCounter.getOperationUsage();
        Assert.assertEquals((long)0L, (long)operationUsage.size());
    }

    @Test
    public void testGetOperationUsageReturnsMultipleDMLs() {
        TResetMetadataRequest testTResetMetadataRequest1 = this.createTestTResetMetadataRequest("TEST", "TABLE", true);
        TResetMetadataRequest testTResetMetadataRequest2 = this.createTestTResetMetadataRequest("TEST", "TABLE", false);
        this.catalogResetMetadataCounter.incrementOperation(testTResetMetadataRequest1);
        this.catalogResetMetadataCounter.incrementOperation(testTResetMetadataRequest2);
        List operationUsage = this.catalogResetMetadataCounter.getOperationUsage();
        Assert.assertEquals((long)2L, (long)operationUsage.size());
    }

    private TResetMetadataRequest createTestTResetMetadataRequest(String dbName, String tableName, boolean isRefresh) {
        TResetMetadataRequest tResetMetadataRequest = new TResetMetadataRequest();
        if (dbName != null && tableName != null) {
            tResetMetadataRequest.setTable_name(new TTableName(dbName, tableName));
        } else {
            tResetMetadataRequest.setTable_name(null);
        }
        tResetMetadataRequest.setIs_refresh(isRefresh);
        return tResetMetadataRequest;
    }
}

