/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.local.CatalogdMetaProvider;
import org.apache.impala.catalog.local.InconsistentMetadataFetchException;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.testutil.HiveJdbcClientPool;
import org.apache.impala.testutil.ImpalaJdbcClient;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCounter;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TRuntimeProfileNode;
import org.apache.impala.thrift.TTable;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.TByteBuffer;
import org.apache.thrift.TConfiguration;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogdMetaProviderTest {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogdMetaProviderTest.class);
    private static final ListMap<TNetworkAddress> HOST_INDEX = new ListMap();
    private final CatalogdMetaProvider provider_;
    private final MetaProvider.TableMetaRef tableRef_;
    private CacheStats prevStats_;
    @Rule
    public TestName name = new TestName();
    private static HiveJdbcClientPool hiveJdbcClientPool_;
    private static final String testDbName_ = "catalogd_meta_provider_test";
    private static final String testTblName_ = "insert_only";
    private static final String testPartitionedTblName_ = "insert_only_partitioned";
    private static final String testFullAcidTblName_ = "full_acid";

    public CatalogdMetaProviderTest() throws Exception {
        TBackendGflags flags = new TBackendGflags();
        flags.setLocal_catalog_cache_expiration_s(3600);
        flags.setLocal_catalog_cache_mb(100);
        this.provider_ = new CatalogdMetaProvider(flags);
        Pair tablePair = this.provider_.loadTable("functional", "alltypes");
        this.tableRef_ = (MetaProvider.TableMetaRef)tablePair.second;
        this.prevStats_ = this.provider_.getCacheStats();
        hiveJdbcClientPool_ = HiveJdbcClientPool.create(1);
    }

    private CacheStats diffStats() {
        CacheStats s = this.provider_.getCacheStats();
        CacheStats diff = s.minus(this.prevStats_);
        this.prevStats_ = s;
        LOG.info("Stats: {}", (Object)diff);
        return diff;
    }

    private void createTestTbls() throws Exception {
        LOG.info("Creating test tables for {}", (Object)this.name.getMethodName());
        Stopwatch st = Stopwatch.createStarted();
        ImpalaJdbcClient client = ImpalaJdbcClient.createClientUsingHiveJdbcDriver();
        client.connect();
        try {
            client.execStatement("drop database if exists catalogd_meta_provider_test cascade");
            client.execStatement("create database catalogd_meta_provider_test");
            client.execStatement("create table " + CatalogdMetaProviderTest.getTestTblName() + " like functional.insert_only_transactional_table stored as parquet");
            client.execStatement("create table " + CatalogdMetaProviderTest.getTestPartitionedTblName() + " (c1 int) partitioned by (part int) stored as parquet tblproperties ('transactional'='true', 'transactional_properties'='insert_only')");
            client.execStatement("create table " + CatalogdMetaProviderTest.getTestFullAcidTblName() + " (c1 int) partitioned by (part int) stored as orc tblproperties ('transactional'='true')");
        }
        finally {
            LOG.info("Time taken for createTestTbls {} msec", (Object)st.stop().elapsed(TimeUnit.MILLISECONDS));
            client.close();
        }
    }

    private void dropTestTbls() throws Exception {
        try (HiveJdbcClientPool.HiveJdbcClient hiveClient = hiveJdbcClientPool_.getClient();){
            hiveClient.executeSql("drop database if exists catalogd_meta_provider_test cascade");
        }
    }

    private static String getTestTblName() {
        return "catalogd_meta_provider_test.insert_only";
    }

    private static String getTestPartitionedTblName() {
        return "catalogd_meta_provider_test.insert_only_partitioned";
    }

    private static String getTestFullAcidTblName() {
        return "catalogd_meta_provider_test.full_acid";
    }

    private void executeHiveSql(String query) throws Exception {
        try (HiveJdbcClientPool.HiveJdbcClient hiveClient = hiveJdbcClientPool_.getClient();){
            hiveClient.executeSql(query);
        }
    }

    @Test
    public void testCachePartitionList() throws Exception {
        List partList = this.provider_.loadPartitionList(this.tableRef_);
        CacheStats stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.requestCount());
        Assert.assertEquals((long)1L, (long)stats.loadCount());
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        List partListHit = this.provider_.loadPartitionList(this.tableRef_);
        stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.requestCount());
        Assert.assertEquals((long)1L, (long)stats.hitCount());
        Assert.assertEquals((Object)partList, (Object)partListHit);
    }

    @Test
    public void testCachePartitionsByRef() throws Exception {
        List allRefs = this.provider_.loadPartitionList(this.tableRef_);
        List<MetaProvider.PartitionRef> partialRefs = allRefs.subList(3, 8);
        CacheStats stats = this.diffStats();
        Map<String, MetaProvider.PartitionMetadata> partMap = this.loadPartitions(this.tableRef_, partialRefs);
        Assert.assertEquals((long)partialRefs.size(), (long)partMap.size());
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Map<String, MetaProvider.PartitionMetadata> partMapHit = this.loadPartitions(this.tableRef_, partialRefs);
        stats = this.diffStats();
        Assert.assertEquals((long)stats.hitCount(), (long)partMapHit.size());
        Map<String, MetaProvider.PartitionMetadata> allParts = this.loadPartitions(this.tableRef_, allRefs);
        Assert.assertEquals((long)allRefs.size(), (long)allParts.size());
        stats = this.diffStats();
        Assert.assertEquals((long)stats.hitCount(), (long)partMapHit.size());
    }

    private Map<String, MetaProvider.PartitionMetadata> loadPartitions(MetaProvider.TableMetaRef tableMetaRef, List<MetaProvider.PartitionRef> partRefs) throws Exception {
        return this.provider_.loadPartitionsByRefs(tableMetaRef, null, HOST_INDEX, partRefs);
    }

    private Map<String, MetaProvider.PartitionMetadata> loadPartitions(String dbName, String tableName) throws Exception {
        Frontend.RetryTracker retryTracker = new Frontend.RetryTracker(String.format("load partitions for table %s.%s", dbName, tableName));
        while (true) {
            try {
                Pair tablePair = this.provider_.loadTable(dbName, tableName);
                List allRefs = this.provider_.loadPartitionList((MetaProvider.TableMetaRef)tablePair.second);
                return this.loadPartitions((MetaProvider.TableMetaRef)tablePair.second, allRefs);
            }
            catch (InconsistentMetadataFetchException e) {
                this.diffStats();
                retryTracker.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    @Test
    public void testCacheColumnStats() throws Exception {
        ImmutableList colNames = ImmutableList.of((Object)"month", (Object)"id");
        List colStats = this.provider_.loadTableColumnStatistics(this.tableRef_, (List)colNames);
        Assert.assertEquals((long)1L, (long)colStats.size());
        CacheStats stats = this.diffStats();
        Assert.assertEquals((long)2L, (long)stats.requestCount());
        Assert.assertEquals((long)2L, (long)stats.missCount());
        List colStats2 = this.provider_.loadTableColumnStatistics(this.tableRef_, (List)colNames);
        Assert.assertEquals((Object)colStats, (Object)colStats2);
        stats = this.diffStats();
        Assert.assertEquals((long)2L, (long)stats.requestCount());
        Assert.assertEquals((long)2L, (long)stats.hitCount());
        Assert.assertEquals((long)0L, (long)stats.missCount());
    }

    @Test
    public void testWeights() throws Exception {
        List refs = this.provider_.loadPartitionList(this.tableRef_);
        ListMap hostIndex = new ListMap();
        this.provider_.loadPartitionsByRefs(this.tableRef_, null, hostIndex, refs);
        CatalogdMetaProvider.SizeOfWeigher weigher = new CatalogdMetaProvider.SizeOfWeigher();
        int weigh = weigher.weigh((Object)refs, null);
        Assert.assertTrue((String)("Actual weigh: " + weigh), (weigh > 4000 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Actual weigh: " + weigh), (weigh < 5000 ? 1 : 0) != 0);
        weigher = new CatalogdMetaProvider.SizeOfWeigher(false, null);
        weigh = weigher.weigh((Object)refs, null);
        Assert.assertTrue((String)("Actual weigh: " + weigh), (weigh > 4000 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Actual weigh: " + weigh), (weigh < 5000 ? 1 : 0) != 0);
    }

    @Test
    public void testCacheAndEvictDatabase() throws Exception {
        Database db = this.provider_.loadDb("functional");
        CacheStats stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.missCount());
        ImmutableCollection tableList = this.provider_.loadTableList("functional");
        stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.missCount());
        Database dbHit = this.provider_.loadDb("functional");
        Assert.assertEquals((Object)db, (Object)dbHit);
        ImmutableCollection tableListHit = this.provider_.loadTableList("functional");
        Assert.assertEquals((Object)tableList, (Object)tableListHit);
        stats = this.diffStats();
        Assert.assertEquals((long)2L, (long)stats.hitCount());
        Assert.assertEquals((long)0L, (long)stats.missCount());
        TCatalogObject obj = new TCatalogObject(TCatalogObjectType.DATABASE, 0L);
        obj.setDb(new TDatabase("functional"));
        this.provider_.invalidateCacheForObject(obj);
        Database dbMiss = this.provider_.loadDb("functional");
        Assert.assertEquals((Object)db, (Object)dbMiss);
        ImmutableCollection tableListMiss = this.provider_.loadTableList("functional");
        Assert.assertEquals((Object)tableList, (Object)tableListMiss);
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Assert.assertEquals((long)2L, (long)stats.missCount());
    }

    @Test
    public void testCacheAndEvictTable() throws Exception {
        this.provider_.loadTable("functional", "alltypes");
        CacheStats stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.hitCount());
        Assert.assertEquals((long)1L, (long)stats.missCount());
        this.provider_.loadTableList("functional");
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Assert.assertEquals((long)1L, (long)stats.missCount());
        this.provider_.loadTable("functional", "alltypes");
        stats = this.diffStats();
        Assert.assertEquals((long)2L, (long)stats.hitCount());
        Assert.assertEquals((long)0L, (long)stats.missCount());
        TCatalogObject obj = new TCatalogObject(TCatalogObjectType.TABLE, 0L);
        obj.setTable(new TTable("functional", "alltypes"));
        this.provider_.invalidateCacheForObject(obj);
        this.provider_.loadTable("functional", "alltypes");
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Assert.assertEquals((long)2L, (long)stats.missCount());
    }

    @Test
    public void testProfile() throws Exception {
        FrontendProfile profile;
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            this.provider_.loadTable("functional", "alltypes");
            List allRefs = this.provider_.loadPartitionList(this.tableRef_);
            this.loadPartitions(this.tableRef_, allRefs);
            profile = FrontendProfile.getCurrent();
        }
        TRuntimeProfileNode prof = profile.emitAsThrift();
        ImmutableMap counters = Maps.uniqueIndex((Iterable)prof.counters, TCounter::getName);
        Assert.assertEquals((String)prof.counters.toString(), (long)16L, (long)counters.size());
        Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.Tables.Hits")).getValue());
        Assert.assertEquals((long)0L, (long)((TCounter)counters.get("CatalogFetch.Tables.Misses")).getValue());
        Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.Tables.Requests")).getValue());
        Assert.assertTrue((boolean)counters.containsKey("CatalogFetch.Tables.Time"));
        Assert.assertEquals((long)0L, (long)((TCounter)counters.get("CatalogFetch.PartitionLists.Hits")).getValue());
        Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.PartitionLists.Misses")).getValue());
        Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.PartitionLists.Requests")).getValue());
        Assert.assertTrue((boolean)counters.containsKey("CatalogFetch.PartitionLists.Time"));
        Assert.assertEquals((long)0L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Hits")).getValue());
        Assert.assertEquals((long)24L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Misses")).getValue());
        Assert.assertEquals((long)24L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Requests")).getValue());
        Assert.assertTrue((boolean)counters.containsKey("CatalogFetch.Partitions.Time"));
        Assert.assertTrue((boolean)counters.containsKey("CatalogFetch.RPCs.Bytes"));
        Assert.assertTrue((boolean)counters.containsKey("CatalogFetch.RPCs.Time"));
        Assert.assertEquals((long)2L, (long)((TCounter)counters.get("CatalogFetch.RPCs.Requests")).getValue());
        Assert.assertTrue((boolean)counters.containsKey("CatalogFetch.StorageLoad.Time"));
    }

    @Test
    public void testPiggybackSuccess() throws Exception {
        Assume.assumeTrue((String)"Skipping this test because it is flaky with Hive3", (TestUtils.getHiveMajorVersion() == 2 ? 1 : 0) != 0);
        this.doTestPiggyback(true);
    }

    @Test
    public void testPiggybackFailure() throws Exception {
        Assume.assumeTrue((String)"Skipping this test because it is flaky with Hive3", (TestUtils.getHiveMajorVersion() == 2 ? 1 : 0) != 0);
        this.doTestPiggyback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestPiggyback(boolean testSuccessCase) throws Exception {
        String tableName = testSuccessCase ? "alltypes" : "table-does-not-exist";
        AtomicInteger counterToWatch = testSuccessCase ? this.provider_.piggybackSuccessCountForTests : this.provider_.piggybackExceptionCountForTests;
        int kNumThreads = 8;
        ExecutorService exec = Executors.newFixedThreadPool(8);
        try {
            Stopwatch sw = Stopwatch.createStarted();
            while (sw.elapsed(TimeUnit.SECONDS) < 60L) {
                ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
                for (int i = 0; i < 8; ++i) {
                    futures.add(exec.submit(() -> this.provider_.loadTable("functional", tableName)));
                }
                for (Future future : futures) {
                    try {
                        Assert.assertNotNull(future.get());
                        if (testSuccessCase) continue;
                        Assert.fail((String)"Did not get expected exception");
                    }
                    catch (Exception e) {
                        if (!testSuccessCase) continue;
                        throw e;
                    }
                }
                if (counterToWatch.get() > 20) {
                    return;
                }
                TCatalogObject obj = new TCatalogObject(TCatalogObjectType.TABLE, 0L);
                obj.setTable(new TTable("functional", tableName));
                this.provider_.invalidateCacheForObject(obj);
            }
            Assert.fail((String)"Did not see enough piggybacked loads!");
        }
        finally {
            exec.shutdown();
            Assert.assertTrue((boolean)exec.awaitTermination(60L, TimeUnit.SECONDS));
        }
        this.diffStats();
        try {
            this.provider_.loadTable("functonal", tableName);
        }
        catch (Exception sw) {
            // empty catch block
        }
        CacheStats stats = this.diffStats();
        if (testSuccessCase) {
            Assert.assertEquals((long)1L, (long)stats.hitCount());
            Assert.assertEquals((long)0L, (long)stats.missCount());
        } else {
            Assert.assertEquals((long)0L, (long)stats.hitCount());
            Assert.assertEquals((long)1L, (long)stats.missCount());
        }
    }

    @Test
    public void testInvalidateObjectsCaseInsensitive() throws Exception {
        this.provider_.loadDb("tpch");
        this.provider_.loadTable("tpch", "nation");
        this.testInvalidateDb("TPCH");
        this.testInvalidateTable("TPCH", "nation");
        this.testInvalidateTable("tpch", "NATION");
    }

    private void testInvalidateTable(String dbName, String tblName) throws Exception {
        CacheStats stats = this.diffStats();
        this.provider_.loadTable(dbName, tblName);
        stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.hitCount());
        Assert.assertEquals((long)1L, (long)stats.missCount());
        TCatalogObject obj = new TCatalogObject(TCatalogObjectType.TABLE, 0L);
        obj.setTable(new TTable(dbName, tblName));
        this.provider_.invalidateCacheForObject(obj);
        this.provider_.loadTable(dbName, tblName);
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Assert.assertEquals((long)2L, (long)stats.missCount());
    }

    private void testInvalidateDb(String dbName) throws Exception {
        CacheStats stats = this.diffStats();
        this.provider_.loadDb(dbName);
        stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.hitCount());
        Assert.assertEquals((long)0L, (long)stats.missCount());
        TCatalogObject obj = new TCatalogObject(TCatalogObjectType.DATABASE, 0L);
        obj.setDb(new TDatabase(dbName));
        this.provider_.invalidateCacheForObject(obj);
        this.provider_.loadDb(dbName);
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Assert.assertEquals((long)1L, (long)stats.missCount());
    }

    @Test
    public void testFullAcidFileMetadataAfterMajorCompaction() throws Exception {
        boolean origFlag = BackendConfig.INSTANCE.isAutoCheckCompaction();
        try {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(true);
            this.createTestTbls();
            String partition = "partition (part=1)";
            this.testFileMetadataAfterCompaction(testDbName_, testFullAcidTblName_, partition, true);
        }
        finally {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(origFlag);
            this.dropTestTbls();
        }
    }

    @Test
    public void testFullAcidFileMetadataAfterMinorCompaction() throws Exception {
        boolean origFlag = BackendConfig.INSTANCE.isAutoCheckCompaction();
        try {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(true);
            this.createTestTbls();
            String partition = "partition (part=1)";
            this.testFileMetadataAfterCompaction(testDbName_, testFullAcidTblName_, partition, false);
        }
        finally {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(origFlag);
            this.dropTestTbls();
        }
    }

    @Test
    public void testTableFileMetadataAfterMajorCompaction() throws Exception {
        boolean origFlag = BackendConfig.INSTANCE.isAutoCheckCompaction();
        try {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(true);
            this.createTestTbls();
            this.testFileMetadataAfterCompaction(testDbName_, testTblName_, "", true);
        }
        finally {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(origFlag);
            this.dropTestTbls();
        }
    }

    @Test
    public void testTableFileMetadataAfterMinorCompaction() throws Exception {
        boolean origFlag = BackendConfig.INSTANCE.isAutoCheckCompaction();
        try {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(true);
            this.createTestTbls();
            this.testFileMetadataAfterCompaction(testDbName_, testTblName_, "", false);
        }
        finally {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(origFlag);
            this.dropTestTbls();
        }
    }

    @Test
    public void testPartitionFileMetadataAfterMajorCompaction() throws Exception {
        boolean origFlag = BackendConfig.INSTANCE.isAutoCheckCompaction();
        try {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(true);
            this.createTestTbls();
            String partition = "partition (part=1)";
            this.testFileMetadataAfterCompaction(testDbName_, testPartitionedTblName_, partition, true);
        }
        finally {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(origFlag);
            this.dropTestTbls();
        }
    }

    @Test
    public void testPartitionFileMetadataAfterMinorCompaction() throws Exception {
        boolean origFlag = BackendConfig.INSTANCE.isAutoCheckCompaction();
        try {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(true);
            this.createTestTbls();
            String partition = "partition (part=1)";
            this.testFileMetadataAfterCompaction(testDbName_, testPartitionedTblName_, partition, false);
        }
        finally {
            BackendConfig.INSTANCE.getBackendCfg().setAuto_check_compaction(origFlag);
            this.dropTestTbls();
        }
    }

    @Test
    public void testLoadNullPartitionKeyValue() throws Exception {
        this.provider_.cache_.invalidateAll();
        CacheStats stats = this.diffStats();
        String nullPartitionName = this.provider_.loadNullPartitionKeyValue();
        Assert.assertNotNull((Object)nullPartitionName);
        stats = this.diffStats();
        Assert.assertEquals((long)1L, (long)stats.missCount());
        Assert.assertEquals((long)0L, (long)stats.hitCount());
        Assert.assertEquals((Object)nullPartitionName, (Object)this.provider_.loadNullPartitionKeyValue());
        stats = this.diffStats();
        Assert.assertEquals((long)0L, (long)stats.missCount());
        Assert.assertEquals((long)1L, (long)stats.hitCount());
    }

    private void testFileMetadataAfterCompaction(String dbName, String tableName, String partition, boolean isMajorCompaction) throws Exception {
        Map<String, MetaProvider.PartitionMetadata> partMap;
        String tableOrPartition = dbName + "." + tableName + " " + partition;
        this.executeHiveSql("insert into " + tableOrPartition + " values (1)");
        this.executeHiveSql("insert into " + tableOrPartition + " values (2)");
        this.loadPartitions(dbName, tableName);
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            partMap = this.loadPartitions(dbName, tableName);
            FrontendProfile profile = FrontendProfile.getCurrent();
            TRuntimeProfileNode prof = profile.emitAsThrift();
            ImmutableMap counters = Maps.uniqueIndex((Iterable)prof.counters, TCounter::getName);
            Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Requests")).getValue());
            Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Hits")).getValue());
            int preFileCount = partMap.values().stream().map(MetaProvider.PartitionMetadata::getFileDescriptors).mapToInt(List::size).sum();
            Assert.assertEquals((long)2L, (long)preFileCount);
        }
        String compactionType = isMajorCompaction ? "'major'" : "'minor'";
        this.executeHiveSql("alter table " + tableOrPartition + " compact " + compactionType + " and wait");
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            partMap = this.loadPartitions(dbName, tableName);
            FrontendProfile profile = FrontendProfile.getCurrent();
            TRuntimeProfileNode prof = profile.emitAsThrift();
            ImmutableMap counters = Maps.uniqueIndex((Iterable)prof.counters, TCounter::getName);
            Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Requests")).getValue());
            Assert.assertEquals((long)1L, (long)((TCounter)counters.get("CatalogFetch.Partitions.Misses")).getValue());
            List paths = partMap.values().stream().map(MetaProvider.PartitionMetadata::getFileDescriptors).flatMap(Collection::stream).map(HdfsPartition.FileDescriptor::getPath).collect(Collectors.toList());
            Assert.assertEquals((String)("Actual paths: " + paths), (long)1L, (long)paths.size());
        }
    }

    public void testLargeTConfiguration() throws Exception {
        int maxSize = BackendConfig.INSTANCE.getThriftRpcMaxMessageSize();
        Assert.assertEquals((long)0x40000000L, (long)maxSize);
        int bufferSize = 105381888;
        TConfiguration configLarge = new TConfiguration(maxSize, 0xFA0000, 64);
        TByteBuffer validTByteBuffer = new TByteBuffer(configLarge, ByteBuffer.allocate(bufferSize));
        validTByteBuffer.close();
    }

    static {
        FeSupport.loadLibrary();
    }
}

