/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.common.Metrics;
import org.apache.impala.service.CatalogOpExecutor;
import org.junit.Assert;

public class SynchronousHMSEventProcessorForTests
extends MetastoreEventsProcessor {
    public SynchronousHMSEventProcessorForTests(CatalogOpExecutor catalogOpExecutor, long startSyncFromId, long pollingFrequencyInSec) throws CatalogException {
        super(catalogOpExecutor, startSyncFromId, pollingFrequencyInSec);
    }

    public Metrics getMetrics() {
        return super.getMetrics();
    }

    public void startScheduler() {
    }

    public void processEvents() {
        super.processEvents();
        super.updateLatestEventId();
        this.verifyEventSyncedMetrics();
    }

    private void verifyEventSyncedMetrics() {
        Metrics metrics = this.getMetrics();
        long lastSyncedEventId = (Long)metrics.getGauge("last-synced-event-id").getValue();
        long latestEventId = (Long)metrics.getGauge("latest-event-id").getValue();
        long lastSyncedEventTime = (Long)metrics.getGauge("last-synced-event-time").getValue();
        long latestEventTime = (Long)metrics.getGauge("latest-event-time").getValue();
        if (lastSyncedEventId == latestEventId) {
            Assert.assertEquals((String)("Incorrect last synced event time for event " + latestEventId), (long)latestEventTime, (long)lastSyncedEventTime);
        }
    }
}

