/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.io.IOUtils;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileMetadataLoadOpts;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.MetastoreApiTestUtils;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableWriteId;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.events.ConfigValidator;
import org.apache.impala.catalog.events.ExternalEventsProcessor;
import org.apache.impala.catalog.events.MetastoreEventProcessorConfig;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.catalog.events.MetastoreNotificationFetchException;
import org.apache.impala.catalog.events.NoOpEventProcessor;
import org.apache.impala.catalog.events.SynchronousHMSEventProcessorForTests;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;
import org.apache.impala.common.TransactionException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hive.executor.HiveJavaFunctionFactory;
import org.apache.impala.hive.executor.TestHiveJavaFunctionFactory;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.FeSupport;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.HiveJdbcClientPool;
import org.apache.impala.testutil.IncompetentMetastoreClientPool;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TAlterDbParams;
import org.apache.impala.thrift.TAlterDbSetOwnerParams;
import org.apache.impala.thrift.TAlterDbType;
import org.apache.impala.thrift.TAlterTableAddColsParams;
import org.apache.impala.thrift.TAlterTableAddPartitionParams;
import org.apache.impala.thrift.TAlterTableDropColParams;
import org.apache.impala.thrift.TAlterTableDropPartitionParams;
import org.apache.impala.thrift.TAlterTableOrViewRenameParams;
import org.apache.impala.thrift.TAlterTableOrViewSetOwnerParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableReplaceColsParams;
import org.apache.impala.thrift.TAlterTableSetFileFormatParams;
import org.apache.impala.thrift.TAlterTableSetLocationParams;
import org.apache.impala.thrift.TAlterTableSetRowFormatParams;
import org.apache.impala.thrift.TAlterTableSetTblPropertiesParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TAlterTableUpdateStatsParams;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TCreateDbParams;
import org.apache.impala.thrift.TCreateFunctionParams;
import org.apache.impala.thrift.TCreateTableLikeParams;
import org.apache.impala.thrift.TCreateTableParams;
import org.apache.impala.thrift.TDdlExecRequest;
import org.apache.impala.thrift.TDdlQueryOptions;
import org.apache.impala.thrift.TDdlType;
import org.apache.impala.thrift.TDropDbParams;
import org.apache.impala.thrift.TDropFunctionParams;
import org.apache.impala.thrift.TDropTableOrViewParams;
import org.apache.impala.thrift.TEventProcessorMetrics;
import org.apache.impala.thrift.TEventProcessorMetricsSummaryResponse;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TOwnerType;
import org.apache.impala.thrift.TPartitionDef;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.thrift.TPrimitiveType;
import org.apache.impala.thrift.TScalarType;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTablePropertyType;
import org.apache.impala.thrift.TTableRowFormat;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;
import org.apache.impala.thrift.TUpdateCatalogRequest;
import org.apache.impala.thrift.TUpdatedPartition;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreEventsProcessorTest {
    private static final String TEST_DB_NAME = "events_test_db";
    private static CatalogServiceTestCatalog catalog_;
    private static CatalogOpExecutor catalogOpExecutor_;
    private static MetastoreEventsProcessor eventsProcessor_;
    private static final Logger LOG;
    private static final Configuration CONF;
    private AtomicLong eventIdGenerator = new AtomicLong(0L);

    @BeforeClass
    public static void setUpTestEnvironment() throws TException, ImpalaException {
        catalog_ = CatalogServiceTestCatalog.create();
        catalogOpExecutor_ = catalog_.getCatalogOpExecutor();
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            CurrentNotificationEventId currentNotificationId = metaStoreClient.getHiveClient().getCurrentNotificationEventId();
            eventsProcessor_ = new SynchronousHMSEventProcessorForTests(catalogOpExecutor_, currentNotificationId.getEventId(), 10L);
            eventsProcessor_.start();
        }
        catalog_.setMetastoreEventProcessor((ExternalEventsProcessor)eventsProcessor_);
    }

    @AfterClass
    public static void tearDownTestSetup() {
        try {
            MetastoreEventsProcessorTest.dropDatabaseCascadeFromHMS();
            catalog_.removeDb(TEST_DB_NAME);
        }
        catch (Exception exception) {
        }
        finally {
            if (eventsProcessor_ != null) {
                eventsProcessor_.shutdown();
            }
        }
    }

    private static void dropDatabaseCascadeFromHMS() throws TException {
        MetastoreEventsProcessorTest.dropDatabaseCascade(TEST_DB_NAME);
    }

    private static void dropDatabaseCascade(String dbName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().dropDatabase(dbName, true, true, true);
        }
    }

    private static void dropDatabaseCascade(String catName, String dbName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().dropDatabase(catName, dbName, true, true, true);
        }
    }

    @Before
    public void beforeTest() throws Exception {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().dropDatabase(TEST_DB_NAME, true, true, true);
        }
        catalog_.removeDb(TEST_DB_NAME);
        eventsProcessor_.pause();
        eventsProcessor_.start(eventsProcessor_.getCurrentEventId());
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    @After
    public void afterTest() {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    @Test
    public void testConfigValidation() throws CatalogException {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        eventsProcessor_.validateConfigs();
    }

    @Test
    public void testValidateConfig() throws TException {
        MetastoreEventsProcessor mockMetastoreEventsProcessor = (MetastoreEventsProcessor)Mockito.spy((Object)eventsProcessor_);
        for (MetastoreEventProcessorConfig config : MetastoreEventProcessorConfig.values()) {
            String configKey = config.getValidator().getConfigKey();
            Mockito.when((Object)mockMetastoreEventsProcessor.getConfigValueFromMetastore(configKey, "")).thenReturn((Object)"false");
            if (!config.equals((Object)MetastoreEventProcessorConfig.METASTORE_DEFAULT_CATALOG_NAME)) continue;
            Mockito.when((Object)mockMetastoreEventsProcessor.getConfigValueFromMetastore(configKey, "")).thenReturn((Object)"test_custom_catalog");
        }
        try {
            mockMetastoreEventsProcessor.validateConfigs();
        }
        catch (CatalogException e) {
            String errorMessage = "Found %d incorrect metastore configuration(s).";
            Assert.assertTrue((boolean)e.getMessage().contains(String.format(errorMessage, MetastoreEventsProcessor.getEventProcessorConfigsToValidate().size())));
        }
    }

    @Test
    public void testNextMetastoreEvents() throws Exception {
        long currentEventId = eventsProcessor_.getCurrentEventId();
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        this.createTableFromImpala(TEST_DB_NAME, "testNextMetastoreEvents1", false);
        this.createTable("testNextMetastoreEvents2", false);
        List events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)currentEventId, null, (int)2, (String[])new String[0]);
        Assert.assertEquals((long)3L, (long)events.size());
        events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)(currentEventId + 1L), null, (int)10, (String[])new String[0]);
        Assert.assertEquals((long)2L, (long)events.size());
        events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)currentEventId, null, (int)3, (String[])new String[0]);
        Assert.assertEquals((long)3L, (long)events.size());
        events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)(currentEventId + 3L), null, (int)3, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)events.size());
    }

    @Test
    public void testConfigValidationWithIncorrectValues() {
        HashMap<MetastoreEventProcessorConfig, String> incorrectValues = new HashMap<MetastoreEventProcessorConfig, String>();
        incorrectValues.put(MetastoreEventProcessorConfig.FIRE_EVENTS_FOR_DML, "false");
        incorrectValues.put(MetastoreEventProcessorConfig.METASTORE_DEFAULT_CATALOG_NAME, "custom");
        for (MetastoreEventProcessorConfig config : incorrectValues.keySet()) {
            this.testConfigValidation(config, (String)incorrectValues.get(config), false);
        }
        this.testConfigValidation(MetastoreEventProcessorConfig.FIRE_EVENTS_FOR_DML, "true", true);
        this.testConfigValidation(MetastoreEventProcessorConfig.FIRE_EVENTS_FOR_DML, "TRUE", true);
        this.testConfigValidation(MetastoreEventProcessorConfig.FIRE_EVENTS_FOR_DML, "tRue", true);
        this.testConfigValidation(MetastoreEventProcessorConfig.METASTORE_DEFAULT_CATALOG_NAME, "hIve", true);
    }

    private void testConfigValidation(MetastoreEventProcessorConfig config, String mockValue, boolean expectSuccess) {
        ConfigValidator.ValidationResult result = config.validate(mockValue);
        Assert.assertNotNull((Object)result);
        if (expectSuccess) {
            Assert.assertTrue((boolean)result.isValid());
        } else {
            Assert.assertFalse((boolean)result.isValid());
            Assert.assertNotNull((Object)result.getReason());
        }
    }

    @Test
    public void testCreateDatabaseEvent() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
    }

    @Test
    public void testIgnoreNonDefaultCatalogs() throws Exception {
        String catName = "custom_hive_catalog";
        try {
            this.dropHiveCatalogIfExists(catName);
            this.createHiveCatalog(catName);
            this.createDatabase(TEST_DB_NAME, null);
            String tblName = "test";
            this.createTable(tblName, false);
            eventsProcessor_.processEvents();
            this.createDatabase(catName, TEST_DB_NAME, null);
            this.createTable(catName, TEST_DB_NAME, tblName, null, false, null);
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
            Assert.assertNotNull((Object)catalog_.getTable(TEST_DB_NAME, tblName));
            MetastoreEventsProcessorTest.dropDatabaseCascade(catName, TEST_DB_NAME);
            MetastoreEventsProcessorTest.dropDatabaseCascade(catName, "default");
            this.dropHiveCatalogIfExists(catName);
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
            Assert.assertNotNull((Object)catalog_.getTable(TEST_DB_NAME, tblName));
        }
        finally {
            this.dropHiveCatalogIfExists(catName);
        }
    }

    @Test
    public void testDropEmptyDatabaseEvent() throws TException, ImpalaException {
        MetastoreEventsProcessorTest.dropDatabaseCascade("database_to_be_dropped");
        this.createDatabase("database_to_be_dropped", null);
        eventsProcessor_.processEvents();
        Assert.assertNotNull((Object)catalog_.getDb("database_to_be_dropped"));
        MetastoreEventsProcessorTest.dropDatabaseCascade("database_to_be_dropped");
        eventsProcessor_.processEvents();
        Assert.assertNull((String)"Database should not be found after processing drop_database event", (Object)catalog_.getDb("database_to_be_dropped"));
    }

    @Test
    public void testdropDatabaseEvent() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        String tblToBeDropped = "tbl_to_be_dropped";
        this.createTable(tblToBeDropped, true);
        this.createTable("tbl_to_be_dropped_unpartitioned", false);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>(2);
        partVals.add(Arrays.asList("1"));
        partVals.add(Arrays.asList("2"));
        this.addPartitions(TEST_DB_NAME, tblToBeDropped, partVals);
        eventsProcessor_.processEvents();
        this.loadTable(tblToBeDropped);
        MetastoreEventsProcessorTest.dropDatabaseCascadeFromHMS();
        eventsProcessor_.processEvents();
        Assert.assertTrue((String)"Dropped database should not be found after processing drop_database event", (catalog_.getDb(TEST_DB_NAME) == null ? 1 : 0) != 0);
        try {
            catalog_.getTable(TEST_DB_NAME, tblToBeDropped);
            Assert.fail();
        }
        catch (DatabaseNotFoundException databaseNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDropCreateDatabase() throws TException {
        this.createDatabase(TEST_DB_NAME, null);
        MetastoreEventsProcessorTest.dropDatabaseCascade(TEST_DB_NAME);
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
    }

    @Test
    public void testAlterDatabaseEvents() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        String testDbParamKey = "testKey";
        String testDbParamVal = "testVal";
        eventsProcessor_.processEvents();
        Db db = catalog_.getDb(TEST_DB_NAME);
        Assert.assertNotNull((Object)db);
        Assert.assertTrue((String)("Newly created test database should not have parameter with key" + testDbParamKey), (!db.getMetaStoreDb().isSetParameters() || !db.getMetaStoreDb().getParameters().containsKey(testDbParamKey) ? 1 : 0) != 0);
        this.addDatabaseParameters(testDbParamKey, testDbParamVal);
        eventsProcessor_.processEvents();
        String getParamValFromDb = (String)catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getParameters().get(testDbParamKey);
        Assert.assertTrue((String)("Altered database should have set the key " + testDbParamKey + " to value " + testDbParamVal + " in parameters, instead we get " + getParamValFromDb), (boolean)testDbParamVal.equals(getParamValFromDb));
        String currentLocation = catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getLocationUri();
        String newLocation = currentLocation + File.separatorChar + "newTestLocation";
        Database alteredDb = catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().deepCopy();
        alteredDb.setLocationUri(newLocation);
        this.alterDatabase(alteredDb);
        eventsProcessor_.processEvents();
        Assert.assertTrue((String)"Altered database should have the updated location", (boolean)newLocation.equals(catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getLocationUri()));
        String owner = catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getOwnerName();
        String newOwner = "newTestOwner";
        Assert.assertFalse((boolean)"newTestOwner".equals(owner));
        alteredDb = catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().deepCopy();
        alteredDb.setOwnerName("newTestOwner");
        this.alterDatabase(alteredDb);
        eventsProcessor_.processEvents();
        Assert.assertTrue((String)"Altered database should have the updated owner", (boolean)"newTestOwner".equals(catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getOwnerName()));
    }

    @Test
    public void testAlterDatabaseSetOwnerFromImpala() throws ImpalaException {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        Assert.assertNotNull((String)"Db should have been found after create database statement", (Object)catalog_.getDb(TEST_DB_NAME));
        eventsProcessor_.processEvents();
        Db db = catalog_.getDb(TEST_DB_NAME);
        long createEventId = db.getCreateEventId();
        long beforeLastSyncedEventId = db.getLastSyncedEventId();
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertEquals((long)createEventId, (long)beforeLastSyncedEventId);
        }
        long numberOfSelfEventsBefore = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        String owner = catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getOwnerName();
        String newOwnerUser = "newUserFromImpala";
        String newOwnerRole = "newRoleFromImpala";
        Assert.assertFalse((newOwnerUser.equals(owner) || newOwnerRole.equals(owner) ? 1 : 0) != 0);
        this.alterDbSetOwnerFromImpala(TEST_DB_NAME, newOwnerUser, TOwnerType.USER);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)newOwnerUser, (Object)catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getOwnerName());
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((catalog_.getDb(TEST_DB_NAME).getLastSyncedEventId() > beforeLastSyncedEventId ? 1 : 0) != 0);
        }
        beforeLastSyncedEventId = db.getLastSyncedEventId();
        this.alterDbSetOwnerFromImpala(TEST_DB_NAME, newOwnerRole, TOwnerType.ROLE);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)newOwnerRole, (Object)catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getOwnerName());
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((catalog_.getDb(TEST_DB_NAME).getLastSyncedEventId() > beforeLastSyncedEventId ? 1 : 0) != 0);
        }
        long selfEventsCountAfter = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        Assert.assertEquals((String)"Unexpected number of self-events generated", (long)(numberOfSelfEventsBefore + 2L), (long)selfEventsCountAfter);
    }

    @Test
    public void testEmptyAlterDatabaseEventsFromImpala() throws ImpalaException {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        Assert.assertNotNull((String)"Db should have been found after create database statement", (Object)catalog_.getDb(TEST_DB_NAME));
        eventsProcessor_.processEvents();
        long numberOfSelfEventsBefore = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        String fnName = "fn1";
        ScalarFunction fn1 = new ScalarFunction(new FunctionName(TEST_DB_NAME, fnName), (List)new ArrayList<Type>(){
            {
                this.add(Type.STRING);
            }
        }, (Type)Type.INT, false);
        fn1.setBinaryType(TFunctionBinaryType.JAVA);
        fn1.setLocation(new HdfsUri("hdfs://foo:bar/fn/fn1.jar"));
        fn1.setSymbolName("FnClass");
        this.createScalarFunctionFromImpala(fn1);
        this.dropScalarFunctionFromImapala(fn1);
        eventsProcessor_.processEvents();
        long numberOfSelfEventsAfter = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        Assert.assertEquals((String)"Unexpected number of self-events generated", (long)(numberOfSelfEventsBefore + 2L), (long)numberOfSelfEventsAfter);
        this.createScalarFunctionFromImpala(fn1);
        this.dropDatabaseCascadeFromImpala(TEST_DB_NAME);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    @Test
    public void testCreateTableEvent() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testCreateTableEvent";
        eventsProcessor_.processEvents();
        Assert.assertNull((String)"testCreateTableEvent is not expected to exist", (Object)catalog_.getTable(TEST_DB_NAME, "testCreateTableEvent"));
        this.createTable("testCreateTableEvent", false);
        eventsProcessor_.processEvents();
        Assert.assertNotNull((String)"Catalog should have a incomplete instance of table after CREATE_TABLE event is received", (Object)catalog_.getTable(TEST_DB_NAME, "testCreateTableEvent"));
        Assert.assertTrue((String)"Newly created table from events should be a IncompleteTable", (boolean)(catalog_.getTable(TEST_DB_NAME, "testCreateTableEvent") instanceof IncompleteTable));
        String testPartitionedTbl = "testCreateTableEventPartitioned";
        this.createTable("testCreateTableEventPartitioned", true);
        eventsProcessor_.processEvents();
        Assert.assertNotNull((String)"Catalog should have create a incomplete table after receiving CREATE_TABLE event", (Object)catalog_.getTable(TEST_DB_NAME, "testCreateTableEventPartitioned"));
        Assert.assertTrue((String)"Newly created table should be instance of IncompleteTable", (boolean)(catalog_.getTable(TEST_DB_NAME, "testCreateTableEventPartitioned") instanceof IncompleteTable));
        this.dropDatabaseCascadeFromImpala(TEST_DB_NAME);
        Assert.assertNull((String)"Database not expected to exist.", (Object)catalog_.getDb(TEST_DB_NAME));
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        this.createTable("createondroppeddb", false);
        this.dropDatabaseCascadeFromImpala(TEST_DB_NAME);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    @Test
    public void testPartitionEvents() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testPartitionEvents";
        this.createTable("testPartitionEvents", true);
        eventsProcessor_.processEvents();
        this.loadTable("testPartitionEvents");
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        partVals.add(Arrays.asList("1"));
        partVals.add(Arrays.asList("2"));
        partVals.add(Arrays.asList("3"));
        partVals.add(Arrays.asList("4"));
        this.addPartitions(TEST_DB_NAME, "testPartitionEvents", partVals);
        eventsProcessor_.processEvents();
        Assert.assertEquals((String)"Unexpected number of partitions fetched for the loaded table", (long)4L, (long)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testPartitionEvents")).getPartitions().size());
        partVals.clear();
        partVals.add(Arrays.asList("1"));
        partVals.add(Arrays.asList("2"));
        partVals.add(Arrays.asList("3"));
        this.dropPartitions("testPartitionEvents", partVals);
        eventsProcessor_.processEvents();
        Assert.assertEquals((String)"Unexpected number of partitions fetched for the loaded table", (long)1L, (long)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testPartitionEvents")).getPartitions().size());
        partVals.clear();
        partVals.add(Arrays.asList("4"));
        String newLocation = "/path/to/location/";
        this.alterPartitions("testPartitionEvents", partVals, newLocation);
        eventsProcessor_.processEvents();
        Collection parts = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testPartitionEvents")));
        FeFsPartition singlePartition = (FeFsPartition)Iterables.getOnlyElement((Iterable)parts);
        Assert.assertTrue((boolean)newLocation.equals(singlePartition.getLocation()));
        List<String> partitionValue = Arrays.asList("4");
        this.alterPartitionsTrivial("testPartitionEvents", partitionValue);
        eventsProcessor_.processEvents();
        Collection partsAfterTrivialAlter = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testPartitionEvents")));
        FeFsPartition singlePartitionAfterTrivialAlter = (FeFsPartition)Iterables.getOnlyElement((Iterable)partsAfterTrivialAlter);
        for (String parameter : MetastoreEvents.parametersToIgnore) {
            Assert.assertEquals((String)"Unexpected parameter value after trivial alter partition event", singlePartition.getParameters().get(parameter), singlePartitionAfterTrivialAlter.getParameters().get(parameter));
        }
    }

    @Test
    public void testInsertEvents() throws TException, ImpalaException, IOException {
        this.createDatabase(TEST_DB_NAME, null);
        String tableToInsertPart = "tbl_to_insert_part";
        this.createTable(TEST_DB_NAME, tableToInsertPart, true);
        this.testInsertEvents(TEST_DB_NAME, tableToInsertPart, true);
        String tableToInsertNoPart = "tbl_to_insert_no_part";
        this.createTable(TEST_DB_NAME, tableToInsertNoPart, false);
        this.testInsertEvents(TEST_DB_NAME, tableToInsertNoPart, false);
    }

    @Test
    public void testPartitionedTblInsertSyncToLatestEvent() throws Exception {
        String tblName = "test_insert_into_part_tbl_sync_to_latest_event";
        this.testTblInsertsSyncToLatestEvent(TEST_DB_NAME, tblName, true);
    }

    @Test
    public void testNonPartitionedTblInsertSyncToLatestEvent() throws Exception {
        String tblName = "test_insert_into_non_part_tbl_sync_to_latest_event";
        this.testTblInsertsSyncToLatestEvent(TEST_DB_NAME, tblName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTblInsertsSyncToLatestEvent(String dbName, String tblName, boolean isPartitioned) throws Exception {
        boolean prevFlagVal = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        boolean invalidateHMSFlag = BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs();
        try {
            BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(true);
            BackendConfig.INSTANCE.setInvalidateCatalogdHMSCacheOnDDLs(false);
            this.createDatabase(dbName, null);
            this.createTable(dbName, tblName, isPartitioned);
            eventsProcessor_.processEvents();
            Assert.assertNotNull((String)("Table " + tblName + " not present in catalog"), (Object)catalog_.getTableNoThrow(dbName, tblName));
            long lastSyncedEventIdBefore = catalog_.getTable(dbName, tblName).getLastSyncedEventId();
            Assert.assertTrue((String)"expected lastSyncedEventIdBefore to be > 0", (lastSyncedEventIdBefore > 0L ? 1 : 0) != 0);
            this.testInsertEvents(dbName, tblName, isPartitioned);
            Table tbl = catalog_.getTable(dbName, tblName);
            long lastSyncedEventIdAfter = tbl.getLastSyncedEventId();
            long currentEventIdHms = -1L;
            try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
                currentEventIdHms = metaStoreClient.getHiveClient().getCurrentNotificationEventId().getEventId();
            }
            Assert.assertTrue((String)String.format("for table %s, expected lastSyncedEventIdBefore %s to be less than lastSyncedEventIdAfter %s", tblName, lastSyncedEventIdBefore, lastSyncedEventIdAfter), (lastSyncedEventIdBefore < lastSyncedEventIdAfter ? 1 : 0) != 0);
            Assert.assertTrue((String)String.format("for table %s, expected lastSyncedEventIdAfter %s to be less than equal to currentEventIdHms %s", tblName, lastSyncedEventIdAfter, currentEventIdHms), (lastSyncedEventIdAfter <= currentEventIdHms ? 1 : 0) != 0);
        }
        finally {
            BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(prevFlagVal);
            BackendConfig.INSTANCE.setInvalidateCatalogdHMSCacheOnDDLs(invalidateHMSFlag);
        }
    }

    @Test
    public void testInsertFromImpala() throws Exception {
        Assume.assumeTrue((String)"Skipping this test because it only works with Hive-3 or greater", (TestUtils.getHiveMajorVersion() >= 3 ? 1 : 0) != 0);
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        String tableToInsertPart = "tbl_with_mul_part";
        String tableToInsertMulPart = "tbl_to_insert_mul_part";
        this.createInsertTestTbls(tableToInsertPart, tableToInsertMulPart);
        eventsProcessor_.processEvents();
        long numberOfSelfEventsBefore = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        this.runInsertTest(tableToInsertPart, tableToInsertMulPart, numberOfSelfEventsBefore, false);
    }

    @Test
    public void testInsertOverwriteFromImpala() throws Exception {
        Assume.assumeTrue((String)"Skipping this test because it only works with Hive-3 or greater", (TestUtils.getHiveMajorVersion() >= 3 ? 1 : 0) != 0);
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        String tableToInsertPart = "tbl_with_mul_part";
        String tableToInsertMulPart = "tbl_to_insert_mul_part";
        this.createInsertTestTbls(tableToInsertPart, tableToInsertMulPart);
        eventsProcessor_.processEvents();
        long numberOfSelfEventsBefore = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        this.runInsertTest(tableToInsertPart, tableToInsertMulPart, numberOfSelfEventsBefore, true);
    }

    private void createInsertTestTbls(String tableToInsertPart, String tableToInsertMulPart) throws Exception {
        this.createTableLike("functional", "alltypes", TEST_DB_NAME, tableToInsertPart);
        this.createTableLike("functional", "alltypes", TEST_DB_NAME, tableToInsertMulPart);
        TPartitionDef partitionDef = new TPartitionDef();
        partitionDef.addToPartition_spec(new TPartitionKeyValue("year", "2009"));
        partitionDef.addToPartition_spec(new TPartitionKeyValue("month", "1"));
        this.alterTableAddPartition(TEST_DB_NAME, tableToInsertPart, partitionDef);
        this.alterTableAddPartition(TEST_DB_NAME, tableToInsertMulPart, partitionDef);
        partitionDef = new TPartitionDef();
        partitionDef.addToPartition_spec(new TPartitionKeyValue("year", "2009"));
        partitionDef.addToPartition_spec(new TPartitionKeyValue("month", "2"));
        this.alterTableAddPartition(TEST_DB_NAME, tableToInsertPart, partitionDef);
        this.alterTableAddPartition(TEST_DB_NAME, tableToInsertMulPart, partitionDef);
        HdfsTable allTypes = (HdfsTable)catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        HdfsTable insertTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, tableToInsertPart, "test", null);
        HdfsTable multiInsertTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, tableToInsertMulPart, "test", null);
        MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=1"), insertTbl.getFileSystem(), new Path(insertTbl.getHdfsBaseDir() + "/year=2009/month=1"), true, null);
        MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=2"), insertTbl.getFileSystem(), new Path(insertTbl.getHdfsBaseDir() + "/year=2009/month=2"), true, null);
        MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=1"), multiInsertTbl.getFileSystem(), new Path(multiInsertTbl.getHdfsBaseDir() + "/year=2009/month=1"), true, null);
        MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=2"), multiInsertTbl.getFileSystem(), new Path(multiInsertTbl.getHdfsBaseDir() + "/year=2009/month=2"), true, null);
        NoOpEventSequence catalogTimeline = NoOpEventSequence.INSTANCE;
        catalog_.reloadTable((Table)multiInsertTbl, "test", (EventSequence)catalogTimeline);
        catalog_.reloadTable((Table)insertTbl, "test", (EventSequence)catalogTimeline);
        eventsProcessor_.processEvents();
    }

    private void runInsertTest(String tableToInsertPart, String tableToInsertMulPart, long numberOfSelfEventsBefore, boolean overwrite) throws Exception {
        HdfsTable allTypes = (HdfsTable)catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        HdfsTable insertTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, tableToInsertPart, "test", null);
        HdfsTable multiInsertTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, tableToInsertMulPart, "test", null);
        long insertTblLatestEventIdBefore = insertTbl.getLastSyncedEventId();
        long multiInsertTblLatestEventIdBefore = multiInsertTbl.getLastSyncedEventId();
        List<String> tbl1Part1Files = MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=1"), insertTbl.getFileSystem(), new Path(insertTbl.getHdfsBaseDir() + "/year=2009/month=1"), overwrite, "copy_");
        List<String> tbl1Part2Files = MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=2"), insertTbl.getFileSystem(), new Path(insertTbl.getHdfsBaseDir() + "/year=2009/month=2"), overwrite, "copy_");
        List<String> tbl2Part1Files = MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=1"), multiInsertTbl.getFileSystem(), new Path(multiInsertTbl.getHdfsBaseDir() + "/year=2009/month=1"), overwrite, "copy_");
        List<String> tbl2Part2Files = MetastoreEventsProcessorTest.copyFiles(allTypes.getFileSystem(), new Path(allTypes.getHdfsBaseDir() + "/year=2009/month=2"), multiInsertTbl.getFileSystem(), new Path(multiInsertTbl.getHdfsBaseDir() + "/year=2009/month=2"), overwrite, "copy_");
        this.insertFromImpala(tableToInsertPart, true, "year=2009", "month=1", overwrite, tbl1Part1Files);
        this.insertFromImpala(tableToInsertPart, true, "year=2009", "month=2", overwrite, tbl1Part2Files);
        HashMap<String, TUpdatedPartition> updated_partitions = new HashMap<String, TUpdatedPartition>();
        String partition1 = "year=2009/month=1";
        String partition2 = "year=2009/month=2";
        TUpdatedPartition updatedPartition1 = new TUpdatedPartition();
        TUpdatedPartition updatedPartition2 = new TUpdatedPartition();
        updatedPartition1.setFiles(tbl2Part1Files);
        updatedPartition2.setFiles(tbl2Part2Files);
        updated_partitions.put(partition1, updatedPartition1);
        updated_partitions.put(partition2, updatedPartition2);
        this.insertMulPartFromImpala(tableToInsertMulPart, tableToInsertPart, updated_partitions, overwrite);
        List events = eventsProcessor_.getNextMetastoreEvents();
        Assert.assertEquals((long)4L, (long)events.size());
        Assert.assertEquals(tbl1Part1Files, this.getFilesFromEvent((NotificationEvent)events.get(0)));
        Assert.assertEquals(tbl1Part2Files, this.getFilesFromEvent((NotificationEvent)events.get(1)));
        Assert.assertEquals(tbl2Part1Files, this.getFilesFromEvent((NotificationEvent)events.get(2)));
        Assert.assertEquals(tbl2Part2Files, this.getFilesFromEvent((NotificationEvent)events.get(3)));
        eventsProcessor_.processEvents();
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((catalog_.getTable(TEST_DB_NAME, tableToInsertPart).getLastSyncedEventId() > insertTblLatestEventIdBefore ? 1 : 0) != 0);
            Assert.assertTrue((catalog_.getTable(TEST_DB_NAME, tableToInsertMulPart).getLastSyncedEventId() > multiInsertTblLatestEventIdBefore ? 1 : 0) != 0);
        }
        String unpartitionedTbl = "tbl_to_insert";
        this.createTableLike("functional", "tinytable", TEST_DB_NAME, unpartitionedTbl);
        HdfsTable tinyTable = (HdfsTable)catalog_.getOrLoadTable("functional", "tinytable", "test", null);
        HdfsTable unpartTable = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, unpartitionedTbl, "test", null);
        List<String> copied_files = MetastoreEventsProcessorTest.copyFiles(tinyTable.getFileSystem(), new Path(tinyTable.getHdfsBaseDir()), unpartTable.getFileSystem(), new Path(unpartTable.getHdfsBaseDir()), overwrite, "copy_");
        this.insertFromImpala(unpartitionedTbl, false, "", "", overwrite, copied_files);
        eventsProcessor_.processEvents();
        long selfEventsCountAfter = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        Assert.assertEquals((String)"Unexpected number of self-events generated", (long)(numberOfSelfEventsBefore + 6L), (long)selfEventsCountAfter);
    }

    private List<String> getFilesFromEvent(NotificationEvent event) {
        Assert.assertEquals((Object)"INSERT", (Object)event.getEventType());
        ArrayList<String> files = new ArrayList<String>();
        for (String f : MetastoreEventsProcessor.getMessageDeserializer().getInsertMessage(event.getMessage()).getFiles()) {
            files.add(f.replaceAll("###", ""));
        }
        return files;
    }

    private static List<String> copyFiles(FileSystem srcFs, Path src, FileSystem destFs, Path dest, boolean overwrite, String prefix) throws Exception {
        FSDataOutputStream out = null;
        try {
            if (srcFs.isDirectory(src)) {
                if (!destFs.exists(dest)) {
                    destFs.mkdirs(dest);
                } else if (overwrite) {
                    destFs.delete(dest, true);
                    destFs.mkdirs(dest);
                }
            }
            ArrayList<String> filesCopied = new ArrayList<String>();
            RemoteIterator it = FileSystemUtil.listStatus((FileSystem)srcFs, (Path)src, (boolean)true, null);
            while (it.hasNext()) {
                FileStatus status = (FileStatus)it.next();
                if (status.isDirectory()) continue;
                FSDataInputStream in = srcFs.open(status.getPath());
                String copyFileName = (prefix == null ? "" : prefix) + status.getPath().getName();
                out = destFs.create(new Path(dest, copyFileName), false);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)CONF, (boolean)true);
                filesCopied.add(new Path(dest, copyFileName).toString());
            }
            return filesCopied;
        }
        catch (IOException ex) {
            IOUtils.closeStream(out);
            throw ex;
        }
    }

    @Test
    public void testInsertEventOnRemovedTable() throws Exception {
        org.apache.hadoop.hive.metastore.api.Table msTbl;
        this.createDatabaseFromImpala(TEST_DB_NAME, "");
        String createInsertDropTable = "tbl_create_insert_drop";
        this.createTableFromImpala(TEST_DB_NAME, "tbl_create_insert_drop", null, false);
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            msTbl = metaStoreClient.getHiveClient().getTable(TEST_DB_NAME, "tbl_create_insert_drop");
        }
        this.simulateInsertIntoTableFromFS(msTbl, 2, null, false);
        this.dropTable("tbl_create_insert_drop");
        Assert.assertEquals((long)4L, (long)eventsProcessor_.getNextMetastoreEvents().size());
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    private List<String> addFilesToDirectory(Path parentPath, String fileNamePrefix, int totalNumberOfFilesToAdd, boolean isOverwrite) throws IOException {
        ArrayList<String> newFiles = new ArrayList<String>();
        FileSystem fs = parentPath.getFileSystem(FileSystemUtil.getConfiguration());
        if (isOverwrite && fs.exists(parentPath)) {
            fs.delete(parentPath, true);
        }
        for (int i = 0; i < totalNumberOfFilesToAdd; ++i) {
            Path filename = new Path(parentPath, fileNamePrefix + RandomStringUtils.random((int)5, (boolean)true, (boolean)true).toUpperCase());
            try (FSDataOutputStream out = fs.create(filename);){
                newFiles.add(filename.getName());
                continue;
            }
        }
        return newFiles;
    }

    public void testInsertEvents(String dbName, String tblName, boolean isPartitionInsert) throws TException, ImpalaException, IOException {
        if (isPartitionInsert) {
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(new ArrayList<String>(Arrays.asList("testPartVal")));
            this.addPartitions(dbName, tblName, partVals);
        }
        eventsProcessor_.processEvents();
        Table tbl = catalog_.getOrLoadTable(dbName, tblName, "test", null);
        Partition partition = null;
        if (isPartitionInsert) {
            try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
                partition = metaStoreClient.getHiveClient().getPartition(dbName, tblName, "p1=testPartVal");
            }
        }
        Assert.assertFalse((String)"Table must be already loaded to verify correctness", (boolean)(tbl instanceof IncompleteTable));
        this.simulateInsertIntoTableFromFS(tbl.getMetaStoreTable(), 3, partition, true);
        this.verifyNumberOfFiles(tbl, 3);
        this.simulateInsertIntoTableFromFS(tbl.getMetaStoreTable(), 2, partition, false);
        this.verifyNumberOfFiles(tbl, 5);
        this.simulateInsertIntoTableFromFS(tbl.getMetaStoreTable(), 1, partition, true);
        this.verifyNumberOfFiles(tbl, 1);
        this.simulateInsertIntoTableFromFS(tbl.getMetaStoreTable(), 2, partition, true);
        this.verifyNumberOfFiles(tbl, 2);
    }

    private void verifyNumberOfFiles(Table tbl, int expectedNumberOfFiles) throws DatabaseNotFoundException {
        eventsProcessor_.processEvents();
        Table tblAfterInsert = catalog_.getTable(tbl.getDb().getName(), tbl.getName());
        Assert.assertFalse((boolean)(tblAfterInsert instanceof IncompleteTable));
        Collection partsAfterInsert = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)tblAfterInsert));
        Assert.assertTrue((String)"Partition not found after insert.", (partsAfterInsert.size() > 0 ? 1 : 0) != 0);
        FeFsPartition singlePart = (FeFsPartition)Iterables.getOnlyElement((Iterable)((List)partsAfterInsert));
        Set filesAfterInsertForTable = ((HdfsPartition)singlePart).getFileNames();
        Assert.assertEquals((String)"File count mismatch after insert.", (long)expectedNumberOfFiles, (long)filesAfterInsertForTable.size());
    }

    private void simulateInsertIntoTableFromFS(org.apache.hadoop.hive.metastore.api.Table msTbl, int totalNumberOfFilesToAdd, Partition partition, boolean isOverwrite) throws IOException, TException {
        Path parentPath = partition == null ? new Path(msTbl.getSd().getLocation()) : new Path(partition.getSd().getLocation());
        List<String> newFiles = this.addFilesToDirectory(parentPath, "testFile.", totalNumberOfFilesToAdd, isOverwrite);
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            ArrayList<InsertEventRequestData> partitionInsertEventInfos = new ArrayList<InsertEventRequestData>();
            ArrayList<List> partitionInsertEventVals = new ArrayList<List>();
            InsertEventRequestData insertEventRequestData = new InsertEventRequestData();
            insertEventRequestData.setFilesAdded(newFiles);
            insertEventRequestData.setReplace(isOverwrite);
            if (partition != null) {
                MetastoreShim.setPartitionVal((InsertEventRequestData)insertEventRequestData, (List)partition.getValues());
            }
            partitionInsertEventInfos.add(insertEventRequestData);
            partitionInsertEventVals.add(partition != null ? partition.getValues() : null);
            MetastoreShim.fireInsertEventHelper((IMetaStoreClient)metaStoreClient.getHiveClient(), partitionInsertEventInfos, partitionInsertEventVals, (String)msTbl.getDbName(), (String)msTbl.getTableName());
        }
    }

    private void simulateInsertIntoTransactionalTableFromFS(org.apache.hadoop.hive.metastore.api.Table msTbl, Partition partition, int totalNumberOfFilesToAdd, long txnId, long writeId) throws IOException {
        Path parentPath = partition == null ? new Path(msTbl.getSd().getLocation()) : new Path(partition.getSd().getLocation());
        Path deltaPath = new Path(parentPath, String.format("delta_%d_%d", writeId, writeId));
        List<String> newFiles = this.addFilesToDirectory(deltaPath, "testFile.", totalNumberOfFilesToAdd, false);
        ArrayList<InsertEventRequestData> insertEventReqDatas = new ArrayList<InsertEventRequestData>();
        ArrayList<List> insertEventVals = new ArrayList<List>();
        InsertEventRequestData insertEventRequestData = new InsertEventRequestData();
        if (partition != null) {
            MetastoreShim.setPartitionVal((InsertEventRequestData)insertEventRequestData, (List)partition.getValues());
        }
        insertEventRequestData.setFilesAdded(newFiles);
        insertEventRequestData.setReplace(false);
        insertEventReqDatas.add(insertEventRequestData);
        insertEventVals.add(partition != null ? partition.getValues() : null);
        MetaStoreUtil.TableInsertEventInfo insertEventInfo = new MetaStoreUtil.TableInsertEventInfo(insertEventReqDatas, insertEventVals, true, txnId, writeId);
        MetastoreShim.fireInsertEvents((MetaStoreClientPool.MetaStoreClient)catalog_.getMetaStoreClient(), (MetaStoreUtil.TableInsertEventInfo)insertEventInfo, (String)msTbl.getDbName(), (String)msTbl.getTableName());
    }

    @Test
    public void testAlterTableEvent() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testAlterTableEvent";
        this.createTable("old_name", false);
        eventsProcessor_.processEvents();
        this.loadTable("old_name");
        long numOfRefreshesBefore = eventsProcessor_.getMetrics().getCounter("tables-refreshed").getCount();
        this.alterTableRename("old_name", "testAlterTableEvent", null);
        eventsProcessor_.processEvents();
        Assert.assertNull((String)"Old named table still exists", (Object)catalog_.getTable(TEST_DB_NAME, "old_name"));
        Table newTable = catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent");
        Assert.assertNotNull((String)"Table with the new name is not found", (Object)newTable);
        Assert.assertTrue((String)"Table with the new name should be incomplete", (boolean)(newTable instanceof IncompleteTable));
        this.createTable("old_table_name", false);
        eventsProcessor_.processEvents();
        this.loadTable("old_table_name");
        this.createDatabase("new_db", null);
        this.alterTableRename("old_table_name", "new_table_name", "new_db");
        eventsProcessor_.processEvents();
        Table tableAfterRename = catalog_.getTable("new_db", "new_table_name");
        Assert.assertNotNull((Object)tableAfterRename);
        Assert.assertTrue((String)"Table after rename should be incomplete.", (boolean)(tableAfterRename instanceof IncompleteTable));
        this.dropDatabaseCascadeFromImpala("new_db");
        this.loadTable("testAlterTableEvent");
        Table testTbl = catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent");
        long lastSyncedEventIdBefore = testTbl.getLastSyncedEventId();
        this.alterTableAddParameter("testAlterTableEvent", "somekey", "someval");
        eventsProcessor_.processEvents();
        Assert.assertFalse((String)"Table should have been refreshed after alter table add parameter", (boolean)(catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent") instanceof IncompleteTable));
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((String)"Table's last synced event id should have been advanced after processing alter table event", (catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent").getLastSyncedEventId() > lastSyncedEventIdBefore ? 1 : 0) != 0);
        }
        this.loadTable("testAlterTableEvent");
        this.alterTableAddCol("testAlterTableEvent", "newCol", "int", "null");
        eventsProcessor_.processEvents();
        Assert.assertFalse((String)"Table should have been refreshed after alter table add column", (boolean)(catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent") instanceof IncompleteTable));
        this.loadTable("testAlterTableEvent");
        this.altertableChangeCol("testAlterTableEvent", "newCol", "string", null);
        eventsProcessor_.processEvents();
        Assert.assertFalse((String)"Table should have been refreshed after changing column type", (boolean)(catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent") instanceof IncompleteTable));
        this.loadTable("testAlterTableEvent");
        this.alterTableRemoveCol("testAlterTableEvent", "newCol");
        eventsProcessor_.processEvents();
        Assert.assertFalse((String)"Table should have been refreshed after removing a column", (boolean)(catalog_.getTable(TEST_DB_NAME, "testAlterTableEvent") instanceof IncompleteTable));
        long numOfRefreshesAfter = eventsProcessor_.getMetrics().getCounter("tables-refreshed").getCount();
        Assert.assertEquals((String)"Unexpected number of table refreshes", (long)(numOfRefreshesBefore + 4L), (long)numOfRefreshesAfter);
        this.loadTable("testAlterTableEvent");
        this.alterTableChangeTrivialProperties("testAlterTableEvent");
        long numberOfInvalidatesAfterTrivialAlter = eventsProcessor_.getMetrics().getCounter("tables-refreshed").getCount();
        Assert.assertEquals((String)"Unexpected number of table refreshes after trivial alters", (long)(numOfRefreshesBefore + 4L), (long)numberOfInvalidatesAfterTrivialAlter);
        String tblName = "alter_drop_test";
        this.createTable(tblName, false);
        eventsProcessor_.processEvents();
        this.alterTableRename(tblName, "new_table_1", null);
        this.dropTableFromImpala(TEST_DB_NAME, tblName);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        this.createTable(tblName, false);
        eventsProcessor_.processEvents();
        this.alterTableRenameFromImpala(TEST_DB_NAME, tblName, "new_table_2");
        this.dropTableFromImpala(TEST_DB_NAME, tblName);
        eventsProcessor_.processEvents();
        this.createTable(tblName, false);
        eventsProcessor_.processEvents();
        this.alterTableRename(tblName, "new_tbl_3", null);
        this.dropDatabaseCascadeFromImpala(TEST_DB_NAME);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    @Test
    public void testDropTableEvent() throws TException, ImpalaException {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "tbl_to_be_dropped";
        this.createTable("tbl_to_be_dropped", false);
        eventsProcessor_.processEvents();
        this.loadTable("tbl_to_be_dropped");
        this.dropTable("tbl_to_be_dropped");
        eventsProcessor_.processEvents();
        Assert.assertTrue((String)"Table should not be found after processing drop_table event", (catalog_.getTable(TEST_DB_NAME, "tbl_to_be_dropped") == null ? 1 : 0) != 0);
        this.createTable("tbl_to_be_dropped", true);
        eventsProcessor_.processEvents();
        this.loadTable("tbl_to_be_dropped");
        ArrayList<List<String>> partVals = new ArrayList<List<String>>(2);
        partVals.add(Arrays.asList("1"));
        partVals.add(Arrays.asList("2"));
        this.addPartitions(TEST_DB_NAME, "tbl_to_be_dropped", partVals);
        this.dropTable("tbl_to_be_dropped");
        eventsProcessor_.processEvents();
        Assert.assertTrue((String)"Partitioned table should not be found after processing drop_table event", (catalog_.getTable(TEST_DB_NAME, "tbl_to_be_dropped") == null ? 1 : 0) != 0);
    }

    @Test
    public void testPauseEventProcessing() throws TException {
        try {
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            eventsProcessor_.pause();
            this.createDatabase(TEST_DB_NAME, null);
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.PAUSED, (Object)eventsProcessor_.getStatus());
            Assert.assertNull((String)"Test database should not be in catalog when event processing is stopped", (Object)catalog_.getDb(TEST_DB_NAME));
        }
        finally {
            eventsProcessor_.start();
        }
    }

    @Test
    public void testEventProcessorRestart() throws TException {
        try {
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            long syncedIdBefore = eventsProcessor_.getLastSyncedEventId();
            eventsProcessor_.pause();
            this.createDatabase(TEST_DB_NAME, null);
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.PAUSED, (Object)eventsProcessor_.getStatus());
            Assert.assertNull((String)"Test database should not be in catalog when event processing is stopped", (Object)catalog_.getDb(TEST_DB_NAME));
            eventsProcessor_.start(syncedIdBefore);
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            eventsProcessor_.processEvents();
            Assert.assertNotNull((String)"Test database should be in catalog when event processing is restarted", (Object)catalog_.getDb(TEST_DB_NAME));
        }
        finally {
            if (eventsProcessor_.getStatus() != MetastoreEventsProcessor.EventProcessorStatus.ACTIVE) {
                eventsProcessor_.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventProcessorFetchAfterHMSRestart() throws ImpalaException {
        CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();
        CatalogOpExecutor catalogOpExecutor = catalog.getCatalogOpExecutor();
        HMSFetchNotificationsEventProcessor fetchProcessor = new HMSFetchNotificationsEventProcessor(catalogOpExecutor, eventsProcessor_.getCurrentEventId(), 2L);
        fetchProcessor.start();
        try {
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)fetchProcessor.getStatus());
            try {
                while (true) {
                    fetchProcessor.getNextMetastoreEvents();
                }
            }
            catch (MetastoreNotificationFetchException ex) {
                Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)fetchProcessor.getStatus());
                fetchProcessor.shutdown();
            }
        }
        catch (Throwable throwable) {
            fetchProcessor.shutdown();
            throw throwable;
        }
    }

    @Test
    public void testEventProcessingAfterReset() throws ImpalaException {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        long syncedIdBefore = eventsProcessor_.getLastSyncedEventId();
        catalog_.reset((EventSequence)NoOpEventSequence.INSTANCE);
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        Assert.assertEquals((long)syncedIdBefore, (long)eventsProcessor_.getLastSyncedEventId());
    }

    @Test
    public void testCreateDropCreateTableFromImpala() throws ImpalaException, TException, InterruptedException {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testCreateDropCreateTableFromImpala";
        eventsProcessor_.processEvents();
        this.createTableFromImpala(TEST_DB_NAME, "testCreateDropCreateTableFromImpala", false);
        Assert.assertNotNull((String)"Table should have been found after create table statement", (Object)catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala"));
        this.loadTable("testCreateDropCreateTableFromImpala");
        Thread.sleep(2000L);
        this.dropTableFromImpala(TEST_DB_NAME, "testCreateDropCreateTableFromImpala");
        this.createTableFromImpala(TEST_DB_NAME, "testCreateDropCreateTableFromImpala", false);
        Assert.assertNotNull((String)"Table should have been found after create table statement", (Object)catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala"));
        this.loadTable("testCreateDropCreateTableFromImpala");
        long currentEventId = eventsProcessor_.getCurrentEventId();
        List events = eventsProcessor_.getNextMetastoreEvents(currentEventId);
        Assert.assertEquals((long)3L, (long)events.size());
        Table existingTable = catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala");
        long id = MetastoreShim.getTableId((org.apache.hadoop.hive.metastore.api.Table)existingTable.getMetaStoreTable());
        Assert.assertEquals((Object)"CREATE_TABLE", (Object)((NotificationEvent)events.get(0)).getEventType());
        eventsProcessor_.processEvents(currentEventId, (List)Lists.newArrayList((Object[])new NotificationEvent[]{(NotificationEvent)events.get(0)}));
        long testId = MetastoreShim.getTableId((org.apache.hadoop.hive.metastore.api.Table)catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala").getMetaStoreTable());
        Assert.assertEquals((long)id, (long)testId);
        Assert.assertEquals((Object)"DROP_TABLE", (Object)((NotificationEvent)events.get(1)).getEventType());
        long numFilteredEvents = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        eventsProcessor_.processEvents(currentEventId, (List)Lists.newArrayList((Object[])new NotificationEvent[]{(NotificationEvent)events.get(1)}));
        Assert.assertEquals((long)(numFilteredEvents + 1L), (long)eventsProcessor_.getMetrics().getCounter("events-skipped").getCount());
        Assert.assertNotNull((String)"Table should have existed since catalog state is current and event is stale", (Object)catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala"));
        Assert.assertEquals((Object)"CREATE_TABLE", (Object)((NotificationEvent)events.get(2)).getEventType());
        eventsProcessor_.processEvents(currentEventId, (List)Lists.newArrayList((Object[])new NotificationEvent[]{(NotificationEvent)events.get(2)}));
        Assert.assertFalse((String)"Table should have been loaded since the create_table should be ignored", (boolean)(catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala") instanceof IncompleteTable));
        testId = MetastoreShim.getTableId((org.apache.hadoop.hive.metastore.api.Table)catalog_.getTable(TEST_DB_NAME, "testCreateDropCreateTableFromImpala").getMetaStoreTable());
        Assert.assertEquals((long)id, (long)testId);
    }

    @Test
    public void testTableEventsFromImpala() throws ImpalaException {
        this.createDatabaseFromImpala(TEST_DB_NAME, "created from Impala");
        String testTblName = "testTableEventsFromImpala";
        this.createTableFromImpala(TEST_DB_NAME, "testTableEventsFromImpala", true);
        this.loadTable("testTableEventsFromImpala");
        List events = eventsProcessor_.getNextMetastoreEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        eventsProcessor_.processEvents();
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
        Assert.assertNotNull((Object)catalog_.getTable(TEST_DB_NAME, "testTableEventsFromImpala"));
        Assert.assertFalse((String)"Table should have been loaded since it was already latest", (boolean)(catalog_.getTable(TEST_DB_NAME, "testTableEventsFromImpala") instanceof IncompleteTable));
        this.dropTableFromImpala(TEST_DB_NAME, "testTableEventsFromImpala");
        Assert.assertNull((Object)catalog_.getTable(TEST_DB_NAME, "testTableEventsFromImpala"));
        events = eventsProcessor_.getNextMetastoreEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        Assert.assertNull((Object)catalog_.getTable(TEST_DB_NAME, "testTableEventsFromImpala"));
    }

    @Test
    public void testCreateDropCreateDatabaseFromImpala() throws ImpalaException, InterruptedException {
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        this.createDatabaseFromImpala(TEST_DB_NAME, "first");
        Assert.assertNotNull((String)"Db should have been found after create database statement", (Object)catalog_.getDb(TEST_DB_NAME));
        Thread.sleep(2000L);
        this.dropDatabaseCascadeFromImpala(TEST_DB_NAME);
        Assert.assertNull((Object)catalog_.getDb(TEST_DB_NAME));
        this.createDatabaseFromImpala(TEST_DB_NAME, "second");
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
        long currentEventId = eventsProcessor_.getCurrentEventId();
        List events = eventsProcessor_.getNextMetastoreEvents(currentEventId);
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertEquals((Object)"CREATE_DATABASE", (Object)((NotificationEvent)events.get(0)).getEventType());
        eventsProcessor_.processEvents(currentEventId, (List)Lists.newArrayList((Object[])new NotificationEvent[]{(NotificationEvent)events.get(0)}));
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
        Assert.assertEquals((Object)"second", (Object)catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getDescription());
        Assert.assertEquals((Object)"DROP_DATABASE", (Object)((NotificationEvent)events.get(1)).getEventType());
        eventsProcessor_.processEvents(currentEventId, (List)Lists.newArrayList((Object[])new NotificationEvent[]{(NotificationEvent)events.get(1)}));
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
        Assert.assertEquals((Object)"second", (Object)catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getDescription());
        Assert.assertEquals((Object)"CREATE_DATABASE", (Object)((NotificationEvent)events.get(2)).getEventType());
        eventsProcessor_.processEvents(currentEventId, (List)Lists.newArrayList((Object[])new NotificationEvent[]{(NotificationEvent)events.get(2)}));
        Assert.assertNotNull((Object)catalog_.getDb(TEST_DB_NAME));
        Assert.assertEquals((Object)"second", (Object)catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().getDescription());
    }

    @Test
    public void testEventSyncFlagTransitions() throws Exception {
        Pair unsetToTrue = new Pair(null, (Object)"true");
        Pair unsetToFalse = new Pair(null, (Object)"false");
        Pair falseToTrue = new Pair((Object)"false", (Object)"true");
        Pair falseToUnset = new Pair((Object)"false", null);
        Pair trueToFalse = new Pair((Object)"true", (Object)"false");
        Pair trueToUnset = new Pair((Object)"true", null);
        List<Pair> allTblTransitions = Arrays.asList(unsetToTrue, unsetToFalse, falseToTrue, falseToUnset, trueToFalse, trueToUnset);
        List<String> dbFlagVals = Arrays.asList(null, "true", "false");
        String testTblName = "testEventSyncFlagTransitions";
        for (String dbFlag : dbFlagVals) {
            for (Pair tblTransition : allTblTransitions) {
                boolean shouldSubsequentEventsBeSkipped = tblTransition.second == null ? Boolean.valueOf(dbFlag) : Boolean.valueOf((String)tblTransition.second);
                this.runDDLTestForFlagTransitionWithMock(TEST_DB_NAME, "testEventSyncFlagTransitions", dbFlag, (Pair<String, String>)tblTransition, shouldSubsequentEventsBeSkipped);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventSyncFlagChanged() throws ImpalaException, TException, CatalogException {
        Pair trueToFalse = new Pair((Object)"true", (Object)"false");
        Pair trueToUnset = new Pair((Object)"true", null);
        List<Pair> tblFlagTransitions = Arrays.asList(trueToFalse, trueToUnset);
        List<String> dbFlagVals = Arrays.asList(null, "false");
        List<Boolean> createDropFromImpala = Arrays.asList(true, false);
        String testTblName = "testEventSyncFlagChanged";
        boolean prevFlagVal = BackendConfig.INSTANCE.enableSkippingOlderEvents();
        try {
            BackendConfig.INSTANCE.setSkippingOlderEvents(true);
            for (String dbFlag : dbFlagVals) {
                for (Pair tblTransition : tblFlagTransitions) {
                    HashMap<String, String> dbParams = new HashMap<String, String>(1);
                    if (dbFlag != null) {
                        dbParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), dbFlag);
                    }
                    HashMap<String, String> tblParams = new HashMap<String, String>(1);
                    if (tblTransition.first != null) {
                        tblParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), (String)tblTransition.first);
                    }
                    this.createDatabase(TEST_DB_NAME, dbParams);
                    this.createTable(null, TEST_DB_NAME, "testEventSyncFlagChanged", tblParams, false, null);
                    eventsProcessor_.processEvents();
                    Assert.assertNull((Object)catalog_.getTable(TEST_DB_NAME, "testEventSyncFlagChanged"));
                    for (boolean doCreateDrop : createDropFromImpala) {
                        this.alterTableAddParameter("testEventSyncFlagChanged", MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), (String)tblTransition.second);
                        if (doCreateDrop) {
                            catalog_.invalidateTable(new TTableName(TEST_DB_NAME, "testEventSyncFlagChanged"), new Reference(), new Reference(), (EventSequence)NoOpEventSequence.INSTANCE);
                            this.dropTableFromImpala(TEST_DB_NAME, "testEventSyncFlagChanged");
                            this.createTableFromImpala(TEST_DB_NAME, "testEventSyncFlagChanged", null, false);
                            this.loadTable(TEST_DB_NAME, "testEventSyncFlagChanged");
                        }
                        eventsProcessor_.processEvents();
                        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
                        Table tbl = catalog_.getTable(TEST_DB_NAME, "testEventSyncFlagChanged");
                        if (!doCreateDrop) {
                            Assert.assertTrue((boolean)(tbl instanceof IncompleteTable));
                            continue;
                        }
                        Assert.assertTrue((boolean)(tbl instanceof HdfsTable));
                        this.alterTableAddParameter("testEventSyncFlagChanged", MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), (String)tblTransition.first);
                        this.alterTableAddParameter("testEventSyncFlagChanged", "somekey", "someval");
                        eventsProcessor_.processEvents();
                        tbl = catalog_.getTable(TEST_DB_NAME, "testEventSyncFlagChanged");
                        Assert.assertTrue((boolean)(tbl instanceof HdfsTable));
                    }
                    MetastoreEventsProcessorTest.dropDatabaseCascade(TEST_DB_NAME);
                }
            }
        }
        finally {
            BackendConfig.INSTANCE.setSkippingOlderEvents(prevFlagVal);
        }
    }

    private void runDDLTestForFlagTransitionWithMock(String dbName, String tblName, String dbFlag, Pair<String, String> tblFlagTransition, boolean shouldNextEventBeSkipped) throws Exception {
        HashMap<String, String> beforeParams = new HashMap<String, String>(2);
        beforeParams.put("transient_lastDdlTime", String.valueOf(1000));
        if (tblFlagTransition.first != null) {
            beforeParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), (String)tblFlagTransition.first);
        }
        HashMap<String, String> afterParams = new HashMap<String, String>(2);
        afterParams.put("transient_lastDdlTime", String.valueOf(1001));
        if (tblFlagTransition.second != null) {
            afterParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), (String)tblFlagTransition.second);
        }
        org.apache.hadoop.hive.metastore.api.Table tableBefore = MetastoreApiTestUtils.getTestTable(null, dbName, tblName, beforeParams, false);
        org.apache.hadoop.hive.metastore.api.Table tableAfter = MetastoreApiTestUtils.getTestTable(null, dbName, tblName, afterParams, false);
        HashMap<String, String> dbParams = new HashMap<String, String>(1);
        if (dbFlag != null) {
            dbParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), dbFlag);
        }
        CatalogOpExecutor fakeCatalogOpExecutor = FakeCatalogOpExecutorForTests.create();
        FakeCatalogServiceCatalogForFlagTests fakeCatalog = (FakeCatalogServiceCatalogForFlagTests)fakeCatalogOpExecutor.getCatalog();
        fakeCatalog.setFlags(dbName, tblName, dbFlag, (String)tblFlagTransition.first);
        NotificationEvent fakeAlterTableNotification = this.createFakeAlterTableNotification(dbName, tblName, tableBefore, tableAfter);
        MetastoreEvents.AlterTableEvent alterTableEvent = new MetastoreEvents.AlterTableEvent(fakeCatalogOpExecutor, eventsProcessor_.getMetrics(), fakeAlterTableNotification);
        Assert.assertFalse((String)("Alter table which changes the flags should not be skipped. " + this.printFlagTransistions(dbFlag, tblFlagTransition)), (boolean)alterTableEvent.isEventProcessingDisabled());
        afterParams.put("dummy", "value");
        org.apache.hadoop.hive.metastore.api.Table nextTable = MetastoreApiTestUtils.getTestTable(null, dbName, tblName, afterParams, false);
        NotificationEvent nextNotification = this.createFakeAlterTableNotification(dbName, tblName, tableAfter, nextTable);
        alterTableEvent = new MetastoreEvents.AlterTableEvent(fakeCatalogOpExecutor, eventsProcessor_.getMetrics(), nextNotification);
        if (shouldNextEventBeSkipped) {
            Assert.assertTrue((String)("Alter table event should not skipped following this table flag transition. " + this.printFlagTransistions(dbFlag, tblFlagTransition)), (boolean)alterTableEvent.isEventProcessingDisabled());
        } else {
            Assert.assertFalse((String)("Alter table event should have been skipped following the table flag transistion. " + this.printFlagTransistions(dbFlag, tblFlagTransition)), (boolean)alterTableEvent.isEventProcessingDisabled());
        }
    }

    private NotificationEvent createFakeAlterTableNotification(String dbName, String tblName, org.apache.hadoop.hive.metastore.api.Table tableBefore, org.apache.hadoop.hive.metastore.api.Table tableAfter) {
        NotificationEvent fakeEvent = new NotificationEvent();
        fakeEvent.setTableName(tblName);
        fakeEvent.setDbName(dbName);
        fakeEvent.setEventId(this.eventIdGenerator.incrementAndGet());
        AlterTableMessage alterTableMessage = MetastoreShim.buildAlterTableMessage((org.apache.hadoop.hive.metastore.api.Table)tableBefore, (org.apache.hadoop.hive.metastore.api.Table)tableAfter, (boolean)false, (long)-1L);
        fakeEvent.setMessage(MetastoreShim.serializeEventMessage((EventMessage)alterTableMessage));
        fakeEvent.setEventType("ALTER_TABLE");
        return fakeEvent;
    }

    private String printFlagTransistions(String dbFlag, Pair<String, String> tblFlagTransition) {
        return "Db flag value: " + dbFlag + " Tbl flag changed from " + (String)tblFlagTransition.first + " -> " + (String)tblFlagTransition.second;
    }

    @Test
    public void testEventProcessorMetrics() throws TException {
        TEventProcessorMetrics responseBefore = eventsProcessor_.getEventProcessorMetrics();
        long numEventsReceivedBefore = responseBefore.getEvents_received();
        long numEventsSkippedBefore = responseBefore.getEvents_skipped();
        long lastEventSyncId = responseBefore.getLast_synced_event_id();
        String testTblName = "testEventProcessorMetrics";
        this.createDatabase(TEST_DB_NAME, null);
        HashMap<String, String> tblParams = new HashMap<String, String>(1);
        tblParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), "true");
        this.createTable(null, TEST_DB_NAME, "tbl_should_skipped", tblParams, true, null);
        this.createTable(null, TEST_DB_NAME, "testEventProcessorMetrics", null, true, null);
        ArrayList<List<String>> partitionVals = new ArrayList<List<String>>();
        partitionVals.add(Arrays.asList("1"));
        partitionVals.add(Arrays.asList("2"));
        partitionVals.add(Arrays.asList("3"));
        this.addPartitions(TEST_DB_NAME, "tbl_should_skipped", partitionVals);
        this.addPartitions(TEST_DB_NAME, "testEventProcessorMetrics", partitionVals);
        eventsProcessor_.processEvents();
        TEventProcessorMetrics response = eventsProcessor_.getEventProcessorMetrics();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE.toString(), (Object)response.getStatus());
        Assert.assertTrue((String)"Atleast 5 events should have been received", (response.getEvents_received() >= numEventsReceivedBefore + 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)"3 events should be skipped", (response.getEvents_skipped() == numEventsSkippedBefore + 3L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Event fetch duration should be greater than zero", (response.getEvents_fetch_duration_mean() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Event process duration should be greater than zero", (response.getEvents_process_duration_mean() > 0.0 ? 1 : 0) != 0);
        TEventProcessorMetricsSummaryResponse summaryResponse = catalog_.getEventProcessorSummary();
        Assert.assertNotNull((Object)summaryResponse);
        Assert.assertTrue((response.getLast_synced_event_id() > lastEventSyncId ? 1 : 0) != 0);
    }

    @Test
    public void testEventProcessorMetricsForSkippedMetric() throws TException {
        TEventProcessorMetrics responseBefore = eventsProcessor_.getEventProcessorMetrics();
        long numEventsReceivedBefore = responseBefore.getEvents_received();
        long numEventsSkippedBefore = responseBefore.getEvents_skipped();
        long lastEventSyncId = responseBefore.getLast_synced_event_id();
        String testTblName1 = "testEventProcessorMetrics1";
        String testTblName2 = "testEventProcessorMetrics2";
        this.createDatabase(TEST_DB_NAME, null);
        this.createTable(null, TEST_DB_NAME, "testEventProcessorMetrics1", null, true, null);
        ArrayList<List<String>> partitionVals = new ArrayList<List<String>>();
        partitionVals.add(Arrays.asList("1"));
        partitionVals.add(Arrays.asList("2"));
        partitionVals.add(Arrays.asList("3"));
        this.addPartitions(TEST_DB_NAME, "testEventProcessorMetrics1", partitionVals);
        eventsProcessor_.processEvents();
        TEventProcessorMetrics response = eventsProcessor_.getEventProcessorMetrics();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE.toString(), (Object)response.getStatus());
        Assert.assertTrue((String)"Atleast 3 events should have been received", (response.getEvents_received() >= numEventsReceivedBefore + 3L ? 1 : 0) != 0);
        Assert.assertTrue((String)"we do not turn off disableHmsSync for table testTblName1", (response.getEvents_skipped() >= numEventsSkippedBefore ? 1 : 0) != 0);
        TEventProcessorMetricsSummaryResponse summaryResponse = catalog_.getEventProcessorSummary();
        Assert.assertNotNull((Object)summaryResponse);
        Assert.assertTrue((response.getLast_synced_event_id() > lastEventSyncId ? 1 : 0) != 0);
        catalog_.invalidateTableIfExists(TEST_DB_NAME, "testEventProcessorMetrics1");
        this.alterTableAddCol("testEventProcessorMetrics1", "newCol", "int", "no decription");
        partitionVals.clear();
        partitionVals.add(Arrays.asList("1"));
        partitionVals.add(Arrays.asList("2"));
        partitionVals.add(Arrays.asList("3"));
        String newLocation = "/path/to/new_location/";
        this.alterPartitions("testEventProcessorMetrics1", partitionVals, newLocation);
        eventsProcessor_.processEvents();
        response = eventsProcessor_.getEventProcessorMetrics();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE.toString(), (Object)response.getStatus());
        Assert.assertTrue((String)"two more events should have been received", (response.getEvents_received() >= numEventsReceivedBefore + 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)"we do not turn off disableHmsSync for table testTblName1", (response.getEvents_skipped() >= numEventsSkippedBefore ? 1 : 0) != 0);
        this.createTransactionalTable(TEST_DB_NAME, "testEventProcessorMetrics2", true);
        partitionVals.clear();
        partitionVals.add(Arrays.asList("1"));
        partitionVals.add(Arrays.asList("2"));
        partitionVals.add(Arrays.asList("3"));
        String anotherNewLocation = "/path/to/another_new_location/";
        this.alterPartitions("testEventProcessorMetrics1", partitionVals, anotherNewLocation);
        eventsProcessor_.processEvents();
        response = eventsProcessor_.getEventProcessorMetrics();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE.toString(), (Object)response.getStatus());
        Assert.assertTrue((String)"two more events should have been received", (response.getEvents_received() >= numEventsReceivedBefore + 7L ? 1 : 0) != 0);
        Assert.assertTrue((String)"we do not turn off disableHmsSync for table testTblName1", (response.getEvents_skipped() >= numEventsSkippedBefore ? 1 : 0) != 0);
    }

    @Test
    public void testEventProcessorWhenNotActive() throws TException {
        try {
            eventsProcessor_.pause();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.PAUSED, (Object)eventsProcessor_.getStatus());
            TEventProcessorMetrics response = eventsProcessor_.getEventProcessorMetrics();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.PAUSED.toString(), (Object)response.getStatus());
            Assert.assertFalse((boolean)response.isSetEvents_fetch_duration_mean());
            Assert.assertFalse((boolean)response.isSetEvents_process_duration_mean());
            Assert.assertFalse((boolean)response.isSetEvents_received());
            Assert.assertFalse((boolean)response.isSetEvents_skipped());
            Assert.assertFalse((boolean)response.isSetEvents_received_1min_rate());
            Assert.assertFalse((boolean)response.isSetEvents_received_5min_rate());
            Assert.assertFalse((boolean)response.isSetEvents_received_15min_rate());
            TEventProcessorMetricsSummaryResponse summaryResponse = eventsProcessor_.getEventProcessorSummary();
            Assert.assertNotNull((Object)summaryResponse);
            Assert.assertTrue((boolean)response.isSetLast_synced_event_id());
        }
        finally {
            eventsProcessor_.start();
        }
    }

    @Test
    public void testEventMetricsWhenNotConfigured() {
        CatalogServiceTestCatalog testCatalog = CatalogServiceTestCatalog.create();
        Assert.assertTrue((String)"Events processed is not expected to be configured for this test", (boolean)(testCatalog.getMetastoreEventProcessor() instanceof NoOpEventProcessor));
        TEventProcessorMetrics response = testCatalog.getEventProcessorMetrics();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.DISABLED.toString(), (Object)response.getStatus());
        TEventProcessorMetricsSummaryResponse summaryResponse = testCatalog.getEventProcessorSummary();
        Assert.assertNotNull((Object)summaryResponse);
    }

    @Test
    public void testDisableEventSyncFlag() throws Exception {
        this.runDDLTestsWithFlags(null, null, true);
        this.runDDLTestsWithFlags(false, false, true);
        this.runDDLTestsWithFlags(true, false, true);
        this.runDDLTestsWithFlags(null, false, true);
        this.runDDLTestsWithFlags(false, true, false);
        this.runDDLTestsWithFlags(true, true, false);
        this.runDDLTestsWithFlags(null, true, false);
        this.runDDLTestsWithFlags(false, null, true);
        this.runDDLTestsWithFlags(true, null, false);
    }

    void runDDLTestsWithFlags(Boolean dbFlag, Boolean tblFlag, boolean shouldEventGetProcessed) throws Exception {
        HashMap<String, String> dbParams = new HashMap<String, String>(1);
        HashMap<String, String> tblParams = new HashMap<String, String>(1);
        if (dbFlag == null) {
            dbParams.remove(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey());
        } else {
            dbParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), String.valueOf(dbFlag));
        }
        if (tblFlag == null) {
            tblParams.remove(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey());
        } else {
            tblParams.put(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), String.valueOf(tblFlag));
        }
        String testTblName = "runDDLTestsWithFlags";
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.CREATE_DATABASE, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.ALTER_DATABASE, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.CREATE_TABLE, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.ALTER_TABLE, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.ADD_PARTITION, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.ALTER_PARTITION, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.DROP_PARTITION, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.DROP_TABLE, shouldEventGetProcessed);
        this.testDDLOpUsingEvent(TEST_DB_NAME, "runDDLTestsWithFlags", dbParams, tblParams, MetastoreEvents.MetastoreEventType.DROP_DATABASE, shouldEventGetProcessed);
    }

    private void cleanUpTblsForFlagTests(String dbName) throws TException, MetastoreNotificationFetchException, CatalogException {
        if (catalog_.getDb(dbName) == null) {
            return;
        }
        MetastoreEventsProcessorTest.dropDatabaseCascade(dbName);
        Assert.assertFalse((boolean)eventsProcessor_.getNextMetastoreEvents().isEmpty());
        eventsProcessor_.processEvents();
        Assert.assertNull((Object)catalog_.getDb(dbName));
    }

    private void initTblsForFlagTests(String dbName, String tblName, Map<String, String> dbParams, Map<String, String> tblParams) throws Exception {
        Assert.assertNull((Object)catalog_.getDb(dbName));
        this.createDatabase(dbName, dbParams);
        this.createTable(null, dbName, tblName, tblParams, true, null);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>(3);
        partVals.add(Arrays.asList("1"));
        partVals.add(Arrays.asList("2"));
        partVals.add(Arrays.asList("3"));
        this.addPartitions(dbName, tblName, partVals);
        Assert.assertEquals((long)3L, (long)eventsProcessor_.getNextMetastoreEvents().size());
    }

    private void testDDLOpUsingEvent(String dbName, String tblName, Map<String, String> dbParams, Map<String, String> tblParams, MetastoreEvents.MetastoreEventType ddlOpCode, boolean shouldEventBeProcessed) throws Exception {
        switch (ddlOpCode) {
            case CREATE_TABLE: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                if (shouldEventBeProcessed) {
                    Assert.assertNotNull((Object)catalog_.getTable(dbName, tblName));
                } else {
                    Assert.assertNull((Object)catalog_.getTable(dbName, tblName));
                }
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case ALTER_TABLE: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                this.loadTable(tblName);
                this.alterTableAddCol(tblName, "newCol", "string", "test new column");
                this.alterTableAddParameter(tblName, "testParamKey", "somevalue");
                this.alterTableRename(tblName, "newTblName", null);
                this.altertableChangeCol("newTblName", "newCol", "int", "changed type to int");
                this.alterTableRemoveCol("newTblName", "newCol");
                this.alterTableRename("newTblName", tblName, null);
                Assert.assertEquals((long)6L, (long)eventsProcessor_.getNextMetastoreEvents().size());
                eventsProcessor_.processEvents();
                if (shouldEventBeProcessed) {
                    Assert.assertNotNull((Object)catalog_.getTable(dbName, tblName));
                    Assert.assertTrue((boolean)(catalog_.getTable(dbName, tblName) instanceof IncompleteTable));
                } else {
                    Assert.assertNull((Object)catalog_.getTable(dbName, tblName));
                }
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case DROP_TABLE: {
                this.createDatabase(dbName, dbParams);
                eventsProcessor_.processEvents();
                this.createTableFromImpala(dbName, "impala_test_tbl", tblParams, true);
                eventsProcessor_.processEvents();
                Assert.assertNotNull((Object)catalog_.getTable(dbName, "impala_test_tbl"));
                this.dropTable("impala_test_tbl");
                Assert.assertEquals((long)1L, (long)eventsProcessor_.getNextMetastoreEvents().size());
                eventsProcessor_.processEvents();
                if (shouldEventBeProcessed) {
                    Assert.assertNull((Object)catalog_.getTable(dbName, "impala_test_tbl"));
                } else {
                    Assert.assertNotNull((Object)catalog_.getTable(dbName, "impala_test_tbl"));
                }
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case ADD_PARTITION: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                this.loadTable(tblName);
                ArrayList<List<String>> partValues = new ArrayList<List<String>>(3);
                partValues.add(Arrays.asList("4"));
                partValues.add(Arrays.asList("5"));
                partValues.add(Arrays.asList("6"));
                this.addPartitions(dbName, tblName, partValues);
                Assert.assertEquals((long)1L, (long)eventsProcessor_.getNextMetastoreEvents().size());
                eventsProcessor_.processEvents();
                if (shouldEventBeProcessed) {
                    Collection partsAfterAdd = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)catalog_.getTable(dbName, tblName)));
                    Assert.assertTrue((String)"Partitions should have been added.", (partsAfterAdd.size() == 6 ? 1 : 0) != 0);
                } else {
                    Assert.assertFalse((String)"Table should still have been in loaded state since sync is disabled", (boolean)(catalog_.getTable(dbName, tblName) instanceof IncompleteTable));
                }
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case DROP_PARTITION: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                this.loadTable(tblName);
                ArrayList<List<String>> partValues = new ArrayList<List<String>>(3);
                partValues.add(Arrays.asList("3"));
                this.dropPartitions(tblName, partValues);
                Assert.assertEquals((long)1L, (long)eventsProcessor_.getNextMetastoreEvents().size());
                eventsProcessor_.processEvents();
                if (shouldEventBeProcessed) {
                    Collection partsAfterDrop = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)catalog_.getTable(dbName, tblName)));
                    Assert.assertTrue((String)"Partitions should have been dropped", (partsAfterDrop.size() == 2 ? 1 : 0) != 0);
                } else {
                    Assert.assertFalse((String)"Table should still have been in loaded state since sync is disabled", (boolean)(catalog_.getTable(dbName, tblName) instanceof IncompleteTable));
                }
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case ALTER_PARTITION: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                this.loadTable(tblName);
                ArrayList<List<String>> partValues = new ArrayList<List<String>>(1);
                partValues.add(Arrays.asList("3"));
                partValues.add(Arrays.asList("2"));
                partValues.add(Arrays.asList("1"));
                String location = "/path/to/partition";
                this.alterPartitions(tblName, partValues, location);
                Assert.assertEquals((long)3L, (long)eventsProcessor_.getNextMetastoreEvents().size());
                eventsProcessor_.processEvents();
                if (shouldEventBeProcessed) {
                    Collection partsAfterAlter = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)catalog_.getTable(dbName, tblName)));
                    for (FeFsPartition part : partsAfterAlter) {
                        Assert.assertTrue((String)"Partition location should have been modified by alter.", (boolean)location.equals(part.getLocation()));
                    }
                } else {
                    Assert.assertFalse((String)"Table should still have been in loaded state since sync is disabled", (boolean)(catalog_.getTable(dbName, tblName) instanceof IncompleteTable));
                }
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case CREATE_DATABASE: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                Assert.assertNotNull((String)"Database should have been created after create database event", (Object)catalog_.getDb(dbName));
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case DROP_DATABASE: {
                this.initTblsForFlagTests(dbName, tblName, dbParams, tblParams);
                eventsProcessor_.processEvents();
                Assert.assertNotNull((Object)catalog_.getDb(dbName));
                MetastoreEventsProcessorTest.dropDatabaseCascade(dbName);
                eventsProcessor_.processEvents();
                Assert.assertNull((String)"Database should have been dropped after drop database event", (Object)catalog_.getDb(dbName));
                this.cleanUpTblsForFlagTests(dbName);
                return;
            }
            case ALTER_DATABASE: {
                return;
            }
        }
    }

    @Test
    public void testAlterDisableFlagFromDb() throws TException, CatalogException, MetastoreNotificationFetchException {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testAlterDisableFlagFromDb";
        eventsProcessor_.processEvents();
        Database alteredDb = catalog_.getDb(TEST_DB_NAME).getMetaStoreDb().deepCopy();
        alteredDb.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), "true");
        this.alterDatabase(alteredDb);
        this.createTable("testAlterDisableFlagFromDb", false);
        Assert.assertEquals((long)2L, (long)eventsProcessor_.getNextMetastoreEvents().size());
        long numSkippedEvents = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        eventsProcessor_.processEvents();
        Assert.assertEquals((long)(numSkippedEvents + 1L), (long)eventsProcessor_.getMetrics().getCounter("events-skipped").getCount());
        Assert.assertNull((String)"Table creation should be skipped when database level event sync flag is disabled", (Object)catalog_.getTable(TEST_DB_NAME, "testAlterDisableFlagFromDb"));
    }

    private void confirmTableIsLoaded(String dbName, String tblname) throws DatabaseNotFoundException {
        Table catalogTbl = catalog_.getTable(dbName, tblname);
        Assert.assertNotNull((Object)catalogTbl);
        Assert.assertFalse((String)"Table should not be invalidated after process events as it is a self-event.", (boolean)(catalogTbl instanceof IncompleteTable));
    }

    @Test
    public void testSelfEventsForTable() throws ImpalaException, TException {
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        String testTblName = "testSelfEventsForTable";
        this.createTableFromImpala(TEST_DB_NAME, "testSelfEventsForTable", true);
        Table testTbl = catalog_.getTable(TEST_DB_NAME, "testSelfEventsForTable");
        Assert.assertTrue((testTbl.getCreateEventId() == testTbl.getLastSyncedEventId() ? 1 : 0) != 0);
        eventsProcessor_.processEvents();
        long numberOfSelfEventsBefore = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        long lastSyncedEventIdBefore = testTbl.getLastSyncedEventId();
        this.alterTableSetTblPropertiesFromImpala("testSelfEventsForTable");
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((catalog_.getTable(TEST_DB_NAME, "testSelfEventsForTable").getLastSyncedEventId() > lastSyncedEventIdBefore ? 1 : 0) != 0);
        }
        this.alterTableAddColsFromImpala(TEST_DB_NAME, "testSelfEventsForTable", "newCol", TPrimitiveType.STRING);
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        this.alterTableRemoveColFromImpala(TEST_DB_NAME, "testSelfEventsForTable", "newCol");
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        this.alterTableReplaceColFromImpala(TEST_DB_NAME, "testSelfEventsForTable", Arrays.asList(MetastoreEventsProcessorTest.getScalarColumn("testCol", TPrimitiveType.STRING)));
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        TPartitionDef partitionDef = new TPartitionDef();
        partitionDef.addToPartition_spec(new TPartitionKeyValue("p1", "100"));
        partitionDef.addToPartition_spec(new TPartitionKeyValue("p2", "200"));
        this.alterTableSetFileFormatFromImpala(TEST_DB_NAME, "testSelfEventsForTable", THdfsFileFormat.TEXT);
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        this.alterTableSetRowFormatFromImpala(TEST_DB_NAME, "testSelfEventsForTable", ",");
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        this.alterTableSetOwnerFromImpala(TEST_DB_NAME, "testSelfEventsForTable", "testowner");
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTable");
        String newTblName = "newTableName";
        this.alterTableRenameFromImpala(TEST_DB_NAME, "testSelfEventsForTable", newTblName);
        this.loadTable(TEST_DB_NAME, newTblName);
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, newTblName);
        Table newTbl = catalog_.getTable(TEST_DB_NAME, newTblName);
        lastSyncedEventIdBefore = newTbl.getLastSyncedEventId();
        org.apache.hadoop.hive.metastore.api.Table hmsTbl = catalog_.getTable(TEST_DB_NAME, newTblName).getMetaStoreTable();
        Assert.assertNotNull((String)"Location is expected to be set to proceed forward in the test", (Object)hmsTbl.getSd().getLocation());
        String tblLocation = hmsTbl.getSd().getLocation();
        this.alterTableSetLocationFromImpala(TEST_DB_NAME, newTblName, tblLocation + "_changed");
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, newTblName);
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((catalog_.getTable(TEST_DB_NAME, newTblName).getLastSyncedEventId() > lastSyncedEventIdBefore ? 1 : 0) != 0);
        }
        long selfEventsCountAfter = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        Assert.assertEquals((String)"Unexpected number of self-events generated", (long)(numberOfSelfEventsBefore + 9L), (long)selfEventsCountAfter);
    }

    @Test
    public void testEventBatching() throws Exception {
        List partitions;
        org.apache.hadoop.hive.metastore.api.Table msTbl;
        String testTblName = "testEventBatching";
        this.createDatabaseFromImpala(TEST_DB_NAME, "test");
        this.createTable(TEST_DB_NAME, testTblName, true);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        partVals.add(Collections.singletonList("1"));
        partVals.add(Collections.singletonList("2"));
        this.addPartitions(TEST_DB_NAME, testTblName, partVals);
        eventsProcessor_.processEvents();
        HashMap<String, String> miscEventTypesToMessage = new HashMap<String, String>();
        this.createDatabaseFromImpala("database_to_be_dropped", "whatever");
        eventsProcessor_.processEvents();
        String currentLocation = catalog_.getDb("database_to_be_dropped").getMetaStoreDb().getLocationUri();
        String newLocation = currentLocation + File.separatorChar + "newTestLocation";
        Database alteredDb = catalog_.getDb("database_to_be_dropped").getMetaStoreDb().deepCopy();
        alteredDb.setLocationUri(newLocation);
        this.alterDatabase(alteredDb);
        List alterDbEvents = eventsProcessor_.getNextMetastoreEvents();
        Assert.assertEquals((long)1L, (long)alterDbEvents.size());
        Assert.assertEquals((Object)"ALTER_DATABASE", (Object)((NotificationEvent)alterDbEvents.get(0)).getEventType());
        miscEventTypesToMessage.put("ALTER_DATABASE", ((NotificationEvent)alterDbEvents.get(0)).getMessage());
        eventsProcessor_.processEvents();
        MetastoreEventsProcessorTest.dropDatabaseCascade("database_to_be_dropped");
        List dropDbEvents = eventsProcessor_.getNextMetastoreEvents();
        Assert.assertEquals((long)1L, (long)dropDbEvents.size());
        Assert.assertEquals((Object)"DROP_DATABASE", (Object)((NotificationEvent)dropDbEvents.get(0)).getEventType());
        miscEventTypesToMessage.put("DROP_DATABASE", ((NotificationEvent)dropDbEvents.get(0)).getMessage());
        eventsProcessor_.processEvents();
        this.createTable(TEST_DB_NAME, "table_before_rename", false);
        eventsProcessor_.processEvents();
        this.alterTableRename("table_before_rename", "table_after_rename", null);
        List alterTblEvents = eventsProcessor_.getNextMetastoreEvents();
        Assert.assertEquals((long)1L, (long)alterTblEvents.size());
        Assert.assertEquals((Object)"ALTER_TABLE", (Object)((NotificationEvent)alterTblEvents.get(0)).getEventType());
        miscEventTypesToMessage.put("ALTER_TABLE", ((NotificationEvent)alterTblEvents.get(0)).getMessage());
        eventsProcessor_.processEvents();
        this.dropTable("table_after_rename");
        eventsProcessor_.processEvents();
        this.alterPartitionsParams(TEST_DB_NAME, testTblName, "testkey", "val", partVals);
        List events = eventsProcessor_.getNextMetastoreEvents();
        NotificationEvent alterPartEvent = null;
        String alterPartitionEventType = "ALTER_PARTITION";
        for (NotificationEvent event : events) {
            if (!event.getEventType().equalsIgnoreCase(alterPartitionEventType)) continue;
            alterPartEvent = event;
            break;
        }
        Assert.assertNotNull(alterPartEvent);
        String alterPartMessage = alterPartEvent.getMessage();
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            msTbl = metaStoreClient.getHiveClient().getTable(TEST_DB_NAME, testTblName);
            partitions = MetastoreShim.getPartitions((IMetaStoreClient)metaStoreClient.getHiveClient(), (String)TEST_DB_NAME, (String)testTblName);
        }
        Assert.assertNotNull((Object)msTbl);
        Assert.assertNotNull((Object)partitions);
        eventsProcessor_.processEvents();
        for (Partition part : partitions) {
            this.simulateInsertIntoTableFromFS(msTbl, 1, part, false);
        }
        List insertEvents = eventsProcessor_.getNextMetastoreEvents();
        NotificationEvent insertEvent = null;
        for (NotificationEvent event : insertEvents) {
            if (!event.getEventType().equalsIgnoreCase("INSERT")) continue;
            insertEvent = event;
            break;
        }
        Assert.assertNotNull(insertEvent);
        HashMap<String, String> eventTypeToMessage = new HashMap<String, String>();
        eventTypeToMessage.put("ALTER_PARTITION", alterPartMessage);
        eventTypeToMessage.put("INSERT", insertEvent.getMessage());
        this.runEventBatchingTest(testTblName, eventTypeToMessage, miscEventTypesToMessage);
    }

    private void runEventBatchingTest(String testTblName, Map<String, String> eventTypeToMessage, Map<String, String> miscEventTypesToMessage) throws DatabaseNotFoundException, MetastoreNotificationException {
        Table tbl = catalog_.getTable(TEST_DB_NAME, testTblName);
        long lastSyncedEventId = tbl.getLastSyncedEventId();
        for (String eventType : eventTypeToMessage.keySet()) {
            String eventMessage = eventTypeToMessage.get(eventType);
            List<MetastoreEvents.MetastoreEvent> mockEvents = this.createMockEvents(lastSyncedEventId + 100L, 10, eventType, TEST_DB_NAME, testTblName, eventMessage);
            MetastoreEvents.MetastoreEventFactory eventFactory = eventsProcessor_.getEventsFactory();
            List batch = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)1L, (long)batch.size());
            Assert.assertTrue((boolean)(batch.get(0) instanceof MetastoreEvents.BatchPartitionEvent));
            MetastoreEvents.BatchPartitionEvent batchEvent = (MetastoreEvents.BatchPartitionEvent)batch.get(0);
            Assert.assertEquals((long)10L, (long)batchEvent.getBatchEvents().size());
            mockEvents = this.createMockEvents(lastSyncedEventId + 110L, 3, eventType, TEST_DB_NAME, "table2", eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 113L, 3, eventType, TEST_DB_NAME, "table1", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 116L, 1, eventType, TEST_DB_NAME, "table2", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 117L, 2, eventType, TEST_DB_NAME, "table1", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 119L, 1, eventType, TEST_DB_NAME, "table2", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 120L, 1, eventType, TEST_DB_NAME, "table1", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 121L, 2, eventType, TEST_DB_NAME, "table2", eventMessage));
            batch = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)2L, (long)batch.size());
            MetastoreEvents.BatchPartitionEvent batch1 = (MetastoreEvents.BatchPartitionEvent)batch.get(0);
            Assert.assertEquals((long)6L, (long)batch1.getNumberOfEvents());
            Assert.assertEquals((long)(lastSyncedEventId + 120L), (long)batch1.getEventId());
            Assert.assertEquals((Object)"table1", (Object)batch1.getTableName());
            MetastoreEvents.BatchPartitionEvent batch2 = (MetastoreEvents.BatchPartitionEvent)batch.get(1);
            Assert.assertEquals((long)7L, (long)batch2.getNumberOfEvents());
            Assert.assertEquals((long)(lastSyncedEventId + 122L), (long)batch2.getEventId());
            Assert.assertEquals((Object)"table2", (Object)batch2.getTableName());
            mockEvents = this.createMockEvents(lastSyncedEventId + 110L, 1, eventType, TEST_DB_NAME, "table1", eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 111L, 1, eventType, TEST_DB_NAME, "table2", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 112L, 1, eventType, TEST_DB_NAME, "table3", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 113L, 1, eventType, TEST_DB_NAME, "table4", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 114L, 1, eventType, TEST_DB_NAME, "table5", eventMessage));
            batch = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)5L, (long)batch.size());
            for (int i = 0; i < batch.size(); ++i) {
                MetastoreEvents.MetastoreEvent monotonicEvent = (MetastoreEvents.MetastoreEvent)batch.get(i);
                Assert.assertEquals((long)1L, (long)monotonicEvent.getNumberOfEvents());
                Assert.assertEquals((long)(lastSyncedEventId + 110L + (long)i), (long)monotonicEvent.getEventId());
                Assert.assertEquals((Object)("table" + (i + 1)), (Object)monotonicEvent.getTableName());
            }
            mockEvents = this.createMockEvents(lastSyncedEventId + 100L, 1, eventType, TEST_DB_NAME, testTblName, eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 101L, 1, eventType, "db1", testTblName, eventMessage));
            List batchEvents = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)2L, (long)batchEvents.size());
            for (MetastoreEvents.MetastoreEvent event : batchEvents) {
                if (eventType.equalsIgnoreCase("ALTER_PARTITION")) {
                    Assert.assertTrue((boolean)(event instanceof MetastoreEvents.AlterPartitionEvent));
                    continue;
                }
                Assert.assertTrue((boolean)(event instanceof MetastoreEvents.InsertEvent));
            }
            mockEvents = this.createMockEvents(lastSyncedEventId + 100L, 1, eventType, TEST_DB_NAME, testTblName, eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 101L, 1, eventType, TEST_DB_NAME, "testtbl", eventMessage));
            batchEvents = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)2L, (long)batchEvents.size());
            for (MetastoreEvents.MetastoreEvent event : batchEvents) {
                if (eventType.equalsIgnoreCase("ALTER_PARTITION")) {
                    Assert.assertTrue((boolean)(event instanceof MetastoreEvents.AlterPartitionEvent));
                    continue;
                }
                Assert.assertTrue((boolean)(event instanceof MetastoreEvents.InsertEvent));
            }
            mockEvents = this.createMockEvents(lastSyncedEventId + 100L, 1, eventType, "database_to_be_dropped", testTblName, eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 101L, 1, eventType, "other_database", testTblName, eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 102L, 1, "ALTER_DATABASE", "database_to_be_dropped", null, miscEventTypesToMessage.get("ALTER_DATABASE")));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 103L, 1, eventType, "database_to_be_dropped", testTblName, eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 104L, 1, eventType, "other_database", testTblName, eventMessage));
            batchEvents = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)4L, (long)batchEvents.size());
            Assert.assertTrue((boolean)(batchEvents.get(1) instanceof MetastoreEvents.AlterDatabaseEvent));
            Assert.assertEquals((Object)"database_to_be_dropped", (Object)((MetastoreEvents.MetastoreEvent)batchEvents.get(0)).getDbName());
            Assert.assertEquals((Object)"database_to_be_dropped", (Object)((MetastoreEvents.MetastoreEvent)batchEvents.get(2)).getDbName());
            Assert.assertEquals((Object)"other_database", (Object)((MetastoreEvents.MetastoreEvent)batchEvents.get(3)).getDbName());
            mockEvents = this.createMockEvents(lastSyncedEventId + 100L, 1, eventType, "database_to_be_dropped", testTblName, eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 101L, 1, eventType, "other_database", testTblName, eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 102L, 1, "DROP_DATABASE", "database_to_be_dropped", null, miscEventTypesToMessage.get("DROP_DATABASE")));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 103L, 1, eventType, "database_to_be_dropped", testTblName, eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 104L, 1, eventType, "other_database", testTblName, eventMessage));
            batchEvents = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)4L, (long)batchEvents.size());
            Assert.assertTrue((boolean)(batchEvents.get(1) instanceof MetastoreEvents.DropDatabaseEvent));
            Assert.assertEquals((Object)"database_to_be_dropped", (Object)((MetastoreEvents.MetastoreEvent)batchEvents.get(0)).getDbName());
            Assert.assertEquals((Object)"database_to_be_dropped", (Object)((MetastoreEvents.MetastoreEvent)batchEvents.get(2)).getDbName());
            Assert.assertEquals((Object)"other_database", (Object)((MetastoreEvents.MetastoreEvent)batchEvents.get(3)).getDbName());
            mockEvents = this.createMockEvents(lastSyncedEventId + 100L, 2, eventType, TEST_DB_NAME, "table_before_rename", eventMessage);
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 102L, 2, eventType, TEST_DB_NAME, "table_after_rename", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 104L, 1, eventType, TEST_DB_NAME, "other_table", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 105L, 1, "ALTER_TABLE", TEST_DB_NAME, "table_before_rename", miscEventTypesToMessage.get("ALTER_TABLE")));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 106L, 2, eventType, TEST_DB_NAME, "table_before_rename", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 108L, 2, eventType, TEST_DB_NAME, "table_after_rename", eventMessage));
            mockEvents.addAll(this.createMockEvents(lastSyncedEventId + 110L, 1, eventType, TEST_DB_NAME, "other_table", eventMessage));
            batchEvents = eventFactory.createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
            Assert.assertEquals((long)6L, (long)batchEvents.size());
            MetastoreEvents.BatchPartitionEvent altTblBatch0 = (MetastoreEvents.BatchPartitionEvent)batchEvents.get(0);
            Assert.assertEquals((long)2L, (long)altTblBatch0.getNumberOfEvents());
            Assert.assertEquals((Object)"table_before_rename", (Object)altTblBatch0.getTableName());
            MetastoreEvents.BatchPartitionEvent altTblBatch1 = (MetastoreEvents.BatchPartitionEvent)batchEvents.get(1);
            Assert.assertEquals((long)2L, (long)altTblBatch1.getNumberOfEvents());
            Assert.assertEquals((Object)"table_after_rename", (Object)altTblBatch1.getTableName());
            Assert.assertTrue((boolean)(batchEvents.get(2) instanceof MetastoreEvents.AlterTableEvent));
            MetastoreEvents.BatchPartitionEvent altTblBatch3 = (MetastoreEvents.BatchPartitionEvent)batchEvents.get(3);
            Assert.assertEquals((long)2L, (long)altTblBatch3.getNumberOfEvents());
            Assert.assertEquals((Object)"table_before_rename", (Object)altTblBatch3.getTableName());
            MetastoreEvents.BatchPartitionEvent altTblBatch4 = (MetastoreEvents.BatchPartitionEvent)batchEvents.get(4);
            Assert.assertEquals((long)2L, (long)altTblBatch4.getNumberOfEvents());
            Assert.assertEquals((Object)"table_after_rename", (Object)altTblBatch4.getTableName());
            MetastoreEvents.BatchPartitionEvent altTblBatch5 = (MetastoreEvents.BatchPartitionEvent)batchEvents.get(5);
            Assert.assertEquals((long)2L, (long)altTblBatch5.getNumberOfEvents());
            Assert.assertEquals((Object)"other_table", (Object)altTblBatch5.getTableName());
        }
        long startEventId = lastSyncedEventId + 117L;
        List<MetastoreEvents.MetastoreEvent> mockEvents = this.createMockEvents(startEventId, 3, "ALTER_PARTITION", TEST_DB_NAME, testTblName, eventTypeToMessage.get("ALTER_PARTITION"));
        mockEvents.addAll(this.createMockEvents(startEventId + (long)mockEvents.size(), 3, "INSERT", TEST_DB_NAME, testTblName, eventTypeToMessage.get("INSERT")));
        mockEvents.addAll(this.createMockEvents(startEventId + (long)mockEvents.size(), 1, "ALTER_PARTITION", TEST_DB_NAME, testTblName, eventTypeToMessage.get("ALTER_PARTITION")));
        mockEvents.addAll(this.createMockEvents(startEventId + (long)mockEvents.size(), 1, "INSERT", TEST_DB_NAME, testTblName, eventTypeToMessage.get("INSERT")));
        mockEvents.addAll(this.createMockEvents(startEventId + (long)mockEvents.size(), 1, "ALTER_PARTITION", TEST_DB_NAME, testTblName, eventTypeToMessage.get("ALTER_PARTITION")));
        mockEvents.addAll(this.createMockEvents(startEventId + (long)mockEvents.size(), 5, "INSERT", TEST_DB_NAME, testTblName, eventTypeToMessage.get("INSERT")));
        mockEvents.addAll(this.createMockEvents(startEventId + (long)mockEvents.size(), 5, "ALTER_PARTITION", TEST_DB_NAME, testTblName, eventTypeToMessage.get("ALTER_PARTITION")));
        List batchedEvents = eventsProcessor_.getEventsFactory().createBatchEvents(mockEvents, eventsProcessor_.getMetrics());
        Assert.assertEquals((long)7L, (long)batchedEvents.size());
        MetastoreEvents.BatchPartitionEvent batch1 = (MetastoreEvents.BatchPartitionEvent)batchedEvents.get(0);
        Assert.assertEquals((long)3L, (long)batch1.getNumberOfEvents());
        MetastoreEvents.BatchPartitionEvent batch2 = (MetastoreEvents.BatchPartitionEvent)batchedEvents.get(1);
        Assert.assertEquals((long)3L, (long)batch2.getNumberOfEvents());
        Assert.assertTrue((boolean)(batchedEvents.get(2) instanceof MetastoreEvents.AlterPartitionEvent));
        Assert.assertTrue((boolean)(batchedEvents.get(3) instanceof MetastoreEvents.InsertEvent));
        Assert.assertTrue((boolean)(batchedEvents.get(4) instanceof MetastoreEvents.AlterPartitionEvent));
        MetastoreEvents.BatchPartitionEvent batch6 = (MetastoreEvents.BatchPartitionEvent)batchedEvents.get(5);
        Assert.assertEquals((long)5L, (long)batch6.getNumberOfEvents());
        MetastoreEvents.BatchPartitionEvent batch7 = (MetastoreEvents.BatchPartitionEvent)batchedEvents.get(6);
        Assert.assertEquals((long)5L, (long)batch7.getNumberOfEvents());
    }

    private List<MetastoreEvents.MetastoreEvent> createMockEvents(long startEventId, int numEvents, String eventType, String dbName, String tblName, String message) throws MetastoreNotificationException {
        ArrayList<NotificationEvent> mockEvents = new ArrayList<NotificationEvent>();
        for (int i = 0; i < numEvents; ++i) {
            NotificationEvent mock = (NotificationEvent)Mockito.mock(NotificationEvent.class);
            Mockito.when((Object)mock.getEventId()).thenReturn((Object)startEventId);
            Mockito.when((Object)mock.getEventType()).thenReturn((Object)eventType);
            Mockito.when((Object)mock.getDbName()).thenReturn((Object)dbName);
            Mockito.when((Object)mock.getTableName()).thenReturn((Object)tblName);
            Mockito.when((Object)mock.getMessage()).thenReturn((Object)message);
            mockEvents.add(mock);
            ++startEventId;
        }
        ArrayList<MetastoreEvents.MetastoreEvent> metastoreEvents = new ArrayList<MetastoreEvents.MetastoreEvent>();
        for (NotificationEvent notificationEvent : mockEvents) {
            metastoreEvents.add(eventsProcessor_.getEventsFactory().get(notificationEvent, eventsProcessor_.getMetrics()));
        }
        return metastoreEvents;
    }

    @Test
    public void testCommitEvent() throws TException, ImpalaException, IOException {
        TBackendGflags origCfg = BackendConfig.INSTANCE.getBackendCfg();
        try {
            TBackendGflags stubCfg = origCfg.deepCopy();
            stubCfg.setHms_event_incremental_refresh_transactional_table(true);
            stubCfg.setEnable_sync_to_latest_event_on_ddls(true);
            BackendConfig.create((TBackendGflags)stubCfg);
            this.createDatabase(TEST_DB_NAME, null);
            this.testInsertIntoTransactionalTable("testCommitEvent_transactional", false, false);
            this.testInsertIntoTransactionalTable("testCommitEvent_transactional_part", false, true);
        }
        finally {
            BackendConfig.create((TBackendGflags)origCfg);
        }
    }

    @Test
    public void testAbortEvent() throws TException, ImpalaException, IOException {
        TBackendGflags origCfg = BackendConfig.INSTANCE.getBackendCfg();
        try {
            TBackendGflags stubCfg = origCfg.deepCopy();
            stubCfg.setHms_event_incremental_refresh_transactional_table(true);
            stubCfg.setEnable_sync_to_latest_event_on_ddls(true);
            BackendConfig.create((TBackendGflags)stubCfg);
            this.createDatabase(TEST_DB_NAME, null);
            this.testInsertIntoTransactionalTable("testAbortEvent_transactional", true, false);
            this.testInsertIntoTransactionalTable("testAbortEvent_transactional_part", true, true);
        }
        finally {
            BackendConfig.create((TBackendGflags)origCfg);
        }
    }

    private void testInsertIntoTransactionalTable(String tblName, boolean toAbort, boolean isPartitioned) throws TException, CatalogException, TransactionException, IOException {
        this.createTransactionalTable(TEST_DB_NAME, tblName, isPartitioned);
        if (isPartitioned) {
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(Arrays.asList("1"));
            this.addPartitions(TEST_DB_NAME, tblName, partVals);
        }
        eventsProcessor_.processEvents();
        this.loadTable(tblName);
        HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, tblName);
        long lastSyncedEventId = tbl.getLastSyncedEventId();
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            long txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
            long writeId = MetastoreShim.allocateTableWriteId((IMetaStoreClient)client.getHiveClient(), (long)txnId, (String)TEST_DB_NAME, (String)tblName);
            eventsProcessor_.processEvents();
            if (isPartitioned) {
                Assert.assertTrue((String)String.format("Expected last synced event id: %s for table %s to be greater than %s", tbl.getLastSyncedEventId(), tbl.getFullName(), lastSyncedEventId), (tbl.getLastSyncedEventId() > lastSyncedEventId ? 1 : 0) != 0);
            }
            lastSyncedEventId = tbl.getLastSyncedEventId();
            ValidWriteIdList writeIdList = tbl.getValidWriteIds();
            Assert.assertFalse((boolean)writeIdList.isWriteIdValid(writeId));
            Assert.assertFalse((boolean)writeIdList.isWriteIdAborted(writeId));
            Partition partition = null;
            if (isPartitioned) {
                partition = client.getHiveClient().getPartition(TEST_DB_NAME, tblName, Arrays.asList("1"));
            }
            this.simulateInsertIntoTransactionalTableFromFS(tbl.getMetaStoreTable(), partition, 1, txnId, writeId);
            if (toAbort) {
                MetastoreShim.abortTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
            } else {
                MetastoreShim.commitTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
            }
            eventsProcessor_.processEvents();
            String partName = isPartitioned ? "p1=1" : "";
            int numFiles = ((HdfsPartition)tbl.getPartitionsForNames(Collections.singletonList(partName)).get(0)).getNumFileDescriptors();
            writeIdList = tbl.getValidWriteIds();
            if (toAbort) {
                Assert.assertEquals((long)0L, (long)numFiles);
                if (isPartitioned) {
                    Assert.assertTrue((String)String.format("Expected last synced event id: %s for table %s to be greater than %s", tbl.getLastSyncedEventId(), tbl.getFullName(), lastSyncedEventId), (tbl.getLastSyncedEventId() > lastSyncedEventId ? 1 : 0) != 0);
                }
            } else {
                Assert.assertTrue((boolean)writeIdList.isWriteIdValid(writeId));
                Assert.assertEquals((long)1L, (long)numFiles);
                Assert.assertTrue((String)String.format("Expected last synced event id: %s for table %s to be greater than %s", tbl.getLastSyncedEventId(), tbl.getFullName(), lastSyncedEventId), (tbl.getLastSyncedEventId() > lastSyncedEventId ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterPartitionNotReloadFMD() throws Exception {
        TBackendGflags origCfg = BackendConfig.INSTANCE.getBackendCfg();
        try {
            TBackendGflags stubCfg = origCfg.deepCopy();
            stubCfg.setHms_event_incremental_refresh_transactional_table(true);
            BackendConfig.create((TBackendGflags)stubCfg);
            String testTblName = "testAlterPartitionNotReloadFMD";
            this.createDatabase(TEST_DB_NAME, null);
            this.createTransactionalTable(TEST_DB_NAME, testTblName, true);
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(Arrays.asList("1"));
            this.addPartitions(TEST_DB_NAME, testTblName, partVals);
            try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
                long txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
                long writeId = MetastoreShim.allocateTableWriteId((IMetaStoreClient)client.getHiveClient(), (long)txnId, (String)TEST_DB_NAME, (String)testTblName);
                Partition partition = client.getHiveClient().getPartition(TEST_DB_NAME, testTblName, Arrays.asList("1"));
                org.apache.hadoop.hive.metastore.api.Table table = client.getHiveClient().getTable(TEST_DB_NAME, testTblName);
                this.simulateInsertIntoTransactionalTableFromFS(table, partition, 1, txnId, writeId);
                MetastoreShim.commitTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
            }
            eventsProcessor_.processEvents();
            this.loadTable(testTblName);
            HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, testTblName);
            this.alterPartitionsParamsInTxn(TEST_DB_NAME, testTblName, "testAlterPartition", "true", partVals);
            Assert.assertNull(((HdfsPartition)tbl.getPartitionsForNames(Collections.singletonList("p1=1")).get(0)).getParameters().get("testAlterPartition"));
            long numLoadFMDBefore = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
            List FDbefore = ((HdfsPartition)tbl.getPartitionsForNames(Collections.singletonList("p1=1")).get(0)).getFileDescriptors();
            eventsProcessor_.processEvents();
            Assert.assertNotNull(((HdfsPartition)tbl.getPartitionsForNames(Collections.singletonList("p1=1")).get(0)).getParameters().get("testAlterPartition"));
            long numLoadFMDAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
            List FDafter = ((HdfsPartition)tbl.getPartitionsForNames(Collections.singletonList("p1=1")).get(0)).getFileDescriptors();
            Assert.assertEquals((String)"File metadata should not be reloaded", (long)numLoadFMDBefore, (long)numLoadFMDAfter);
            Assert.assertEquals((Object)Lists.transform((List)FDbefore, (Function)HdfsPartition.FileDescriptor.TO_BYTES), (Object)Lists.transform((List)FDafter, (Function)HdfsPartition.FileDescriptor.TO_BYTES));
        }
        finally {
            BackendConfig.create((TBackendGflags)origCfg);
        }
    }

    @Test
    public void testAlterTableNoFileMetadataReload() throws Exception {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testAlterTableNoFileMetadataReload";
        this.createTable("testAlterTableNoFileMetadataReload", true);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        partVals.add(Arrays.asList("1"));
        this.addPartitions(TEST_DB_NAME, "testAlterTableNoFileMetadataReload", partVals);
        eventsProcessor_.processEvents();
        this.loadTable("testAlterTableNoFileMetadataReload");
        HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterTableNoFileMetadataReload");
        long fileMetadataLoadBefore = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        this.alterTableAddCol("testAlterTableNoFileMetadataReload", "newCol", "string", "");
        eventsProcessor_.processEvents();
        this.altertableChangeCol("testAlterTableNoFileMetadataReload", "newCol", "int", null);
        eventsProcessor_.processEvents();
        this.alterTableSetOwner("testAlterTableNoFileMetadataReload", "testOwner");
        eventsProcessor_.processEvents();
        this.alterTableAddParameter("testAlterTableNoFileMetadataReload", "dummyKey1", "dummyValue1");
        eventsProcessor_.processEvents();
        tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterTableNoFileMetadataReload");
        long fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertEquals((long)fileMetadataLoadAfter, (long)fileMetadataLoadBefore);
        this.alterTableAddParameter("testAlterTableNoFileMetadataReload", "EXTERNAL", "true");
        eventsProcessor_.processEvents();
        tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterTableNoFileMetadataReload");
        fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertNotEquals((long)fileMetadataLoadAfter, (long)fileMetadataLoadBefore);
        fileMetadataLoadBefore = fileMetadataLoadAfter;
        this.alterTableAddParameter("testAlterTableNoFileMetadataReload", "EXTERNAL", "false");
        eventsProcessor_.processEvents();
        tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterTableNoFileMetadataReload");
        fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertNotEquals((long)fileMetadataLoadAfter, (long)fileMetadataLoadBefore);
        fileMetadataLoadBefore = fileMetadataLoadAfter;
        this.alterTableAddParameter("testAlterTableNoFileMetadataReload", "EXTERNAL", "false");
        eventsProcessor_.processEvents();
        tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterTableNoFileMetadataReload");
        fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertEquals((long)fileMetadataLoadAfter, (long)fileMetadataLoadBefore);
        this.alterTableAddParameter("testAlterTableNoFileMetadataReload", "EXTERNAL", null);
        eventsProcessor_.processEvents();
        tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterTableNoFileMetadataReload");
        fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertNotEquals((long)fileMetadataLoadAfter, (long)fileMetadataLoadBefore);
    }

    @Test
    public void testAlterTableSdVerifyMetadataReload() throws Exception {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testSdFileMetadataReload";
        this.createTable("testSdFileMetadataReload", true);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        partVals.add(Arrays.asList("1"));
        this.addPartitions(TEST_DB_NAME, "testSdFileMetadataReload", partVals);
        eventsProcessor_.processEvents();
        this.loadTable("testSdFileMetadataReload");
        HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testSdFileMetadataReload");
        long fileMetadataLoadBefore = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        LOG.info("Test changes in file format for an Alter table statement");
        org.apache.hadoop.hive.metastore.api.Table hmsTbl = catalog_.getTable(TEST_DB_NAME, "testSdFileMetadataReload").getMetaStoreTable();
        hmsTbl.getSd().setInputFormat("org.apache.hadoop.mapred.TextInputFormat");
        hmsTbl.getSd().setOutputFormat("org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
        long fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
        fileMetadataLoadBefore = fileMetadataLoadAfter;
        LOG.info("Test changes in row format for Alter table statement");
        hmsTbl = catalog_.getTable(TEST_DB_NAME, "testSdFileMetadataReload").getMetaStoreTable();
        hmsTbl.getSd().getSerdeInfo().setSerializerClass("org.apache.hadoop.hive.contrib.serde2.RegexSerDe");
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
        fileMetadataLoadBefore = fileMetadataLoadAfter;
        LOG.info("Test changes in table location for Alter table statement");
        hmsTbl = catalog_.getTable(TEST_DB_NAME, "testSdFileMetadataReload").getMetaStoreTable();
        Assert.assertNotNull((String)"Location is expected to be set to proceed forward in the test", (Object)hmsTbl.getSd().getLocation());
        String tblLocation = hmsTbl.getSd().getLocation() + "_changed";
        hmsTbl.getSd().setLocation(tblLocation);
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
        fileMetadataLoadBefore = fileMetadataLoadAfter;
        LOG.info("Test changes in storedAsSubDirectories from false to unset");
        hmsTbl = tbl.getMetaStoreTable().deepCopy();
        hmsTbl.getSd().unsetStoredAsSubDirectories();
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)fileMetadataLoadBefore, (long)fileMetadataLoadAfter);
        LOG.info("Test changes in storedAsSubDirectories from unset to true");
        hmsTbl.getSd().setStoredAsSubDirectories(true);
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
        fileMetadataLoadBefore = fileMetadataLoadAfter;
        LOG.info("Test changes in storedAsSubDirectories from true to false");
        hmsTbl.getSd().setStoredAsSubDirectories(false);
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
        LOG.info("Test changes in storedAsSubDirectories from unset to false");
        hmsTbl.getSd().unsetStoredAsSubDirectories();
        fileMetadataLoadBefore = fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        hmsTbl.getSd().setStoredAsSubDirectories(false);
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)fileMetadataLoadBefore, (long)fileMetadataLoadAfter);
        LOG.info("Test changes in non-trivial tbl props and same SD");
        hmsTbl = tbl.getMetaStoreTable().deepCopy();
        hmsTbl.getSd().setStoredAsSubDirectories(false);
        hmsTbl.getParameters().put("EXTERNAL", "false");
        fileMetadataLoadAfter = this.processAlterTableAndReturnMetric("testSdFileMetadataReload", hmsTbl);
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
    }

    private long processAlterTableAndReturnMetric(String testTblName, org.apache.hadoop.hive.metastore.api.Table msTbl) throws Exception {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, testTblName, msTbl, null);
        }
        eventsProcessor_.processEvents();
        HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, testTblName);
        return tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
    }

    @Test
    public void testAlterPartitionNoFileMetadataReload() throws Exception {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testAlterPartitionNoFileMetadataReload";
        this.createTable("testAlterPartitionNoFileMetadataReload", true);
        eventsProcessor_.processEvents();
        this.loadTable("testAlterPartitionNoFileMetadataReload");
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        partVals.add(Arrays.asList("1"));
        this.addPartitions(TEST_DB_NAME, "testAlterPartitionNoFileMetadataReload", partVals);
        eventsProcessor_.processEvents();
        Assert.assertEquals((String)"Unexpected number of partitions fetched for the loaded table", (long)1L, (long)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterPartitionNoFileMetadataReload")).getPartitions().size());
        HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterPartitionNoFileMetadataReload");
        long fileMetadataLoadBefore = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        partVals.clear();
        partVals.add(Arrays.asList("1"));
        String testKey = "randomDummyKey1";
        String testVal = "randomDummyVal1";
        this.alterPartitionsParams(TEST_DB_NAME, "testAlterPartitionNoFileMetadataReload", testKey, testVal, partVals);
        eventsProcessor_.processEvents();
        tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterPartitionNoFileMetadataReload");
        long fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertEquals((long)fileMetadataLoadAfter, (long)fileMetadataLoadBefore);
        Collection parts = FeCatalogUtils.loadAllPartitions((FeFsTable)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterPartitionNoFileMetadataReload")));
        FeFsPartition singlePartition = (FeFsPartition)Iterables.getOnlyElement((Iterable)parts);
        String val = singlePartition.getParameters().getOrDefault(testKey, null);
        Assert.assertNotNull((String)("Expected " + testKey + " to be present in partition parameters"), (Object)val);
        Assert.assertEquals((Object)testVal, (Object)val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterPartitionFileMetadataReload() throws Exception {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testAlterPartitionFileMetadataReload";
        this.createTable("testAlterPartitionFileMetadataReload", true);
        eventsProcessor_.processEvents();
        this.loadTable("testAlterPartitionFileMetadataReload");
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        partVals.add(Arrays.asList("1"));
        this.addPartitions(TEST_DB_NAME, "testAlterPartitionFileMetadataReload", partVals);
        eventsProcessor_.processEvents();
        Assert.assertEquals((String)"Unexpected number of partitions fetched for the loaded table", (long)1L, (long)((HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterPartitionFileMetadataReload")).getPartitions().size());
        HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, "testAlterPartitionFileMetadataReload");
        long fileMetadataLoadBefore = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        partVals.clear();
        partVals.add(Arrays.asList("1"));
        String newLocation = "/path/to/new_location/";
        this.alterPartitions("testAlterPartitionFileMetadataReload", partVals, newLocation);
        eventsProcessor_.processEvents();
        long fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
        String partName = FeCatalogUtils.getPartitionName((FeFsTable)tbl, (List)((List)partVals.get(0)));
        List partitionsToDrop = tbl.getPartitionsForNames(Arrays.asList(partName));
        tbl.dropPartitions(partitionsToDrop, false);
        Assert.assertEquals((long)0L, (long)tbl.getPartitions().size());
        fileMetadataLoadBefore = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Partition msPartition = null;
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            msPartition = metaStoreClient.getHiveClient().getPartition(TEST_DB_NAME, "testAlterPartitionFileMetadataReload", Arrays.asList("1"));
            HashMap<Partition, Object> mp = new HashMap<Partition, Object>();
            mp.put(msPartition, null);
            if (!catalog_.tryWriteLock((Table)tbl)) {
                throw new CatalogException("Couldn't acquire write lock on table: " + tbl.getFullName());
            }
            catalog_.getLock().writeLock().unlock();
            try {
                tbl.reloadPartitions(metaStoreClient.getHiveClient(), mp, FileMetadataLoadOpts.LOAD_IF_SD_CHANGED, (EventSequence)NoOpEventSequence.INSTANCE);
            }
            finally {
                if (tbl.isWriteLockedByCurrentThread()) {
                    tbl.releaseWriteLock();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)tbl.getPartitionsForNames(Arrays.asList(partName)).size());
        fileMetadataLoadAfter = tbl.getMetrics().getCounter("num-load-filemetadata").getCount();
        Assert.assertEquals((long)(fileMetadataLoadBefore + 1L), (long)fileMetadataLoadAfter);
    }

    @Test
    public void testSelfEventsWithInterleavedClients() throws Exception {
        this.createDatabase(TEST_DB_NAME, null);
        this.createTable("self_event_tbl", false);
        eventsProcessor_.processEvents();
        int numOfExecutions = 100;
        HiveAlterTableExecutor hiveExecutor = new HiveAlterTableExecutor(TEST_DB_NAME, "self_event_tbl");
        ImpalaAlterTableExecutor impalaExecutor = new ImpalaAlterTableExecutor(TEST_DB_NAME, "self_event_tbl");
        Random random = new Random(117L);
        for (int i = 0; i < numOfExecutions; ++i) {
            if (random.nextBoolean()) {
                ((AlterTableExecutor)hiveExecutor).execute();
                continue;
            }
            ((AlterTableExecutor)impalaExecutor).execute();
        }
    }

    @Test
    public void testSelfEventsForTableUnsupportedCases() throws Exception {
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        String testTblName = "testSelfEventsForTableUnsupportedCases";
        this.createTableFromImpala(TEST_DB_NAME, "testSelfEventsForTableUnsupportedCases", true);
        TPartitionDef partitionDef = new TPartitionDef();
        partitionDef.addToPartition_spec(new TPartitionKeyValue("p1", "100"));
        partitionDef.addToPartition_spec(new TPartitionKeyValue("p2", "200"));
        this.alterTableAddPartition(TEST_DB_NAME, "testSelfEventsForTableUnsupportedCases", partitionDef);
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForTableUnsupportedCases");
        TPartitionKeyValue partitionKeyValue1 = new TPartitionKeyValue("p1", "100");
        TPartitionKeyValue partitionKeyValue2 = new TPartitionKeyValue("p2", "200");
        this.alterTableDropPartition(TEST_DB_NAME, "testSelfEventsForTableUnsupportedCases", Arrays.asList(partitionKeyValue1, partitionKeyValue2));
        eventsProcessor_.processEvents();
        Assert.assertNotNull((Object)catalog_.getTable(TEST_DB_NAME, "testSelfEventsForTableUnsupportedCases"));
    }

    @Test
    public void testSelfEventsForPartition() throws ImpalaException, TException {
        this.createDatabase(TEST_DB_NAME, null);
        String testTblName = "testSelfEventsForPartition";
        this.createTable("testSelfEventsForPartition", true);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>(2);
        partVals.add(Arrays.asList("1"));
        partVals.add(Arrays.asList("2"));
        this.addPartitions(TEST_DB_NAME, "testSelfEventsForPartition", partVals);
        eventsProcessor_.processEvents();
        Table catalogTbl = catalog_.getTable(TEST_DB_NAME, "testSelfEventsForPartition");
        ArrayList<TPartitionKeyValue> partKeyVals = new ArrayList<TPartitionKeyValue>();
        partKeyVals.add(new TPartitionKeyValue("p1", "1"));
        long lastSyncedEventIdBefore = catalogTbl.getLastSyncedEventId();
        this.alterTableSetPartitionPropertiesFromImpala("testSelfEventsForPartition", partKeyVals);
        HdfsPartition hdfsPartition = catalog_.getHdfsPartition(TEST_DB_NAME, "testSelfEventsForPartition", partKeyVals);
        Assert.assertNotNull((Object)hdfsPartition.getParameters());
        Assert.assertEquals((Object)"dummyValue1", hdfsPartition.getParameters().get("dummyKey1"));
        eventsProcessor_.processEvents();
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            Assert.assertTrue((catalog_.getTable(TEST_DB_NAME, "testSelfEventsForPartition").getLastSyncedEventId() > lastSyncedEventIdBefore ? 1 : 0) != 0);
        }
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForPartition");
        Assert.assertEquals((String)"Partition should not have been refreshed after receiving self-event", (Object)hdfsPartition, (Object)catalog_.getHdfsPartition(TEST_DB_NAME, "testSelfEventsForPartition", partKeyVals));
        this.alterTableComputeStats("testSelfEventsForPartition", Arrays.asList(Arrays.asList("1"), Arrays.asList("2")));
        HdfsPartition part1Before = catalog_.getHdfsPartition(TEST_DB_NAME, "testSelfEventsForPartition", partKeyVals);
        ArrayList<TPartitionKeyValue> partKeyVals2 = new ArrayList<TPartitionKeyValue>();
        partKeyVals2.add(new TPartitionKeyValue("p1", "2"));
        HdfsPartition part2Before = catalog_.getHdfsPartition(TEST_DB_NAME, "testSelfEventsForPartition", partKeyVals2);
        Assert.assertTrue((eventsProcessor_.getNextMetastoreEvents().size() >= 2 ? 1 : 0) != 0);
        eventsProcessor_.processEvents();
        this.confirmTableIsLoaded(TEST_DB_NAME, "testSelfEventsForPartition");
        Assert.assertEquals((String)"Partition should not have been refreshed after receiving the self-event", (Object)part1Before, (Object)catalog_.getHdfsPartition(TEST_DB_NAME, "testSelfEventsForPartition", partKeyVals));
        Assert.assertEquals((String)"Partition should not have been refreshed after receiving the self-event", (Object)part2Before, (Object)catalog_.getHdfsPartition(TEST_DB_NAME, "testSelfEventsForPartition", partKeyVals2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkippingOlderEvents() throws Exception {
        boolean prevFlagVal = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        boolean invalidateHMSFlag = BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs();
        try {
            BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(true);
            BackendConfig.INSTANCE.setInvalidateCatalogdHMSCacheOnDDLs(false);
            BackendConfig.INSTANCE.setSkippingOlderEvents(true);
            this.createDatabase(TEST_DB_NAME, null);
            String testTblName = "testSkippingOlderEvents";
            this.createTable("testSkippingOlderEvents", true);
            eventsProcessor_.processEvents();
            HiveAlterTableExecutor hiveExecutor = new HiveAlterTableExecutor(TEST_DB_NAME, "testSkippingOlderEvents");
            ((AlterTableExecutor)hiveExecutor).execute();
            HdfsTable testTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, "testSkippingOlderEvents", "test", null);
            long lastSyncEventIdBefore = testTbl.getLastRefreshEventId();
            this.alterTableAddParameter("testSkippingOlderEvents", "somekey", "someval");
            eventsProcessor_.processEvents();
            Assert.assertEquals((long)testTbl.getLastRefreshEventId(), (long)eventsProcessor_.getCurrentEventId());
            Assert.assertTrue((testTbl.getLastRefreshEventId() > lastSyncEventIdBefore ? 1 : 0) != 0);
            this.confirmTableIsLoaded(TEST_DB_NAME, "testSkippingOlderEvents");
            String testUnpartTblName = "testUnPartSkippingOlderEvents";
            this.createTable("testUnPartSkippingOlderEvents", false);
            this.testInsertEvents(TEST_DB_NAME, "testUnPartSkippingOlderEvents", false);
            testTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, "testUnPartSkippingOlderEvents", "test", null);
            eventsProcessor_.processEvents();
            Assert.assertEquals((long)testTbl.getLastRefreshEventId(), (long)eventsProcessor_.getCurrentEventId());
            this.confirmTableIsLoaded(TEST_DB_NAME, "testUnPartSkippingOlderEvents");
            this.alterTableAddCol("testUnPartSkippingOlderEvents", "newCol", "string", "test new column");
            testTbl = (HdfsTable)catalog_.getOrLoadTable(TEST_DB_NAME, "testUnPartSkippingOlderEvents", "test", null);
            lastSyncEventIdBefore = testTbl.getLastRefreshEventId();
            catalog_.reloadTable((Table)testTbl, "test", (EventSequence)NoOpEventSequence.INSTANCE);
            eventsProcessor_.processEvents();
            Assert.assertEquals((long)testTbl.getLastRefreshEventId(), (long)eventsProcessor_.getCurrentEventId());
            Assert.assertTrue((testTbl.getLastRefreshEventId() > lastSyncEventIdBefore ? 1 : 0) != 0);
            this.confirmTableIsLoaded(TEST_DB_NAME, "testSkippingOlderEvents");
        }
        finally {
            BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(prevFlagVal);
            BackendConfig.INSTANCE.setInvalidateCatalogdHMSCacheOnDDLs(invalidateHMSFlag);
        }
    }

    @Test
    public void testSkipFetchOpenTransactionEvent() throws Exception {
        long currentEventId = eventsProcessor_.getCurrentEventId();
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            long txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
            Assert.assertEquals((long)(currentEventId + 1L), (long)eventsProcessor_.getCurrentEventId());
            eventsProcessor_.updateLatestEventId();
            Assert.assertEquals((long)(currentEventId + 1L), (long)eventsProcessor_.getLatestEventId());
            MetastoreShim.commitTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
            Assert.assertEquals((long)(currentEventId + 2L), (long)eventsProcessor_.getCurrentEventId());
            eventsProcessor_.updateLatestEventId();
            Assert.assertEquals((long)(currentEventId + 2L), (long)eventsProcessor_.getLatestEventId());
            List events = eventsProcessor_.getNextMetastoreEvents();
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)MetastoreEvents.MetastoreEventType.COMMIT_TXN, (Object)MetastoreEvents.MetastoreEventType.from((String)((NotificationEvent)events.get(0)).getEventType()));
            Assert.assertEquals((long)currentEventId, (long)eventsProcessor_.getLastSyncedEventId());
            eventsProcessor_.processEvents();
            Assert.assertEquals((long)(currentEventId + 2L), (long)eventsProcessor_.getLastSyncedEventId());
            currentEventId = eventsProcessor_.getCurrentEventId();
            txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
            Assert.assertEquals((long)(currentEventId + 1L), (long)eventsProcessor_.getCurrentEventId());
            events = eventsProcessor_.getNextMetastoreEvents();
            Assert.assertEquals((long)0L, (long)events.size());
            Assert.assertEquals((long)currentEventId, (long)eventsProcessor_.getLastSyncedEventId());
            eventsProcessor_.processEvents();
            Assert.assertEquals((long)(currentEventId + 1L), (long)eventsProcessor_.getLastSyncedEventId());
            MetastoreShim.commitTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
            Assert.assertEquals((long)(currentEventId + 2L), (long)eventsProcessor_.getCurrentEventId());
        }
    }

    @Test
    public void testFetchEventsInBatchWithOpenTxnAsLastEvent() throws Exception {
        long currentEventId = eventsProcessor_.getCurrentEventId();
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            long txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
            Assert.assertEquals((long)(currentEventId + 1L), (long)eventsProcessor_.getCurrentEventId());
            List events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)currentEventId, null, null);
            Assert.assertEquals((long)0L, (long)events.size());
            MetastoreShim.commitTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
            Assert.assertEquals((long)(currentEventId + 2L), (long)eventsProcessor_.getCurrentEventId());
        }
    }

    @Test
    public void testNotFetchingUnwantedEvents() throws Exception {
        String tblName = "test_event_skip_list";
        this.createDatabase(TEST_DB_NAME, null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "true");
        params.put("external.table.purge", "true");
        this.createTable(null, TEST_DB_NAME, tblName, params, true, "EXTERNAL_TABLE");
        eventsProcessor_.processEvents();
        Table tbl = catalog_.getTable(TEST_DB_NAME, tblName);
        Assert.assertTrue((String)"tbl should be unloaded", (boolean)(tbl instanceof IncompleteTable));
        long createEventId = tbl.getCreateEventId();
        Assert.assertEquals((long)eventsProcessor_.getLatestEventId(), (long)createEventId);
        try (HiveJdbcClientPool jdbcClientPool = HiveJdbcClientPool.create(1);
             HiveJdbcClientPool.HiveJdbcClient hiveClient = jdbcClientPool.getClient();){
            hiveClient.executeSql("set hive.exec.dynamic.partition.mode=nonstrict");
            hiveClient.executeSql(String.format("insert into %s.%s partition(p1) values (0,0,0),(1,1,1)", TEST_DB_NAME, tblName));
            hiveClient.executeSql(String.format("analyze table %s.%s compute statistics for columns", TEST_DB_NAME, tblName));
        }
        List events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)createEventId, null, (String[])new String[0]);
        Assert.assertEquals((long)5L, (long)events.size());
        events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)createEventId, null, (String[])new String[]{"CREATE_TABLE"});
        Assert.assertEquals((long)0L, (long)events.size());
        events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)createEventId, null, (String[])new String[]{"ADD_PARTITION"});
        Assert.assertEquals((long)1L, (long)events.size());
        events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)MetastoreEventsProcessorTest.eventsProcessor_.catalog_, (long)createEventId, null, (String[])new String[]{"ALTER_PARTITION"});
        Assert.assertEquals((long)2L, (long)events.size());
    }

    @Test(expected=MetastoreNotificationFetchException.class)
    public void testHMSClientFailureInGettingCurrentEventId() throws Exception {
        MetaStoreClientPool origPool = catalog_.getMetaStoreClientPool();
        try {
            IncompetentMetastoreClientPool badPool = new IncompetentMetastoreClientPool(0, 0);
            catalog_.setMetaStoreClientPool(badPool);
            eventsProcessor_.getCurrentEventId();
        }
        finally {
            catalog_.setMetaStoreClientPool(origPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=MetastoreNotificationFetchException.class)
    public void testHMSClientFailureInFetchingEvents() throws Exception {
        MetaStoreClientPool origPool = catalog_.getMetaStoreClientPool();
        try {
            IncompetentMetastoreClientPool badPool = new IncompetentMetastoreClientPool(0, 0);
            catalog_.setMetaStoreClientPool(badPool);
            long currentEventId = eventsProcessor_.getLastSyncedEventId() + 1L;
            eventsProcessor_.getNextMetastoreEvents(currentEventId);
        }
        finally {
            catalog_.setMetaStoreClientPool(origPool);
        }
    }

    @Test(expected=MetastoreNotificationFetchException.class)
    public void testHMSClientFailureInFetchingEventsInBatches() throws Exception {
        MetaStoreClientPool origPool = catalog_.getMetaStoreClientPool();
        try {
            IncompetentMetastoreClientPool badPool = new IncompetentMetastoreClientPool(0, 0);
            catalog_.setMetaStoreClientPool(badPool);
            MetastoreEventsProcessor.getNextMetastoreEventsInBatches((CatalogServiceCatalog)catalog_, (long)0L, null, null);
        }
        finally {
            catalog_.setMetaStoreClientPool(origPool);
        }
    }

    @Test
    public void testHMSClientFailureInGettingEventTime() {
        MetaStoreClientPool origPool = catalog_.getMetaStoreClientPool();
        try {
            IncompetentMetastoreClientPool badPool = new IncompetentMetastoreClientPool(0, 0);
            catalog_.setMetaStoreClientPool(badPool);
            Assert.assertEquals((long)0L, (long)eventsProcessor_.getEventTimeFromHMS(0L));
        }
        finally {
            catalog_.setMetaStoreClientPool(origPool);
        }
    }

    @Test
    public void testAllocWriteIdEventForPartTableWithoutLoad() throws Exception {
        String tblName = "test_alloc_writeid_part_table";
        this.testAllocWriteIdEvent(tblName, true, false);
    }

    @Test
    public void testAllocWriteIdEventForNonPartTableWithoutLoad() throws Exception {
        String tblName = "test_alloc_writeid_table";
        this.testAllocWriteIdEvent(tblName, false, false);
    }

    @Test
    public void testAllocWriteIdEventForPartTable() throws Exception {
        String tblName = "test_alloc_writeid_part_table_load";
        this.testAllocWriteIdEvent(tblName, true, true);
    }

    @Test
    public void testAllocWriteIdEventForNonPartTable() throws Exception {
        String tblName = "test_alloc_writeid_table_load";
        this.testAllocWriteIdEvent(tblName, false, true);
    }

    @Test
    public void testReloadEventOnLoadedTable() throws Exception {
        String tblName = "test_reload";
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        this.createTable(tblName, false);
        MetastoreShim.fireReloadEventHelper((MetaStoreClientPool.MetaStoreClient)catalog_.getMetaStoreClient(), (boolean)true, null, (String)TEST_DB_NAME, (String)tblName, Collections.emptyMap());
        List events = eventsProcessor_.getNextMetastoreEvents();
        List filteredEvents = eventsProcessor_.getEventsFactory().getFilteredEvents(events, eventsProcessor_.getMetrics());
        Assert.assertTrue((filteredEvents.size() == 2 ? 1 : 0) != 0);
        MetastoreEvents.MetastoreEvent event = (MetastoreEvents.MetastoreEvent)filteredEvents.get(0);
        Assert.assertEquals((Object)MetastoreEvents.MetastoreEventType.CREATE_TABLE, (Object)event.getEventType());
        event.processIfEnabled();
        this.loadTable(tblName);
        event = (MetastoreEvents.MetastoreEvent)filteredEvents.get(1);
        Assert.assertEquals((Object)MetastoreEvents.MetastoreEventType.RELOAD, (Object)event.getEventType());
        long refreshCount = eventsProcessor_.getMetrics().getCounter("tables-refreshed").getCount();
        event.processIfEnabled();
        Assert.assertEquals((long)(refreshCount + 1L), (long)eventsProcessor_.getMetrics().getCounter("tables-refreshed").getCount());
        long skipCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        event.processIfEnabled();
        Assert.assertEquals((long)(skipCount + 1L), (long)eventsProcessor_.getMetrics().getCounter("events-skipped").getCount());
    }

    @Test
    public void testCommitCompactionEventOnLoadedTable() throws Exception {
        String tblName = "test_commit_compaction";
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        this.createTransactionalTable(TEST_DB_NAME, tblName, false);
        this.insertIntoTable(TEST_DB_NAME, tblName);
        this.insertIntoTable(TEST_DB_NAME, tblName);
        this.alterTableAddParameter(tblName, MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), "true");
        try (HiveJdbcClientPool jdbcClientPool = HiveJdbcClientPool.create(1);
             HiveJdbcClientPool.HiveJdbcClient hiveClient = jdbcClientPool.getClient();){
            hiveClient.executeSql("alter table events_test_db." + tblName + " compact 'minor' and wait");
        }
        List events = eventsProcessor_.getNextMetastoreEvents();
        List filteredEvents = eventsProcessor_.getEventsFactory().getFilteredEvents(events, eventsProcessor_.getMetrics());
        Assert.assertTrue((filteredEvents.size() > 1 ? 1 : 0) != 0);
        MetastoreEvents.MetastoreEvent event = (MetastoreEvents.MetastoreEvent)filteredEvents.get(0);
        Assert.assertEquals((Object)MetastoreEvents.MetastoreEventType.CREATE_TABLE, (Object)event.getEventType());
        event.processIfEnabled();
        this.loadTable(tblName);
        event = (MetastoreEvents.MetastoreEvent)filteredEvents.get(filteredEvents.size() - 1);
        Assert.assertEquals((Object)MetastoreEvents.MetastoreEventType.COMMIT_COMPACTION, (Object)event.getEventType());
        long skipCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
        event.processIfEnabled();
        Assert.assertEquals((long)(skipCount + 1L), (long)eventsProcessor_.getMetrics().getCounter("events-skipped").getCount());
    }

    @Test
    public void testEventProcessorErrorState() throws Exception {
        boolean prevFlagVal = BackendConfig.INSTANCE.isInvalidateGlobalMetadataOnEventProcessFailureEnabled();
        try {
            BackendConfig.INSTANCE.setInvalidateGlobalMetadataOnEventProcessFailure(true);
            this.createDatabase(TEST_DB_NAME, null);
            eventsProcessor_.updateStatus(MetastoreEventsProcessor.EventProcessorStatus.NEEDS_INVALIDATE);
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            MetastoreEventsProcessorTest.dropDatabaseCascadeFromHMS();
            eventsProcessor_.updateStatus(MetastoreEventsProcessor.EventProcessorStatus.ERROR);
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        }
        finally {
            BackendConfig.INSTANCE.setInvalidateGlobalMetadataOnEventProcessFailure(prevFlagVal);
        }
    }

    @Test
    public void testCreateTblOnUnloadedDB() throws Exception {
        eventsProcessor_.pause();
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.PAUSED, (Object)eventsProcessor_.getStatus());
        Assert.assertNull((String)"Test database should not be in catalog when event processing is stopped", (Object)catalog_.getDb(TEST_DB_NAME));
        long currentEventId = eventsProcessor_.getCurrentEventId();
        eventsProcessor_.start(currentEventId);
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
        String tblName = "test_create_tbl";
        this.createTable(tblName, false);
        eventsProcessor_.processEvents();
        Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
    }

    private void insertIntoTable(String dbName, String tableName) throws Exception {
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = client.getHiveClient().getTable(dbName, tableName);
            long txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
            long writeId = MetastoreShim.allocateTableWriteId((IMetaStoreClient)client.getHiveClient(), (long)txnId, (String)dbName, (String)tableName);
            this.simulateInsertIntoTransactionalTableFromFS(msTable, null, 1, txnId, writeId);
            MetastoreShim.commitTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
        }
    }

    public void testAllocWriteIdEvent(String tblName, boolean isPartitioned, boolean isLoadTable) throws TException, TransactionException, CatalogException {
        long writeId;
        long txnId;
        this.createDatabase(TEST_DB_NAME, null);
        eventsProcessor_.processEvents();
        this.createTransactionalTable(TEST_DB_NAME, tblName, isPartitioned);
        if (isLoadTable) {
            eventsProcessor_.processEvents();
            this.loadTable(tblName);
        }
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            txnId = MetastoreShim.openTransaction((IMetaStoreClient)client.getHiveClient());
            writeId = MetastoreShim.allocateTableWriteId((IMetaStoreClient)client.getHiveClient(), (long)txnId, (String)TEST_DB_NAME, (String)tblName);
            eventsProcessor_.processEvents();
            MetastoreShim.abortTransaction((IMetaStoreClient)client.getHiveClient(), (long)txnId);
        }
        Table table = catalog_.getTableNoThrow(TEST_DB_NAME, tblName);
        Assert.assertNotNull((String)"Table is not present in catalog", (Object)table);
        Set writeIds = catalog_.getWriteIds(txnId);
        Assert.assertEquals((long)1L, (long)writeIds.size());
        Assert.assertTrue((boolean)writeIds.contains(new TableWriteId(TEST_DB_NAME, tblName, table.getCreateEventId(), writeId)));
        if (isLoadTable) {
            Assert.assertTrue((boolean)(table instanceof HdfsTable));
            if (isPartitioned) {
                Assert.assertEquals((long)writeId, (long)table.getValidWriteIds().getHighWatermark());
            } else {
                Assert.assertNotEquals((long)writeId, (long)table.getValidWriteIds().getHighWatermark());
            }
        } else {
            Assert.assertTrue((boolean)(table instanceof IncompleteTable));
            Assert.assertNull((Object)table.getValidWriteIds());
        }
    }

    @Test
    public void testNotificationEventRequest() throws Exception {
        long currentEventId = eventsProcessor_.getCurrentEventId();
        int EVENTS_BATCH_SIZE_PER_RPC = 1000;
        this.createDatabaseFromImpala(TEST_DB_NAME, null);
        String testDbParamKey = "testKey";
        String testDbParamVal = "testVal";
        String testTable1 = "testNotifyTable1";
        String testTable2 = "testNotifyTable2";
        this.addDatabaseParameters(testDbParamKey, testDbParamVal);
        eventsProcessor_.processEvents();
        this.testInsertIntoTransactionalTable(testTable1, true, false);
        this.alterTableAddColsFromImpala(TEST_DB_NAME, testTable1, "newCol", TPrimitiveType.STRING);
        this.alterTableRemoveColFromImpala(TEST_DB_NAME, testTable1, "newCol");
        eventsProcessor_.processEvents();
        this.createTable(testTable2, false);
        eventsProcessor_.processEvents();
        this.alterTableSetOwnerFromImpala(TEST_DB_NAME, testTable2, "testowner");
        this.alterTableSetFileFormatFromImpala(TEST_DB_NAME, testTable2, THdfsFileFormat.TEXT);
        eventsProcessor_.processEvents();
        IMetaStoreClient.NotificationFilter filter = event -> "CREATE_DATABASE".equals(event.getEventType());
        MetastoreEventsProcessor.MetaDataFilter metaDataFilter = new MetastoreEventsProcessor.MetaDataFilter(filter, MetastoreShim.getDefaultCatalogName(), TEST_DB_NAME);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)1L);
        Db db = catalog_.getDb(TEST_DB_NAME);
        metaDataFilter.setNotificationFilter(MetastoreEventsProcessor.getDbNotificationEventFilter((Db)db));
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)2L);
        filter = event -> "ALTER_TABLE".equals(event.getEventType());
        metaDataFilter = new MetastoreEventsProcessor.MetaDataFilter(filter, MetastoreShim.getDefaultCatalogName(), TEST_DB_NAME, testTable1);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)2L);
        metaDataFilter.setNotificationFilter(null);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)3L);
        filter = event -> "ALTER_TABLE".equals(event.getEventType());
        metaDataFilter = new MetastoreEventsProcessor.MetaDataFilter(filter, MetastoreShim.getDefaultCatalogName(), TEST_DB_NAME, testTable2);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)2L);
        metaDataFilter.setNotificationFilter(null);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)3L);
        filter = event -> "ALTER_TABLE".equals(event.getEventType());
        metaDataFilter = new MetastoreEventsProcessor.MetaDataFilter(filter, MetastoreShim.getDefaultCatalogName(), TEST_DB_NAME);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)4L);
        metaDataFilter.setNotificationFilter(null);
        Assert.assertEquals((long)MetastoreEventsProcessor.getNextMetastoreEventsWithFilterInBatches((CatalogServiceCatalog)catalog_, (long)currentEventId, (MetastoreEventsProcessor.MetaDataFilter)metaDataFilter, (int)EVENTS_BATCH_SIZE_PER_RPC, (String[])new String[0]).size(), (long)8L);
    }

    @Test
    public void testAlterTableWithEpDisabled() throws Exception {
        try {
            this.createDatabaseFromImpala(TEST_DB_NAME, null);
            String testTable = "testAlterTableNoError";
            this.createTableFromImpala(TEST_DB_NAME, testTable, true);
            eventsProcessor_.processEvents();
            eventsProcessor_.pause();
            long numberOfSelfEventsBefore = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            TPartitionDef partitionDef = new TPartitionDef();
            partitionDef.addToPartition_spec(new TPartitionKeyValue("p1", "100"));
            partitionDef.addToPartition_spec(new TPartitionKeyValue("p2", "200"));
            this.alterTableAddPartition(TEST_DB_NAME, testTable, partitionDef, "enable_event_processor");
            eventsProcessor_.processEvents();
            Assert.assertEquals((Object)MetastoreEventsProcessor.EventProcessorStatus.ACTIVE, (Object)eventsProcessor_.getStatus());
            long numberOfSelfEventsAfter = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            Assert.assertEquals((String)"Unexpected self events skipped: ", (long)numberOfSelfEventsAfter, (long)(numberOfSelfEventsBefore + 1L));
        }
        catch (NullPointerException ex) {
            throw new CatalogException("Exception occured while applying AlterTableEvent", (Throwable)ex);
        }
        finally {
            if (eventsProcessor_.getStatus() != MetastoreEventsProcessor.EventProcessorStatus.ACTIVE) {
                eventsProcessor_.start();
            }
        }
    }

    private void createDatabase(String catName, String dbName, Map<String, String> params) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.createDatabase(msClient, catName, dbName, params);
        }
    }

    private void createDatabase(String dbName, Map<String, String> params) throws TException {
        this.createDatabase(null, dbName, params);
    }

    private void createHiveCatalog(String catName) throws TException {
        Catalog catalog = new Catalog();
        catalog.setName(catName);
        catalog.setLocationUri(Files.createTempDir().getAbsolutePath());
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            metaStoreClient.getHiveClient().createCatalog(catalog);
        }
    }

    private void dropHiveCatalogIfExists(String catName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            if (msClient.getHiveClient().getCatalogs().contains(catName)) {
                for (String db : msClient.getHiveClient().getAllDatabases(catName)) {
                    msClient.getHiveClient().dropDatabase(catName, db, true, true, true);
                }
                msClient.getHiveClient().dropCatalog(catName);
            }
        }
    }

    private void addDatabaseParameters(String key, String val) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.addDatabaseParametersInHms(msClient, TEST_DB_NAME, key, val);
        }
    }

    private void alterDatabase(Database newDatabase) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().alterDatabase(newDatabase.getName(), newDatabase);
        }
    }

    private void createTransactionalTable(String dbName, String tblName, boolean isPartitioned) throws TException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transactional", "true");
        params.put("transactional_properties", "insert_only");
        this.createTable(null, dbName, tblName, params, isPartitioned, "MANAGED_TABLE");
    }

    private void createTable(String catName, String dbName, String tblName, Map<String, String> params, boolean isPartitioned, String tableType) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.createTable(msClient, catName, dbName, tblName, params, isPartitioned, tableType);
        }
    }

    private void dropTableFromImpala(String dbName, String tblName) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.DROP_TABLE);
        TDropTableOrViewParams dropTableParams = new TDropTableOrViewParams();
        dropTableParams.setTable_name(new TTableName(dbName, tblName));
        dropTableParams.setIf_exists(true);
        req.setDrop_table_or_view_params(dropTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    public static void createDatabaseFromImpala(CatalogOpExecutor catalogOpExecutor, String dbName, String desc) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.CREATE_DATABASE);
        TCreateDbParams createDbParams = new TCreateDbParams();
        createDbParams.setDb(dbName);
        createDbParams.setComment(desc);
        req.setCreate_db_params(createDbParams);
        catalogOpExecutor.execDdlRequest(req);
    }

    private void createDatabaseFromImpala(String dbName, String desc) throws ImpalaException {
        MetastoreEventsProcessorTest.createDatabaseFromImpala(catalogOpExecutor_, dbName, desc);
    }

    private void alterDbSetOwnerFromImpala(String dbName, String owner, TOwnerType ownerType) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_DATABASE);
        TAlterDbParams alterDbParams = new TAlterDbParams();
        alterDbParams.setDb(dbName);
        alterDbParams.setAlter_type(TAlterDbType.SET_OWNER);
        TAlterDbSetOwnerParams alterDbSetOwnerParams = new TAlterDbSetOwnerParams();
        alterDbSetOwnerParams.setOwner_name(owner);
        alterDbSetOwnerParams.setOwner_type(ownerType);
        alterDbParams.setSet_owner_params(alterDbSetOwnerParams);
        req.setAlter_db_params(alterDbParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void dropDatabaseCascadeFromImpala(String dbName) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.DROP_DATABASE);
        TDropDbParams dropDbParams = new TDropDbParams();
        dropDbParams.setDb(dbName);
        dropDbParams.setCascade(true);
        req.setDrop_db_params(dropDbParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void createTableLike(String srcDb, String srcTbl, String destDb, String destTbl) throws Exception {
        HdfsTable table = (HdfsTable)catalog_.getOrLoadTable(srcDb, srcTbl, "Test", null);
        TCreateTableLikeParams createTableLikeParams = new TCreateTableLikeParams();
        createTableLikeParams.setSrc_table_name(new TTableName(srcDb, srcTbl));
        createTableLikeParams.setTable_name(new TTableName(destDb, destTbl));
        createTableLikeParams.setIs_external(false);
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.CREATE_TABLE_LIKE);
        req.create_table_like_params = createTableLikeParams;
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void createTableFromImpala(String dbName, String tblName, boolean isPartitioned) throws ImpalaException {
        this.createTableFromImpala(dbName, tblName, null, isPartitioned);
    }

    public static void createTableFromImpala(CatalogOpExecutor opExecutor, String dbName, String tblName, Map<String, String> tblParams, boolean isPartitioned) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.CREATE_TABLE);
        TCreateTableParams createTableParams = new TCreateTableParams();
        createTableParams.setTable_name(new TTableName(dbName, tblName));
        createTableParams.setFile_format(THdfsFileFormat.PARQUET);
        createTableParams.setIs_external(false);
        createTableParams.setIf_not_exists(false);
        if (tblParams != null) {
            createTableParams.setTable_properties(tblParams);
        }
        ArrayList<TColumn> columns = new ArrayList<TColumn>(2);
        columns.add(MetastoreEventsProcessorTest.getScalarColumn("c1", TPrimitiveType.STRING));
        columns.add(MetastoreEventsProcessorTest.getScalarColumn("c2", TPrimitiveType.STRING));
        createTableParams.setColumns(columns);
        if (isPartitioned) {
            ArrayList<TColumn> partitionColumns = new ArrayList<TColumn>(2);
            partitionColumns.add(MetastoreEventsProcessorTest.getScalarColumn("p1", TPrimitiveType.INT));
            partitionColumns.add(MetastoreEventsProcessorTest.getScalarColumn("p2", TPrimitiveType.STRING));
            createTableParams.setPartition_columns(partitionColumns);
        }
        req.setCreate_table_params(createTableParams);
        opExecutor.execDdlRequest(req);
    }

    private void createTableFromImpala(String dbName, String tblName, Map<String, String> tblParams, boolean isPartitioned) throws ImpalaException {
        MetastoreEventsProcessorTest.createTableFromImpala(catalogOpExecutor_, dbName, tblName, tblParams, isPartitioned);
    }

    private void createScalarFunctionFromImpala(ScalarFunction fn) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.CREATE_FUNCTION);
        TCreateFunctionParams createFunctionParams = new TCreateFunctionParams();
        createFunctionParams.setFn(fn.toThrift());
        req.setCreate_fn_params(createFunctionParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void dropScalarFunctionFromImapala(ScalarFunction fn) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.DROP_FUNCTION);
        TDropFunctionParams dropFunctionParams = new TDropFunctionParams();
        dropFunctionParams.setFn_name(fn.getFunctionName().toThrift());
        dropFunctionParams.setArg_types(fn.toThrift().getArg_types());
        dropFunctionParams.setSignature(fn.toThrift().getSignature());
        req.setDrop_fn_params(dropFunctionParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void renameTableFromImpala(String oldTblName, String newTblName) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableOrViewRenameParams renameParams = new TAlterTableOrViewRenameParams();
        renameParams.new_table_name = new TTableName(TEST_DB_NAME, newTblName);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setAlter_type(TAlterTableType.RENAME_TABLE);
        alterTableParams.setTable_name(new TTableName(TEST_DB_NAME, oldTblName));
        alterTableParams.setRename_params(renameParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableAddColsFromImpala(String dbName, String tblName, String colName, TPrimitiveType colType) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.ADD_COLUMNS);
        TAlterTableAddColsParams addColsParams = new TAlterTableAddColsParams();
        addColsParams.addToColumns(MetastoreEventsProcessorTest.getScalarColumn(colName, colType));
        alterTableParams.setAdd_cols_params(addColsParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
        Table tbl = catalog_.getTable(dbName, tblName);
        Assert.assertNotNull((Object)tbl.getColumn(colName));
    }

    private void alterTableRemoveColFromImpala(String dbName, String tblName, String colName) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.DROP_COLUMN);
        TAlterTableDropColParams dropColParams = new TAlterTableDropColParams();
        dropColParams.setCol_name(colName);
        alterTableParams.setDrop_col_params(dropColParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
        Table tbl = catalog_.getTable(dbName, tblName);
        Assert.assertNull((Object)tbl.getColumn(colName));
    }

    private void alterTableReplaceColFromImpala(String dbName, String tblName, List<TColumn> newCols) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.REPLACE_COLUMNS);
        TAlterTableReplaceColsParams replaceColsParams = new TAlterTableReplaceColsParams();
        replaceColsParams.setColumns(newCols);
        alterTableParams.setReplace_cols_params(replaceColsParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
        Table tbl = catalog_.getTable(dbName, tblName);
        Assert.assertNotNull((Object)tbl.getColumn(newCols.get(0).getColumnName()));
    }

    private void alterTableAddPartition(String dbName, String tblName, TPartitionDef partitionDef) throws ImpalaException {
        this.alterTableAddPartition(dbName, tblName, partitionDef, null);
    }

    private void alterTableAddPartition(String dbName, String tblName, TPartitionDef partitionDef, String debugActions) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        TDdlQueryOptions queryOptions = new TDdlQueryOptions();
        if (debugActions != null) {
            queryOptions.setDebug_action(debugActions);
        }
        req.setQuery_options(queryOptions);
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.ADD_PARTITION);
        TAlterTableAddPartitionParams addPartitionParams = new TAlterTableAddPartitionParams();
        addPartitionParams.addToPartitions(partitionDef);
        alterTableParams.setAdd_partition_params(addPartitionParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableDropPartition(String dbName, String tblName, List<TPartitionKeyValue> keyValue) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.DROP_PARTITION);
        TAlterTableDropPartitionParams dropPartitionParams = new TAlterTableDropPartitionParams();
        dropPartitionParams.addToPartition_set(keyValue);
        alterTableParams.setDrop_partition_params(dropPartitionParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableSetFileFormatFromImpala(String dbName, String tblName, THdfsFileFormat fileformat) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.SET_FILE_FORMAT);
        TAlterTableSetFileFormatParams fileFormatParams = new TAlterTableSetFileFormatParams();
        fileFormatParams.setFile_format(fileformat);
        alterTableParams.setSet_file_format_params(fileFormatParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableSetRowFormatFromImpala(String dbName, String tblName, String fieldTerminator) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.SET_ROW_FORMAT);
        TAlterTableSetRowFormatParams rowFormatParams = new TAlterTableSetRowFormatParams();
        TTableRowFormat rowFormat = new TTableRowFormat();
        rowFormat.setField_terminator(fieldTerminator);
        rowFormatParams.setRow_format(rowFormat);
        alterTableParams.setSet_row_format_params(rowFormatParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableSetOwnerFromImpala(String dbName, String tblName, String owner) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.SET_OWNER);
        TAlterTableOrViewSetOwnerParams alterTableOrViewSetOwnerParams = new TAlterTableOrViewSetOwnerParams();
        alterTableOrViewSetOwnerParams.setOwner_name(owner);
        alterTableOrViewSetOwnerParams.setOwner_type(TOwnerType.USER);
        alterTableParams.setSet_owner_params(alterTableOrViewSetOwnerParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableSetLocationFromImpala(String dbName, String tblName, String location) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.SET_LOCATION);
        TAlterTableSetLocationParams setLocationParams = new TAlterTableSetLocationParams();
        setLocationParams.setLocation(location);
        alterTableParams.setSet_location_params(setLocationParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableRenameFromImpala(String dbName, String tblName, String newTable) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(dbName, tblName));
        alterTableParams.setAlter_type(TAlterTableType.RENAME_TABLE);
        TAlterTableOrViewRenameParams renameParams = new TAlterTableOrViewRenameParams();
        renameParams.setNew_table_name(new TTableName(dbName, newTable));
        alterTableParams.setRename_params(renameParams);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableSetTblPropertiesFromImpala(String tblName) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(TEST_DB_NAME, tblName));
        TAlterTableSetTblPropertiesParams setTblPropertiesParams = new TAlterTableSetTblPropertiesParams();
        setTblPropertiesParams.setTarget(TTablePropertyType.TBL_PROPERTY);
        HashMap<String, String> propertiesMap = new HashMap<String, String>(){
            {
                this.put("dummyKey1", "dummyValue1");
            }
        };
        setTblPropertiesParams.setProperties((Map)propertiesMap);
        alterTableParams.setSet_tbl_properties_params(setTblPropertiesParams);
        alterTableParams.setAlter_type(TAlterTableType.SET_TBL_PROPERTIES);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
        Table catalogTbl = catalog_.getTable(TEST_DB_NAME, tblName);
        Assert.assertNotNull((Object)catalogTbl.getMetaStoreTable().getParameters());
        Assert.assertEquals((Object)"dummyValue1", catalogTbl.getMetaStoreTable().getParameters().get("dummyKey1"));
    }

    private void alterTableComputeStats(String tblName, List<List<String>> partValsList) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setAlter_type(TAlterTableType.UPDATE_STATS);
        alterTableParams.setTable_name(new TTableName(TEST_DB_NAME, tblName));
        req.setAlter_table_params(alterTableParams);
        TAlterTableUpdateStatsParams updateStatsParams = new TAlterTableUpdateStatsParams();
        TTableStats tTableStats = new TTableStats();
        tTableStats.num_rows = 10L;
        tTableStats.total_file_bytes = 1000L;
        updateStatsParams.setTable_stats(tTableStats);
        HashMap<List<String>, TPartitionStats> partitionStats = new HashMap<List<String>, TPartitionStats>();
        for (List<String> partVals : partValsList) {
            TPartitionStats partStats = new TPartitionStats();
            partStats.stats = new TTableStats();
            partStats.stats.num_rows = 6L;
            partitionStats.put(partVals, partStats);
        }
        updateStatsParams.setPartition_stats(partitionStats);
        alterTableParams.setUpdate_stats_params(updateStatsParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void alterTableSetPartitionPropertiesFromImpala(String tblName, List<TPartitionKeyValue> partKeyVal) throws ImpalaException {
        TDdlExecRequest req = new TDdlExecRequest();
        req.setQuery_options(new TDdlQueryOptions());
        req.setDdl_type(TDdlType.ALTER_TABLE);
        TAlterTableParams alterTableParams = new TAlterTableParams();
        alterTableParams.setTable_name(new TTableName(TEST_DB_NAME, tblName));
        TAlterTableSetTblPropertiesParams setTblPropertiesParams = new TAlterTableSetTblPropertiesParams();
        ArrayList<List<TPartitionKeyValue>> partitionsToAlter = new ArrayList<List<TPartitionKeyValue>>();
        partitionsToAlter.add(partKeyVal);
        setTblPropertiesParams.setPartition_set(partitionsToAlter);
        setTblPropertiesParams.setTarget(TTablePropertyType.TBL_PROPERTY);
        HashMap<String, String> propertiesMap = new HashMap<String, String>(){
            {
                this.put("dummyKey1", "dummyValue1");
            }
        };
        setTblPropertiesParams.setProperties((Map)propertiesMap);
        alterTableParams.setSet_tbl_properties_params(setTblPropertiesParams);
        alterTableParams.setAlter_type(TAlterTableType.SET_TBL_PROPERTIES);
        req.setAlter_table_params(alterTableParams);
        catalogOpExecutor_.execDdlRequest(req);
    }

    private void insertMulPartFromImpala(String tblName1, String tblName2, Map<String, TUpdatedPartition> updated_partitions, boolean overwrite) throws ImpalaException {
        String insert_mul_part = String.format("insert into table %s partition(p1, p2) select * from %s", tblName1, tblName2);
        TUpdateCatalogRequest testInsertRequest = this.createTestTUpdateCatalogRequest(TEST_DB_NAME, tblName1, insert_mul_part, updated_partitions, overwrite, -1L, -1L);
        catalogOpExecutor_.updateCatalog(testInsertRequest);
    }

    private void insertFromImpala(String tblName, boolean isPartitioned, String p1val, String p2val, boolean isOverwrite, List<String> files) throws ImpalaException {
        this.insertFromImpala(tblName, isPartitioned, p1val, p2val, isOverwrite, files, -1L, -1L);
    }

    private void insertFromImpala(String tblName, boolean isPartitioned, String p1val, String p2val, boolean isOverwrite, List<String> files, long txnId, long writeId) throws ImpalaException {
        String partition = String.format("partition (%s, %s)", p1val, p2val);
        String test_insert_tbl = String.format("insert into table %s %s values ('a','aa') ", tblName, isPartitioned ? partition : "");
        HashMap<String, TUpdatedPartition> updated_partitions = new HashMap<String, TUpdatedPartition>();
        TUpdatedPartition updatedPartition = new TUpdatedPartition();
        updatedPartition.setFiles(files);
        String created_part_str = isPartitioned ? String.format("%s/%s", p1val, p2val) : "";
        updated_partitions.put(created_part_str, updatedPartition);
        TUpdateCatalogRequest testInsertRequest = this.createTestTUpdateCatalogRequest(TEST_DB_NAME, tblName, test_insert_tbl, updated_partitions, isOverwrite, txnId, writeId);
        catalogOpExecutor_.updateCatalog(testInsertRequest);
    }

    private TUpdateCatalogRequest createTestTUpdateCatalogRequest(String dBName, String tableName, String redacted_sql_stmt, Map<String, TUpdatedPartition> updated_partitions, boolean isOverwrite, long txnId, long writeId) {
        TUpdateCatalogRequest tUpdateCatalogRequest = new TUpdateCatalogRequest();
        tUpdateCatalogRequest.setDb_name(dBName);
        tUpdateCatalogRequest.setTarget_table(tableName);
        tUpdateCatalogRequest.setUpdated_partitions(updated_partitions);
        tUpdateCatalogRequest.setHeader(new TCatalogServiceRequestHeader());
        tUpdateCatalogRequest.getHeader().setRedacted_sql_stmt(redacted_sql_stmt);
        if (isOverwrite) {
            tUpdateCatalogRequest.setIs_overwrite(true);
        }
        if (txnId > 0L) {
            tUpdateCatalogRequest.setTransaction_id(txnId);
        }
        if (writeId > 0L) {
            tUpdateCatalogRequest.setWrite_id(writeId);
        }
        return tUpdateCatalogRequest;
    }

    private static TColumn getScalarColumn(String colName, TPrimitiveType type) {
        TTypeNode tTypeNode = new TTypeNode(TTypeNodeType.SCALAR);
        tTypeNode.setScalar_type(new TScalarType(type));
        TColumnType columnType = new TColumnType(Arrays.asList(tTypeNode));
        return new TColumn(colName, columnType);
    }

    private TPartitionDef getScalarPartitionDef(List<String> partNames, List<String> partVals) {
        TPartitionDef partitionDef = new TPartitionDef();
        ArrayList<TPartitionKeyValue> partKeyVals = new ArrayList<TPartitionKeyValue>();
        int i = 0;
        for (String partName : partNames) {
            partKeyVals.add(new TPartitionKeyValue(partName, partVals.get(i)));
            ++i;
        }
        partitionDef.setPartition_spec(partKeyVals);
        return partitionDef;
    }

    private void createTable(String dbName, String tblName, boolean isPartitioned) throws TException {
        this.createTable(null, dbName, tblName, null, isPartitioned, null);
    }

    private void createTable(String tblName, boolean isPartitioned) throws TException {
        this.createTable(null, TEST_DB_NAME, tblName, null, isPartitioned, null);
    }

    private void dropTable(String tableName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            client.getHiveClient().dropTable(TEST_DB_NAME, tableName, true, false);
        }
    }

    private void alterTableRename(String tblName, String newTblName, String newDbName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table newTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            String dbName = newDbName != null ? newDbName : TEST_DB_NAME;
            newTable.setTableName(newTblName);
            newTable.setDbName(dbName);
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, newTable, null);
        }
    }

    private void alterTableAddParameter(String tblName, String key, String val) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            if (val == null) {
                msTable.getParameters().remove(key);
            } else {
                msTable.getParameters().put(key, val);
            }
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, msTable, null);
        }
    }

    private void alterTableChangeTrivialProperties(String tblName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            for (String parameter : MetastoreEvents.parametersToIgnore) {
                msTable.getParameters().put(parameter, "1234567");
            }
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, msTable, null);
        }
    }

    private void alterTableAddCol(String tblName, String colName, String colType, String comment) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            msTable.getSd().getCols().add(new FieldSchema(colName, colType, comment));
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, msTable, null);
        }
    }

    private void altertableChangeCol(String tblName, String colName, String colType, String comment) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            FieldSchema targetCol = null;
            for (FieldSchema col : msTable.getSd().getCols()) {
                if (!col.getName().equalsIgnoreCase(colName)) continue;
                targetCol = col;
                break;
            }
            Assert.assertNotNull((String)("Column " + colName + " does not exist"), (Object)targetCol);
            targetCol.setName(colName);
            targetCol.setType(colType);
            targetCol.setComment(comment);
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, msTable, null);
        }
    }

    private void alterTableRemoveCol(String tblName, String colName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            FieldSchema targetCol = null;
            for (FieldSchema col : msTable.getSd().getCols()) {
                if (!col.getName().equalsIgnoreCase(colName)) continue;
                targetCol = col;
                break;
            }
            Assert.assertNotNull((String)("Column " + colName + " does not exist"), (Object)targetCol);
            msTable.getSd().getCols().remove(targetCol);
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, msTable, null);
        }
    }

    private void alterTableSetOwner(String tblName, String newOwner) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table msTable = msClient.getHiveClient().getTable(TEST_DB_NAME, tblName);
            msTable.setOwner(newOwner);
            msTable.setOwnerType(PrincipalType.USER);
            msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, msTable, null);
        }
    }

    private void dropPartitions(String tblName, List<List<String>> partitionValues) throws TException {
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            for (List<String> partVals : partitionValues) {
                metaStoreClient.getHiveClient().dropPartition(TEST_DB_NAME, tblName, partVals, true);
            }
        }
    }

    private void alterPartitions(String tblName, List<List<String>> partValsList, String location) throws TException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            for (List<String> partVal : partValsList) {
                Partition partition = metaStoreClient.getHiveClient().getPartition(TEST_DB_NAME, tblName, partVal);
                partition.getSd().setLocation(location);
                partitions.add(partition);
            }
            metaStoreClient.getHiveClient().alter_partitions(TEST_DB_NAME, tblName, partitions);
        }
    }

    private void alterPartitionsParams(String db, String tblName, String key, String val, List<List<String>> partVals) throws Exception {
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            for (List<String> partVal : partVals) {
                Partition partition = metaStoreClient.getHiveClient().getPartition(db, tblName, partVal);
                partition.getParameters().put(key, val);
                partitions.add(partition);
            }
            metaStoreClient.getHiveClient().alter_partitions(db, tblName, partitions);
        }
    }

    private void alterPartitionsParamsInTxn(String db, String tblName, String key, String val, List<List<String>> partVals) throws Exception {
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            long txnId = MetastoreShim.openTransaction((IMetaStoreClient)metaStoreClient.getHiveClient());
            long writeId = MetastoreShim.allocateTableWriteId((IMetaStoreClient)metaStoreClient.getHiveClient(), (long)txnId, (String)db, (String)tblName);
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            for (List<String> partVal : partVals) {
                Partition partition = metaStoreClient.getHiveClient().getPartition(db, tblName, partVal);
                partition.getParameters().put(key, val);
                MetastoreShim.setWriteIdToMSPartition((Partition)partition, (long)writeId);
                partitions.add(partition);
            }
            metaStoreClient.getHiveClient().alter_partitions(db, tblName, partitions);
            MetastoreShim.commitTransaction((IMetaStoreClient)metaStoreClient.getHiveClient(), (long)txnId);
        }
    }

    private void alterPartitionsTrivial(String tblName, List<String> partVal) throws TException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            Partition partition = metaStoreClient.getHiveClient().getPartition(TEST_DB_NAME, tblName, partVal);
            for (String parameter : MetastoreEvents.parametersToIgnore) {
                partition.getParameters().put(parameter, "12334567");
                partitions.add(partition);
            }
            metaStoreClient.getHiveClient().alter_partitions(TEST_DB_NAME, tblName, partitions);
        }
    }

    private void addPartitions(String dbName, String tblName, List<List<String>> partitionValues) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.addPartitions(client, dbName, tblName, partitionValues);
        }
    }

    private Table loadTable(String dbName, String tblName) throws CatalogException {
        Table loadedTable = catalog_.getOrLoadTable(dbName, tblName, "test", null);
        Assert.assertFalse((String)"Table should have been loaded after getOrLoadTable call", (boolean)(loadedTable instanceof IncompleteTable));
        return loadedTable;
    }

    private Table loadTable(String tblName) throws CatalogException {
        return this.loadTable(TEST_DB_NAME, tblName);
    }

    static {
        LOG = LoggerFactory.getLogger(MetastoreEventsProcessorTest.class);
        CONF = new Configuration();
    }

    private class ImpalaAlterTableExecutor
    extends AlterTableExecutor {
        private final String tblName_;
        private final String colName_ = "impalaColName";
        private final TPrimitiveType colType_;
        private final AtomicBoolean toggle_;

        private ImpalaAlterTableExecutor(String dbName, String tblName) {
            this.colName_ = "impalaColName";
            this.colType_ = TPrimitiveType.STRING;
            this.toggle_ = new AtomicBoolean(true);
            this.tblName_ = tblName;
        }

        @Override
        public void execute() throws Exception {
            if (this.toggle_.get()) {
                MetastoreEventsProcessorTest.this.alterTableAddColsFromImpala(MetastoreEventsProcessorTest.TEST_DB_NAME, this.tblName_, "impalaColName", this.colType_);
            } else {
                MetastoreEventsProcessorTest.this.alterTableRemoveColFromImpala(MetastoreEventsProcessorTest.TEST_DB_NAME, this.tblName_, "impalaColName");
            }
            this.verify();
            this.toggle_.compareAndSet(this.toggle_.get(), !this.toggle_.get());
        }

        public void verify() throws Exception {
            long numTblsRefreshedBefore = this.getNumTblsRefreshed();
            eventsProcessor_.processEvents();
            Table catTable = catalog_.getTable(MetastoreEventsProcessorTest.TEST_DB_NAME, this.tblName_);
            Assert.assertNotNull((Object)catTable);
            Assert.assertFalse((boolean)(catTable instanceof IncompleteTable));
            Assert.assertTrue((numTblsRefreshedBefore == this.getNumTblsRefreshed() ? 1 : 0) != 0);
        }
    }

    private class HiveAlterTableExecutor
    extends AlterTableExecutor {
        private final String tblName_;
        private final String colName_ = "hiveColName";
        private final String colType_ = "string";
        private final AtomicBoolean toggle_;

        private HiveAlterTableExecutor(String dbName, String tblName) {
            this.colName_ = "hiveColName";
            this.colType_ = "string";
            this.toggle_ = new AtomicBoolean(true);
            this.tblName_ = tblName;
        }

        @Override
        public void execute() throws Exception {
            Table tblBefore = (Table)Preconditions.checkNotNull((Object)catalog_.getTable(MetastoreEventsProcessorTest.TEST_DB_NAME, this.tblName_));
            boolean incompleteBefore = tblBefore instanceof IncompleteTable;
            if (this.toggle_.get()) {
                MetastoreEventsProcessorTest.this.alterTableAddCol(this.tblName_, "hiveColName", "string", "");
            } else {
                MetastoreEventsProcessorTest.this.alterTableRemoveCol(this.tblName_, "hiveColName");
            }
            this.verify(incompleteBefore);
            this.toggle_.compareAndSet(this.toggle_.get(), !this.toggle_.get());
        }

        private void verify(boolean wasTblIncompleteBefore) throws Exception {
            long numTblsRefreshedBefore = this.getNumTblsRefreshed();
            eventsProcessor_.processEvents();
            Table catTable = catalog_.getTable(MetastoreEventsProcessorTest.TEST_DB_NAME, this.tblName_);
            Assert.assertNotNull((Object)catTable);
            if (wasTblIncompleteBefore) {
                Assert.assertTrue((String)"Table should not reloaded if its already incomplete", (boolean)(catTable instanceof IncompleteTable));
                Assert.assertTrue((numTblsRefreshedBefore == this.getNumTblsRefreshed() ? 1 : 0) != 0);
            } else {
                Assert.assertFalse((String)"Table should have been reloaded if its loaded before", (boolean)(catTable instanceof IncompleteTable));
                Assert.assertTrue((numTblsRefreshedBefore < this.getNumTblsRefreshed() ? 1 : 0) != 0);
            }
        }
    }

    private abstract class AlterTableExecutor {
        private AlterTableExecutor() {
        }

        protected abstract void execute() throws Exception;

        protected long getNumTblsRefreshed() {
            return eventsProcessor_.getMetrics().getCounter("tables-refreshed").getCount();
        }
    }

    private static class FakeCatalogServiceCatalogForFlagTests
    extends CatalogServiceCatalog {
        private String dbFlag_;
        private String dbName_;
        private String tblFlag_;
        private String tblName_;
        private static final List<String> TABLE_SYNC_PROPERTYLIST = Arrays.asList(MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey());

        private FakeCatalogServiceCatalogForFlagTests(boolean loadInBackground, int numLoadingThreads, String localLibraryPath, MetaStoreClientPool metaStoreClientPool) throws ImpalaException {
            super(loadInBackground, numLoadingThreads, localLibraryPath, metaStoreClientPool);
        }

        public static CatalogServiceCatalog create() {
            FakeCatalogServiceCatalogForFlagTests cs;
            FeSupport.loadLibrary();
            try {
                cs = new FakeCatalogServiceCatalogForFlagTests(false, 16, System.getProperty("java.io.tmpdir"), new MetaStoreClientPool(0, 0));
                cs.setAuthzManager((AuthorizationManager)new NoopAuthorizationFactory.NoopAuthorizationManager());
                cs.setMetastoreEventProcessor(NoOpEventProcessor.getInstance());
                cs.reset((EventSequence)NoOpEventSequence.INSTANCE);
            }
            catch (ImpalaException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            return cs;
        }

        public void setFlags(String dbName, String tblName, String dbFlag, String tblFlag) {
            Preconditions.checkNotNull((Object)dbName);
            Preconditions.checkNotNull((Object)tblName);
            this.dbFlag_ = dbFlag;
            this.dbName_ = dbName;
            this.tblFlag_ = tblFlag;
            this.tblName_ = tblName;
        }

        public String getDbProperty(String dbName, String propertyKey) {
            if (this.dbName_.equals(dbName)) {
                return this.dbFlag_;
            }
            return super.getDbProperty(dbName, propertyKey);
        }

        public List<String> getTableProperties(String dbName, String tblName, List<String> propertyKey) {
            if (TABLE_SYNC_PROPERTYLIST.equals(propertyKey) && this.dbName_.equals(dbName) && this.tblName_.equals(tblName)) {
                return Arrays.asList(this.tblFlag_);
            }
            return super.getTableProperties(dbName, tblName, propertyKey);
        }
    }

    private static class FakeCatalogOpExecutorForTests
    extends CatalogOpExecutor {
        public FakeCatalogOpExecutorForTests(CatalogServiceCatalog catalog, AuthorizationConfig authzConfig, AuthorizationManager authzManager, HiveJavaFunctionFactory hiveJavaFuncFactory) throws ImpalaException {
            super(catalog, authzConfig, authzManager, hiveJavaFuncFactory);
        }

        public static CatalogOpExecutor create() throws ImpalaException {
            return new FakeCatalogOpExecutorForTests(FakeCatalogServiceCatalogForFlagTests.create(), new NoopAuthorizationFactory().getAuthorizationConfig(), (AuthorizationManager)new NoopAuthorizationFactory.NoopAuthorizationManager(), new TestHiveJavaFunctionFactory());
        }
    }

    private static class HMSFetchNotificationsEventProcessor
    extends MetastoreEventsProcessor {
        HMSFetchNotificationsEventProcessor(CatalogOpExecutor catalogOp, long startSyncFromId, long pollingFrequencyInSec) throws CatalogException {
            super(catalogOp, startSyncFromId, pollingFrequencyInSec);
        }

        public List<NotificationEvent> getNextMetastoreEvents() throws MetastoreNotificationFetchException {
            Random rand = new Random();
            if (rand.nextInt(10) % 2 == 0) {
                throw new MetastoreNotificationFetchException("Fetch Exception");
            }
            return super.getNextMetastoreEvents();
        }
    }
}

