/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.Table;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Reference;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.HiveJdbcClientPool;
import org.apache.impala.testutil.ImpalaJdbcClient;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableInfoSelector;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialCatalogInfoWriteIdTest {
    private static final Logger LOG = LoggerFactory.getLogger(PartialCatalogInfoWriteIdTest.class);
    private static CatalogServiceCatalog catalog_;
    private static HiveJdbcClientPool hiveClientPool_;
    private static final String testDbName = "partial_catalog_info_test";
    private static final String testTblName = "insert_only";
    private static final String testPartitionedTbl = "insert_only_partitioned";
    private static final String testAcidTblName = "test_full_acid";
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupTestEnv() throws SQLException, ClassNotFoundException {
        catalog_ = CatalogServiceTestCatalog.create();
        hiveClientPool_ = HiveJdbcClientPool.create(1);
    }

    @AfterClass
    public static void shutdown() {
        if (catalog_ != null) {
            catalog_.close();
        }
        if (hiveClientPool_ != null) {
            hiveClientPool_.close();
        }
    }

    @Before
    public void createTestTbls() throws Exception {
        LOG.info("Creating test tables for {}", (Object)this.name.getMethodName());
        Stopwatch st = Stopwatch.createStarted();
        ImpalaJdbcClient client = ImpalaJdbcClient.createClientUsingHiveJdbcDriver();
        client.connect();
        try {
            client.execStatement("drop database if exists partial_catalog_info_test cascade");
            client.execStatement("create database partial_catalog_info_test");
            client.execStatement("create table " + PartialCatalogInfoWriteIdTest.getTestTblName() + " like functional.insert_only_transactional_table stored as parquet");
            client.execStatement("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (1)");
            client.execStatement("create table " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " (c1 int) partitioned by (part int) stored as parquet " + PartialCatalogInfoWriteIdTest.getTblProperties());
            client.execStatement("insert into " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " partition (part=1) values (1)");
        }
        finally {
            LOG.info("Time taken for createTestTbls {} msec", (Object)st.stop().elapsed(TimeUnit.MILLISECONDS));
            client.close();
        }
        catalog_.reset((EventSequence)NoOpEventSequence.INSTANCE);
    }

    private static String getTblProperties() {
        return "tblproperties ('transactional'='true', 'transactional_properties' = 'insert_only')";
    }

    @After
    public void dropTestTbls() throws Exception {
        client.connect();
        try (ImpalaJdbcClient client = ImpalaJdbcClient.createClientUsingHiveJdbcDriver();){
            client.execStatement("drop database if exists partial_catalog_info_test cascade");
        }
    }

    @Test
    public void testCatalogLoadWithWriteIds() throws CatalogException, InternalException, TException {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        this.invalidateTbl(testDbName, testTblName);
        long prevVersion = catalog_.getOrLoadTable(testDbName, testTblName, "test", null).getCatalogVersion();
        ValidWriteIdList validWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        TGetPartialCatalogObjectRequest req = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(validWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(req);
        Assert.assertEquals((Object)MetastoreShim.convertToTValidWriteIdList((ValidWriteIdList)validWriteIdList), (Object)response.table_info.valid_write_ids);
        Assert.assertTrue((catalog_.getTable(testDbName, testTblName).getCatalogVersion() == prevVersion ? 1 : 0) != 0);
    }

    @Test
    public void testCatalogBehindClientWriteIds() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        Table tbl = catalog_.getOrLoadTable(testDbName, testTblName, "test", null);
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        long previousVersion = tbl.getCatalogVersion();
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (2)");
        ValidWriteIdList validWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        TGetPartialCatalogObjectRequest req = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(validWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(req);
        Assert.assertEquals((Object)MetastoreShim.convertToTValidWriteIdList((ValidWriteIdList)validWriteIdList), (Object)response.table_info.valid_write_ids);
        Assert.assertTrue((catalog_.getTable(testDbName, testTblName).getCatalogVersion() > previousVersion ? 1 : 0) != 0);
    }

    @Test
    public void testCatalogAheadOfClientWriteIds() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        Table tbl = catalog_.getOrLoadTable(testDbName, testTblName, "test", null);
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        ValidWriteIdList validWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (2)");
        catalog_.invalidateTable(new TTableName(testDbName, testTblName), new Reference(), new Reference(), (EventSequence)NoOpEventSequence.INSTANCE);
        Table tblAfterReload = catalog_.getOrLoadTable(testDbName, testTblName, "test", null);
        long tblVersion = tblAfterReload.getCatalogVersion();
        TGetPartialCatalogObjectRequest req = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(validWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(req);
        TPartialPartitionInfo partialPartitionInfo = (TPartialPartitionInfo)Iterables.getOnlyElement((Iterable)response.table_info.partitions);
        Assert.assertEquals((long)1L, (long)partialPartitionInfo.file_descriptors.size());
        Assert.assertEquals((long)tblVersion, (long)catalog_.getOrLoadTable(testDbName, testTblName, "test", null).getCatalogVersion());
    }

    @Test
    public void testFetchGranularityWithWriteIds() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        Table tbl = catalog_.getOrLoadTable(testDbName, testPartitionedTbl, "test", null);
        long olderVersion = tbl.getCatalogVersion();
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        ValidWriteIdList olderWriteIdList = this.getValidWriteIdList(testDbName, testPartitionedTbl);
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " partition (part=2) values (2)");
        ValidWriteIdList currentWriteIdList = this.getValidWriteIdList(testDbName, testPartitionedTbl);
        TGetPartialCatalogObjectRequest request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(olderWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(request);
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartitionsSize());
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartition_prefixesSize());
        Assert.assertNotNull((Object)((TPartialPartitionInfo)response.getTable_info().getPartitions().get(0)).getFile_descriptors());
        Assert.assertNotNull((Object)((TPartialPartitionInfo)response.getTable_info().getPartitions().get(0)).getLocation());
        Assert.assertEquals((long)0L, (long)((TPartialPartitionInfo)response.getTable_info().getPartitions().get(0)).getLocation().getPrefix_index());
        Assert.assertNotNull((Object)((TPartialPartitionInfo)response.getTable_info().getPartitions().get(0)).getHdfs_storage_descriptor());
        Assert.assertNotNull((Object)((TPartialPartitionInfo)response.getTable_info().getPartitions().get(0)).getHms_parameters());
        request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(olderWriteIdList).wantPartitionNames().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partInfo : response.getTable_info().getPartitions()) {
            Assert.assertNull((Object)partInfo.getFile_descriptors());
            Assert.assertNull((Object)partInfo.getHdfs_storage_descriptor());
            Assert.assertNull((Object)partInfo.getLocation());
        }
        request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(currentWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)2L, (long)response.getTable_info().getPartitionsSize());
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartition_prefixesSize());
        for (TPartialPartitionInfo partInfo : response.getTable_info().getPartitions()) {
            Assert.assertNotNull((Object)partInfo.getFile_descriptors());
            Assert.assertNotNull((Object)partInfo.getHdfs_storage_descriptor());
            Assert.assertNotNull((Object)partInfo.getLocation());
            Assert.assertEquals((long)0L, (long)partInfo.getLocation().getPrefix_index());
        }
        long newerVersion = catalog_.getTable(testDbName, testPartitionedTbl).getCatalogVersion();
        Assert.assertTrue((newerVersion > olderVersion ? 1 : 0) != 0);
        request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(olderWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)2L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partitionInfo : response.getTable_info().getPartitions()) {
            if (partitionInfo.getName().equalsIgnoreCase("part=2")) {
                Assert.assertTrue((boolean)partitionInfo.getFile_descriptors().isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)partitionInfo.getFile_descriptors().isEmpty());
        }
    }

    private long getMetricCount(String db, String tbl, String name) throws CatalogException {
        return catalog_.getTable(db, tbl).getMetrics().getCounter(name).getCount();
    }

    @Test
    public void fetchAfterMajorCompaction() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        Table tbl = catalog_.getOrLoadTable(testDbName, testPartitionedTbl, "test", null);
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " partition (part=1) values (2)");
        ValidWriteIdList olderWriteIdList = this.getValidWriteIdList(testDbName, testPartitionedTbl);
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " partition (part=1) values (2)");
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " partition (part=2) values (2)");
        this.executeHiveSql("alter table " + PartialCatalogInfoWriteIdTest.getPartitionedTblName() + " partition(part=1) compact 'major' and wait");
        long numMisses = this.getMetricCount(testDbName, testPartitionedTbl, "filemetadata-cache-miss");
        long numHits = this.getMetricCount(testDbName, testPartitionedTbl, "filemetadata-cache-hit");
        ValidWriteIdList currentWriteIdList = this.getValidWriteIdList(testDbName, testPartitionedTbl);
        TGetPartialCatalogObjectRequest request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(currentWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(request);
        Assert.assertEquals((long)2L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partitionInfo : response.getTable_info().getPartitions()) {
            Assert.assertEquals((long)1L, (long)partitionInfo.getFile_descriptors().size());
            Assert.assertEquals((long)0L, (long)partitionInfo.getInsert_file_descriptors().size());
            Assert.assertEquals((long)0L, (long)partitionInfo.getDelete_file_descriptors().size());
        }
        long numMissesAfter = this.getMetricCount(testDbName, testPartitionedTbl, "filemetadata-cache-miss");
        long numHitsAfter = this.getMetricCount(testDbName, testPartitionedTbl, "filemetadata-cache-hit");
        Assert.assertEquals((long)(numHits + 2L), (long)numHitsAfter);
        Assert.assertEquals((long)numMisses, (long)numMissesAfter);
        request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(olderWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)2L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partitionInfo : response.getTable_info().getPartitions()) {
            if (partitionInfo.getName().equals("part=1")) {
                Assert.assertEquals((long)2L, (long)partitionInfo.getFile_descriptors().size());
            } else {
                Assert.assertTrue((boolean)partitionInfo.getFile_descriptors().isEmpty());
            }
            Assert.assertEquals((long)0L, (long)partitionInfo.getInsert_file_descriptors().size());
            Assert.assertEquals((long)0L, (long)partitionInfo.getDelete_file_descriptors().size());
        }
        numMisses = this.getMetricCount(testDbName, testPartitionedTbl, "filemetadata-cache-miss");
        numHits = this.getMetricCount(testDbName, testPartitionedTbl, "filemetadata-cache-hit");
        Assert.assertEquals((long)(numHitsAfter + 1L), (long)numHits);
        Assert.assertEquals((long)(numMissesAfter + 1L), (long)numMisses);
        request = new RequestBuilder().db(testDbName).tbl(testPartitionedTbl).writeId(currentWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)2L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partitionInfo : response.getTable_info().getPartitions()) {
            Assert.assertEquals((long)1L, (long)partitionInfo.getFile_descriptors().size());
            Assert.assertEquals((long)0L, (long)partitionInfo.getInsert_file_descriptors().size());
            Assert.assertEquals((long)0L, (long)partitionInfo.getDelete_file_descriptors().size());
        }
    }

    @Test
    public void testFetchAfterMinorCompaction() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        Table tbl = catalog_.getOrLoadTable(testDbName, testTblName, "test", null);
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (2)");
        ValidWriteIdList olderWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (3)");
        this.executeHiveSql("alter table " + PartialCatalogInfoWriteIdTest.getTestTblName() + " compact 'minor' and wait");
        ValidWriteIdList currentWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        long numMisses = this.getMetricCount(testDbName, testTblName, "filemetadata-cache-miss");
        long numHits = this.getMetricCount(testDbName, testTblName, "filemetadata-cache-hit");
        TGetPartialCatalogObjectRequest request = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(currentWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(request);
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partitionInfo : response.getTable_info().getPartitions()) {
            Assert.assertEquals((long)1L, (long)partitionInfo.getFile_descriptors().size());
        }
        long numMissesAfter = this.getMetricCount(testDbName, testTblName, "filemetadata-cache-miss");
        long numHitsAfter = this.getMetricCount(testDbName, testTblName, "filemetadata-cache-hit");
        Assert.assertEquals((long)(numHits + 1L), (long)numHitsAfter);
        Assert.assertEquals((long)numMisses, (long)numMissesAfter);
        request = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(olderWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo partitionInfo : response.getTable_info().getPartitions()) {
            Assert.assertEquals((long)2L, (long)partitionInfo.getFile_descriptors().size());
        }
        long numMisses1 = this.getMetricCount(testDbName, testTblName, "filemetadata-cache-miss");
        long numHits1 = this.getMetricCount(testDbName, testTblName, "filemetadata-cache-hit");
        Assert.assertEquals((long)(numMissesAfter + 1L), (long)numMisses1);
        Assert.assertEquals((long)numHitsAfter, (long)numHits1);
    }

    @Test
    public void testTableFileMetadataAfterMajorCompaction() throws Exception {
        this.testFileMetadataAfterCompaction(testTblName, "", true, 1);
    }

    @Test
    public void testTableFileMetadataAfterMinorCompaction() throws Exception {
        this.testFileMetadataAfterCompaction(testTblName, "", false, 1);
    }

    @Test
    public void testPartitionFileMetadataAfterMajorCompaction() throws Exception {
        String partition = "partition (part=1)";
        this.testFileMetadataAfterCompaction(testPartitionedTbl, partition, true, 1);
    }

    @Test
    public void testPartitionFileMetadataAfterMinorCompaction() throws Exception {
        String partition = "partition (part=1)";
        this.testFileMetadataAfterCompaction(testPartitionedTbl, partition, false, 1);
    }

    @Test
    public void testFullAcidFileMetadataAfterMajorCompaction() throws Exception {
        String partition = "partition (part=1)";
        this.executeHiveSql("create table " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " (c1 int) partitioned by (part int) stored as orc tblproperties ('transactional' = 'true')");
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " " + partition + " values (1)");
        this.executeHiveSql("delete from " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " where c1 = 1");
        catalog_.addIncompleteTable(testDbName, testAcidTblName, TImpalaTableType.TABLE, null);
        this.testFileMetadataAfterCompaction(testAcidTblName, partition, true, 1);
    }

    @Test
    public void testFullAcidFileMetadataAfterMinorCompaction() throws Exception {
        String partition = "partition (part=1)";
        this.executeHiveSql("create table " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " (c1 int) partitioned by (part int) stored as orc tblproperties ('transactional' = 'true')");
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " " + partition + " values (1)");
        this.executeHiveSql("delete from " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " where c1 = 1");
        catalog_.addIncompleteTable(testDbName, testAcidTblName, TImpalaTableType.TABLE, null);
        this.testFileMetadataAfterCompaction(testAcidTblName, partition, false, 2);
    }

    private void testFileMetadataAfterCompaction(String tableName, String partition, boolean isMajorCompaction, int expectedFileCount) throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        String tableOrPartition = "partial_catalog_info_test." + tableName + " " + partition;
        this.executeHiveSql("insert into " + tableOrPartition + " values (2)");
        this.executeHiveSql("insert into " + tableOrPartition + " values (3)");
        ValidWriteIdList currentWriteIdList = this.getValidWriteIdList(testDbName, tableName);
        TGetPartialCatalogObjectRequest request = new RequestBuilder().db(testDbName).tbl(tableName).writeId(currentWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(request);
        TPartialPartitionInfo prePartitionInfo = (TPartialPartitionInfo)Iterables.getOnlyElement((Iterable)response.getTable_info().getPartitions());
        int preFileCount = prePartitionInfo.getFile_descriptorsSize() + prePartitionInfo.getInsert_file_descriptorsSize() + prePartitionInfo.getDelete_file_descriptorsSize();
        Assert.assertTrue((preFileCount > 1 ? 1 : 0) != 0);
        String compactionType = isMajorCompaction ? "'major'" : "'minor'";
        this.executeHiveSql("alter table " + tableOrPartition + " compact " + compactionType + " and wait");
        long numMisses = this.getMetricCount(testDbName, tableName, "filemetadata-cache-miss");
        long numHits = this.getMetricCount(testDbName, tableName, "filemetadata-cache-hit");
        request = new RequestBuilder().db(testDbName).tbl(tableName).writeId(currentWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        TPartialPartitionInfo afterPartitionInfo = (TPartialPartitionInfo)Iterables.getOnlyElement((Iterable)response.getTable_info().getPartitions());
        int afterFileCount = afterPartitionInfo.getFile_descriptorsSize() + afterPartitionInfo.getInsert_file_descriptorsSize() + afterPartitionInfo.getDelete_file_descriptorsSize();
        String message = "Actual file_descriptors:\n" + this.getPathsFromFileDescriptors(afterPartitionInfo.getFile_descriptors()) + "\nActual insert_file_descriptors:\n" + this.getPathsFromFileDescriptors(afterPartitionInfo.getInsert_file_descriptors()) + "\nActual delete_file_descriptors:\n" + this.getPathsFromFileDescriptors(afterPartitionInfo.getDelete_file_descriptors());
        Assert.assertEquals((String)message, (long)expectedFileCount, (long)afterFileCount);
        long numMissesAfterMinor = this.getMetricCount(testDbName, tableName, "filemetadata-cache-miss");
        long numHitsAfterMinor = this.getMetricCount(testDbName, tableName, "filemetadata-cache-hit");
        Assert.assertEquals((long)(numHits + 1L), (long)numHitsAfterMinor);
        Assert.assertEquals((long)numMisses, (long)numMissesAfterMinor);
    }

    private List<String> getPathsFromFileDescriptors(List<THdfsFileDesc> fileDescriptors) {
        return fileDescriptors.stream().map(HdfsPartition.FileDescriptor::fromThrift).map(HdfsPartition.FileDescriptor::getPath).collect(Collectors.toList());
    }

    @Test
    public void testFetchAfterDropAndRecreate() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        this.executeImpalaSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (2)");
        Table tbl = catalog_.getOrLoadTable(testDbName, testTblName, "test", null);
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        ValidWriteIdList olderWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        Assert.assertEquals((Object)olderWriteIdList.toString(), (Object)tbl.getValidWriteIds().toString());
        TGetPartialCatalogObjectRequest request = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(olderWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(request);
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartitionsSize());
        List oldFds = ((TPartialPartitionInfo)response.getTable_info().getPartitions().get((int)0)).file_descriptors;
        Assert.assertEquals((long)2L, (long)oldFds.size());
        this.executeHiveSql("drop table " + PartialCatalogInfoWriteIdTest.getTestTblName());
        this.executeHiveSql("create table " + PartialCatalogInfoWriteIdTest.getTestTblName() + " like functional.insert_only_transactional_table stored as parquet");
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (1)");
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestTblName() + " values (2)");
        ValidWriteIdList newerWriteIdList = this.getValidWriteIdList(testDbName, testTblName);
        Assert.assertTrue((AcidUtils.compare((ValidWriteIdList)newerWriteIdList, (ValidWriteIdList)olderWriteIdList) == 0 ? 1 : 0) != 0);
        request = new RequestBuilder().db(testDbName).tbl(testTblName).writeId(newerWriteIdList).tableId(this.getTableId(testDbName, testTblName)).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)1L, (long)response.getTable_info().getPartitionsSize());
        List newFds = ((TPartialPartitionInfo)response.getTable_info().getPartitions().get((int)0)).file_descriptors;
        Assert.assertEquals((long)2L, (long)newFds.size());
        for (int i = 0; i < newFds.size(); ++i) {
            Assert.assertNotEquals((String)"Found the new file descriptor same as old one", newFds.get(i), oldFds.get(i));
        }
    }

    @Test
    public void testFullAcidCompaction() throws Exception {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        this.executeImpalaSql("create table " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " like functional_orc_def.alltypes");
        this.executeHiveSql("insert into " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " select * from functional_orc_def.alltypes");
        this.executeHiveSql("delete from " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " where id % 2 = 0");
        catalog_.reset((EventSequence)NoOpEventSequence.INSTANCE);
        Table tbl = catalog_.getOrLoadTable(testDbName, testAcidTblName, "test", null);
        Assert.assertFalse((String)"Table must be loaded", (boolean)(tbl instanceof IncompleteTable));
        ValidWriteIdList olderWriteIdList = this.getValidWriteIdList(testDbName, testAcidTblName);
        this.executeHiveSql("delete from " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " where id % 3 = 0");
        this.executeHiveSql("alter table " + PartialCatalogInfoWriteIdTest.getTestFullAcidTblName() + " partition(year=2010,month=10) compact 'major' and wait");
        ValidWriteIdList currWriteIdList = this.getValidWriteIdList(testDbName, testAcidTblName);
        TGetPartialCatalogObjectRequest request = new RequestBuilder().db(testDbName).tbl(testAcidTblName).writeId(currWriteIdList).wantFiles().build();
        TGetPartialCatalogObjectResponse response = this.sendRequest(request);
        Assert.assertEquals((long)24L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo part : response.getTable_info().getPartitions()) {
            if (part.getName().equalsIgnoreCase("year=2010/month=10")) {
                Assert.assertEquals((long)1L, (long)part.file_descriptors.size());
                Assert.assertEquals((long)0L, (long)part.insert_file_descriptors.size());
                Assert.assertEquals((long)0L, (long)part.delete_file_descriptors.size());
                continue;
            }
            Assert.assertEquals((long)0L, (long)part.file_descriptors.size());
            Assert.assertEquals((long)1L, (long)part.insert_file_descriptors.size());
            Assert.assertEquals((long)2L, (long)part.delete_file_descriptors.size());
        }
        request = new RequestBuilder().db(testDbName).tbl(testAcidTblName).writeId(olderWriteIdList).wantFiles().build();
        response = this.sendRequest(request);
        Assert.assertEquals((long)24L, (long)response.getTable_info().getPartitionsSize());
        for (TPartialPartitionInfo part : response.getTable_info().getPartitions()) {
            Assert.assertEquals((long)0L, (long)part.file_descriptors.size());
            Assert.assertEquals((long)1L, (long)part.insert_file_descriptors.size());
            Assert.assertEquals((long)1L, (long)part.delete_file_descriptors.size());
        }
    }

    private void executeHiveSql(String query) throws Exception {
        try (HiveJdbcClientPool.HiveJdbcClient hiveClient = hiveClientPool_.getClient();){
            hiveClient.executeSql(query);
        }
    }

    private void executeImpalaSql(String query) throws Exception {
        client.connect();
        try (ImpalaJdbcClient client = ImpalaJdbcClient.createClientUsingHiveJdbcDriver();){
            client.execStatement(query);
        }
    }

    private long getTableId(String db, String tbl) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            long l = MetastoreShim.getTableId((org.apache.hadoop.hive.metastore.api.Table)client.getHiveClient().getTable(db, tbl));
            return l;
        }
    }

    private ValidWriteIdList getValidWriteIdList(String db, String tbl) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            ValidWriteIdList validWriteIdList = client.getHiveClient().getValidWriteIds(db + "." + tbl);
            return validWriteIdList;
        }
    }

    private TGetPartialCatalogObjectResponse sendRequest(TGetPartialCatalogObjectRequest req) throws CatalogException, InternalException, TException {
        TGetPartialCatalogObjectResponse resp = catalog_.getPartialCatalogObject(req);
        byte[] respBytes = new TSerializer().serialize((TBase)resp);
        resp.clear();
        new TDeserializer().deserialize((TBase)resp, respBytes);
        return resp;
    }

    private static String getTestTblName() {
        return "partial_catalog_info_test.insert_only";
    }

    private static String getTestFullAcidTblName() {
        return "partial_catalog_info_test.test_full_acid";
    }

    private static String getPartitionedTblName() {
        return "partial_catalog_info_test.insert_only_partitioned";
    }

    private void invalidateTbl(String db, String tbl) throws CatalogException {
        catalog_.invalidateTable(new TTableName(db, tbl), new Reference(), new Reference(), (EventSequence)NoOpEventSequence.INSTANCE);
        Assert.assertTrue((String)"Table must not be loaded", (boolean)(catalog_.getTable(db, tbl) instanceof IncompleteTable));
    }

    private static class RequestBuilder {
        boolean wantFileMetadata;
        boolean wantPartitionMeta;
        boolean wantPartitionNames;
        String tblName;
        String dbName;
        ValidWriteIdList writeIdList;
        long tableId = -1L;

        private RequestBuilder() {
        }

        RequestBuilder db(String db) {
            this.dbName = db;
            return this;
        }

        RequestBuilder tbl(String tbl) {
            this.tblName = tbl;
            return this;
        }

        RequestBuilder writeId(ValidWriteIdList validWriteIdList) {
            this.writeIdList = validWriteIdList;
            return this;
        }

        RequestBuilder tableId(long id) {
            this.tableId = id;
            return this;
        }

        RequestBuilder wantFiles() {
            this.wantFileMetadata = true;
            this.wantPartitionMeta = true;
            this.wantPartitionNames = true;
            return this;
        }

        RequestBuilder wantPartitions() {
            this.wantPartitionMeta = true;
            this.wantFileMetadata = true;
            return this;
        }

        RequestBuilder wantPartitionNames() {
            this.wantPartitionNames = true;
            return this;
        }

        TGetPartialCatalogObjectRequest build() {
            TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
            req.object_desc = new TCatalogObject();
            req.object_desc.setType(TCatalogObjectType.TABLE);
            req.object_desc.table = new TTable(this.dbName, this.tblName);
            req.object_desc.table.hdfs_table = new THdfsTable();
            req.table_info_selector = new TTableInfoSelector();
            req.table_info_selector.valid_write_ids = MetastoreShim.convertToTValidWriteIdList((ValidWriteIdList)this.writeIdList);
            req.table_info_selector.table_id = this.tableId;
            req.table_info_selector.want_hms_table = true;
            if (this.wantPartitionNames) {
                req.table_info_selector.want_partition_names = true;
            }
            if (this.wantPartitionMeta) {
                req.table_info_selector.want_partition_metadata = true;
            }
            if (this.wantFileMetadata) {
                req.table_info_selector.want_partition_files = true;
            }
            return req;
        }
    }
}

