/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TCatalogInfoSelector;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TDbInfoSelector;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableInfoSelector;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class PartialCatalogInfoTest {
    private static CatalogServiceCatalog catalog_ = CatalogServiceTestCatalog.create();

    @AfterClass
    public static void cleanUp() {
        catalog_.close();
    }

    private TGetPartialCatalogObjectResponse sendRequest(TGetPartialCatalogObjectRequest req) throws CatalogException, InternalException, TException {
        TGetPartialCatalogObjectResponse resp = catalog_.getPartialCatalogObject(req);
        byte[] respBytes = new TSerializer().serialize((TBase)resp);
        resp.clear();
        new TDeserializer().deserialize((TBase)resp, respBytes);
        return resp;
    }

    private void sendParallelRequests(TGetPartialCatalogObjectRequest request, int requestCount) throws Exception {
        Preconditions.checkState((requestCount > 0 ? 1 : 0) != 0);
        ExecutorService threadPoolExecutor = Executors.newFixedThreadPool(requestCount);
        ArrayList<Future<TGetPartialCatalogObjectResponse>> tasksToWaitFor = new ArrayList<Future<TGetPartialCatalogObjectResponse>>();
        for (int i = 0; i < requestCount; ++i) {
            tasksToWaitFor.add(threadPoolExecutor.submit(new CallableGetPartialCatalogObjectRequest(request)));
        }
        for (Future future : tasksToWaitFor) {
            future.get();
        }
    }

    @Test
    public void testDbList() throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.CATALOG);
        req.catalog_info_selector = new TCatalogInfoSelector();
        req.catalog_info_selector.want_db_names = true;
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        Assert.assertTrue((boolean)resp.catalog_info.db_names.contains("functional"));
    }

    @Test
    public void testDb() throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.DATABASE);
        req.object_desc.db = new TDatabase("functional");
        req.db_info_selector = new TDbInfoSelector();
        req.db_info_selector.want_hms_database = true;
        req.db_info_selector.want_brief_meta_of_tables = true;
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        Assert.assertTrue((boolean)resp.isSetObject_version_number());
        Assert.assertEquals((Object)resp.db_info.hms_database.getName(), (Object)"functional");
        Assert.assertTrue((boolean)resp.db_info.brief_meta_of_tables.stream().map(TBriefTableMeta::getName).anyMatch("alltypes"::equals));
    }

    @Test
    public void testTable() throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "alltypes");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.want_partition_names = true;
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        Assert.assertTrue((boolean)resp.isSetObject_version_number());
        Assert.assertEquals((Object)resp.table_info.hms_table.getTableName(), (Object)"alltypes");
        Assert.assertTrue((resp.table_info.partitions.size() > 0 ? 1 : 0) != 0);
        TPartialPartitionInfo partInfo = (TPartialPartitionInfo)resp.table_info.partitions.get(1);
        Assert.assertTrue((String)("bad part name: " + partInfo.name), (boolean)partInfo.name.matches("year=\\d+/month=\\d+"));
        req.table_info_selector.clear();
        req.table_info_selector.want_partition_metadata = true;
        req.table_info_selector.partition_ids = ImmutableList.of((Object)((TPartialPartitionInfo)resp.table_info.partitions.get((int)1)).id, (Object)((TPartialPartitionInfo)resp.table_info.partitions.get((int)3)).id);
        resp = this.sendRequest(req);
        Assert.assertNull((Object)resp.table_info.hms_table);
        Assert.assertEquals((long)2L, (long)resp.table_info.partitions.size());
        Assert.assertEquals((long)1L, (long)resp.table_info.getPartition_prefixesSize());
        Assert.assertEquals((Object)"hdfs://localhost:20500/test-warehouse/alltypes/", resp.table_info.partition_prefixes.get(0));
        partInfo = (TPartialPartitionInfo)resp.table_info.partitions.get(0);
        Assert.assertNull((Object)partInfo.name);
        Assert.assertEquals(req.table_info_selector.partition_ids.get(0), (Object)partInfo.id);
        Assert.assertEquals((long)0L, (long)partInfo.location.prefix_index);
        Assert.assertTrue((String)("Bad suffix " + partInfo.location.suffix), (boolean)partInfo.location.suffix.matches("year=\\d+/month=\\d+"));
        Assert.assertNotNull((Object)partInfo.hdfs_storage_descriptor);
        Assert.assertEquals((Object)THdfsFileFormat.TEXT, (Object)partInfo.hdfs_storage_descriptor.fileFormat);
    }

    @Test
    public void testFetchMissingPartId() throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "alltypes");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_partition_metadata = true;
        req.table_info_selector.partition_ids = ImmutableList.of((Object)-12345L);
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        Assert.assertEquals((Object)resp.lookup_status, (Object)CatalogLookupStatus.PARTITION_NOT_FOUND);
    }

    private List<ColumnStatisticsObj> fetchColumStats(String dbName, String tblName, ImmutableList<String> columns) throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable(dbName, tblName);
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_stats_for_column_names = columns;
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        return resp.table_info.column_stats;
    }

    @Test
    public void testTableStats() throws Exception {
        List<ColumnStatisticsObj> stats = this.fetchColumStats("functional", "alltypes", (ImmutableList<String>)ImmutableList.of((Object)"year", (Object)"month", (Object)"id", (Object)"bool_col", (Object)"tinyint_col", (Object)"smallint_col", (Object)"int_col", (Object)"bigint_col", (Object)"float_col", (Object)"double_col", (Object)"date_string_col", (Object)"string_col", (Object[])new String[]{"timestamp_col"}));
        Assert.assertEquals((long)11L, (long)stats.size());
        Assert.assertEquals((Object)"ColumnStatisticsObj(colName:id, colType:INT, statsData:<ColumnStatisticsData longStats:LongColumnStatsData(numNulls:0, numDVs:7300)>)", (Object)stats.get(0).toString());
    }

    @Test
    public void testDateTableStats() throws Exception {
        List<ColumnStatisticsObj> stats = this.fetchColumStats("functional", "date_tbl", (ImmutableList<String>)ImmutableList.of((Object)"date_col", (Object)"date_part"));
        Assert.assertEquals((long)1L, (long)stats.size());
        Assert.assertEquals((Object)"ColumnStatisticsObj(colName:date_col, colType:DATE, statsData:<ColumnStatisticsData dateStats:DateColumnStatsData(numNulls:2, numDVs:16)>)", (Object)stats.get(0).toString());
    }

    @Test
    public void testBinaryTableStats() throws Exception {
        List<ColumnStatisticsObj> stats = this.fetchColumStats("functional", "binary_tbl", (ImmutableList<String>)ImmutableList.of((Object)"binary_col"));
        Assert.assertEquals((long)1L, (long)stats.size());
        Assert.assertEquals((Object)"ColumnStatisticsObj(colName:binary_col, colType:BINARY, statsData:<ColumnStatisticsData binaryStats:BinaryColumnStatsData(maxColLen:26, avgColLen:8.714285850524902, numNulls:1)>)", (Object)stats.get(0).toString());
    }

    @Test
    public void testFetchErrorTable() throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "bad_serde");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.want_partition_names = true;
        try {
            this.sendRequest(req);
            Assert.fail((String)"expected exception");
        }
        catch (TableLoadingException tle) {
            Assert.assertEquals((Object)"Failed to load metadata for table: functional.bad_serde", (Object)tle.getMessage());
        }
    }

    @Test
    public void testGetSqlConstraints() throws Exception {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "parent_table");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.want_table_constraints = true;
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        List primaryKeys = resp.table_info.sql_constraints.primary_keys;
        List foreignKeys = resp.table_info.sql_constraints.foreign_keys;
        Assert.assertEquals((long)2L, (long)primaryKeys.size());
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        for (SQLPrimaryKey pk : primaryKeys) {
            Assert.assertEquals((Object)"functional", (Object)pk.getTable_db());
            Assert.assertEquals((Object)"parent_table", (Object)pk.getTable_name());
        }
        Assert.assertEquals((Object)"id", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getColumn_name());
        Assert.assertEquals((Object)"year", (Object)((SQLPrimaryKey)primaryKeys.get(1)).getColumn_name());
        req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "child_table");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.want_table_constraints = true;
        resp = this.sendRequest(req);
        primaryKeys = resp.table_info.sql_constraints.primary_keys;
        foreignKeys = resp.table_info.sql_constraints.foreign_keys;
        Assert.assertEquals((long)1L, (long)primaryKeys.size());
        Assert.assertEquals((long)3L, (long)foreignKeys.size());
        Assert.assertEquals((Object)"functional", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getTable_db());
        Assert.assertEquals((Object)"child_table", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getTable_name());
        for (SQLForeignKey fk : foreignKeys) {
            Assert.assertEquals((Object)"functional", (Object)fk.getFktable_db());
            Assert.assertEquals((Object)"child_table", (Object)fk.getFktable_name());
            Assert.assertEquals((Object)"functional", (Object)fk.getPktable_db());
        }
        Assert.assertEquals((Object)"parent_table", (Object)((SQLForeignKey)foreignKeys.get(0)).getPktable_name());
        Assert.assertEquals((Object)"parent_table", (Object)((SQLForeignKey)foreignKeys.get(1)).getPktable_name());
        Assert.assertEquals((Object)"parent_table_2", (Object)((SQLForeignKey)foreignKeys.get(2)).getPktable_name());
        Assert.assertEquals((Object)"id", (Object)((SQLForeignKey)foreignKeys.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)"year", (Object)((SQLForeignKey)foreignKeys.get(1)).getPkcolumn_name());
        Assert.assertEquals((Object)"a", (Object)((SQLForeignKey)foreignKeys.get(2)).getPkcolumn_name());
        Assert.assertEquals((Object)((SQLForeignKey)foreignKeys.get(0)).getFk_name(), (Object)((SQLForeignKey)foreignKeys.get(1)).getFk_name());
        req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "alltypes");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.want_table_constraints = true;
        resp = this.sendRequest(req);
        primaryKeys = resp.table_info.sql_constraints.primary_keys;
        foreignKeys = resp.table_info.sql_constraints.foreign_keys;
        Assert.assertNotNull((Object)primaryKeys);
        Assert.assertNotNull((Object)foreignKeys);
        Assert.assertEquals((long)0L, (long)primaryKeys.size());
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentPartialObjectRequests() throws Exception {
        Future<Void> assertThreadTask;
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable("functional", "alltypes");
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.want_partition_names = true;
        req.table_info_selector.want_partition_metadata = true;
        final AtomicBoolean requestsFinished = new AtomicBoolean(false);
        final int maxParallelRuns = BackendConfig.INSTANCE.getCatalogMaxParallelPartialFetchRpc();
        Callable<Void> assertReqCount = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!requestsFinished.get()) {
                    int currentReqCount = catalog_.getConcurrentPartialRpcReqCount();
                    Assert.assertTrue((String)("Invalid concurrent request count: " + currentReqCount), (currentReqCount <= maxParallelRuns ? 1 : 0) != 0);
                }
                return null;
            }
        };
        try {
            assertThreadTask = Executors.newSingleThreadExecutor().submit(assertReqCount);
            this.sendParallelRequests(req, 64);
        }
        finally {
            requestsFinished.set(true);
        }
        assertThreadTask.get(5L, TimeUnit.MINUTES);
    }

    private class CallableGetPartialCatalogObjectRequest
    implements Callable<TGetPartialCatalogObjectResponse> {
        private final TGetPartialCatalogObjectRequest request_;

        CallableGetPartialCatalogObjectRequest(TGetPartialCatalogObjectRequest request) {
            this.request_ = request;
        }

        @Override
        public TGetPartialCatalogObjectResponse call() throws Exception {
            return PartialCatalogInfoTest.this.sendRequest(this.request_);
        }
    }
}

