/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.thrift.TException;
import org.junit.Assert;

public class MetastoreApiTestUtils {
    public static Database createHmsDatabaseObject(String catName, String dbName, Map<String, String> params) {
        Database database = new Database();
        if (catName != null) {
            database.setCatalogName(catName);
        }
        database.setName(dbName);
        database.setDescription("Notification test database");
        database.setOwnerName("NotificationOwner");
        database.setOwnerType(PrincipalType.USER);
        if (params != null && !params.isEmpty()) {
            database.setParameters(params);
        }
        return database;
    }

    public static void addDatabaseParametersInHms(MetaStoreClientPool.MetaStoreClient msClient, String dbName, String key, String val) throws TException {
        Database msDb = msClient.getHiveClient().getDatabase(dbName);
        Assert.assertFalse((String)(key + " already exists in the database parameters"), (boolean)msDb.getParameters().containsKey(key));
        msDb.putToParameters(key, val);
        msClient.getHiveClient().alterDatabase(dbName, msDb);
    }

    public static Table getTestTable(String catName, String dbName, String tblName, Map<String, String> params, boolean isPartitioned) throws MetaException {
        return MetastoreApiTestUtils.getTestTable(catName, dbName, tblName, params, isPartitioned, TableType.EXTERNAL_TABLE.toString());
    }

    public static Table getTestTable(String catName, String dbName, String tblName, Map<String, String> params, boolean isPartitioned, String tableType) throws MetaException {
        Table tbl = new Table();
        if (catName != null) {
            tbl.setCatName(catName);
        }
        tbl.setDbName(dbName);
        tbl.setTableName(tblName);
        tbl.putToParameters("tblParamKey", "tblParamValue");
        ArrayList cols = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("c1", "string", "c1 description"), new FieldSchema("c2", "string", "c2 description")});
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols((List)cols);
        sd.setInputFormat(HdfsFileFormat.PARQUET.inputFormat());
        sd.setOutputFormat(HdfsFileFormat.PARQUET.outputFormat());
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setSerializationLib(HdfsFileFormat.PARQUET.serializationLib());
        sd.setSerdeInfo(serDeInfo);
        tbl.setSd(sd);
        if (params != null && !params.isEmpty()) {
            tbl.setParameters(params);
        }
        if (isPartitioned) {
            ArrayList pcols = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("p1", "string", "partition p1 description")});
            tbl.setPartitionKeys((List)pcols);
        }
        if (tableType != null) {
            Preconditions.checkArgument((tableType.equals(TableType.MANAGED_TABLE.toString()) || tableType.equals(TableType.EXTERNAL_TABLE.toString()) ? 1 : 0) != 0, (Object)("Invalid table type " + tableType));
            tbl.setTableType(tableType);
        }
        return tbl;
    }

    public static void createDatabase(MetaStoreClientPool.MetaStoreClient msClient, String catName, String dbName, Map<String, String> params) throws TException {
        Database database = MetastoreApiTestUtils.createHmsDatabaseObject(catName, dbName, params);
        msClient.getHiveClient().createDatabase(database);
    }

    public static void createTable(MetaStoreClientPool.MetaStoreClient msClient, String catName, String dbName, String tblName, Map<String, String> params, boolean isPartitioned) throws TException {
        MetastoreApiTestUtils.createTable(msClient, catName, dbName, tblName, params, isPartitioned, null);
    }

    public static void createTable(MetaStoreClientPool.MetaStoreClient msClient, String catName, String dbName, String tblName, Map<String, String> params, boolean isPartitioned, String tableType) throws TException {
        Table tbl = MetastoreApiTestUtils.getTestTable(catName, dbName, tblName, params, isPartitioned, tableType);
        msClient.getHiveClient().createTable(tbl);
    }

    public static void addPartitions(MetaStoreClientPool.MetaStoreClient msClient, String dbName, String tblName, List<List<String>> partitionValues) throws TException {
        ArrayList<Partition> partitions = new ArrayList<Partition>(partitionValues.size());
        Table msTable = msClient.getHiveClient().getTable(dbName, tblName);
        for (List<String> partVals : partitionValues) {
            Partition partition = new Partition();
            partition.setDbName(msTable.getDbName());
            partition.setTableName(msTable.getTableName());
            partition.setSd(msTable.getSd().deepCopy());
            partition.setValues(partVals);
            partitions.add(partition);
        }
        msClient.getHiveClient().add_partitions(partitions);
    }
}

