/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HdfsPartitionSdCompareTest {
    private CatalogServiceCatalog catalog_;
    private Partition hmsPartition_ = null;

    @Before
    public void init() throws Exception {
        this.catalog_ = CatalogServiceTestCatalog.create();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            this.hmsPartition_ = client.getHiveClient().getPartition("functional", "alltypes", "year=2009/month=1");
        }
    }

    @After
    public void cleanUp() {
        this.catalog_.close();
    }

    @Test
    public void testCompareSds() throws Exception {
        Assert.assertNotNull((Object)this.hmsPartition_);
        Assert.assertNotNull((Object)this.hmsPartition_.getSd());
        StorageDescriptor hmsSd = this.hmsPartition_.getSd();
        HdfsTable tbl = (HdfsTable)this.catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        HdfsPartition hdfsPartition = (HdfsPartition)tbl.getPartitionsForNames(Arrays.asList("year=2009/month=1")).get(0);
        Assert.assertTrue((boolean)hdfsPartition.compareSd(hmsSd));
        StorageDescriptor testSd = new StorageDescriptor(hmsSd);
        testSd.setLocation("file:///tmp/year=2009/month=1");
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.setInputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.setOutputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.addToCols(new FieldSchema("c1", "int", "comment"));
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.addToSortCols(new Order());
        testSd.setLocation("file:///tmp/year=2009/month=1");
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.setSerdeInfo(new SerDeInfo("parquet", "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", new HashMap()));
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.setCompressed(!hmsSd.isCompressed());
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.setNumBuckets(hmsSd.getNumBuckets() + 1);
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
        testSd = new StorageDescriptor(hmsSd);
        testSd.putToParameters("test", "value");
        Assert.assertFalse((boolean)hdfsPartition.compareSd(testSd));
    }
}

