/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.CatalogdTableInvalidator;
import org.apache.impala.catalog.Table;
import org.apache.impala.common.Reference;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.NoOpEventSequence;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class CatalogdTableInvalidatorTest {
    private static CatalogServiceCatalog catalog_ = CatalogServiceTestCatalog.create();

    @AfterClass
    public static void tearDown() {
        catalog_.close();
    }

    private long waitForTrigger(long previousTriggerCount) throws InterruptedException {
        long triggerCount;
        do {
            Thread.sleep(5L);
        } while ((triggerCount = CatalogdTableInvalidatorTest.catalog_.getCatalogdTableInvalidator().scanCount_.get()) == previousTriggerCount);
        return triggerCount;
    }

    @Test
    public void testCatalogdTableInvalidator() throws CatalogException, InterruptedException {
        Reference tblWasRemoved = new Reference();
        Reference dbWasAdded = new Reference();
        String dbName = "functional";
        String tblName = "alltypes";
        catalog_.invalidateTable(new TTableName(dbName, tblName), tblWasRemoved, dbWasAdded, (EventSequence)NoOpEventSequence.INSTANCE);
        MockTicker ticker = new MockTicker();
        CatalogdTableInvalidator.TIME_SOURCE = ticker;
        catalog_.setCatalogdTableInvalidator(new CatalogdTableInvalidator(catalog_, 2L, false, 0.6, 0.1));
        Assert.assertFalse((boolean)catalog_.getDb(dbName).getTable(tblName).isLoaded());
        Table table = catalog_.getOrLoadTable(dbName, tblName, "test", null);
        Assert.assertTrue((boolean)table.isLoaded());
        Assert.assertEquals((long)ticker.now_, (long)table.getLastUsedTime());
        long previousTriggerCount = CatalogdTableInvalidatorTest.catalog_.getCatalogdTableInvalidator().scanCount_.get();
        ticker.set(TimeUnit.SECONDS.toNanos(1L));
        table.refreshLastUsedTime();
        ticker.set(TimeUnit.SECONDS.toNanos(3L));
        previousTriggerCount = this.waitForTrigger(previousTriggerCount);
        Assert.assertTrue((boolean)catalog_.getTable(dbName, tblName).isLoaded());
        ticker.set(TimeUnit.SECONDS.toNanos(6L));
        this.waitForTrigger(previousTriggerCount);
        Assert.assertFalse((boolean)catalog_.getTable(dbName, tblName).isLoaded());
    }

    @After
    public void cleanUp() {
        catalog_.getCatalogdTableInvalidator().stop();
        catalog_.setCatalogdTableInvalidator(null);
        CatalogdTableInvalidator.TIME_SOURCE = Ticker.systemTicker();
    }

    class MockTicker
    extends Ticker {
        long now_ = 1000L;

        MockTicker() {
        }

        public synchronized long read() {
            return this.now_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(long nanoSec) {
            MockTicker mockTicker = this;
            synchronized (mockTicker) {
                this.now_ = nanoSec;
            }
            catalog_.getCatalogdTableInvalidator().wakeUpForTests();
        }
    }
}

