/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.impala.catalog.CatalogObjectVersionSet;
import org.junit.Assert;
import org.junit.Test;

public class CatalogObjectVersionSetTest {
    private CatalogObjectVersionSet set_ = new CatalogObjectVersionSet();
    private List<Long> list_ = new ArrayList<Long>();

    private void doAdd(long v) {
        this.set_.addVersion(v);
        this.list_.add(v);
        this.checkConsistency();
    }

    private void doRemove(long v) {
        this.set_.removeVersion(v);
        this.list_.remove(v);
        this.checkConsistency();
    }

    private void doUpdate(long from, long to) {
        this.set_.updateVersions(from, to);
        this.list_.remove(from);
        this.list_.add(to);
        this.checkConsistency();
    }

    private void checkConsistency() {
        if (this.list_.isEmpty()) {
            Assert.assertEquals((long)0L, (long)this.set_.getMinimumVersion());
        } else {
            Assert.assertEquals((long)Collections.min(this.list_), (long)this.set_.getMinimumVersion());
        }
    }

    @Test
    public void testAddRemove() {
        Assert.assertEquals((long)0L, (long)this.set_.getMinimumVersion());
        this.doAdd(10L);
        this.doAdd(20L);
        this.doAdd(5L);
        this.doAdd(5L);
        this.doRemove(5L);
        this.doRemove(5L);
        this.doRemove(10L);
        this.doRemove(20L);
    }

    @Test
    public void testUpdate() {
        this.doAdd(10L);
        this.doUpdate(10L, 20L);
        this.doUpdate(20L, 30L);
        this.doUpdate(30L, 10L);
        this.doAdd(10L);
        this.doUpdate(10L, 20L);
        this.doRemove(10L);
        this.doRemove(20L);
    }

    @Test
    public void testRemoveNonExistentVersion() {
        this.doRemove(10L);
    }
}

