/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import org.apache.impala.authorization.AuthorizationProvider;
import org.apache.impala.authorization.AuthorizationTestBase;
import org.apache.impala.authorization.ranger.RangerImpaladAuthorizationManager;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.thrift.TShowRolesParams;
import org.apache.impala.thrift.TShowRolesResult;
import org.junit.Assert;
import org.junit.Test;

public class RangerImpaladAuthorizationManagerTest
extends AuthorizationTestBase {
    private final RangerImpaladAuthorizationManager rangerImpaladAuthzManager_;

    public RangerImpaladAuthorizationManagerTest() throws ImpalaException {
        super(AuthorizationProvider.RANGER);
        this.rangerImpaladAuthzManager_ = (RangerImpaladAuthorizationManager)this.authzFrontend_.getAuthzManager();
    }

    private static TShowRolesParams createTestShowRolesParams(boolean isShowCurrentRole) {
        TShowRolesParams showRolesParams = new TShowRolesParams(isShowCurrentRole);
        if (!isShowCurrentRole) {
            showRolesParams.setRequesting_user("admin");
        } else {
            showRolesParams.setRequesting_user("non_owner");
        }
        return showRolesParams;
    }

    private static TShowRolesParams createTestShowRolesParams(String grantGroup) {
        TShowRolesParams showRolesParams = RangerImpaladAuthorizationManagerTest.createTestShowRolesParams(false);
        showRolesParams.setGrant_group(grantGroup);
        return showRolesParams;
    }

    private void _testNoExceptionInShowRolesWhenNoRolesInRanger(TShowRolesParams showRolesParams, String desc) {
        try {
            TShowRolesResult result = this.rangerImpaladAuthzManager_.getRoles(showRolesParams);
            Assert.assertNotNull((Object)result.getRole_names());
        }
        catch (ImpalaException ex) {
            Assert.fail((String)("No Exception should be thrown for show role statement:" + desc));
        }
    }

    @Test
    public void testNoExceptionInShowRolesWhenNoRolesInRanger() {
        TShowRolesParams showRolesParams = RangerImpaladAuthorizationManagerTest.createTestShowRolesParams(false);
        this._testNoExceptionInShowRolesWhenNoRolesInRanger(showRolesParams, "SHOW ROLES");
        TShowRolesParams showCurrentRolesParams = RangerImpaladAuthorizationManagerTest.createTestShowRolesParams(true);
        this._testNoExceptionInShowRolesWhenNoRolesInRanger(showCurrentRolesParams, "SHOW CURRENT ROLES");
        TShowRolesParams showRolesGrantGroupParams = RangerImpaladAuthorizationManagerTest.createTestShowRolesParams("admin");
        this._testNoExceptionInShowRolesWhenNoRolesInRanger(showRolesGrantGroupParams, "SHOW ROLE GRANT GROUP admin");
    }
}

