/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.impala.analysis.AnalyzerTest;
import org.apache.impala.analysis.TypesUtil;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.junit.Assert;
import org.junit.Test;

public class TypesUtilTest
extends AnalyzerTest {
    private void verifyDecimalType(Type t1, Type t2) {
        Assert.assertTrue((t1.getPrimitiveType() == PrimitiveType.DECIMAL ? 1 : 0) != 0);
        Assert.assertTrue((t2.getPrimitiveType() == PrimitiveType.DECIMAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)t1.equals((Object)t2));
    }

    private void verifyInvalid(Type t) {
        Assert.assertTrue((boolean)t.equals((Object)Type.INVALID));
    }

    @Test
    public void TestDecimalAssignementType() {
        for (boolean decimalV2 : new boolean[]{false, true}) {
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)Type.DEFAULT_DECIMAL, (ScalarType)Type.DEFAULT_DECIMAL, (boolean)decimalV2), (Type)Type.DEFAULT_DECIMAL);
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)10, (int)2), (ScalarType)ScalarType.createDecimalType((int)12, (int)2), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)12, (int)2));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)10, (int)5), (ScalarType)ScalarType.createDecimalType((int)12, (int)3), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)14, (int)5));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)12, (int)2), (ScalarType)ScalarType.createDecimalType((int)10, (int)2), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)12, (int)2));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)12, (int)3), (ScalarType)ScalarType.createDecimalType((int)10, (int)5), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)14, (int)5));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)10, (int)0), (ScalarType)ScalarType.createDecimalType((int)16, (int)5), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)16, (int)5));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType(), (ScalarType)ScalarType.createDecimalType(), (boolean)decimalV2), (Type)ScalarType.createDecimalType());
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)10, (int)2), (ScalarType)ScalarType.createDecimalType((int)12, (int)2), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)12, (int)2));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)5, (int)0), (ScalarType)Type.DECIMAL, (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)5, (int)0));
            this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)Type.DECIMAL, (ScalarType)ScalarType.createDecimalType((int)5, (int)0), (boolean)decimalV2), (Type)ScalarType.createDecimalType((int)5, (int)0));
        }
        this.verifyDecimalType((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)38, (int)38), (ScalarType)ScalarType.createDecimalType((int)3), (boolean)false), (Type)ScalarType.createDecimalType((int)38, (int)38));
        this.verifyInvalid((Type)TypesUtil.getDecimalAssignmentCompatibleType((ScalarType)ScalarType.createDecimalType((int)38, (int)38), (ScalarType)ScalarType.createDecimalType((int)3), (boolean)true));
    }

    @Test
    public void TestNumericImplicitCast() {
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)2, (int)0), (Type)Type.TINYINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)4, (int)0), (Type)Type.SMALLINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)9, (int)0), (Type)Type.INT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)18, (int)0), (Type)Type.BIGINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)3, (int)0), (Type)Type.TINYINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)5, (int)0), (Type)Type.SMALLINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)10, (int)0), (Type)Type.INT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)19, (int)0), (Type)Type.BIGINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)2, (int)1), (Type)Type.TINYINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)4, (int)1), (Type)Type.SMALLINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)2, (int)1), (Type)Type.INT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)ScalarType.createDecimalType((int)18, (int)5), (Type)Type.BIGINT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.TINYINT, (Type)ScalarType.createDecimalType((int)2, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.SMALLINT, (Type)ScalarType.createDecimalType((int)4, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.INT, (Type)ScalarType.createDecimalType((int)9, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.BIGINT, (Type)ScalarType.createDecimalType((int)18, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.TINYINT, (Type)ScalarType.createDecimalType((int)3, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.SMALLINT, (Type)ScalarType.createDecimalType((int)5, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.INT, (Type)ScalarType.createDecimalType((int)10, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.BIGINT, (Type)ScalarType.createDecimalType((int)19, (int)0), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.TINYINT, (Type)ScalarType.createDecimalType((int)4, (int)1), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.SMALLINT, (Type)ScalarType.createDecimalType((int)6, (int)1), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.INT, (Type)ScalarType.createDecimalType((int)11, (int)1), (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.BIGINT, (Type)ScalarType.createDecimalType((int)20, (int)1), (TypeCompatibility)TypeCompatibility.DEFAULT));
        List<Type> intTypes = Arrays.asList(Type.TINYINT, Type.SMALLINT, Type.INT, Type.BIGINT);
        for (Type t1 : intTypes) {
            for (Type t2 : intTypes) {
                if (t1.getSlotSize() == t2.getSlotSize()) {
                    Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)t1, (Type)t2, (TypeCompatibility)TypeCompatibility.STRICT));
                    Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)t1, (Type)t2, (TypeCompatibility)TypeCompatibility.DEFAULT));
                    continue;
                }
                if (t1.getSlotSize() < t2.getSlotSize()) {
                    Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)t1, (Type)t2, (TypeCompatibility)TypeCompatibility.STRICT));
                    Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)t1, (Type)t2, (TypeCompatibility)TypeCompatibility.DEFAULT));
                    Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)t2, (Type)t1, (TypeCompatibility)TypeCompatibility.STRICT));
                    Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)t2, (Type)t1, (TypeCompatibility)TypeCompatibility.DEFAULT));
                    continue;
                }
                Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)t1, (Type)t2, (TypeCompatibility)TypeCompatibility.STRICT));
                Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)t1, (Type)t2, (TypeCompatibility)TypeCompatibility.DEFAULT));
                Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)t2, (Type)t1, (TypeCompatibility)TypeCompatibility.STRICT));
                Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)t2, (Type)t1, (TypeCompatibility)TypeCompatibility.DEFAULT));
            }
        }
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.FLOAT, (Type)Type.FLOAT, (TypeCompatibility)TypeCompatibility.STRICT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.DOUBLE, (Type)Type.FLOAT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.FLOAT, (Type)Type.DOUBLE, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)Type.FLOAT, (Type)Type.DOUBLE, (TypeCompatibility)TypeCompatibility.STRICT));
        List<ScalarType> dts = Arrays.asList(ScalarType.createDecimalType((int)30, (int)10), ScalarType.createDecimalType((int)2, (int)0));
        for (Type type : dts) {
            Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)type, (Type)Type.FLOAT, (TypeCompatibility)TypeCompatibility.STRICT));
            Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)type, (Type)Type.FLOAT, (TypeCompatibility)TypeCompatibility.DEFAULT));
            Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)type, (Type)Type.DOUBLE, (TypeCompatibility)TypeCompatibility.STRICT));
            Assert.assertTrue((boolean)Type.isImplicitlyCastable((Type)type, (Type)Type.DOUBLE, (TypeCompatibility)TypeCompatibility.DEFAULT));
        }
    }

    @Test
    public void TestComplexImplicitCast() {
        ArrayType arrayType = new ArrayType((Type)Type.INT);
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.INT, (Type)arrayType, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)arrayType, (Type)Type.INT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        MapType mapType = new MapType((Type)Type.STRING, (Type)Type.INT);
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.INT, (Type)mapType, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)mapType, (Type)Type.INT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)mapType, (Type)arrayType, (TypeCompatibility)TypeCompatibility.DEFAULT));
        StructType structType = new StructType((List)Lists.newArrayList((Object[])new StructField[]{new StructField("foo", (Type)Type.FLOAT, ""), new StructField("bar", (Type)Type.FLOAT, "")}));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)structType, (Type)Type.INT, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)Type.INT, (Type)structType, (TypeCompatibility)TypeCompatibility.DEFAULT));
        Assert.assertFalse((boolean)Type.isImplicitlyCastable((Type)arrayType, (Type)structType, (TypeCompatibility)TypeCompatibility.DEFAULT));
    }
}

