/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.Arrays;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.local.CatalogdMetaProvider;
import org.apache.impala.catalog.local.FailedLoadLocalTable;
import org.apache.impala.catalog.local.LocalCatalog;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.util.EventSequence;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class StmtMetadataLoaderTest {
    private void testLoadTables(String stmtStr, int expectedNumLoadRequests, int expectedNumCatalogUpdates, String[] expectedDbs, String[] expectedTables) throws ImpalaException {
        try (ImpaladTestCatalog catalog = new ImpaladTestCatalog();){
            Frontend fe = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)catalog);
            StatementBase stmt = Parser.parse((String)stmtStr);
            this.validateUncached(stmt, fe, expectedNumLoadRequests, expectedNumCatalogUpdates, expectedDbs, expectedTables);
            this.validateCached(stmt, fe, expectedDbs, expectedTables);
        }
    }

    private void testNoLoad(String stmtStr) throws ImpalaException {
        try (ImpaladTestCatalog catalog = new ImpaladTestCatalog();){
            Frontend fe = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)catalog);
            StatementBase stmt = Parser.parse((String)stmtStr);
            this.validateCached(stmt, fe, new String[0], new String[0]);
        }
    }

    private void testLoadAcidTables(String stmtStr) throws ImpalaException {
        try (ImpaladTestCatalog catalog = new ImpaladTestCatalog();){
            Frontend fe = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)catalog);
            StatementBase stmt = Parser.parse((String)stmtStr);
            EventSequence timeline = new EventSequence("Test Timeline");
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", timeline);
            StmtMetadataLoader.StmtTableCache stmtTableCache = mdLoader.loadTables(stmt);
            this.validateTablesWriteIds(stmtTableCache);
        }
    }

    private void validateDbs(StmtMetadataLoader.StmtTableCache stmtTableCache, String[] expectedDbs) {
        Object[] actualDbs = new String[stmtTableCache.dbs.size()];
        actualDbs = stmtTableCache.dbs.toArray(actualDbs);
        Arrays.sort(expectedDbs);
        Arrays.sort(actualDbs);
        Assert.assertArrayEquals((Object[])expectedDbs, (Object[])actualDbs);
    }

    private void validateTables(StmtMetadataLoader.StmtTableCache stmtTableCache, String[] expectedTables) {
        Object[] actualTables = new String[stmtTableCache.tables.size()];
        int idx = 0;
        for (FeTable t : stmtTableCache.tables.values()) {
            Assert.assertTrue((boolean)t.isLoaded());
            actualTables[idx++] = t.getFullName();
        }
        Arrays.sort(expectedTables);
        Arrays.sort(actualTables);
        Assert.assertArrayEquals((Object[])expectedTables, (Object[])actualTables);
    }

    private void validateTablesWriteIds(StmtMetadataLoader.StmtTableCache stmtTableCache) {
        Assert.assertTrue((stmtTableCache.tables.size() > 0 ? 1 : 0) != 0);
        for (FeTable t : stmtTableCache.tables.values()) {
            Assert.assertTrue((boolean)t.isLoaded());
            Assert.assertTrue((t.getValidWriteIds() != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)t.getValidWriteIds().isWriteIdValid(t.getWriteId()));
        }
    }

    private void validateUncached(StatementBase stmt, Frontend fe, int expectedNumLoadRequests, int expectedNumCatalogUpdates, String[] expectedDbs, String[] expectedTables) throws InternalException {
        EventSequence timeline = new EventSequence("Test Timeline");
        StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", timeline);
        StmtMetadataLoader.StmtTableCache stmtTableCache = mdLoader.loadTables(stmt);
        Assert.assertEquals((long)expectedNumLoadRequests, (long)mdLoader.getNumLoadRequestsSent());
        Assert.assertEquals((long)expectedNumCatalogUpdates, (long)mdLoader.getNumCatalogUpdatesReceived());
        Assert.assertEquals((long)2L, (long)mdLoader.getTimeline().getNumEvents());
        this.validateDbs(stmtTableCache, expectedDbs);
        this.validateTables(stmtTableCache, expectedTables);
    }

    private void validateCached(StatementBase stmt, Frontend fe, String[] expectedDbs, String[] expectedTables) throws InternalException {
        EventSequence timeline = new EventSequence("Test Timeline");
        StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", timeline);
        StmtMetadataLoader.StmtTableCache stmtTableCache = mdLoader.loadTables(stmt);
        Assert.assertEquals((long)0L, (long)mdLoader.getNumLoadRequestsSent());
        Assert.assertEquals((long)0L, (long)mdLoader.getNumCatalogUpdatesReceived());
        Assert.assertEquals((long)1L, (long)mdLoader.getTimeline().getNumEvents());
        this.validateDbs(stmtTableCache, expectedDbs);
        this.validateTables(stmtTableCache, expectedTables);
    }

    @Test
    public void testSingleLoadRequest() throws ImpalaException {
        this.testLoadTables("select * from functional.alltypes", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes"});
        this.testLoadTables("select * from functional.alltypes, functional_parquet.alltypes, functional_avro.alltypes", 1, 1, new String[]{"default", "functional", "functional_parquet", "functional_avro"}, new String[]{"functional.alltypes", "functional_parquet.alltypes", "functional_avro.alltypes"});
        this.testLoadTables("select * from functional.alltypes, functional.alltypes, functional.alltypes", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes"});
        this.testLoadTables("with w as (select id from functional.alltypes) select * from w, (select id from functional.alltypessmall) v where v.id in (select id from functional.alltypestiny)", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes", "functional.alltypessmall", "functional.alltypestiny"});
        this.testLoadTables("select * from functional.alltypes union distinct select * from functional.alltypessmall union all select * from functional.alltypestiny", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes", "functional.alltypessmall", "functional.alltypestiny"});
        this.testLoadTables("with w as (select id from functional.alltypes) select * from w, (select id from functional.alltypes) v where v.id in (select id from functional.alltypes)", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes"});
        this.testLoadTables("select * from functional.alltypes union distinct select * from functional.alltypes union all select * from functional.alltypes", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes"});
    }

    @Test
    public void testViewExpansion() throws ImpalaException {
        this.testLoadTables("select * from functional.alltypes_view", 2, 2, new String[]{"default", "functional"}, new String[]{"functional.alltypes_view", "functional.alltypes"});
        this.testLoadTables("select * from functional.view_view", 3, 3, new String[]{"default", "functional"}, new String[]{"functional.view_view", "functional.alltypes_view", "functional.alltypes"});
        this.testLoadTables("select * from functional.view_view, functional.view_view", 3, 3, new String[]{"default", "functional"}, new String[]{"functional.view_view", "functional.alltypes_view", "functional.alltypes"});
        this.testLoadTables("select * from functional.alltypes, functional.view_view", 2, 2, new String[]{"default", "functional"}, new String[]{"functional.view_view", "functional.alltypes_view", "functional.alltypes"});
        this.testLoadTables("select * from functional.alltypes_view, functional.view_view", 2, 2, new String[]{"default", "functional"}, new String[]{"functional.view_view", "functional.alltypes_view", "functional.alltypes"});
        this.testLoadTables("select * from functional.alltypes, functional.alltypes_view, functional.view_view", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.view_view", "functional.alltypes_view", "functional.alltypes"});
    }

    @Test
    public void testResetMetadataStmts() throws ImpalaException {
        this.testNoLoad("invalidate metadata");
        this.testNoLoad("invalidate metadata functional.alltypes");
        this.testNoLoad("refresh functional.alltypes");
        this.testNoLoad("refresh functions functional");
        this.testNoLoad("refresh authorization");
        this.testLoadTables("refresh functional.alltypes partition (year=2009, month=1)", 1, 1, new String[]{"default", "functional"}, new String[]{"functional.alltypes"});
    }

    @Test
    public void testTableWriteID() throws ImpalaException {
        Assume.assumeTrue((MetastoreShim.getMajorVersion() >= 3L ? 1 : 0) != 0);
        this.testLoadAcidTables("select * from functional.insert_only_transactional_table");
    }

    @Test
    public void testCollectPolicyTablesOnFailedTables() throws ImpalaException {
        FeSupport.loadLibrary();
        CatalogdMetaProvider provider = new CatalogdMetaProvider(BackendConfig.INSTANCE.getBackendCfg());
        LocalCatalog catalog = new LocalCatalog((MetaProvider)provider, null);
        Frontend fe = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)catalog);
        EventSequence timeline = new EventSequence("Test Timeline");
        User user = new User("user");
        StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", timeline, user, null);
        LocalDb db = new LocalDb(catalog, "default");
        mdLoader.collectPolicyTables((FeTable)new FailedLoadLocalTable(db, "tbl", TImpalaTableType.TABLE, "comment", new TableLoadingException("error", (Throwable)new Exception())));
    }
}

