/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AnalyzerTest;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.rewrite.EqualityDisjunctsToInRule;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TQueryOptions;
import org.junit.Assert;
import org.junit.Test;

public class ExprRewriterTest
extends AnalyzerTest {
    private final ExprRewriter exprToTrue_ = new ExprRewriter((ExprRewriteRule)ExprToBoolRule.INSTANCE);
    private final ExprRewriter trueToFalse_ = new ExprRewriter((ExprRewriteRule)TrueToFalseRule.INSTANCE);
    private final String stmt_ = "select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10";

    public void RewritesOk(String stmt, int expectedNumChanges, int expectedNumExprTrees) throws ImpalaException {
        StatementBase parsedStmt = this.ParsesOk(stmt);
        this.AnalyzesOkNoRewrite(parsedStmt);
        this.exprToTrue_.reset();
        parsedStmt.rewriteExprs(this.exprToTrue_);
        Assert.assertEquals((long)expectedNumChanges, (long)this.exprToTrue_.getNumChanges());
        this.trueToFalse_.reset();
        parsedStmt.rewriteExprs(this.trueToFalse_);
        Assert.assertEquals((long)expectedNumExprTrees, (long)this.trueToFalse_.getNumChanges());
        parsedStmt.reset();
        this.AnalyzesOkNoRewrite(parsedStmt);
    }

    public void CheckNoRewrite(String stmt) throws ImpalaException {
        this.exprToTrue_.reset();
        AnalysisContext analysisCtx = this.createAnalysisCtx();
        AnalysisContext.AnalysisResult result = this.parseAndAnalyze(stmt, analysisCtx);
        Preconditions.checkNotNull((Object)result.getStmt());
        Assert.assertEquals((long)0L, (long)this.exprToTrue_.getNumChanges());
    }

    private Expr analyze(String query) {
        AnalysisContext ctx = this.createAnalysisCtx();
        ctx.getQueryOptions().setDecimal_v2(true);
        ctx.getQueryOptions().setEnable_expr_rewrites(false);
        return ((SelectListItem)((SelectStmt)this.AnalyzesOk(query, ctx)).getSelectList().getItems().get(0)).getExpr();
    }

    @Test
    public void TestQueryStmts() throws ImpalaException {
        this.RewritesOk("select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10", 23, 11);
        this.RewritesOk("select * from (select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10) v", 23, 11);
        this.RewritesOk(String.format("%s union all (%s) order by cnt", "select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10", "select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10"), 47, 23);
        this.RewritesOk(String.format("select * from (%s union all (%s) order by cnt limit 10) v", "select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10", "select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10"), 47, 23);
        this.RewritesOk("select 1, 2, 3, 4", 4, 4);
        this.RewritesOk("values(1, '2', 3, 4.1), (1, '2', 3, 4.1),(CAST(true OR false AS INT), '2', 3*1+2-4, 1.1%1)", 0, 0);
        this.RewritesOk("values(CONCAT('a', 'b'), true OR true)", 0, 0);
        this.RewritesOk("values(1 <= 2 || 'impala' <> 'IMPALA'), (0.5 BETWEEN 0 AND 1),('a' NOT BETWEEN 'b' AND 'c')", 3, 0);
        this.RewritesOk("values(1 <= 2 AND ((0.5 BETWEEN 0 AND 1) AND (('a' || 'b') = 'ab' AND (true || false))))", 3, 0);
        this.RewritesOk("select id, int_col from functional.alltypes a where exists (select 1 from functional.alltypes where string_col = 'test' having count(*) < 10)", 9, 5);
        this.RewritesOk("select id, int_col from functional.alltypes a where a.id in (select count(*) from functional.alltypes where string_col = 'test' having count(*) < 10)", 10, 6);
    }

    @Test
    public void TestDdlStmts() throws ImpalaException {
        this.RewritesOk("create table ctas_test as select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10", 23, 11);
        this.CheckNoRewrite("create view view_test as select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10");
        this.CheckNoRewrite("alter view functional.alltypes_view as select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10");
    }

    @Test
    public void TestDmlStmts() throws ImpalaException {
        this.RewritesOk("insert into functional.alltypes (id, int_col, float_col, bigint_col) partition(year=2009,month=10) select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10", 23, 11);
        this.RewritesOk("update t2 set name = 'test' from functional.alltypes t1 join functional_kudu.dimtbl t2 on (t1.id = t2.id) where t2.id < 10", 10, 5);
        this.RewritesOk("update functional_kudu.dimtbl set name = 'test', zip = 4711 where exists (select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10)", 28, 16);
        this.RewritesOk("delete a from functional_kudu.testtbl a join functional.testtbl b on a.zip = b.zip", 4, 2);
        this.RewritesOk("delete functional_kudu.testtbl where exists (select a.int_col a, 10 b, 20.2 c, count(b.int_col) cnt from functional.alltypes a join functional.alltypes b on (a.id = b.id)where b.float_col > 1 and b.double_col > 2 group by 1, a.string_col having count(b.int_col) < 3 order by a.int_col, 4 limit 10)", 24, 12);
    }

    private void CreateInList(int offset, int length, StringBuilder stmtSb) {
        stmtSb.append("string_col in(");
        for (int j = 0; j < length - 1; ++j) {
            stmtSb.append("'c").append(offset + j).append("',");
        }
        stmtSb.append("'c").append(offset + length - 1).append("')");
    }

    private void CheckNumChangesByEqualityDisjunctsToInRule(String stmt, int expectedNumChanges) throws ImpalaException {
        StatementBase parsedStmt = this.ParsesOk(stmt);
        this.AnalyzesOkNoRewrite(parsedStmt);
        ExprRewriter rewriter = new ExprRewriter(EqualityDisjunctsToInRule.INSTANCE);
        parsedStmt.rewriteExprs(rewriter);
        Assert.assertEquals((long)expectedNumChanges, (long)rewriter.getNumChanges());
    }

    @Test
    public void TestEqualityDisjunctsToInRuleSizeLimit() throws ImpalaException {
        String stmtPrefix = "select count(*) from functional.alltypes where ( ";
        StringBuilder stmtSb = new StringBuilder(stmtPrefix);
        for (int i = 0; i < 2; ++i) {
            int offset = 9999 * i;
            this.CreateInList(offset, 9999, stmtSb);
            if (i == 1) continue;
            stmtSb.append(" or ");
        }
        stmtSb.append(")");
        this.CheckNumChangesByEqualityDisjunctsToInRule(stmtSb.toString(), 0);
        stmtSb = new StringBuilder(stmtPrefix);
        this.CreateInList(0, 9999, stmtSb);
        stmtSb.append("or string_col='").append(9999).append("')");
        this.CheckNumChangesByEqualityDisjunctsToInRule(stmtSb.toString(), 0);
        stmtSb = new StringBuilder(stmtPrefix);
        this.CreateInList(0, 9998, stmtSb);
        stmtSb.append("or string_col='").append(9998).append("' or string_col='").append(9999).append("')");
        this.CheckNumChangesByEqualityDisjunctsToInRule(stmtSb.toString(), 1);
    }

    @Test
    public void TestToSql() {
        TQueryOptions options = new TQueryOptions();
        options.setEnable_expr_rewrites(true);
        AnalysisContext ctx = this.createAnalysisCtx(options);
        this.assertToSql(ctx, "select 1 + 1", "SELECT 1 + 1", "SELECT 2");
        this.assertToSql(ctx, "select (case when true then 1 else id end) from functional.alltypes union select 1 + 1", "SELECT (CASE WHEN TRUE THEN 1 ELSE id END) FROM functional.alltypes UNION SELECT 1 + 1", "SELECT 1 FROM functional.alltypes UNION SELECT 2");
        this.assertToSql(ctx, "values(1, '2', 3, 4.1), (1, '2', 3, 4.1)", "VALUES((1, '2', 3, 4.1), (1, '2', 3, 4.1))", "SELECT 1, '2', 3, 4.1 UNION ALL SELECT 1, '2', 3, 4.1");
        this.assertToSql(ctx, "select case when 1 = 1 then 1 else 2.0 end from functional.alltypes", "SELECT CASE WHEN 1 = 1 THEN 1 ELSE 2.0 END FROM functional.alltypes", "SELECT 1.0 FROM functional.alltypes");
        this.assertToSql(ctx, "select case when false then 1.0 else 2 end from functional.alltypes", "SELECT CASE WHEN FALSE THEN 1.0 ELSE 2 END FROM functional.alltypes", "SELECT 2.0 FROM functional.alltypes");
        this.assertToSql(ctx, "select * from functional.alltypes where case when true = true then year < 2019 when false then year > 2010 end", "SELECT * FROM functional.alltypes WHERE CASE WHEN TRUE = TRUE THEN `year` < 2019 WHEN FALSE THEN `year` > 2010 END", "SELECT * FROM functional.alltypes WHERE `year` < 2019");
        this.assertToSql(ctx, "select * from (select * from functional.alltypes where id = (select 1 + 1)) a", "SELECT * FROM (SELECT * FROM functional.alltypes WHERE id = (SELECT 1 + 1)) a", "SELECT * FROM (SELECT * FROM functional.alltypes LEFT SEMI JOIN (SELECT 2) `$a$1` (`$c$1`) ON id = `$a$1`.`$c$1`) a");
        this.assertToSql(ctx, "select * from (select * from functional.alltypes where id = (select 1 + 1)) a union select * from (select * from functional.alltypes where id = (select 1 + 1)) b", "SELECT * FROM (SELECT * FROM functional.alltypes WHERE id = (SELECT 1 + 1)) a UNION SELECT * FROM (SELECT * FROM functional.alltypes WHERE id = (SELECT 1 + 1)) b", "SELECT * FROM (SELECT * FROM functional.alltypes LEFT SEMI JOIN (SELECT 2) `$a$1` (`$c$1`) ON id = `$a$1`.`$c$1`) a UNION SELECT * FROM (SELECT * FROM functional.alltypes LEFT SEMI JOIN (SELECT 2) `$a$1` (`$c$1`) ON id = `$a$1`.`$c$1`) b");
        this.assertToSql(ctx, "select * from (select (case when true then 1 else id end) from functional.alltypes union select 1 + 1) v", "SELECT * FROM (SELECT (CASE WHEN TRUE THEN 1 ELSE id END) FROM functional.alltypes UNION SELECT 1 + 1) v", "SELECT * FROM (SELECT 1 FROM functional.alltypes UNION SELECT 2) v");
        this.assertToSql(ctx, "create table ctas_test as select 1 + 1", "CREATE TABLE default.ctas_test\nSTORED AS TEXTFILE\n AS SELECT 1 + 1", "CREATE TABLE default.ctas_test\nSTORED AS TEXTFILE\n AS SELECT 2");
        this.assertToSql(ctx, "insert into functional.alltypes(id) partition(year=2009, month=10) select 1 + 1", "INSERT INTO TABLE functional.alltypes(id) PARTITION (`year`=2009, `month`=10) SELECT 1 + 1", "INSERT INTO TABLE functional.alltypes(id) PARTITION (`year`=2009, `month`=10) SELECT 2");
        this.assertToSql(ctx, "update functional_kudu.alltypes set string_col = 'test' where id = (select 1 + 1)", "UPDATE functional_kudu.alltypes SET string_col = 'test' FROM functional_kudu.alltypes WHERE id = (SELECT 1 + 1)", "UPDATE functional_kudu.alltypes SET string_col = 'test' FROM functional_kudu.alltypes LEFT SEMI JOIN (SELECT 2) `$a$1` (`$c$1`) ON id = `$a$1`.`$c$1` WHERE id = (SELECT 2)");
        this.assertToSql(ctx, "delete functional_kudu.alltypes where id = (select 1 + 1)", "DELETE FROM functional_kudu.alltypes WHERE id = (SELECT 1 + 1)", "DELETE functional_kudu.alltypes FROM functional_kudu.alltypes LEFT SEMI JOIN (SELECT 2) `$a$1` (`$c$1`) ON id = `$a$1`.`$c$1` WHERE id = (SELECT 2)");
        this.assertToSql(ctx, "select * from functional.alltypes where int_col = 1 || int_col = 2 || tinyint_col > 5 || (string_col || string_col) = 'testtest'", "SELECT * FROM functional.alltypes WHERE int_col = 1 OR int_col = 2 OR tinyint_col > 5 OR (concat(string_col, string_col)) = 'testtest'", "SELECT * FROM functional.alltypes WHERE int_col IN (1, 2) OR tinyint_col > 5 OR concat(string_col, string_col) = 'testtest'");
        this.assertToSql(ctx, "select int_col = 1 || int_col = 2, string_col || 'test' from functional.alltypes where (bool_col || id = 2) || (string_col || 'test') = 'testtest'", "SELECT int_col = 1 OR int_col = 2, concat(string_col, 'test') FROM functional.alltypes WHERE (bool_col OR id = 2) OR (concat(string_col, 'test')) = 'testtest'", "SELECT int_col IN (1, 2), concat(string_col, 'test') FROM functional.alltypes WHERE bool_col OR id = 2 OR concat(string_col, 'test') = 'testtest'");
        StatementBase stmt = (StatementBase)this.AnalyzesOk("with t as (select 1 + 1) select id from functional.alltypes union select id from functional.alltypesagg", ctx);
        Assert.assertEquals((Object)stmt.toSql(), (Object)stmt.toSql());
    }

    @Test
    public void TestToSqlWithImplicitCasts() {
        TQueryOptions options = new TQueryOptions();
        options.setEnable_expr_rewrites(true);
        AnalysisContext ctx = this.createAnalysisCtx(options);
        this.assertToSqlWithImplicitCasts(ctx, "select * from functional_kudu.alltypestiny where bigint_col < 1000 / 100", "SELECT * FROM functional_kudu.alltypestiny WHERE CAST(bigint_col AS DOUBLE) < CAST(10 AS DOUBLE)");
        this.assertToSqlWithImplicitCasts(ctx, "select float_col + 1.1 from functional.alltypestiny", "SELECT CAST(float_col AS DECIMAL(38,9)) + CAST(1.1 AS DECIMAL(2,1)) FROM functional.alltypestiny");
        this.assertToSqlWithImplicitCasts(ctx, "select cast(2 as bigint)", "SELECT CAST(2 AS BIGINT)");
        this.assertToSqlWithImplicitCasts(ctx, "select cast(2 as decimal(38,37))", "SELECT CAST(2.0000000000000000000000000000000000000 AS DECIMAL(38,37))");
        this.assertToSqlWithImplicitCasts(ctx, "select d1 - 1.1 from functional.decimal_tbl", "SELECT d1 - CAST(1.1 AS DECIMAL(2,1)) FROM functional.decimal_tbl");
        this.assertToSqlWithImplicitCasts(ctx, "select * from functional.date_tbl where date_col = '2017-11-28'", "SELECT * FROM functional.date_tbl WHERE date_col = DATE '2017-11-28'");
        this.assertToSqlWithImplicitCasts(ctx, "select * from functional.alltypes, functional.date_tbl where timestamp_col = date_col", "SELECT * FROM functional.alltypes, functional.date_tbl WHERE timestamp_col = CAST(date_col AS TIMESTAMP)");
        this.assertToSqlWithImplicitCasts(ctx, "select round(1.2345, 2) * pow(10, 10)", "SELECT CAST(12300000000 AS DOUBLE)");
        this.assertToSqlWithImplicitCasts(ctx, "select * from functional.alltypes where double_col in (int_col, bigint_col)", "SELECT * FROM functional.alltypes WHERE double_col IN (CAST(int_col AS DOUBLE), CAST(bigint_col AS DOUBLE))");
        this.assertToSqlWithImplicitCasts(ctx, "select * from functional.alltypes where double_col between smallint_col and int_col", "SELECT * FROM functional.alltypes WHERE double_col >= CAST(smallint_col AS DOUBLE) AND double_col <= CAST(int_col AS DOUBLE)");
        this.assertToSqlWithImplicitCasts(ctx, "select * from (select 10 as i, 2 as j, 2013 as s) as t where t.i < 10", "SELECT * FROM (SELECT CAST(10 AS TINYINT) i, CAST(2 AS TINYINT) j, CAST(2013 AS SMALLINT) s) t WHERE t.i < CAST(10 AS TINYINT)");
        this.assertToSqlWithImplicitCasts(ctx, "select * from (select id, int_col, year,  sum(int_col)  over(partition by year order by id) as s from functional.alltypes) v  where year = 2009 and id = 1 and int_col < 10 and s = 4", "SELECT * FROM (SELECT id, int_col, `year`, sum(int_col) OVER (PARTITION BY `year` ORDER BY id ASC) s FROM functional.alltypes) v WHERE `year` = CAST(2009 AS INT) AND id = CAST(1 AS INT) AND int_col < CAST(10 AS INT) AND s = CAST(4 AS BIGINT)");
        this.assertToSqlWithImplicitCasts(ctx, "select * from functional.alltypes where int_col = 1 or int_col = 2 or tinyint_col > 5 AND (float_col = 5 or double_col = 6)", "SELECT * FROM functional.alltypes WHERE int_col IN (CAST(1 AS INT), CAST(2 AS INT)) OR tinyint_col > CAST(5 AS TINYINT) AND (float_col = CAST(5 AS FLOAT) OR double_col = CAST(6 AS DOUBLE))");
        this.checkNumericLiteralCasts(ctx, "tinyint_col", "1", "TINYINT");
        this.checkNumericLiteralCasts(ctx, "smallint_col", "1", "TINYINT");
        this.checkNumericLiteralCasts(ctx, "smallint_col", "1000", "SMALLINT");
        this.checkNumericLiteralCasts(ctx, "int_col", "1", "TINYINT");
        this.checkNumericLiteralCasts(ctx, "int_col", "1000", "SMALLINT");
        this.checkNumericLiteralCasts(ctx, "int_col", "1000000", "INT");
        this.checkNumericLiteralCasts(ctx, "bigint_col", "1", "TINYINT");
        this.checkNumericLiteralCasts(ctx, "bigint_col", "1000", "SMALLINT");
        this.checkNumericLiteralCasts(ctx, "bigint_col", "1000000", "INT");
        this.checkNumericLiteralCasts(ctx, "bigint_col", "10000000000", "BIGINT");
        this.checkNumericLiteralCasts(ctx, "float_col", "1", "TINYINT");
        this.checkNumericLiteralCasts(ctx, "float_col", "1.0", "DECIMAL(2,1)");
        this.checkNumericLiteralCasts(ctx, "float_col", "100000.001", "DECIMAL(9,3)");
        this.checkNumericLiteralCasts(ctx, "double_col", "1", "TINYINT");
        this.checkNumericLiteralCasts(ctx, "double_col", "1.0", "DECIMAL(2,1)");
        this.checkNumericLiteralCasts(ctx, "double_col", "100000.001", "DECIMAL(9,3)");
    }

    private void checkNumericLiteralCasts(AnalysisContext ctx, String columnName, String data, String castColumn) {
        String query = "insert into table functional.alltypesnopart (" + columnName + ") values(" + data + ")";
        String expectedToSql = "INSERT INTO TABLE functional.alltypesnopart(" + columnName + ") SELECT CAST(" + data + " AS " + castColumn + ")";
        this.assertToSqlWithImplicitCasts(ctx, query, expectedToSql);
    }

    private void assertToSql(AnalysisContext ctx, String query, String expectedToSql, String expectedToRewrittenSql) {
        StatementBase stmt = (StatementBase)this.AnalyzesOk(query, ctx);
        Assert.assertEquals((Object)expectedToSql, (Object)stmt.toSql(ToSqlOptions.DEFAULT));
        Assert.assertEquals((Object)expectedToSql, (Object)stmt.toSql());
        Assert.assertEquals((Object)expectedToRewrittenSql, (Object)stmt.toSql(ToSqlOptions.REWRITTEN));
    }

    private void assertToSqlWithImplicitCasts(AnalysisContext ctx, String query, String expectedToSqlWithImplicitCasts) {
        StatementBase stmt = (StatementBase)this.AnalyzesOk(query, ctx);
        String actual = stmt.toSql(ToSqlOptions.SHOW_IMPLICIT_CASTS);
        Assert.assertEquals((String)("Bad sql with implicit casts from original query:\n" + query), (Object)expectedToSqlWithImplicitCasts, (Object)actual);
    }

    @Test
    public void TestToSqlWithAppxCountDistinctAndDefaultNdvs() {
        TQueryOptions options = new TQueryOptions();
        options.setEnable_expr_rewrites(true);
        AnalysisContext ctx = this.createAnalysisCtx(options);
        String countDistinctSql = "SELECT count(DISTINCT id) FROM functional.alltypes";
        this.assertToSql(ctx, countDistinctSql, countDistinctSql, countDistinctSql);
        options.setAppx_count_distinct(true);
        this.assertToSql(this.createAnalysisCtx(options), countDistinctSql, countDistinctSql, "SELECT ndv(id) FROM functional.alltypes");
        options.setDefault_ndv_scale(10);
        this.assertToSql(this.createAnalysisCtx(options), countDistinctSql, countDistinctSql, "SELECT ndv(id, 10) FROM functional.alltypes");
        String ndvSql = "SELECT ndv(id) FROM functional.alltypes";
        options.setDefault_ndv_scale(2);
        this.assertToSql(this.createAnalysisCtx(options), ndvSql, ndvSql, ndvSql);
        options.setDefault_ndv_scale(9);
        this.assertToSql(this.createAnalysisCtx(options), ndvSql, ndvSql, "SELECT ndv(id, 9) FROM functional.alltypes");
        String sql1 = "SELECT ndv(id), ndv(id, 5), count(DISTINCT id) FROM functional.alltypes";
        options.setDefault_ndv_scale(5).setAppx_count_distinct(true);
        this.assertToSql(this.createAnalysisCtx(options), sql1, sql1, "SELECT ndv(id, 5), ndv(id, 5), ndv(id, 5) FROM functional.alltypes");
        options.setDefault_ndv_scale(5).setAppx_count_distinct(false);
        this.assertToSql(this.createAnalysisCtx(options), sql1, sql1, "SELECT ndv(id, 5), ndv(id, 5), count(DISTINCT id) FROM functional.alltypes");
        options.setDefault_ndv_scale(9).setAppx_count_distinct(true);
        this.assertToSql(this.createAnalysisCtx(options), sql1, sql1, "SELECT ndv(id, 9), ndv(id, 5), ndv(id, 9) FROM functional.alltypes");
        options.setDefault_ndv_scale(3).setAppx_count_distinct(false);
        this.assertToSql(this.createAnalysisCtx(options), sql1, sql1, "SELECT ndv(id, 3), ndv(id, 5), count(DISTINCT id) FROM functional.alltypes");
        options.setDefault_ndv_scale(2).setAppx_count_distinct(true);
        this.assertToSql(this.createAnalysisCtx(options), sql1, sql1, "SELECT ndv(id), ndv(id, 5), ndv(id) FROM functional.alltypes");
        options.setDefault_ndv_scale(2).setAppx_count_distinct(false);
        this.assertToSql(this.createAnalysisCtx(options), sql1, sql1, "SELECT ndv(id), ndv(id, 5), count(DISTINCT id) FROM functional.alltypes");
    }

    @Test
    public void TestShouldConvertToCNF() {
        TQueryOptions options = new TQueryOptions();
        options.setEnable_expr_rewrites(false);
        AnalysisContext ctx = this.createAnalysisCtx(options);
        List<String> convertablePredicates = Arrays.asList("select (1=cast(1 as int))", "select (cast(d_date_sk as int) = 10) from tpcds_parquet.date_dim", "select (d_date_sk = d_year) from tpcds_parquet.date_dim", "select (d_date_sk between 1 and 10) from tpcds_parquet.date_dim", "select (d_date_sk in (1,2,10)) from tpcds_parquet.date_dim", "select (d_date_sk is null) from tpcds_parquet.date_dim", "select (cos(1) = 1.1)", "select (cast(d_date_sk as int) * 2 = 10) from tpcds_parquet.date_dim", "select ((2 = cast(1 as int)) and (cos(1) = 1))", "select ((2 = cast(1 as int)) or (cast(0 as int) is not null))", "select (sin(cos(2*pi())))");
        for (String query : convertablePredicates) {
            Expr expr = this.analyze(query);
            Assert.assertTrue((String)("Should convert to CNF: " + query), (boolean)expr.shouldConvertToCNF());
        }
        List<String> inconvertablePredicates = Arrays.asList("select (upper(d_day_name) = 'A') from tpcds_parquet.date_dim", "select (d_day_name like '%A') from tpcds_parquet.date_dim", "select (coalesce(d_date_sk, -1) = d_year) from tpcds_parquet.date_dim", "select (log10(cast(1 + length(upper(d_day_name)) as double)) > 1.0) from tpcds_parquet.date_dim");
        for (String query : inconvertablePredicates) {
            Expr expr = this.analyze(query);
            Assert.assertFalse((String)("Should not convert to CNF: " + query), (boolean)expr.shouldConvertToCNF());
        }
    }

    static class TrueToFalseRule
    implements ExprRewriteRule {
        public static TrueToFalseRule INSTANCE = new TrueToFalseRule();

        public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
            if (Expr.IS_TRUE_LITERAL.apply((Object)expr)) {
                return new BoolLiteral(false);
            }
            return expr;
        }

        private TrueToFalseRule() {
        }
    }

    static class ExprToBoolRule
    implements ExprRewriteRule {
        public static ExprToBoolRule INSTANCE = new ExprToBoolRule();

        public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
            if (expr.contains(Subquery.class)) {
                return expr;
            }
            if (Expr.IS_TRUE_LITERAL.apply((Object)expr)) {
                return expr;
            }
            return new BoolLiteral(true);
        }

        private ExprToBoolRule() {
        }
    }
}

