/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.AnalysisSessionFixture;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.QueryFixture;
import org.apache.impala.common.SqlCastException;
import org.apache.impala.rewrite.BetweenToCompoundRule;
import org.apache.impala.rewrite.ConvertToCNFRule;
import org.apache.impala.rewrite.CountDistinctToNdvRule;
import org.apache.impala.rewrite.DefaultNdvScaleRule;
import org.apache.impala.rewrite.EqualityDisjunctsToInRule;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.rewrite.ExtractCommonConjunctRule;
import org.apache.impala.rewrite.ExtractCompoundVerticalBarExprRule;
import org.apache.impala.rewrite.FoldConstantsRule;
import org.apache.impala.rewrite.NormalizeBinaryPredicatesRule;
import org.apache.impala.rewrite.NormalizeCountStarRule;
import org.apache.impala.rewrite.NormalizeExprsRule;
import org.apache.impala.rewrite.SimplifyCastExprRule;
import org.apache.impala.rewrite.SimplifyCastStringToTimestamp;
import org.apache.impala.rewrite.SimplifyConditionalsRule;
import org.apache.impala.rewrite.SimplifyDistinctFromRule;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExprRewriteRulesTest
extends FrontendTestBase {
    public static AnalysisSessionFixture session = new AnalysisSessionFixture();

    @BeforeClass
    public static void setup() {
        session.options().setEnable_expr_rewrites(false);
    }

    public Expr RewritesOk(String exprStr, ExprRewriteRule rule, String expectedExprStr) throws ImpalaException {
        return this.RewritesOk("functional.alltypessmall", exprStr, rule, expectedExprStr);
    }

    public Expr RewritesOk(String tableName, String exprStr, ExprRewriteRule rule, String expectedExprStr) throws ImpalaException {
        return this.RewritesOk(tableName, exprStr, Lists.newArrayList((Object[])new ExprRewriteRule[]{rule}), expectedExprStr);
    }

    public Expr RewritesOk(String exprStr, List<ExprRewriteRule> rules, String expectedExprStr) throws ImpalaException {
        return this.RewritesOk("functional.alltypessmall", exprStr, rules, expectedExprStr);
    }

    public Expr RewritesOk(String tableName, String exprStr, List<ExprRewriteRule> rules, String expectedExprStr) throws ImpalaException {
        SelectRewriteFixture qf = new SelectRewriteFixture(session);
        qf.table(tableName);
        qf.exprSql(exprStr);
        qf.analyze();
        return qf.verifySelectRewrite(rules, expectedExprStr);
    }

    public Expr RewritesOkWhereExpr(String exprStr, ExprRewriteRule rule, String expectedExprStr) throws ImpalaException {
        return this.RewritesOkWhereExpr(exprStr, Lists.newArrayList((Object[])new ExprRewriteRule[]{rule}), expectedExprStr);
    }

    public Expr RewritesOkWhereExpr(String exprStr, List<ExprRewriteRule> rules, String expectedExprStr) throws ImpalaException {
        SelectRewriteFixture qf = new SelectRewriteFixture(session);
        qf.table("functional.alltypessmall");
        qf.whereSql(exprStr);
        qf.analyze();
        return qf.verifyWhereRewrite(rules, expectedExprStr);
    }

    public String repeat(String givenStr, long numberOfRepetitions) {
        StringBuilder resultStr = new StringBuilder();
        resultStr.append("'");
        for (long i = 0L; i < numberOfRepetitions; ++i) {
            resultStr.append(givenStr);
        }
        resultStr.append("'");
        System.out.println("resultStr.length(): " + resultStr.length());
        return resultStr.toString();
    }

    @Test
    public void testBetweenToCompoundRule() throws ImpalaException {
        ExprRewriteRule rule = BetweenToCompoundRule.INSTANCE;
        this.RewritesOk("int_col between float_col and double_col", rule, "int_col >= float_col AND int_col <= double_col");
        this.RewritesOk("int_col not between float_col and double_col", rule, "int_col < float_col OR int_col > double_col");
        this.RewritesOk("50.0 between null and 5000", rule, "50.0 >= NULL AND 50.0 <= 5000");
        this.RewritesOk("int_col between 10 and 20", rule, "int_col >= 10 AND int_col <= 20");
        this.RewritesOk("int_col not between 10 and 20", rule, "int_col < 10 OR int_col > 20");
        this.RewritesOk("50.0 not between null and 5000", rule, "50.0 < NULL OR 50.0 > 5000");
        this.RewritesOk("int_col between if(tinyint_col between 1 and 2, 10, 20) and cast(smallint_col between 1 and 2 as int)", rule, "int_col >= if(tinyint_col >= 1 AND tinyint_col <= 2, 10, 20) AND int_col <= CAST(smallint_col >= 1 AND smallint_col <= 2 AS INT)");
        this.RewritesOk("int_col not between if(tinyint_col not between 1 and 2, 10, 20) and cast(smallint_col not between 1 and 2 as int)", rule, "int_col < if(tinyint_col < 1 OR tinyint_col > 2, 10, 20) OR int_col > CAST(smallint_col < 1 OR smallint_col > 2 AS INT)");
        this.RewritesOk("int_col between if(tinyint_col between 1 and 2, 10, 20) and cast(smallint_col not between 1 and 2 as int)", rule, "int_col >= if(tinyint_col >= 1 AND tinyint_col <= 2, 10, 20) AND int_col <= CAST(smallint_col < 1 OR smallint_col > 2 AS INT)");
    }

    @Test
    public void testExtractCommonConjunctsRule() throws ImpalaException {
        ExprRewriteRule rule = ExtractCommonConjunctRule.INSTANCE;
        this.RewritesOk("(int_col < 10 and bigint_col < 10) or (string_col = '10' and int_col < 10)", rule, "int_col < 10 AND ((bigint_col < 10) OR (string_col = '10'))");
        this.RewritesOk("(int_col < 10 and bigint_col < 10) or (string_col = '10' and int_col < 10) or (id < 20 and int_col < 10) or (int_col < 10 and float_col > 3.14)", rule, "int_col < 10 AND ((bigint_col < 10) OR (string_col = '10') OR (id < 20) OR (float_col > 3.14))");
        this.RewritesOk("((int_col < 10 and bigint_col < 10) or  (string_col = '10' and int_col < 10)) or ((id < 20 and int_col < 10) or  (int_col < 10 and float_col > 3.14))", rule, "int_col < 10 AND ((bigint_col < 10) OR (string_col = '10') OR (id < 20) OR (float_col > 3.14))");
        this.RewritesOk("(int_col < 10 and bigint_col < 10 and bool_col is null) or (bool_col is null and string_col = '10' and int_col < 10)", rule, "int_col < 10 AND bool_col IS NULL AND ((bigint_col < 10) OR (string_col = '10'))");
        this.RewritesOk("(!(int_col=5 or tinyint_col > 9) and double_col = 7) or (!(int_col=5 or tinyint_col > 9) and double_col = 8)", rule, "NOT (int_col = 5 OR tinyint_col > 9) AND ((double_col = 7) OR (double_col = 8))");
        this.RewritesOk("(int_col between 10 and 30 and bigint_col < 10) or (string_col = '10' and int_col between 10 and 30) or (id < 20 and int_col between 10 and 30) or (int_col between 10 and 30 and float_col > 3.14)", rule, "int_col BETWEEN 10 AND 30 AND ((bigint_col < 10) OR (string_col = '10') OR (id < 20) OR (float_col > 3.14))");
        this.RewritesOk("(int_col not between 10 and 30 and bigint_col < 10) or (string_col = '10' and int_col not between 10 and 30) or (id < 20 and int_col not between 10 and 30) or (int_col not between 10 and 30 and float_col > 3.14)", rule, "int_col NOT BETWEEN 10 AND 30 AND ((bigint_col < 10) OR (string_col = '10') OR (id < 20) OR (float_col > 3.14))");
        this.RewritesOk("(int_col not between 10 and 30 and bigint_col < 10) or (string_col = '10' and int_col between 10 and 30) or (id < 20 and int_col not between 10 and 30) or (int_col between 10 and 30 and float_col > 3.14)", rule, null);
        this.RewritesOk("(int_col < 10 and id between 5 and 6) or (id between 5 and 6 and int_col < 10) or (int_col < 10 and id between 5 and 6)", rule, "int_col < 10 AND id BETWEEN 5 AND 6");
        this.RewritesOk("(int_col < 10) or (int_col < 10 and bigint_col < 10 and bool_col is null) or (int_col < 10) or (bool_col is null and int_col < 10)", rule, "int_col < 10");
        this.RewritesOk("(int_col < 10 and bigint_col < 10) or (string_col = '10' and int_col < 10) or (id < 20 and int_col < 10) or (int_col < 10 and id < 20)", rule, "int_col < 10 AND ((bigint_col < 10) OR (string_col = '10') OR (id < 20) OR (id < 20))");
    }

    @Test
    public void testFoldConstantsRule() throws ImpalaException {
        ExprRewriteRule rule = FoldConstantsRule.INSTANCE;
        this.RewritesOk("1 + 1", rule, "2");
        this.RewritesOk("1 + 1 + 1 + 1 + 1", rule, "5");
        this.RewritesOk("10 - 5 - 2 - 1 - 8", rule, "-6");
        this.RewritesOk("cast('2016-11-09' as date)", rule, "DATE '2016-11-09'");
        this.RewritesOk("cast('2016-11-09' as timestamp)", rule, "TIMESTAMP '2016-11-09 00:00:00'");
        this.RewritesOk("cast('2016-11-09' as timestamp) + interval 1 year", rule, "TIMESTAMP '2017-11-09 00:00:00'");
        this.RewritesOk("CAST('9999-12-31 21:00:00' AS TIMESTAMP) + INTERVAL 1 DAYS", rule, "TIMESTAMP '9999-12-31 21:00:00' + INTERVAL 1 DAYS");
        this.RewritesOk("'_' LIKE '\\\\_'", rule, "TRUE");
        this.RewritesOk("base64decode(base64encode('\\047\\001\\132\\060')) = '\\047\\001\\132\\060'", rule, "TRUE");
        this.RewritesOk("hex(unhex(hex(unhex('D3'))))", rule, null);
        this.RewritesOk("rand()", rule, null);
        this.RewritesOk("random()", rule, null);
        this.RewritesOk("uuid()", rule, null);
        this.RewritesOk("null + 1", rule, "NULL");
        this.RewritesOk("(1 + 1) is null", rule, "FALSE");
        this.RewritesOk("(null + 1) is null", rule, "TRUE");
        this.RewritesOk("repeat('AZ', 2)", rule, "'AZAZ'");
        this.RewritesOk("repeat('A', 65536)", rule, this.repeat("A", 65536L));
        this.RewritesOk("repeat('A', 4294967296)", rule, null);
        this.RewritesOk("cast(concat('a', 'b') as binary)", rule, "'ab'");
    }

    @Test
    public void testIf() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        this.RewritesOk("if(true, id, id+1)", rule, "id");
        this.RewritesOk("if(false, id, id+1)", rule, "id + 1");
        this.RewritesOk("if(null, id, id+1)", rule, "id + 1");
        this.RewritesOk("if(id = 0, true, false)", rule, null);
    }

    @Test
    public void testIfNull() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        for (String f : ImmutableList.of((Object)"ifnull", (Object)"isnull", (Object)"nvl")) {
            this.RewritesOk(f + "(null, id)", rule, "id");
            this.RewritesOk(f + "(null, null)", rule, "NULL");
            this.RewritesOk(f + "(id, id + 1)", rule, null);
            this.RewritesOk(f + "(1, 2)", rule, "1");
            this.RewritesOk(f + "(0, id)", rule, "0");
        }
    }

    @Test
    public void testCompoundPredicate() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{NormalizeExprsRule.INSTANCE, SimplifyConditionalsRule.INSTANCE});
        this.RewritesOk("id = 0 OR false", rules, "id = 0");
        this.RewritesOk("id = 0 OR true", rules, "TRUE");
        this.RewritesOk("id = 0 && false", rules, "FALSE");
        this.RewritesOk("id = 0 && true", rules, "id = 0");
        this.RewritesOk("false OR id = 0 AND true", rules, "id = 0");
        this.RewritesOk("true AND id = 0 OR false", rules, "id = 0");
    }

    @Test
    public void testCaseWithExpr() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        ArrayList<ExprRewriteRule> rules = new ArrayList<ExprRewriteRule>();
        rules.add(FoldConstantsRule.INSTANCE);
        rules.add(rule);
        this.RewritesOk("case 1 when 0 then id when 1 then id + 1 when 2 then id + 2 end", rule, "id + 1");
        this.RewritesOk("case 1 when id then id when 1 then id + 1 end", rule, "CASE 1 WHEN id THEN id ELSE id + 1 END");
        this.RewritesOk("case 0 when 1 then 1 when id then id + 1 end", rule, "CASE 0 WHEN id THEN id + 1 END");
        this.RewritesOk("case 2 when 0 then id when 1 then id * 2 else 0 end", rule, "0");
        this.RewritesOk("case 3 when 0 then id when 1 then id + 1 end", rule, "NULL");
        this.RewritesOk("case 1 when id then id when 2 - 1 then id + 1 when 1 then id + 2 end", rules, "CASE 1 WHEN id THEN id ELSE id + 1 END");
        this.RewritesOk("case 0 when null then id else 1 end", rule, "1");
        this.RewritesOk("case id when 1 then 1 when 2 then 2 else 3 end", rule, null);
        this.RewritesOk("case NULL when id then id else 1 end", rule, null);
        this.RewritesOk("case case 1 when 0 then 0 when 1 then id end when 2 then id + 2 else id + 3 end", rule, "CASE id WHEN 2 THEN id + 2 ELSE id + 3 END");
        this.RewritesOk("case case 3 when 0 then id when 1 then id + 1 end when 2 then id + 2 end", rule, "CASE NULL WHEN 2 THEN id + 2 END");
    }

    @Test
    public void testCaseWithoutExpr() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        ArrayList<ExprRewriteRule> rules = new ArrayList<ExprRewriteRule>();
        rules.add(FoldConstantsRule.INSTANCE);
        rules.add(rule);
        this.RewritesOk("case when FALSE then 0 when TRUE then 1 end", rule, "1");
        this.RewritesOk("case when id = 0 then 0 when true then 1 when id = 2 then 2 end", rule, "CASE WHEN id = 0 THEN 0 ELSE 1 END");
        this.RewritesOk("case when id = 0 then 0 when false then 1 when id = 2 then 2 end", rule, "CASE WHEN id = 0 THEN 0 WHEN id = 2 THEN 2 END");
        this.RewritesOk("case when false then 1 when false then 2 else id + 1 end", rule, "id + 1");
        this.RewritesOk("case when false then 0 end", rule, "NULL");
        this.RewritesOk("case when id = 1 then 0 when 2 = 1 + 1 then 1 when true then 2 end", rules, "CASE WHEN id = 1 THEN 0 ELSE 1 END");
        this.RewritesOk("case when id = 0 then 0 when null then 1 else 2 end", rule, "CASE WHEN id = 0 THEN 0 ELSE 2 END");
        this.RewritesOk("case when id = 0 then 0 when id = 1 then 1 end", rule, null);
        this.RewritesOk("case when id = 1 then 10 when false then 20 when true then 30 else 40 end", rule, "CASE WHEN id = 1 THEN 10 ELSE 30 END");
        this.RewritesOkWhereExpr("case when true then id < 50 end", rule, "id < 50");
        this.RewritesOkWhereExpr("case when false then id > 50 when true then id < 50 END", rule, "id < 50");
        this.RewritesOkWhereExpr("case when true then id > 30 when true then id = 30 when true then id < 30 END", rule, "id > 30");
    }

    @Test
    public void testDecode() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        ArrayList<ExprRewriteRule> rules = new ArrayList<ExprRewriteRule>();
        rules.add(FoldConstantsRule.INSTANCE);
        rules.add(rule);
        this.RewritesOk("decode(1, 0, id, 1, id + 1, 2, id + 2)", rules, "id + 1");
        this.RewritesOk("decode(1, id, id, 1, id + 1, 0)", rules, "CASE WHEN 1 = id THEN id ELSE id + 1 END");
        this.RewritesOk("decode(1, 0, id, tinyint_col, id + 1)", rules, "CASE WHEN 1 = tinyint_col THEN id + 1 END");
        this.RewritesOk("decode(1, 0, id, 2, 2, 3)", rules, "3");
        this.RewritesOk("decode(1, 1 + 1, id, 1 + 2, 3)", rules, "NULL");
        this.RewritesOk("decode(1, id, id, 1 + 1, 0, 1 * 1, 1, 2 - 1, 2)", rules, "CASE WHEN 1 = id THEN id ELSE 1 END");
        this.RewritesOk("decode(id, null, 0, 1)", rules, null);
        this.RewritesOk("decode(id, 1, 1, 2, 2)", rules, null);
    }

    @Test
    public void testExcludeAggregates() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        this.RewritesOk("if(true, 0, sum(id))", rule, null);
        this.RewritesOk("if(false, max(id), min(id))", rule, "min(id)");
        this.RewritesOk("true || sum(id) = 0", rule, null);
        this.RewritesOk("ifnull(null, max(id))", rule, "max(id)");
        this.RewritesOk("ifnull(1, max(id))", rule, null);
        this.RewritesOk("case when true then 0 when false then sum(id) end", rule, null);
        this.RewritesOk("case when true then count(id) when false then sum(id) end", rule, "count(id)");
        this.RewritesOk("sum(id) is distinct from null", rule, null);
        this.RewritesOk("sum(id) is distinct from sum(id)", rule, null);
    }

    @Test
    public void testCoalesce() throws ImpalaException {
        ExprRewriteRule rule = SimplifyConditionalsRule.INSTANCE;
        ArrayList<ExprRewriteRule> rules = new ArrayList<ExprRewriteRule>();
        rules.add(FoldConstantsRule.INSTANCE);
        rules.add(rule);
        this.RewritesOk("coalesce(null, id, year)", rule, "coalesce(id, `year`)");
        this.RewritesOk("coalesce(null, 1, id)", rule, "1");
        this.RewritesOk("coalesce(null, null, id)", rule, "id");
        this.RewritesOk("coalesce(1, id, year)", rule, "1");
        this.RewritesOk("coalesce(id)", rule, "id");
        this.RewritesOk("coalesce(null, null)", rule, "NULL");
        this.RewritesOk("coalesce(null is null, id)", rule, null);
        this.RewritesOk("coalesce(10 + null, id)", rule, null);
        this.RewritesOk("coalesce(1 + 2, id, year)", rules, "3");
        this.RewritesOk("coalesce(null is null, bool_col)", rules, "TRUE");
        this.RewritesOk("coalesce(10 + null, id, year)", rules, "coalesce(id, `year`)");
        this.RewritesOk("coalesce(year, id)", rule, null);
        this.RewritesOk("functional_kudu.alltypessmall", "coalesce(id, `year`)", rule, null);
        this.RewritesOk("coalesce(null, min(distinct tinyint_col), 42)", rule, "coalesce(min(tinyint_col), 42)");
    }

    @Test
    public void TestCoalesceDecimal() throws ImpalaException {
        String query = "SELECT coalesce(1.8, CAST(0 AS DECIMAL(38,38))) AS c  FROM functional.alltypestiny";
        for (int i = 0; i < 2; ++i) {
            boolean rewrite = i == 1;
            AnalysisContext ctx = this.createAnalysisCtx();
            ctx.getQueryOptions().setEnable_expr_rewrites(rewrite);
            ctx.getQueryOptions().setDecimal_v2(false);
            SelectStmt stmt = (SelectStmt)this.AnalyzesOk(query, ctx);
            Expr expr = ((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
            Assert.assertTrue((boolean)(expr instanceof FunctionCallExpr));
            Assert.assertEquals((Object)ScalarType.createDecimalType((int)38, (int)38), (Object)expr.getType());
            Expr arg = (Expr)expr.getChild(0);
            Assert.assertTrue((boolean)(arg instanceof CastExpr));
            Assert.assertEquals((Object)ScalarType.createDecimalType((int)38, (int)38), (Object)arg.getType());
            Expr num = (Expr)arg.getChild(0);
            Assert.assertTrue((boolean)(num instanceof NumericLiteral));
            Assert.assertEquals((Object)ScalarType.createDecimalType((int)2, (int)1), (Object)num.getType());
        }
        try {
            AnalysisContext ctx = this.createAnalysisCtx();
            ctx.getQueryOptions().setEnable_expr_rewrites(true);
            ctx.getQueryOptions().setDecimal_v2(true);
            this.parseAndAnalyze(query, ctx);
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
    }

    @Test
    public void testNormalizeExprsRule() throws ImpalaException {
        ExprRewriteRule rule = NormalizeExprsRule.INSTANCE;
        this.RewritesOk("id = 0 OR false", rule, "FALSE OR id = 0");
        this.RewritesOk("null AND true", rule, "TRUE AND NULL");
        this.RewritesOk("true and id = 0", rule, null);
        this.RewritesOk("false or id = 1", rule, null);
        this.RewritesOk("false or true", rule, null);
    }

    @Test
    public void testNormalizeBinaryPredicatesRule() throws ImpalaException {
        ExprRewriteRule rule = NormalizeBinaryPredicatesRule.INSTANCE;
        this.RewritesOk("0 = id", rule, "id = 0");
        this.RewritesOk("cast(0 as double) = id", rule, "id = CAST(0 AS DOUBLE)");
        this.RewritesOk("1 + 1 = cast(id as int)", rule, "CAST(id AS INT) = 1 + 1");
        this.RewritesOk("5 = id + 2", rule, "id + 2 = 5");
        this.RewritesOk("5 + 3 = id", rule, "id = 5 + 3");
        this.RewritesOk("tinyint_col + smallint_col = int_col", rule, "int_col = tinyint_col + smallint_col");
        this.RewritesOk("5 = 6", rule, null);
        this.RewritesOk("id = 5", rule, null);
        this.RewritesOk("cast(id as int) = int_col", rule, null);
        this.RewritesOk("int_col = cast(id as int)", rule, null);
        this.RewritesOk("int_col = tinyint_col", rule, null);
        this.RewritesOk("tinyint_col = int_col", rule, null);
    }

    @Test
    public void testEqualityDisjunctsToInRule() throws ImpalaException {
        ExprRewriteRule edToInrule = EqualityDisjunctsToInRule.INSTANCE;
        ExprRewriteRule normalizeRule = NormalizeBinaryPredicatesRule.INSTANCE;
        ArrayList comboRules = Lists.newArrayList((Object[])new ExprRewriteRule[]{normalizeRule, edToInrule});
        this.RewritesOk("int_col = 1 or int_col = 2", edToInrule, "int_col IN (1, 2)");
        this.RewritesOk("int_col = 1 or int_col = 2 or int_col = 3", edToInrule, "int_col IN (1, 2, 3)");
        this.RewritesOk("(int_col = 1 or int_col = 2) or (int_col = 3 or int_col = 4)", edToInrule, "int_col IN (1, 2, 3, 4)");
        this.RewritesOk("float_col = 1.1 or float_col = 2.2 or float_col = 3.3", edToInrule, "float_col IN (1.1, 2.2, 3.3)");
        this.RewritesOk("string_col = '1' or string_col = '2' or string_col = '3'", edToInrule, "string_col IN ('1', '2', '3')");
        this.RewritesOk("bool_col = true or bool_col = false or bool_col = true", edToInrule, "bool_col IN (TRUE, FALSE, TRUE)");
        this.RewritesOk("bool_col = null or bool_col = null or bool_col is null", edToInrule, "bool_col IN (NULL, NULL) OR bool_col IS NULL");
        this.RewritesOk("int_col * 3 = 6 or int_col * 3 = 9 or int_col * 3 = 12", edToInrule, "int_col * 3 IN (6, 9, 12)");
        this.RewritesOk("(int_col = 1 or int_col = 2) or (int_col = 3 and int_col = 4)", edToInrule, "int_col IN (1, 2) OR (int_col = 3 AND int_col = 4)");
        this.RewritesOk("1 = int_col or 2 = int_col or 3 = int_col AND (float_col = 5 or float_col = 6)", edToInrule, "1 = int_col OR 2 = int_col OR 3 = int_col AND float_col IN (5, 6)");
        this.RewritesOk("int_col * 3 = 6 or int_col * 3 = 9 or int_col * 3 <= 12", edToInrule, "int_col * 3 IN (6, 9) OR int_col * 3 <= 12");
        this.RewritesOk("1 = int_col or 2 = int_col or 3 = int_col AND (float_col = 5 or float_col = 6)", comboRules, "int_col IN (1, 2) OR int_col = 3 AND float_col IN (5, 6)");
        this.RewritesOk("int_col in (1,2) or int_col = 3", edToInrule, "int_col IN (1, 2, 3)");
        this.RewritesOk("int_col = 1 or int_col in (2, 3)", edToInrule, "int_col IN (2, 3, 1)");
        this.RewritesOk("int_col in (1, 2) or int_col in (3, 4)", edToInrule, "int_col IN (1, 2, 3, 4)");
        this.RewritesOk("int_col = smallint_col or int_col = bigint_col ", edToInrule, null);
        this.RewritesOk("int_col = 1 or int_col = int_col ", edToInrule, null);
        this.RewritesOk("int_col = 1 or int_col = int_col + 3 ", edToInrule, null);
        this.RewritesOk("int_col in (1, 2) or int_col = int_col + 3 ", edToInrule, null);
        this.RewritesOk("int_col not in (1,2) or int_col = 3", edToInrule, null);
        this.RewritesOk("int_col = 3 or int_col not in (1,2)", edToInrule, null);
        this.RewritesOk("int_col not in (1,2) or int_col not in (3, 4)", edToInrule, null);
        this.RewritesOk("int_col in (1,2) or int_col not in (3, 4)", edToInrule, null);
        this.RewritesOkWhereExpr("int_col = 1 and int_col in (select smallint_col from functional.alltypessmall where smallint_col<10)", edToInrule, null);
    }

    @Test
    public void testNormalizeCountStarRule() throws ImpalaException {
        ExprRewriteRule rule = NormalizeCountStarRule.INSTANCE;
        this.RewritesOk("count(1)", rule, "count(*)");
        this.RewritesOk("count(5)", rule, "count(*)");
        this.RewritesOk("count(null)", rule, null);
        this.RewritesOk("count(id)", rule, null);
        this.RewritesOk("count(1 + 1)", rule, null);
        this.RewritesOk("count(1 + null)", rule, null);
    }

    @Test
    public void testSimplifyDistinctFromRule() throws ImpalaException {
        ExprRewriteRule rule = SimplifyDistinctFromRule.INSTANCE;
        this.RewritesOk("bool_col IS DISTINCT FROM bool_col", rule, "FALSE");
        this.RewritesOk("bool_col IS NOT DISTINCT FROM bool_col", rule, "TRUE");
        this.RewritesOk("bool_col <=> bool_col", rule, "TRUE");
        this.RewritesOk("bool_col IS NOT DISTINCT FROM int_col", rule, null);
        this.RewritesOk("bool_col IS DISTINCT FROM int_col", rule, null);
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{SimplifyConditionalsRule.INSTANCE, SimplifyDistinctFromRule.INSTANCE});
        this.RewritesOk("if(bool_col is distinct from bool_col, 1, 2)", rules, "2");
        this.RewritesOk("if(bool_col is not distinct from bool_col, 1, 2)", rules, "1");
        this.RewritesOk("if(bool_col <=> bool_col, 1, 2)", rules, "1");
        this.RewritesOk("if(bool_col <=> NULL, 1, 2)", rules, null);
    }

    @Test
    public void testCountDistinctToNdvRule() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{CountDistinctToNdvRule.INSTANCE});
        session.options().setAppx_count_distinct(true);
        this.RewritesOk("count(distinct bool_col)", rules, "ndv(bool_col)");
    }

    @Test
    public void testDefaultNdvScaleRule() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{DefaultNdvScaleRule.INSTANCE});
        session.options().setDefault_ndv_scale(10);
        this.RewritesOk("ndv(bool_col)", rules, "ndv(bool_col, 10)");
    }

    @Test
    public void testDefaultNdvScaleRuleNotSet() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{DefaultNdvScaleRule.INSTANCE});
        this.RewritesOk("ndv(bool_col)", rules, null);
    }

    @Test
    public void testDefaultNdvScaleRuleSetDefault() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{DefaultNdvScaleRule.INSTANCE});
        session.options().setDefault_ndv_scale(2);
        this.RewritesOk("ndv(bool_col)", rules, null);
    }

    @Test
    public void testCountDistinctToNdvAndDefaultNdvScaleRule() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{CountDistinctToNdvRule.INSTANCE, DefaultNdvScaleRule.INSTANCE});
        session.options().setAppx_count_distinct(true);
        session.options().setDefault_ndv_scale(10);
        this.RewritesOk("count(distinct bool_col)", rules, "ndv(bool_col, 10)");
    }

    @Test
    public void testSimplifyCastStringToTimestamp() throws ImpalaException {
        ExprRewriteRule rule = SimplifyCastStringToTimestamp.INSTANCE;
        this.RewritesOk("cast(unix_timestamp(date_string_col) as timestamp)", rule, "CAST(date_string_col AS TIMESTAMP)");
        this.RewritesOk("cast(unix_timestamp(date_string_col, 'yyyy-MM-dd') as timestamp)", rule, "to_timestamp(date_string_col, 'yyyy-MM-dd')");
        this.RewritesOk("cast(unix_timestamp(timestamp_col) as timestamp)", rule, null);
        this.RewritesOk("cast(unix_timestamp() as timestamp)", rule, null);
    }

    @Test
    public void testNullif() throws ImpalaException {
        ArrayList rules = Lists.newArrayList((Object[])new ExprRewriteRule[]{SimplifyConditionalsRule.INSTANCE, SimplifyDistinctFromRule.INSTANCE});
        this.RewritesOk("nullif(bool_col, bool_col)", rules, "NULL");
        this.RewritesOk("nullif(1 + int_col, 1 + int_col)", rules, "NULL");
    }

    @Test
    public void testConvertToCNFRule() throws ImpalaException {
        ConvertToCNFRule rule = new ConvertToCNFRule(-1, false);
        this.RewritesOk("(int_col > 10 AND int_col < 20) OR float_col < 5.0", (ExprRewriteRule)rule, "int_col < 20 OR float_col < 5.0 AND int_col > 10 OR float_col < 5.0");
        this.RewritesOk("float_col < 5.0 OR (int_col > 10 AND int_col < 20)", (ExprRewriteRule)rule, "float_col < 5.0 OR int_col < 20 AND float_col < 5.0 OR int_col > 10");
        this.RewritesOk("(int_col > 10 AND float_col < 5.0) OR (int_col < 20 AND float_col > 15.0)", (ExprRewriteRule)rule, "float_col < 5.0 OR float_col > 15.0 AND float_col < 5.0 OR int_col < 20 AND int_col > 10 OR float_col > 15.0 AND int_col > 10 OR int_col < 20");
        this.RewritesOk("NOT(int_col > 10 OR int_col < 20)", (ExprRewriteRule)rule, "NOT int_col < 20 AND NOT int_col > 10");
    }

    @Test
    public void testExtractCompoundVerticalBarExprRule() throws ImpalaException {
        ExprRewriteRule extractCompoundVerticalBarExprRule = ExtractCompoundVerticalBarExprRule.INSTANCE;
        ExprRewriteRule simplifyConditionalsRule = SimplifyConditionalsRule.INSTANCE;
        ArrayList<ExprRewriteRule> rules = new ArrayList<ExprRewriteRule>();
        rules.add(extractCompoundVerticalBarExprRule);
        rules.add(simplifyConditionalsRule);
        this.RewritesOk("string_col || string_col", extractCompoundVerticalBarExprRule, "concat(string_col, string_col)");
        this.RewritesOk("bool_col || bool_col", extractCompoundVerticalBarExprRule, "bool_col OR bool_col");
        this.RewritesOk("string_col || 'TEST'", extractCompoundVerticalBarExprRule, "concat(string_col, 'TEST')");
        this.RewritesOk("functional.chars_tiny", "cl || cs", extractCompoundVerticalBarExprRule, "concat(cl, cs)");
        this.RewritesOk("FALSE || id = 0", extractCompoundVerticalBarExprRule, "FALSE OR id = 0");
        this.RewritesOk("FALSE || id = 0", rules, "id = 0");
        this.RewritesOk("'' || ''", extractCompoundVerticalBarExprRule, "concat('', '')");
        this.RewritesOk("NULL || bool_col", extractCompoundVerticalBarExprRule, "NULL OR bool_col");
    }

    @Test
    public void testSimplifyCastExprRule() throws ImpalaException {
        ExprRewriteRule rule = SimplifyCastExprRule.INSTANCE;
        this.RewritesOk("functional.alltypes", "CAST(int_col AS INT)", rule, "int_col");
        this.RewritesOk("functional.alltypes", "CAST(date_string_col AS STRING)", rule, "date_string_col");
        this.RewritesOk("functional.alltypes", "CAST(timestamp_col AS TIMESTAMP)", rule, "timestamp_col");
        this.RewritesOk("functional.alltypes", "CAST(CAST(int_col AS INT) AS INT)", rule, "int_col");
        this.RewritesOk("functional.alltypes", "CAST(int_col AS BIGINT)", rule, null);
        this.RewritesOk("functional.alltypes", "CAST(bigint_col+bigint_col AS BIGINT)", rule, "bigint_col + bigint_col");
        this.RewritesOk("functional.alltypes", "SUM(CAST(bigint_col+bigint_col AS BIGINT))", rule, "sum(bigint_col + bigint_col)");
        this.RewritesOk("functional.alltypes", "CAST(bigint_col+bigint_col AS DOUBLE)", rule, null);
        this.RewritesOk("functional.alltypes", "CAST(CAST(int_col AS BIGINT) AS BIGINT)", rule, "CAST(int_col AS BIGINT)");
        this.RewritesOk("functional.alltypes", "CAST(CAST(CAST(int_col AS BIGINT) AS BIGINT) AS BIGINT)", rule, "CAST(int_col AS BIGINT)");
        this.RewritesOk("functional.alltypes", "CAST(CAST(int_col AS BIGINT) AS INT)", rule, null);
        this.RewritesOk("functional.decimal_tbl", "CAST(d3 AS DECIMAL(20,10))", rule, "d3");
        this.RewritesOk("functional.decimal_tbl", "CAST(CAST(d3 AS DECIMAL(10,5)) AS DECIMAL(10,5))", rule, "CAST(d3 AS DECIMAL(10,5))");
        this.RewritesOk("functional.decimal_tbl", "CAST(d3 AS DECIMAL(10,5))", rule, null);
        this.RewritesOk("functional.decimal_tbl", "CAST(d3 AS DECIMAL(25,15))", rule, null);
        this.RewritesOk("functional.decimal_tbl", "CAST(CAST(d3 AS DECIMAL(10,5)) AS DECIMAL(15,5))", rule, null);
        this.RewritesOk("functional.chars_formats", "CAST(vc AS VARCHAR(32))", rule, "vc");
        this.RewritesOk("functional.chars_formats", "CAST(CAST(vc AS VARCHAR(16)) AS VARCHAR(16))", rule, "CAST(vc AS VARCHAR(16))");
        this.RewritesOk("functional.chars_formats", "CAST(vc AS VARCHAR(16))", rule, null);
        this.RewritesOk("functional.chars_formats", "CAST(vc AS VARCHAR(48))", rule, null);
        this.RewritesOk("functional.chars_formats", "CAST(CAST(vc AS VARCHAR(48)) AS VARCHAR(16))", rule, null);
        this.RewritesOk("functional.allcomplextypes.int_array_col", "CAST(int_array_col.item AS INT)", rule, "int_array_col.item");
        this.RewritesOk("functional.allcomplextypes.int_array_col", "CAST(CAST(int_array_col.item AS BIGINT) AS BIGINT)", rule, "CAST(int_array_col.item AS BIGINT)");
        this.RewritesOk("functional.allcomplextypes.int_map_col", "CAST(int_map_col.key AS STRING)", rule, "int_map_col.`key`");
        this.RewritesOk("functional.allcomplextypes.int_map_col", "CAST(CAST(int_map_col.value AS STRING) AS STRING)", rule, "CAST(int_map_col.value AS STRING)");
        this.RewritesOk("functional.allcomplextypes", "CAST(int_struct_col.f1 AS INT)", rule, "int_struct_col.f1");
        this.RewritesOk("functional.allcomplextypes", "CAST(CAST(int_struct_col.f1 AS BIGINT) AS BIGINT)", rule, "CAST(int_struct_col.f1 AS BIGINT)");
    }

    public static class SelectRewriteFixture
    extends QueryFixture.SelectFixture {
        private Analyzer analyzer_;

        public SelectRewriteFixture(AnalysisSessionFixture analysisFixture) {
            super(analysisFixture);
        }

        @Override
        public StatementBase analyze() throws AnalysisException {
            Preconditions.checkState((this.analyzer_ == null ? 1 : 0) != 0, (Object)"Already analyzed");
            this.stmt_ = this.parse();
            this.analysisCtx_ = this.makeAnalysisContext();
            this.analyzer_ = this.analysisCtx_.createAnalyzer(this.makeTableCache(this.stmt_));
            this.stmt_.analyze(this.analyzer_);
            return this.stmt_;
        }

        @Override
        public Analyzer analyzer() {
            Preconditions.checkState((this.analyzer_ != null ? 1 : 0) != 0, (Object)"Not yet analyzed");
            return this.analyzer_;
        }

        public Expr rewrite(Expr origExpr, List<ExprRewriteRule> rules, boolean requireFire) throws AnalysisException {
            ArrayList<CountingRewriteRuleWrapper> wrappedRules = new ArrayList<CountingRewriteRuleWrapper>();
            for (ExprRewriteRule r : rules) {
                wrappedRules.add(new CountingRewriteRuleWrapper(r));
            }
            ExprRewriter rewriter = new ExprRewriter(wrappedRules);
            Expr rewrittenExpr = rewriter.rewrite(origExpr, this.analyzer());
            if (requireFire) {
                for (ExprRewriteRule exprRewriteRule : wrappedRules) {
                    CountingRewriteRuleWrapper w = (CountingRewriteRuleWrapper)exprRewriteRule;
                    Assert.assertTrue((String)("Rule " + w.wrapped_.toString() + " didn't fire."), (w.rewrites_ > 0 ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((Object)requireFire, (Object)rewriter.changed());
            return rewrittenExpr;
        }

        public Expr verifyExprEquivalence(Expr origExpr, String expectedExprStr, List<ExprRewriteRule> rules) throws AnalysisException {
            String origSql = origExpr.toSql();
            boolean expectChange = expectedExprStr != null;
            Expr rewrittenExpr = this.rewrite(origExpr, rules, expectChange);
            String rewrittenSql = rewrittenExpr.toSql();
            if (expectedExprStr != null) {
                Assert.assertEquals((Object)expectedExprStr, (Object)rewrittenSql);
            } else {
                Assert.assertEquals((Object)origSql, (Object)rewrittenSql);
            }
            return rewrittenExpr;
        }

        public Expr verifySelectRewrite(List<ExprRewriteRule> rules, String expectedExprStr) throws AnalysisException {
            return this.verifyExprEquivalence(this.selectExpr(), expectedExprStr, rules);
        }

        public Expr verifyWhereRewrite(List<ExprRewriteRule> rules, String expectedExprStr) throws AnalysisException {
            return this.verifyExprEquivalence(this.whereExpr(), expectedExprStr, rules);
        }
    }

    public static class CountingRewriteRuleWrapper
    implements ExprRewriteRule {
        int rewrites_;
        final ExprRewriteRule wrapped_;

        CountingRewriteRuleWrapper(ExprRewriteRule wrapped) {
            this.wrapped_ = wrapped;
        }

        public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
            Expr ret = this.wrapped_.apply(expr, analyzer);
            if (expr != ret) {
                ++this.rewrites_;
            }
            return ret;
        }
    }
}

